<?php
/**
 * ArchitectMeCondition
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ArchitectMeCondition Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ArchitectMeCondition implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ArchitectMeCondition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'supported' => 'bool',
        'flowTypes' => 'string[]',
        'subConditions' => 'map[string,\PureCloudSDK\ArchitectMeCondition]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'supported' => 'supported',
        'flowTypes' => 'flowTypes',
        'subConditions' => 'subConditions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'supported' => 'setSupported',
        'flowTypes' => 'setFlowTypes',
        'subConditions' => 'setSubConditions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'supported' => 'getSupported',
        'flowTypes' => 'getFlowTypes',
        'subConditions' => 'getSubConditions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const FLOW_TYPES_INBOUNDCALL = 'inboundcall';
    const FLOW_TYPES_INBOUNDEMAIL = 'inboundemail';
    const FLOW_TYPES_INQUEUECALL = 'inqueuecall';
    const FLOW_TYPES_OUTBOUNDCALL = 'outboundcall';
    const FLOW_TYPES_SECURECALL = 'securecall';
    const FLOW_TYPES_WORKFLOW = 'workflow';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowTypesAllowableValues()
    {
        return [
            self::FLOW_TYPES_INBOUNDCALL,
            self::FLOW_TYPES_INBOUNDEMAIL,
            self::FLOW_TYPES_INQUEUECALL,
            self::FLOW_TYPES_OUTBOUNDCALL,
            self::FLOW_TYPES_SECURECALL,
            self::FLOW_TYPES_WORKFLOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['supported'] = isset($data['supported']) ? $data['supported'] : false;
        $this->container['flowTypes'] = isset($data['flowTypes']) ? $data['flowTypes'] : null;
        $this->container['subConditions'] = isset($data['subConditions']) ? $data['subConditions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets supported
     * @return bool
     */
    public function getSupported()
    {
        return $this->container['supported'];
    }

    /**
     * Sets supported
     * @param bool $supported
     * @return $this
     */
    public function setSupported($supported)
    {
        $this->container['supported'] = $supported;

        return $this;
    }

    /**
     * Gets flowTypes
     * @return string[]
     */
    public function getFlowTypes()
    {
        return $this->container['flowTypes'];
    }

    /**
     * Sets flowTypes
     * @param string[] $flowTypes
     * @return $this
     */
    public function setFlowTypes($flowTypes)
    {
        $allowed_values = array('inboundcall', 'inboundemail', 'inqueuecall', 'outboundcall', 'securecall', 'workflow');
        if (!in_array($flowTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowTypes', must be one of 'inboundcall', 'inboundemail', 'inqueuecall', 'outboundcall', 'securecall', 'workflow'");
        }
        $this->container['flowTypes'] = $flowTypes;

        return $this;
    }

    /**
     * Gets subConditions
     * @return map[string,\PureCloudSDK\ArchitectMeCondition]
     */
    public function getSubConditions()
    {
        return $this->container['subConditions'];
    }

    /**
     * Sets subConditions
     * @param map[string,\PureCloudSDK\ArchitectMeCondition] $subConditions
     * @return $this
     */
    public function setSubConditions($subConditions)
    {
        $this->container['subConditions'] = $subConditions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


