<?php
/**
 * Call
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Call Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Call implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Call';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'direction' => 'string',
        'recording' => 'bool',
        'recordingState' => 'string',
        'muted' => 'bool',
        'confined' => 'bool',
        'held' => 'bool',
        'recordingId' => 'string',
        'segments' => '\PureCloudSDK\Segment[]',
        'errorInfo' => '\PureCloudSDK\ErrorBody',
        'disconnectType' => 'string',
        'startHoldTime' => '\DateTime',
        'documentId' => 'string',
        'connectedTime' => '\DateTime',
        'disconnectedTime' => '\DateTime',
        'disconnectReasons' => '\PureCloudSDK\DisconnectReason[]',
        'faxStatus' => '\PureCloudSDK\FaxStatus',
        'provider' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'direction' => 'direction',
        'recording' => 'recording',
        'recordingState' => 'recordingState',
        'muted' => 'muted',
        'confined' => 'confined',
        'held' => 'held',
        'recordingId' => 'recordingId',
        'segments' => 'segments',
        'errorInfo' => 'errorInfo',
        'disconnectType' => 'disconnectType',
        'startHoldTime' => 'startHoldTime',
        'documentId' => 'documentId',
        'connectedTime' => 'connectedTime',
        'disconnectedTime' => 'disconnectedTime',
        'disconnectReasons' => 'disconnectReasons',
        'faxStatus' => 'faxStatus',
        'provider' => 'provider'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'direction' => 'setDirection',
        'recording' => 'setRecording',
        'recordingState' => 'setRecordingState',
        'muted' => 'setMuted',
        'confined' => 'setConfined',
        'held' => 'setHeld',
        'recordingId' => 'setRecordingId',
        'segments' => 'setSegments',
        'errorInfo' => 'setErrorInfo',
        'disconnectType' => 'setDisconnectType',
        'startHoldTime' => 'setStartHoldTime',
        'documentId' => 'setDocumentId',
        'connectedTime' => 'setConnectedTime',
        'disconnectedTime' => 'setDisconnectedTime',
        'disconnectReasons' => 'setDisconnectReasons',
        'faxStatus' => 'setFaxStatus',
        'provider' => 'setProvider'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'direction' => 'getDirection',
        'recording' => 'getRecording',
        'recordingState' => 'getRecordingState',
        'muted' => 'getMuted',
        'confined' => 'getConfined',
        'held' => 'getHeld',
        'recordingId' => 'getRecordingId',
        'segments' => 'getSegments',
        'errorInfo' => 'getErrorInfo',
        'disconnectType' => 'getDisconnectType',
        'startHoldTime' => 'getStartHoldTime',
        'documentId' => 'getDocumentId',
        'connectedTime' => 'getConnectedTime',
        'disconnectedTime' => 'getDisconnectedTime',
        'disconnectReasons' => 'getDisconnectReasons',
        'faxStatus' => 'getFaxStatus',
        'provider' => 'getProvider'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_CONVERTING = 'converting';
    const STATE_UPLOADING = 'uploading';
    const STATE_TRANSMITTING = 'transmitting';
    const STATE_NONE = 'none';
    const DIRECTION_INBOUND = 'inbound';
    const DIRECTION_OUTBOUND = 'outbound';
    const RECORDING_STATE_NONE = 'none';
    const RECORDING_STATE_ACTIVE = 'active';
    const RECORDING_STATE_PAUSED = 'paused';
    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TIMEOUT = 'timeout';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRecordingStateAllowableValues()
    {
        return [
            self::RECORDING_STATE_NONE,
            self::RECORDING_STATE_ACTIVE,
            self::RECORDING_STATE_PAUSED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : false;
        $this->container['recordingState'] = isset($data['recordingState']) ? $data['recordingState'] : null;
        $this->container['muted'] = isset($data['muted']) ? $data['muted'] : false;
        $this->container['confined'] = isset($data['confined']) ? $data['confined'] : false;
        $this->container['held'] = isset($data['held']) ? $data['held'] : false;
        $this->container['recordingId'] = isset($data['recordingId']) ? $data['recordingId'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
        $this->container['errorInfo'] = isset($data['errorInfo']) ? $data['errorInfo'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['startHoldTime'] = isset($data['startHoldTime']) ? $data['startHoldTime'] : null;
        $this->container['documentId'] = isset($data['documentId']) ? $data['documentId'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['disconnectedTime'] = isset($data['disconnectedTime']) ? $data['disconnectedTime'] : null;
        $this->container['disconnectReasons'] = isset($data['disconnectReasons']) ? $data['disconnectReasons'] : null;
        $this->container['faxStatus'] = isset($data['faxStatus']) ? $data['faxStatus'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("none", "active", "paused");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'recordingState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("none", "active", "paused");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this communication.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this communication.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the call
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets recording
     * @return bool
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param bool $recording True if this call is being recorded.
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets recordingState
     * @return string
     */
    public function getRecordingState()
    {
        return $this->container['recordingState'];
    }

    /**
     * Sets recordingState
     * @param string $recordingState State of recording on this call.
     * @return $this
     */
    public function setRecordingState($recordingState)
    {
        $allowed_values = array('none', 'active', 'paused');
        if (!in_array($recordingState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'recordingState', must be one of 'none', 'active', 'paused'");
        }
        $this->container['recordingState'] = $recordingState;

        return $this;
    }

    /**
     * Gets muted
     * @return bool
     */
    public function getMuted()
    {
        return $this->container['muted'];
    }

    /**
     * Sets muted
     * @param bool $muted True if this call is muted so that remote participants can't hear any audio from this end.
     * @return $this
     */
    public function setMuted($muted)
    {
        $this->container['muted'] = $muted;

        return $this;
    }

    /**
     * Gets confined
     * @return bool
     */
    public function getConfined()
    {
        return $this->container['confined'];
    }

    /**
     * Sets confined
     * @param bool $confined True if this call is held and the person on this side hears hold music.
     * @return $this
     */
    public function setConfined($confined)
    {
        $this->container['confined'] = $confined;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held True if this call is held and the person on this side hears silence.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets recordingId
     * @return string
     */
    public function getRecordingId()
    {
        return $this->container['recordingId'];
    }

    /**
     * Sets recordingId
     * @param string $recordingId A globally unique identifier for the recording associated with this call.
     * @return $this
     */
    public function setRecordingId($recordingId)
    {
        $this->container['recordingId'] = $recordingId;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\Segment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\Segment[] $segments The time line of the participant's call, divided into activity segments.
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }

    /**
     * Gets errorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInfo()
    {
        return $this->container['errorInfo'];
    }

    /**
     * Sets errorInfo
     * @param \PureCloudSDK\ErrorBody $errorInfo
     * @return $this
     */
    public function setErrorInfo($errorInfo)
    {
        $this->container['errorInfo'] = $errorInfo;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets startHoldTime
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['startHoldTime'];
    }

    /**
     * Sets startHoldTime
     * @param \DateTime $startHoldTime The timestamp the call was placed on hold in the cloud clock if the call is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($startHoldTime)
    {
        $this->container['startHoldTime'] = $startHoldTime;

        return $this;
    }

    /**
     * Gets documentId
     * @return string
     */
    public function getDocumentId()
    {
        return $this->container['documentId'];
    }

    /**
     * Sets documentId
     * @param string $documentId If call is an outbound fax of a document from content management, then this is the id in content management.
     * @return $this
     */
    public function setDocumentId($documentId)
    {
        $this->container['documentId'] = $documentId;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets disconnectedTime
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnectedTime'];
    }

    /**
     * Sets disconnectedTime
     * @param \DateTime $disconnectedTime The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDisconnectedTime($disconnectedTime)
    {
        $this->container['disconnectedTime'] = $disconnectedTime;

        return $this;
    }

    /**
     * Gets disconnectReasons
     * @return \PureCloudSDK\DisconnectReason[]
     */
    public function getDisconnectReasons()
    {
        return $this->container['disconnectReasons'];
    }

    /**
     * Sets disconnectReasons
     * @param \PureCloudSDK\DisconnectReason[] $disconnectReasons List of reasons that this call was disconnected. This will be set once the call disconnects.
     * @return $this
     */
    public function setDisconnectReasons($disconnectReasons)
    {
        $this->container['disconnectReasons'] = $disconnectReasons;

        return $this;
    }

    /**
     * Gets faxStatus
     * @return \PureCloudSDK\FaxStatus
     */
    public function getFaxStatus()
    {
        return $this->container['faxStatus'];
    }

    /**
     * Sets faxStatus
     * @param \PureCloudSDK\FaxStatus $faxStatus Extra information on fax transmission.
     * @return $this
     */
    public function setFaxStatus($faxStatus)
    {
        $this->container['faxStatus'] = $faxStatus;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the call.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


