<?php
/**
 * CaseComment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CaseComment Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CaseComment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CaseComment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'text' => 'string',
        'commentType' => 'string',
        'userOwner' => '\PureCloudSDK\User',
        'externalContact' => '\PureCloudSDK\ExternalContact',
        'dateCreated' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'text' => 'text',
        'commentType' => 'commentType',
        'userOwner' => 'userOwner',
        'externalContact' => 'externalContact',
        'dateCreated' => 'dateCreated',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'text' => 'setText',
        'commentType' => 'setCommentType',
        'userOwner' => 'setUserOwner',
        'externalContact' => 'setExternalContact',
        'dateCreated' => 'setDateCreated',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'text' => 'getText',
        'commentType' => 'getCommentType',
        'userOwner' => 'getUserOwner',
        'externalContact' => 'getExternalContact',
        'dateCreated' => 'getDateCreated',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const COMMENT_TYPE_AGENT_EXTERNAL_COMMENT = 'AGENT_EXTERNAL_COMMENT';
    const COMMENT_TYPE_AGENT_INTERNAL_COMMENT = 'AGENT_INTERNAL_COMMENT';
    const COMMENT_TYPE_CUSTOMER_COMMENT = 'CUSTOMER_COMMENT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCommentTypeAllowableValues()
    {
        return [
            self::COMMENT_TYPE_AGENT_EXTERNAL_COMMENT,
            self::COMMENT_TYPE_AGENT_INTERNAL_COMMENT,
            self::COMMENT_TYPE_CUSTOMER_COMMENT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['text'] = isset($data['text']) ? $data['text'] : null;
        $this->container['commentType'] = isset($data['commentType']) ? $data['commentType'] : null;
        $this->container['userOwner'] = isset($data['userOwner']) ? $data['userOwner'] : null;
        $this->container['externalContact'] = isset($data['externalContact']) ? $data['externalContact'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['text'] === null) {
            $invalid_properties[] = "'text' can't be null";
        }
        if ($this->container['commentType'] === null) {
            $invalid_properties[] = "'commentType' can't be null";
        }
        $allowed_values = array("AGENT_EXTERNAL_COMMENT", "AGENT_INTERNAL_COMMENT", "CUSTOMER_COMMENT");
        if (!in_array($this->container['commentType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'commentType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['text'] === null) {
            return false;
        }
        if ($this->container['commentType'] === null) {
            return false;
        }
        $allowed_values = array("AGENT_EXTERNAL_COMMENT", "AGENT_INTERNAL_COMMENT", "CUSTOMER_COMMENT");
        if (!in_array($this->container['commentType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets text
     * @return string
     */
    public function getText()
    {
        return $this->container['text'];
    }

    /**
     * Sets text
     * @param string $text Holds the content of a case comment. A comment cannot exceed 5000 characters.
     * @return $this
     */
    public function setText($text)
    {
        $this->container['text'] = $text;

        return $this;
    }

    /**
     * Gets commentType
     * @return string
     */
    public function getCommentType()
    {
        return $this->container['commentType'];
    }

    /**
     * Sets commentType
     * @param string $commentType Type of a comment, can be internal comment added by an agent, external comment added by an agent or a note added by an external customer.
     * @return $this
     */
    public function setCommentType($commentType)
    {
        $allowed_values = array('AGENT_EXTERNAL_COMMENT', 'AGENT_INTERNAL_COMMENT', 'CUSTOMER_COMMENT');
        if (!in_array($commentType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'commentType', must be one of 'AGENT_EXTERNAL_COMMENT', 'AGENT_INTERNAL_COMMENT', 'CUSTOMER_COMMENT'");
        }
        $this->container['commentType'] = $commentType;

        return $this;
    }

    /**
     * Gets userOwner
     * @return \PureCloudSDK\User
     */
    public function getUserOwner()
    {
        return $this->container['userOwner'];
    }

    /**
     * Sets userOwner
     * @param \PureCloudSDK\User $userOwner User details will be populated if the comment is added by an Agent/User
     * @return $this
     */
    public function setUserOwner($userOwner)
    {
        $this->container['userOwner'] = $userOwner;

        return $this;
    }

    /**
     * Gets externalContact
     * @return \PureCloudSDK\ExternalContact
     */
    public function getExternalContact()
    {
        return $this->container['externalContact'];
    }

    /**
     * Sets externalContact
     * @param \PureCloudSDK\ExternalContact $externalContact External customer details will be populated if the comment is added by an External contact
     * @return $this
     */
    public function setExternalContact($externalContact)
    {
        $this->container['externalContact'] = $externalContact;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date when case comment is created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


