<?php
/**
 * ConversationNotificationParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotificationParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'connectedTime' => '\DateTime',
        'endTime' => '\DateTime',
        'userId' => 'string',
        'externalContactId' => 'string',
        'externalOrganizationId' => 'string',
        'name' => 'string',
        'queueId' => 'string',
        'groupId' => 'string',
        'purpose' => 'string',
        'consultParticipantId' => 'string',
        'address' => 'string',
        'wrapupRequired' => 'bool',
        'wrapupExpected' => 'bool',
        'wrapupPrompt' => 'string',
        'wrapupTimeoutMs' => 'int',
        'wrapup' => '\PureCloudSDK\ConversationNotificationWrapup',
        'monitoredParticipantId' => 'string',
        'attributes' => 'map[string,string]',
        'calls' => '\PureCloudSDK\ConversationNotificationCalls[]',
        'callbacks' => '\PureCloudSDK\ConversationNotificationCallbacks[]',
        'chats' => '\PureCloudSDK\ConversationNotificationChats[]',
        'cobrowsesessions' => '\PureCloudSDK\ConversationNotificationCobrowsesessions[]',
        'emails' => '\PureCloudSDK\ConversationNotificationEmails[]',
        'screenShares' => '\PureCloudSDK\ConversationNotificationScreenShares[]',
        'socialExpressions' => '\PureCloudSDK\ConversationNotificationSocialExpressions[]',
        'videos' => '\PureCloudSDK\ConversationNotificationVideos[]',
        'additionalProperties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'connectedTime' => 'connectedTime',
        'endTime' => 'endTime',
        'userId' => 'userId',
        'externalContactId' => 'externalContactId',
        'externalOrganizationId' => 'externalOrganizationId',
        'name' => 'name',
        'queueId' => 'queueId',
        'groupId' => 'groupId',
        'purpose' => 'purpose',
        'consultParticipantId' => 'consultParticipantId',
        'address' => 'address',
        'wrapupRequired' => 'wrapupRequired',
        'wrapupExpected' => 'wrapupExpected',
        'wrapupPrompt' => 'wrapupPrompt',
        'wrapupTimeoutMs' => 'wrapupTimeoutMs',
        'wrapup' => 'wrapup',
        'monitoredParticipantId' => 'monitoredParticipantId',
        'attributes' => 'attributes',
        'calls' => 'calls',
        'callbacks' => 'callbacks',
        'chats' => 'chats',
        'cobrowsesessions' => 'cobrowsesessions',
        'emails' => 'emails',
        'screenShares' => 'screenShares',
        'socialExpressions' => 'socialExpressions',
        'videos' => 'videos',
        'additionalProperties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'connectedTime' => 'setConnectedTime',
        'endTime' => 'setEndTime',
        'userId' => 'setUserId',
        'externalContactId' => 'setExternalContactId',
        'externalOrganizationId' => 'setExternalOrganizationId',
        'name' => 'setName',
        'queueId' => 'setQueueId',
        'groupId' => 'setGroupId',
        'purpose' => 'setPurpose',
        'consultParticipantId' => 'setConsultParticipantId',
        'address' => 'setAddress',
        'wrapupRequired' => 'setWrapupRequired',
        'wrapupExpected' => 'setWrapupExpected',
        'wrapupPrompt' => 'setWrapupPrompt',
        'wrapupTimeoutMs' => 'setWrapupTimeoutMs',
        'wrapup' => 'setWrapup',
        'monitoredParticipantId' => 'setMonitoredParticipantId',
        'attributes' => 'setAttributes',
        'calls' => 'setCalls',
        'callbacks' => 'setCallbacks',
        'chats' => 'setChats',
        'cobrowsesessions' => 'setCobrowsesessions',
        'emails' => 'setEmails',
        'screenShares' => 'setScreenShares',
        'socialExpressions' => 'setSocialExpressions',
        'videos' => 'setVideos',
        'additionalProperties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'connectedTime' => 'getConnectedTime',
        'endTime' => 'getEndTime',
        'userId' => 'getUserId',
        'externalContactId' => 'getExternalContactId',
        'externalOrganizationId' => 'getExternalOrganizationId',
        'name' => 'getName',
        'queueId' => 'getQueueId',
        'groupId' => 'getGroupId',
        'purpose' => 'getPurpose',
        'consultParticipantId' => 'getConsultParticipantId',
        'address' => 'getAddress',
        'wrapupRequired' => 'getWrapupRequired',
        'wrapupExpected' => 'getWrapupExpected',
        'wrapupPrompt' => 'getWrapupPrompt',
        'wrapupTimeoutMs' => 'getWrapupTimeoutMs',
        'wrapup' => 'getWrapup',
        'monitoredParticipantId' => 'getMonitoredParticipantId',
        'attributes' => 'getAttributes',
        'calls' => 'getCalls',
        'callbacks' => 'getCallbacks',
        'chats' => 'getChats',
        'cobrowsesessions' => 'getCobrowsesessions',
        'emails' => 'getEmails',
        'screenShares' => 'getScreenShares',
        'socialExpressions' => 'getSocialExpressions',
        'videos' => 'getVideos',
        'additionalProperties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['externalOrganizationId'] = isset($data['externalOrganizationId']) ? $data['externalOrganizationId'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['groupId'] = isset($data['groupId']) ? $data['groupId'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['consultParticipantId'] = isset($data['consultParticipantId']) ? $data['consultParticipantId'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['wrapupRequired'] = isset($data['wrapupRequired']) ? $data['wrapupRequired'] : null;
        $this->container['wrapupExpected'] = isset($data['wrapupExpected']) ? $data['wrapupExpected'] : null;
        $this->container['wrapupPrompt'] = isset($data['wrapupPrompt']) ? $data['wrapupPrompt'] : null;
        $this->container['wrapupTimeoutMs'] = isset($data['wrapupTimeoutMs']) ? $data['wrapupTimeoutMs'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['monitoredParticipantId'] = isset($data['monitoredParticipantId']) ? $data['monitoredParticipantId'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['calls'] = isset($data['calls']) ? $data['calls'] : null;
        $this->container['callbacks'] = isset($data['callbacks']) ? $data['callbacks'] : null;
        $this->container['chats'] = isset($data['chats']) ? $data['chats'] : null;
        $this->container['cobrowsesessions'] = isset($data['cobrowsesessions']) ? $data['cobrowsesessions'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['screenShares'] = isset($data['screenShares']) ? $data['screenShares'] : null;
        $this->container['socialExpressions'] = isset($data['socialExpressions']) ? $data['socialExpressions'] : null;
        $this->container['videos'] = isset($data['videos']) ? $data['videos'] : null;
        $this->container['additionalProperties'] = isset($data['additionalProperties']) ? $data['additionalProperties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets externalOrganizationId
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['externalOrganizationId'];
    }

    /**
     * Sets externalOrganizationId
     * @param string $externalOrganizationId
     * @return $this
     */
    public function setExternalOrganizationId($externalOrganizationId)
    {
        $this->container['externalOrganizationId'] = $externalOrganizationId;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets groupId
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['groupId'];
    }

    /**
     * Sets groupId
     * @param string $groupId
     * @return $this
     */
    public function setGroupId($groupId)
    {
        $this->container['groupId'] = $groupId;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets consultParticipantId
     * @return string
     */
    public function getConsultParticipantId()
    {
        return $this->container['consultParticipantId'];
    }

    /**
     * Sets consultParticipantId
     * @param string $consultParticipantId
     * @return $this
     */
    public function setConsultParticipantId($consultParticipantId)
    {
        $this->container['consultParticipantId'] = $consultParticipantId;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets wrapupRequired
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapupRequired'];
    }

    /**
     * Sets wrapupRequired
     * @param bool $wrapupRequired
     * @return $this
     */
    public function setWrapupRequired($wrapupRequired)
    {
        $this->container['wrapupRequired'] = $wrapupRequired;

        return $this;
    }

    /**
     * Gets wrapupExpected
     * @return bool
     */
    public function getWrapupExpected()
    {
        return $this->container['wrapupExpected'];
    }

    /**
     * Sets wrapupExpected
     * @param bool $wrapupExpected
     * @return $this
     */
    public function setWrapupExpected($wrapupExpected)
    {
        $this->container['wrapupExpected'] = $wrapupExpected;

        return $this;
    }

    /**
     * Gets wrapupPrompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapupPrompt'];
    }

    /**
     * Sets wrapupPrompt
     * @param string $wrapupPrompt
     * @return $this
     */
    public function setWrapupPrompt($wrapupPrompt)
    {
        $this->container['wrapupPrompt'] = $wrapupPrompt;

        return $this;
    }

    /**
     * Gets wrapupTimeoutMs
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapupTimeoutMs'];
    }

    /**
     * Sets wrapupTimeoutMs
     * @param int $wrapupTimeoutMs
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapupTimeoutMs)
    {
        $this->container['wrapupTimeoutMs'] = $wrapupTimeoutMs;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\ConversationNotificationWrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\ConversationNotificationWrapup $wrapup
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets monitoredParticipantId
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitoredParticipantId'];
    }

    /**
     * Sets monitoredParticipantId
     * @param string $monitoredParticipantId
     * @return $this
     */
    public function setMonitoredParticipantId($monitoredParticipantId)
    {
        $this->container['monitoredParticipantId'] = $monitoredParticipantId;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets calls
     * @return \PureCloudSDK\ConversationNotificationCalls[]
     */
    public function getCalls()
    {
        return $this->container['calls'];
    }

    /**
     * Sets calls
     * @param \PureCloudSDK\ConversationNotificationCalls[] $calls
     * @return $this
     */
    public function setCalls($calls)
    {
        $this->container['calls'] = $calls;

        return $this;
    }

    /**
     * Gets callbacks
     * @return \PureCloudSDK\ConversationNotificationCallbacks[]
     */
    public function getCallbacks()
    {
        return $this->container['callbacks'];
    }

    /**
     * Sets callbacks
     * @param \PureCloudSDK\ConversationNotificationCallbacks[] $callbacks
     * @return $this
     */
    public function setCallbacks($callbacks)
    {
        $this->container['callbacks'] = $callbacks;

        return $this;
    }

    /**
     * Gets chats
     * @return \PureCloudSDK\ConversationNotificationChats[]
     */
    public function getChats()
    {
        return $this->container['chats'];
    }

    /**
     * Sets chats
     * @param \PureCloudSDK\ConversationNotificationChats[] $chats
     * @return $this
     */
    public function setChats($chats)
    {
        $this->container['chats'] = $chats;

        return $this;
    }

    /**
     * Gets cobrowsesessions
     * @return \PureCloudSDK\ConversationNotificationCobrowsesessions[]
     */
    public function getCobrowsesessions()
    {
        return $this->container['cobrowsesessions'];
    }

    /**
     * Sets cobrowsesessions
     * @param \PureCloudSDK\ConversationNotificationCobrowsesessions[] $cobrowsesessions
     * @return $this
     */
    public function setCobrowsesessions($cobrowsesessions)
    {
        $this->container['cobrowsesessions'] = $cobrowsesessions;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\ConversationNotificationEmails[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\ConversationNotificationEmails[] $emails
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets screenShares
     * @return \PureCloudSDK\ConversationNotificationScreenShares[]
     */
    public function getScreenShares()
    {
        return $this->container['screenShares'];
    }

    /**
     * Sets screenShares
     * @param \PureCloudSDK\ConversationNotificationScreenShares[] $screenShares
     * @return $this
     */
    public function setScreenShares($screenShares)
    {
        $this->container['screenShares'] = $screenShares;

        return $this;
    }

    /**
     * Gets socialExpressions
     * @return \PureCloudSDK\ConversationNotificationSocialExpressions[]
     */
    public function getSocialExpressions()
    {
        return $this->container['socialExpressions'];
    }

    /**
     * Sets socialExpressions
     * @param \PureCloudSDK\ConversationNotificationSocialExpressions[] $socialExpressions
     * @return $this
     */
    public function setSocialExpressions($socialExpressions)
    {
        $this->container['socialExpressions'] = $socialExpressions;

        return $this;
    }

    /**
     * Gets videos
     * @return \PureCloudSDK\ConversationNotificationVideos[]
     */
    public function getVideos()
    {
        return $this->container['videos'];
    }

    /**
     * Sets videos
     * @param \PureCloudSDK\ConversationNotificationVideos[] $videos
     * @return $this
     */
    public function setVideos($videos)
    {
        $this->container['videos'] = $videos;

        return $this;
    }

    /**
     * Gets additionalProperties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additionalProperties'];
    }

    /**
     * Sets additionalProperties
     * @param object $additionalProperties
     * @return $this
     */
    public function setAdditionalProperties($additionalProperties)
    {
        $this->container['additionalProperties'] = $additionalProperties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


