<?php
/**
 * FacetEntry
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FacetEntry Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FacetEntry implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FacetEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'attribute' => '\PureCloudSDK\TermAttribute',
        'statistics' => '\PureCloudSDK\FacetStatistics',
        'other' => 'int',
        'total' => 'int',
        'missing' => 'int',
        'termCount' => 'int',
        'termType' => 'string',
        'terms' => '\PureCloudSDK\FacetTerm[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'attribute' => 'attribute',
        'statistics' => 'statistics',
        'other' => 'other',
        'total' => 'total',
        'missing' => 'missing',
        'termCount' => 'termCount',
        'termType' => 'termType',
        'terms' => 'terms'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'attribute' => 'setAttribute',
        'statistics' => 'setStatistics',
        'other' => 'setOther',
        'total' => 'setTotal',
        'missing' => 'setMissing',
        'termCount' => 'setTermCount',
        'termType' => 'setTermType',
        'terms' => 'setTerms'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'attribute' => 'getAttribute',
        'statistics' => 'getStatistics',
        'other' => 'getOther',
        'total' => 'getTotal',
        'missing' => 'getMissing',
        'termCount' => 'getTermCount',
        'termType' => 'getTermType',
        'terms' => 'getTerms'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TERM_TYPE_TERM = 'TERM';
    const TERM_TYPE_NUMBERRANGE = 'NUMBERRANGE';
    const TERM_TYPE_NUMBERHISTOGRAM = 'NUMBERHISTOGRAM';
    const TERM_TYPE_DATERANGE = 'DATERANGE';
    const TERM_TYPE_DATEHISTOGRAM = 'DATEHISTOGRAM';
    const TERM_TYPE_ID = 'ID';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTermTypeAllowableValues()
    {
        return [
            self::TERM_TYPE_TERM,
            self::TERM_TYPE_NUMBERRANGE,
            self::TERM_TYPE_NUMBERHISTOGRAM,
            self::TERM_TYPE_DATERANGE,
            self::TERM_TYPE_DATEHISTOGRAM,
            self::TERM_TYPE_ID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['attribute'] = isset($data['attribute']) ? $data['attribute'] : null;
        $this->container['statistics'] = isset($data['statistics']) ? $data['statistics'] : null;
        $this->container['other'] = isset($data['other']) ? $data['other'] : null;
        $this->container['total'] = isset($data['total']) ? $data['total'] : null;
        $this->container['missing'] = isset($data['missing']) ? $data['missing'] : null;
        $this->container['termCount'] = isset($data['termCount']) ? $data['termCount'] : null;
        $this->container['termType'] = isset($data['termType']) ? $data['termType'] : null;
        $this->container['terms'] = isset($data['terms']) ? $data['terms'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("TERM", "NUMBERRANGE", "NUMBERHISTOGRAM", "DATERANGE", "DATEHISTOGRAM", "ID");
        if (!in_array($this->container['termType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'termType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("TERM", "NUMBERRANGE", "NUMBERHISTOGRAM", "DATERANGE", "DATEHISTOGRAM", "ID");
        if (!in_array($this->container['termType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets attribute
     * @return \PureCloudSDK\TermAttribute
     */
    public function getAttribute()
    {
        return $this->container['attribute'];
    }

    /**
     * Sets attribute
     * @param \PureCloudSDK\TermAttribute $attribute
     * @return $this
     */
    public function setAttribute($attribute)
    {
        $this->container['attribute'] = $attribute;

        return $this;
    }

    /**
     * Gets statistics
     * @return \PureCloudSDK\FacetStatistics
     */
    public function getStatistics()
    {
        return $this->container['statistics'];
    }

    /**
     * Sets statistics
     * @param \PureCloudSDK\FacetStatistics $statistics
     * @return $this
     */
    public function setStatistics($statistics)
    {
        $this->container['statistics'] = $statistics;

        return $this;
    }

    /**
     * Gets other
     * @return int
     */
    public function getOther()
    {
        return $this->container['other'];
    }

    /**
     * Sets other
     * @param int $other
     * @return $this
     */
    public function setOther($other)
    {
        $this->container['other'] = $other;

        return $this;
    }

    /**
     * Gets total
     * @return int
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     * @param int $total
     * @return $this
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets missing
     * @return int
     */
    public function getMissing()
    {
        return $this->container['missing'];
    }

    /**
     * Sets missing
     * @param int $missing
     * @return $this
     */
    public function setMissing($missing)
    {
        $this->container['missing'] = $missing;

        return $this;
    }

    /**
     * Gets termCount
     * @return int
     */
    public function getTermCount()
    {
        return $this->container['termCount'];
    }

    /**
     * Sets termCount
     * @param int $termCount
     * @return $this
     */
    public function setTermCount($termCount)
    {
        $this->container['termCount'] = $termCount;

        return $this;
    }

    /**
     * Gets termType
     * @return string
     */
    public function getTermType()
    {
        return $this->container['termType'];
    }

    /**
     * Sets termType
     * @param string $termType
     * @return $this
     */
    public function setTermType($termType)
    {
        $allowed_values = array('TERM', 'NUMBERRANGE', 'NUMBERHISTOGRAM', 'DATERANGE', 'DATEHISTOGRAM', 'ID');
        if (!in_array($termType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'termType', must be one of 'TERM', 'NUMBERRANGE', 'NUMBERHISTOGRAM', 'DATERANGE', 'DATEHISTOGRAM', 'ID'");
        }
        $this->container['termType'] = $termType;

        return $this;
    }

    /**
     * Gets terms
     * @return \PureCloudSDK\FacetTerm[]
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     * @param \PureCloudSDK\FacetTerm[] $terms
     * @return $this
     */
    public function setTerms($terms)
    {
        $this->container['terms'] = $terms;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


