<?php
/**
 * Flow
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Flow Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Flow implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Flow';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'type' => 'string',
        'lockedUser' => '\PureCloudSDK\UriReference',
        'active' => 'bool',
        'system' => 'bool',
        'deleted' => 'bool',
        'publishedVersion' => '\PureCloudSDK\FlowVersion',
        'savedVersion' => '\PureCloudSDK\FlowVersion',
        'inputSchema' => 'object',
        'outputSchema' => 'object',
        'checkedInVersion' => '\PureCloudSDK\FlowVersion',
        'publishedBy' => '\PureCloudSDK\UriReference',
        'currentOperation' => '\PureCloudSDK\Operation',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'type' => 'type',
        'lockedUser' => 'lockedUser',
        'active' => 'active',
        'system' => 'system',
        'deleted' => 'deleted',
        'publishedVersion' => 'publishedVersion',
        'savedVersion' => 'savedVersion',
        'inputSchema' => 'inputSchema',
        'outputSchema' => 'outputSchema',
        'checkedInVersion' => 'checkedInVersion',
        'publishedBy' => 'publishedBy',
        'currentOperation' => 'currentOperation',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'type' => 'setType',
        'lockedUser' => 'setLockedUser',
        'active' => 'setActive',
        'system' => 'setSystem',
        'deleted' => 'setDeleted',
        'publishedVersion' => 'setPublishedVersion',
        'savedVersion' => 'setSavedVersion',
        'inputSchema' => 'setInputSchema',
        'outputSchema' => 'setOutputSchema',
        'checkedInVersion' => 'setCheckedInVersion',
        'publishedBy' => 'setPublishedBy',
        'currentOperation' => 'setCurrentOperation',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'type' => 'getType',
        'lockedUser' => 'getLockedUser',
        'active' => 'getActive',
        'system' => 'getSystem',
        'deleted' => 'getDeleted',
        'publishedVersion' => 'getPublishedVersion',
        'savedVersion' => 'getSavedVersion',
        'inputSchema' => 'getInputSchema',
        'outputSchema' => 'getOutputSchema',
        'checkedInVersion' => 'getCheckedInVersion',
        'publishedBy' => 'getPublishedBy',
        'currentOperation' => 'getCurrentOperation',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_INBOUNDCALL = 'INBOUNDCALL';
    const TYPE_INBOUNDEMAIL = 'INBOUNDEMAIL';
    const TYPE_INQUEUECALL = 'INQUEUECALL';
    const TYPE_OUTBOUNDCALL = 'OUTBOUNDCALL';
    const TYPE_SECURECALL = 'SECURECALL';
    const TYPE_SPEECH = 'SPEECH';
    const TYPE_WORKFLOW = 'WORKFLOW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_INBOUNDCALL,
            self::TYPE_INBOUNDEMAIL,
            self::TYPE_INQUEUECALL,
            self::TYPE_OUTBOUNDCALL,
            self::TYPE_SECURECALL,
            self::TYPE_SPEECH,
            self::TYPE_WORKFLOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['lockedUser'] = isset($data['lockedUser']) ? $data['lockedUser'] : null;
        $this->container['active'] = isset($data['active']) ? $data['active'] : false;
        $this->container['system'] = isset($data['system']) ? $data['system'] : false;
        $this->container['deleted'] = isset($data['deleted']) ? $data['deleted'] : false;
        $this->container['publishedVersion'] = isset($data['publishedVersion']) ? $data['publishedVersion'] : null;
        $this->container['savedVersion'] = isset($data['savedVersion']) ? $data['savedVersion'] : null;
        $this->container['inputSchema'] = isset($data['inputSchema']) ? $data['inputSchema'] : null;
        $this->container['outputSchema'] = isset($data['outputSchema']) ? $data['outputSchema'] : null;
        $this->container['checkedInVersion'] = isset($data['checkedInVersion']) ? $data['checkedInVersion'] : null;
        $this->container['publishedBy'] = isset($data['publishedBy']) ? $data['publishedBy'] : null;
        $this->container['currentOperation'] = isset($data['currentOperation']) ? $data['currentOperation'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("INBOUNDCALL", "INBOUNDEMAIL", "INQUEUECALL", "OUTBOUNDCALL", "SECURECALL", "SPEECH", "WORKFLOW");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("INBOUNDCALL", "INBOUNDEMAIL", "INQUEUECALL", "OUTBOUNDCALL", "SECURECALL", "SPEECH", "WORKFLOW");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The flow name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('INBOUNDCALL', 'INBOUNDEMAIL', 'INQUEUECALL', 'OUTBOUNDCALL', 'SECURECALL', 'SPEECH', 'WORKFLOW');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'INBOUNDCALL', 'INBOUNDEMAIL', 'INQUEUECALL', 'OUTBOUNDCALL', 'SECURECALL', 'SPEECH', 'WORKFLOW'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets lockedUser
     * @return \PureCloudSDK\UriReference
     */
    public function getLockedUser()
    {
        return $this->container['lockedUser'];
    }

    /**
     * Sets lockedUser
     * @param \PureCloudSDK\UriReference $lockedUser
     * @return $this
     */
    public function setLockedUser($lockedUser)
    {
        $this->container['lockedUser'] = $lockedUser;

        return $this;
    }

    /**
     * Gets active
     * @return bool
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     * @param bool $active
     * @return $this
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets system
     * @return bool
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     * @param bool $system
     * @return $this
     */
    public function setSystem($system)
    {
        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets deleted
     * @return bool
     */
    public function getDeleted()
    {
        return $this->container['deleted'];
    }

    /**
     * Sets deleted
     * @param bool $deleted
     * @return $this
     */
    public function setDeleted($deleted)
    {
        $this->container['deleted'] = $deleted;

        return $this;
    }

    /**
     * Gets publishedVersion
     * @return \PureCloudSDK\FlowVersion
     */
    public function getPublishedVersion()
    {
        return $this->container['publishedVersion'];
    }

    /**
     * Sets publishedVersion
     * @param \PureCloudSDK\FlowVersion $publishedVersion
     * @return $this
     */
    public function setPublishedVersion($publishedVersion)
    {
        $this->container['publishedVersion'] = $publishedVersion;

        return $this;
    }

    /**
     * Gets savedVersion
     * @return \PureCloudSDK\FlowVersion
     */
    public function getSavedVersion()
    {
        return $this->container['savedVersion'];
    }

    /**
     * Sets savedVersion
     * @param \PureCloudSDK\FlowVersion $savedVersion
     * @return $this
     */
    public function setSavedVersion($savedVersion)
    {
        $this->container['savedVersion'] = $savedVersion;

        return $this;
    }

    /**
     * Gets inputSchema
     * @return object
     */
    public function getInputSchema()
    {
        return $this->container['inputSchema'];
    }

    /**
     * Sets inputSchema
     * @param object $inputSchema json schema describing the inputs for the flow
     * @return $this
     */
    public function setInputSchema($inputSchema)
    {
        $this->container['inputSchema'] = $inputSchema;

        return $this;
    }

    /**
     * Gets outputSchema
     * @return object
     */
    public function getOutputSchema()
    {
        return $this->container['outputSchema'];
    }

    /**
     * Sets outputSchema
     * @param object $outputSchema json schema describing the outputs for the flow
     * @return $this
     */
    public function setOutputSchema($outputSchema)
    {
        $this->container['outputSchema'] = $outputSchema;

        return $this;
    }

    /**
     * Gets checkedInVersion
     * @return \PureCloudSDK\FlowVersion
     */
    public function getCheckedInVersion()
    {
        return $this->container['checkedInVersion'];
    }

    /**
     * Sets checkedInVersion
     * @param \PureCloudSDK\FlowVersion $checkedInVersion
     * @return $this
     */
    public function setCheckedInVersion($checkedInVersion)
    {
        $this->container['checkedInVersion'] = $checkedInVersion;

        return $this;
    }

    /**
     * Gets publishedBy
     * @return \PureCloudSDK\UriReference
     */
    public function getPublishedBy()
    {
        return $this->container['publishedBy'];
    }

    /**
     * Sets publishedBy
     * @param \PureCloudSDK\UriReference $publishedBy
     * @return $this
     */
    public function setPublishedBy($publishedBy)
    {
        $this->container['publishedBy'] = $publishedBy;

        return $this;
    }

    /**
     * Gets currentOperation
     * @return \PureCloudSDK\Operation
     */
    public function getCurrentOperation()
    {
        return $this->container['currentOperation'];
    }

    /**
     * Sets currentOperation
     * @param \PureCloudSDK\Operation $currentOperation
     * @return $this
     */
    public function setCurrentOperation($currentOperation)
    {
        $this->container['currentOperation'] = $currentOperation;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


