<?php
/**
 * FlowConfigMetaData
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowConfigMetaData Class Doc Comment
 *
 * @category    Class */
 // @description Details about the current state of a Flow Definition
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowConfigMetaData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowConfigMetaData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'configState' => 'string',
        'flowType' => 'string',
        'lockedByUser' => '\PureCloudSDK\User',
        'newestPublishedVersion' => 'string',
        'newestVersion' => 'string',
        'associatedWorkspaces' => '\PureCloudSDK\Workspace[]',
        'description' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'configState' => 'configState',
        'flowType' => 'flowType',
        'lockedByUser' => 'lockedByUser',
        'newestPublishedVersion' => 'newestPublishedVersion',
        'newestVersion' => 'newestVersion',
        'associatedWorkspaces' => 'associatedWorkspaces',
        'description' => 'description',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'configState' => 'setConfigState',
        'flowType' => 'setFlowType',
        'lockedByUser' => 'setLockedByUser',
        'newestPublishedVersion' => 'setNewestPublishedVersion',
        'newestVersion' => 'setNewestVersion',
        'associatedWorkspaces' => 'setAssociatedWorkspaces',
        'description' => 'setDescription',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'configState' => 'getConfigState',
        'flowType' => 'getFlowType',
        'lockedByUser' => 'getLockedByUser',
        'newestPublishedVersion' => 'getNewestPublishedVersion',
        'newestVersion' => 'getNewestVersion',
        'associatedWorkspaces' => 'getAssociatedWorkspaces',
        'description' => 'getDescription',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const CONFIG_STATE_UNKNOWN = 'UNKNOWN';
    const CONFIG_STATE_ACTIVE = 'ACTIVE';
    const CONFIG_STATE_INACTIVE = 'INACTIVE';
    const CONFIG_STATE_DELETED = 'DELETED';
    const FLOW_TYPE_UNKNOWN = 'UNKNOWN';
    const FLOW_TYPE_WORKFLOW = 'WORKFLOW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getConfigStateAllowableValues()
    {
        return [
            self::CONFIG_STATE_UNKNOWN,
            self::CONFIG_STATE_ACTIVE,
            self::CONFIG_STATE_INACTIVE,
            self::CONFIG_STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowTypeAllowableValues()
    {
        return [
            self::FLOW_TYPE_UNKNOWN,
            self::FLOW_TYPE_WORKFLOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['configState'] = isset($data['configState']) ? $data['configState'] : null;
        $this->container['flowType'] = isset($data['flowType']) ? $data['flowType'] : null;
        $this->container['lockedByUser'] = isset($data['lockedByUser']) ? $data['lockedByUser'] : null;
        $this->container['newestPublishedVersion'] = isset($data['newestPublishedVersion']) ? $data['newestPublishedVersion'] : null;
        $this->container['newestVersion'] = isset($data['newestVersion']) ? $data['newestVersion'] : null;
        $this->container['associatedWorkspaces'] = isset($data['associatedWorkspaces']) ? $data['associatedWorkspaces'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("UNKNOWN", "ACTIVE", "INACTIVE", "DELETED");
        if (!in_array($this->container['configState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'configState', must be one of #{allowed_values}.";
        }

        if ($this->container['flowType'] === null) {
            $invalid_properties[] = "'flowType' can't be null";
        }
        $allowed_values = array("UNKNOWN", "WORKFLOW");
        if (!in_array($this->container['flowType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'flowType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("UNKNOWN", "ACTIVE", "INACTIVE", "DELETED");
        if (!in_array($this->container['configState'], $allowed_values)) {
            return false;
        }
        if ($this->container['flowType'] === null) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "WORKFLOW");
        if (!in_array($this->container['flowType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets configState
     * @return string
     */
    public function getConfigState()
    {
        return $this->container['configState'];
    }

    /**
     * Sets configState
     * @param string $configState Usability of this flow definition. (output only)
     * @return $this
     */
    public function setConfigState($configState)
    {
        $allowed_values = array('UNKNOWN', 'ACTIVE', 'INACTIVE', 'DELETED');
        if (!in_array($configState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'configState', must be one of 'UNKNOWN', 'ACTIVE', 'INACTIVE', 'DELETED'");
        }
        $this->container['configState'] = $configState;

        return $this;
    }

    /**
     * Gets flowType
     * @return string
     */
    public function getFlowType()
    {
        return $this->container['flowType'];
    }

    /**
     * Sets flowType
     * @param string $flowType Type of flow this definition describes
     * @return $this
     */
    public function setFlowType($flowType)
    {
        $allowed_values = array('UNKNOWN', 'WORKFLOW');
        if (!in_array($flowType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowType', must be one of 'UNKNOWN', 'WORKFLOW'");
        }
        $this->container['flowType'] = $flowType;

        return $this;
    }

    /**
     * Gets lockedByUser
     * @return \PureCloudSDK\User
     */
    public function getLockedByUser()
    {
        return $this->container['lockedByUser'];
    }

    /**
     * Sets lockedByUser
     * @param \PureCloudSDK\User $lockedByUser If locked for editing, the user who locked this definition, otherwise null
     * @return $this
     */
    public function setLockedByUser($lockedByUser)
    {
        $this->container['lockedByUser'] = $lockedByUser;

        return $this;
    }

    /**
     * Gets newestPublishedVersion
     * @return string
     */
    public function getNewestPublishedVersion()
    {
        return $this->container['newestPublishedVersion'];
    }

    /**
     * Sets newestPublishedVersion
     * @param string $newestPublishedVersion The most recently published version (output only)
     * @return $this
     */
    public function setNewestPublishedVersion($newestPublishedVersion)
    {
        $this->container['newestPublishedVersion'] = $newestPublishedVersion;

        return $this;
    }

    /**
     * Gets newestVersion
     * @return string
     */
    public function getNewestVersion()
    {
        return $this->container['newestVersion'];
    }

    /**
     * Sets newestVersion
     * @param string $newestVersion The most recent version, regardless of published state (output only)
     * @return $this
     */
    public function setNewestVersion($newestVersion)
    {
        $this->container['newestVersion'] = $newestVersion;

        return $this;
    }

    /**
     * Gets associatedWorkspaces
     * @return \PureCloudSDK\Workspace[]
     */
    public function getAssociatedWorkspaces()
    {
        return $this->container['associatedWorkspaces'];
    }

    /**
     * Sets associatedWorkspaces
     * @param \PureCloudSDK\Workspace[] $associatedWorkspaces Workspaces associated with this flow.
     * @return $this
     */
    public function setAssociatedWorkspaces($associatedWorkspaces)
    {
        $this->container['associatedWorkspaces'] = $associatedWorkspaces;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description User notes describing the flow definition.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


