<?php
/**
 * FlowLaunchRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowLaunchRequest Class Doc Comment
 *
 * @category    Class */
 // @description Passed into a flow to describe an object to launch and returned from the operation with the Id populated with the flowInstance launched.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowLaunchRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowLaunchRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'flowConfigId' => '\PureCloudSDK\FlowConfigId',
        'flowInstanceName' => 'string',
        'inputData' => '\PureCloudSDK\FlowInputData',
        'launchType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'flowConfigId' => 'flowConfigId',
        'flowInstanceName' => 'flowInstanceName',
        'inputData' => 'inputData',
        'launchType' => 'launchType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'flowConfigId' => 'setFlowConfigId',
        'flowInstanceName' => 'setFlowInstanceName',
        'inputData' => 'setInputData',
        'launchType' => 'setLaunchType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'flowConfigId' => 'getFlowConfigId',
        'flowInstanceName' => 'getFlowInstanceName',
        'inputData' => 'getInputData',
        'launchType' => 'getLaunchType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const LAUNCH_TYPE_UNKNOWN = 'UNKNOWN';
    const LAUNCH_TYPE_NORMAL = 'NORMAL';
    const LAUNCH_TYPE_TEST = 'TEST';
    const LAUNCH_TYPE_AUTOMATIC = 'AUTOMATIC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLaunchTypeAllowableValues()
    {
        return [
            self::LAUNCH_TYPE_UNKNOWN,
            self::LAUNCH_TYPE_NORMAL,
            self::LAUNCH_TYPE_TEST,
            self::LAUNCH_TYPE_AUTOMATIC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['flowConfigId'] = isset($data['flowConfigId']) ? $data['flowConfigId'] : null;
        $this->container['flowInstanceName'] = isset($data['flowInstanceName']) ? $data['flowInstanceName'] : null;
        $this->container['inputData'] = isset($data['inputData']) ? $data['inputData'] : null;
        $this->container['launchType'] = isset($data['launchType']) ? $data['launchType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowConfigId'] === null) {
            $invalid_properties[] = "'flowConfigId' can't be null";
        }
        if ($this->container['launchType'] === null) {
            $invalid_properties[] = "'launchType' can't be null";
        }
        $allowed_values = array("UNKNOWN", "NORMAL", "TEST", "AUTOMATIC");
        if (!in_array($this->container['launchType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'launchType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowConfigId'] === null) {
            return false;
        }
        if ($this->container['launchType'] === null) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "NORMAL", "TEST", "AUTOMATIC");
        if (!in_array($this->container['launchType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets flowConfigId
     * @return \PureCloudSDK\FlowConfigId
     */
    public function getFlowConfigId()
    {
        return $this->container['flowConfigId'];
    }

    /**
     * Sets flowConfigId
     * @param \PureCloudSDK\FlowConfigId $flowConfigId ID of the flow to launch, will launch the most recently published version if a specific version is not specified.
     * @return $this
     */
    public function setFlowConfigId($flowConfigId)
    {
        $this->container['flowConfigId'] = $flowConfigId;

        return $this;
    }

    /**
     * Gets flowInstanceName
     * @return string
     */
    public function getFlowInstanceName()
    {
        return $this->container['flowInstanceName'];
    }

    /**
     * Sets flowInstanceName
     * @param string $flowInstanceName The displayable instance name to assign to the new flow instance (or omit to have one automatically generated)
     * @return $this
     */
    public function setFlowInstanceName($flowInstanceName)
    {
        $this->container['flowInstanceName'] = $flowInstanceName;

        return $this;
    }

    /**
     * Gets inputData
     * @return \PureCloudSDK\FlowInputData
     */
    public function getInputData()
    {
        return $this->container['inputData'];
    }

    /**
     * Sets inputData
     * @param \PureCloudSDK\FlowInputData $inputData contains launch parameters or initializations for variables in the flow.
     * @return $this
     */
    public function setInputData($inputData)
    {
        $this->container['inputData'] = $inputData;

        return $this;
    }

    /**
     * Gets launchType
     * @return string
     */
    public function getLaunchType()
    {
        return $this->container['launchType'];
    }

    /**
     * Sets launchType
     * @param string $launchType launch type of the flow - NORMAL or TEST
     * @return $this
     */
    public function setLaunchType($launchType)
    {
        $allowed_values = array('UNKNOWN', 'NORMAL', 'TEST', 'AUTOMATIC');
        if (!in_array($launchType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'launchType', must be one of 'UNKNOWN', 'NORMAL', 'TEST', 'AUTOMATIC'");
        }
        $this->container['launchType'] = $launchType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


