<?php
/**
 * FlowReportResultItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowReportResultItem Class Doc Comment
 *
 * @category    Class */
 // @description Report for one active (running) process found in result to a report request.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowReportResultItem implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowReportResultItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'flowExecId' => '\PureCloudSDK\FlowExecId',
        'flowConfigId' => '\PureCloudSDK\FlowConfigId',
        'associatedDocument' => '\PureCloudSDK\AssociatedDocument',
        'flowStatus' => 'string',
        'currentState' => 'string',
        'startDateTime' => '\DateTime',
        'endDateTime' => '\DateTime',
        'workItemUserAssignees' => '\PureCloudSDK\User[]',
        'completedUser' => '\PureCloudSDK\User',
        'completionReason' => 'string',
        'flowErrorInfo' => '\PureCloudSDK\ErrorBody'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'flowExecId' => 'flowExecId',
        'flowConfigId' => 'flowConfigId',
        'associatedDocument' => 'associatedDocument',
        'flowStatus' => 'flowStatus',
        'currentState' => 'currentState',
        'startDateTime' => 'startDateTime',
        'endDateTime' => 'endDateTime',
        'workItemUserAssignees' => 'workItemUserAssignees',
        'completedUser' => 'completedUser',
        'completionReason' => 'completionReason',
        'flowErrorInfo' => 'flowErrorInfo'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'flowExecId' => 'setFlowExecId',
        'flowConfigId' => 'setFlowConfigId',
        'associatedDocument' => 'setAssociatedDocument',
        'flowStatus' => 'setFlowStatus',
        'currentState' => 'setCurrentState',
        'startDateTime' => 'setStartDateTime',
        'endDateTime' => 'setEndDateTime',
        'workItemUserAssignees' => 'setWorkItemUserAssignees',
        'completedUser' => 'setCompletedUser',
        'completionReason' => 'setCompletionReason',
        'flowErrorInfo' => 'setFlowErrorInfo'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'flowExecId' => 'getFlowExecId',
        'flowConfigId' => 'getFlowConfigId',
        'associatedDocument' => 'getAssociatedDocument',
        'flowStatus' => 'getFlowStatus',
        'currentState' => 'getCurrentState',
        'startDateTime' => 'getStartDateTime',
        'endDateTime' => 'getEndDateTime',
        'workItemUserAssignees' => 'getWorkItemUserAssignees',
        'completedUser' => 'getCompletedUser',
        'completionReason' => 'getCompletionReason',
        'flowErrorInfo' => 'getFlowErrorInfo'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const FLOW_STATUS_UNKNOWN = 'UNKNOWN';
    const FLOW_STATUS_RUNNING = 'RUNNING';
    const FLOW_STATUS_ERROR = 'ERROR';
    const FLOW_STATUS_TERMINATED = 'TERMINATED';
    const FLOW_STATUS_COMPLETED = 'COMPLETED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowStatusAllowableValues()
    {
        return [
            self::FLOW_STATUS_UNKNOWN,
            self::FLOW_STATUS_RUNNING,
            self::FLOW_STATUS_ERROR,
            self::FLOW_STATUS_TERMINATED,
            self::FLOW_STATUS_COMPLETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['flowExecId'] = isset($data['flowExecId']) ? $data['flowExecId'] : null;
        $this->container['flowConfigId'] = isset($data['flowConfigId']) ? $data['flowConfigId'] : null;
        $this->container['associatedDocument'] = isset($data['associatedDocument']) ? $data['associatedDocument'] : null;
        $this->container['flowStatus'] = isset($data['flowStatus']) ? $data['flowStatus'] : null;
        $this->container['currentState'] = isset($data['currentState']) ? $data['currentState'] : null;
        $this->container['startDateTime'] = isset($data['startDateTime']) ? $data['startDateTime'] : null;
        $this->container['endDateTime'] = isset($data['endDateTime']) ? $data['endDateTime'] : null;
        $this->container['workItemUserAssignees'] = isset($data['workItemUserAssignees']) ? $data['workItemUserAssignees'] : null;
        $this->container['completedUser'] = isset($data['completedUser']) ? $data['completedUser'] : null;
        $this->container['completionReason'] = isset($data['completionReason']) ? $data['completionReason'] : null;
        $this->container['flowErrorInfo'] = isset($data['flowErrorInfo']) ? $data['flowErrorInfo'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowExecId'] === null) {
            $invalid_properties[] = "'flowExecId' can't be null";
        }
        if ($this->container['flowConfigId'] === null) {
            $invalid_properties[] = "'flowConfigId' can't be null";
        }
        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED");
        if (!in_array($this->container['flowStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'flowStatus', must be one of #{allowed_values}.";
        }

        if ($this->container['currentState'] === null) {
            $invalid_properties[] = "'currentState' can't be null";
        }
        if ($this->container['startDateTime'] === null) {
            $invalid_properties[] = "'startDateTime' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowExecId'] === null) {
            return false;
        }
        if ($this->container['flowConfigId'] === null) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED");
        if (!in_array($this->container['flowStatus'], $allowed_values)) {
            return false;
        }
        if ($this->container['currentState'] === null) {
            return false;
        }
        if ($this->container['startDateTime'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets flowExecId
     * @return \PureCloudSDK\FlowExecId
     */
    public function getFlowExecId()
    {
        return $this->container['flowExecId'];
    }

    /**
     * Sets flowExecId
     * @param \PureCloudSDK\FlowExecId $flowExecId The flow instance ID for this process
     * @return $this
     */
    public function setFlowExecId($flowExecId)
    {
        $this->container['flowExecId'] = $flowExecId;

        return $this;
    }

    /**
     * Gets flowConfigId
     * @return \PureCloudSDK\FlowConfigId
     */
    public function getFlowConfigId()
    {
        return $this->container['flowConfigId'];
    }

    /**
     * Sets flowConfigId
     * @param \PureCloudSDK\FlowConfigId $flowConfigId The flow config ID that this workitem was created from.
     * @return $this
     */
    public function setFlowConfigId($flowConfigId)
    {
        $this->container['flowConfigId'] = $flowConfigId;

        return $this;
    }

    /**
     * Gets associatedDocument
     * @return \PureCloudSDK\AssociatedDocument
     */
    public function getAssociatedDocument()
    {
        return $this->container['associatedDocument'];
    }

    /**
     * Sets associatedDocument
     * @param \PureCloudSDK\AssociatedDocument $associatedDocument the document for this flow (if this flow was launched via a document)
     * @return $this
     */
    public function setAssociatedDocument($associatedDocument)
    {
        $this->container['associatedDocument'] = $associatedDocument;

        return $this;
    }

    /**
     * Gets flowStatus
     * @return string
     */
    public function getFlowStatus()
    {
        return $this->container['flowStatus'];
    }

    /**
     * Sets flowStatus
     * @param string $flowStatus The flow's running status, which indicates whether the flow is running normally or in error, etc;
     * @return $this
     */
    public function setFlowStatus($flowStatus)
    {
        $allowed_values = array('UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED');
        if (!in_array($flowStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowStatus', must be one of 'UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED'");
        }
        $this->container['flowStatus'] = $flowStatus;

        return $this;
    }

    /**
     * Gets currentState
     * @return string
     */
    public function getCurrentState()
    {
        return $this->container['currentState'];
    }

    /**
     * Sets currentState
     * @param string $currentState The current state of the flow (EG what action is being processed)
     * @return $this
     */
    public function setCurrentState($currentState)
    {
        $this->container['currentState'] = $currentState;

        return $this;
    }

    /**
     * Gets startDateTime
     * @return \DateTime
     */
    public function getStartDateTime()
    {
        return $this->container['startDateTime'];
    }

    /**
     * Sets startDateTime
     * @param \DateTime $startDateTime The time the flow was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDateTime($startDateTime)
    {
        $this->container['startDateTime'] = $startDateTime;

        return $this;
    }

    /**
     * Gets endDateTime
     * @return \DateTime
     */
    public function getEndDateTime()
    {
        return $this->container['endDateTime'];
    }

    /**
     * Sets endDateTime
     * @param \DateTime $endDateTime The time the flow ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDateTime($endDateTime)
    {
        $this->container['endDateTime'] = $endDateTime;

        return $this;
    }

    /**
     * Gets workItemUserAssignees
     * @return \PureCloudSDK\User[]
     */
    public function getWorkItemUserAssignees()
    {
        return $this->container['workItemUserAssignees'];
    }

    /**
     * Sets workItemUserAssignees
     * @param \PureCloudSDK\User[] $workItemUserAssignees List of users currently assigned to a workItem
     * @return $this
     */
    public function setWorkItemUserAssignees($workItemUserAssignees)
    {
        $this->container['workItemUserAssignees'] = $workItemUserAssignees;

        return $this;
    }

    /**
     * Gets completedUser
     * @return \PureCloudSDK\User
     */
    public function getCompletedUser()
    {
        return $this->container['completedUser'];
    }

    /**
     * Sets completedUser
     * @param \PureCloudSDK\User $completedUser User that completed the flow
     * @return $this
     */
    public function setCompletedUser($completedUser)
    {
        $this->container['completedUser'] = $completedUser;

        return $this;
    }

    /**
     * Gets completionReason
     * @return string
     */
    public function getCompletionReason()
    {
        return $this->container['completionReason'];
    }

    /**
     * Sets completionReason
     * @param string $completionReason Reason for completion
     * @return $this
     */
    public function setCompletionReason($completionReason)
    {
        $this->container['completionReason'] = $completionReason;

        return $this;
    }

    /**
     * Gets flowErrorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getFlowErrorInfo()
    {
        return $this->container['flowErrorInfo'];
    }

    /**
     * Sets flowErrorInfo
     * @param \PureCloudSDK\ErrorBody $flowErrorInfo Additional information if the flow is in error
     * @return $this
     */
    public function setFlowErrorInfo($flowErrorInfo)
    {
        $this->container['flowErrorInfo'] = $flowErrorInfo;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


