<?php
/**
 * ForecastModification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ForecastModification Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ForecastModification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ForecastModification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'forecastId' => 'string',
        'priority' => 'int',
        'metric' => 'string',
        'modificationType' => 'string',
        'modificationValue' => 'double',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'attributes' => '\PureCloudSDK\ForecastFilterAttributes',
        'enabled' => 'bool',
        'lastModifiedDate' => '\DateTime',
        'lastModifiedBy' => '\PureCloudSDK\User',
        'notes' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'forecastId' => 'forecastId',
        'priority' => 'priority',
        'metric' => 'metric',
        'modificationType' => 'modificationType',
        'modificationValue' => 'modificationValue',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'attributes' => 'attributes',
        'enabled' => 'enabled',
        'lastModifiedDate' => 'lastModifiedDate',
        'lastModifiedBy' => 'lastModifiedBy',
        'notes' => 'notes',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'forecastId' => 'setForecastId',
        'priority' => 'setPriority',
        'metric' => 'setMetric',
        'modificationType' => 'setModificationType',
        'modificationValue' => 'setModificationValue',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'attributes' => 'setAttributes',
        'enabled' => 'setEnabled',
        'lastModifiedDate' => 'setLastModifiedDate',
        'lastModifiedBy' => 'setLastModifiedBy',
        'notes' => 'setNotes',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'forecastId' => 'getForecastId',
        'priority' => 'getPriority',
        'metric' => 'getMetric',
        'modificationType' => 'getModificationType',
        'modificationValue' => 'getModificationValue',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'attributes' => 'getAttributes',
        'enabled' => 'getEnabled',
        'lastModifiedDate' => 'getLastModifiedDate',
        'lastModifiedBy' => 'getLastModifiedBy',
        'notes' => 'getNotes',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const METRIC_VOLUME = 'VOLUME';
    const METRIC_ATT = 'ATT';
    const METRIC_ACW = 'ACW';
    const MODIFICATION_TYPE_MINIMUM_PER_INTERVAL = 'MINIMUM_PER_INTERVAL';
    const MODIFICATION_TYPE_MAXIMUM_PER_INTERVAL = 'MAXIMUM_PER_INTERVAL';
    const MODIFICATION_TYPE_SET_VALUE_PER_INTERVAL = 'SET_VALUE_PER_INTERVAL';
    const MODIFICATION_TYPE_CHANGE_VALUE_PER_INTERVAL = 'CHANGE_VALUE_PER_INTERVAL';
    const MODIFICATION_TYPE_CHANGE_PERCENT_PER_INTERVAL = 'CHANGE_PERCENT_PER_INTERVAL';
    const MODIFICATION_TYPE_SET_VALUE_OVER_RANGE = 'SET_VALUE_OVER_RANGE';
    const MODIFICATION_TYPE_CHANGE_VALUE_OVER_RANGE = 'CHANGE_VALUE_OVER_RANGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_VOLUME,
            self::METRIC_ATT,
            self::METRIC_ACW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getModificationTypeAllowableValues()
    {
        return [
            self::MODIFICATION_TYPE_MINIMUM_PER_INTERVAL,
            self::MODIFICATION_TYPE_MAXIMUM_PER_INTERVAL,
            self::MODIFICATION_TYPE_SET_VALUE_PER_INTERVAL,
            self::MODIFICATION_TYPE_CHANGE_VALUE_PER_INTERVAL,
            self::MODIFICATION_TYPE_CHANGE_PERCENT_PER_INTERVAL,
            self::MODIFICATION_TYPE_SET_VALUE_OVER_RANGE,
            self::MODIFICATION_TYPE_CHANGE_VALUE_OVER_RANGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['forecastId'] = isset($data['forecastId']) ? $data['forecastId'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['modificationType'] = isset($data['modificationType']) ? $data['modificationType'] : null;
        $this->container['modificationValue'] = isset($data['modificationValue']) ? $data['modificationValue'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['lastModifiedDate'] = isset($data['lastModifiedDate']) ? $data['lastModifiedDate'] : null;
        $this->container['lastModifiedBy'] = isset($data['lastModifiedBy']) ? $data['lastModifiedBy'] : null;
        $this->container['notes'] = isset($data['notes']) ? $data['notes'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['forecastId'] === null) {
            $invalid_properties[] = "'forecastId' can't be null";
        }
        if ($this->container['priority'] === null) {
            $invalid_properties[] = "'priority' can't be null";
        }
        if ($this->container['metric'] === null) {
            $invalid_properties[] = "'metric' can't be null";
        }
        $allowed_values = array("VOLUME", "ATT", "ACW");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        if ($this->container['modificationType'] === null) {
            $invalid_properties[] = "'modificationType' can't be null";
        }
        $allowed_values = array("MINIMUM_PER_INTERVAL", "MAXIMUM_PER_INTERVAL", "SET_VALUE_PER_INTERVAL", "CHANGE_VALUE_PER_INTERVAL", "CHANGE_PERCENT_PER_INTERVAL", "SET_VALUE_OVER_RANGE", "CHANGE_VALUE_OVER_RANGE");
        if (!in_array($this->container['modificationType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'modificationType', must be one of #{allowed_values}.";
        }

        if ($this->container['modificationValue'] === null) {
            $invalid_properties[] = "'modificationValue' can't be null";
        }
        if ($this->container['startDate'] === null) {
            $invalid_properties[] = "'startDate' can't be null";
        }
        if ($this->container['endDate'] === null) {
            $invalid_properties[] = "'endDate' can't be null";
        }
        if ($this->container['attributes'] === null) {
            $invalid_properties[] = "'attributes' can't be null";
        }
        if ($this->container['enabled'] === null) {
            $invalid_properties[] = "'enabled' can't be null";
        }
        if ($this->container['lastModifiedDate'] === null) {
            $invalid_properties[] = "'lastModifiedDate' can't be null";
        }
        if ($this->container['lastModifiedBy'] === null) {
            $invalid_properties[] = "'lastModifiedBy' can't be null";
        }
        if ($this->container['notes'] === null) {
            $invalid_properties[] = "'notes' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['forecastId'] === null) {
            return false;
        }
        if ($this->container['priority'] === null) {
            return false;
        }
        if ($this->container['metric'] === null) {
            return false;
        }
        $allowed_values = array("VOLUME", "ATT", "ACW");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        if ($this->container['modificationType'] === null) {
            return false;
        }
        $allowed_values = array("MINIMUM_PER_INTERVAL", "MAXIMUM_PER_INTERVAL", "SET_VALUE_PER_INTERVAL", "CHANGE_VALUE_PER_INTERVAL", "CHANGE_PERCENT_PER_INTERVAL", "SET_VALUE_OVER_RANGE", "CHANGE_VALUE_OVER_RANGE");
        if (!in_array($this->container['modificationType'], $allowed_values)) {
            return false;
        }
        if ($this->container['modificationValue'] === null) {
            return false;
        }
        if ($this->container['startDate'] === null) {
            return false;
        }
        if ($this->container['endDate'] === null) {
            return false;
        }
        if ($this->container['attributes'] === null) {
            return false;
        }
        if ($this->container['enabled'] === null) {
            return false;
        }
        if ($this->container['lastModifiedDate'] === null) {
            return false;
        }
        if ($this->container['lastModifiedBy'] === null) {
            return false;
        }
        if ($this->container['notes'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets forecastId
     * @return string
     */
    public function getForecastId()
    {
        return $this->container['forecastId'];
    }

    /**
     * Sets forecastId
     * @param string $forecastId The id of the associated forecast
     * @return $this
     */
    public function setForecastId($forecastId)
    {
        $this->container['forecastId'] = $forecastId;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority in which the modification is applied
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric The metric the modification is appied to
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('VOLUME', 'ATT', 'ACW');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'VOLUME', 'ATT', 'ACW'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets modificationType
     * @return string
     */
    public function getModificationType()
    {
        return $this->container['modificationType'];
    }

    /**
     * Sets modificationType
     * @param string $modificationType The type of modification
     * @return $this
     */
    public function setModificationType($modificationType)
    {
        $allowed_values = array('MINIMUM_PER_INTERVAL', 'MAXIMUM_PER_INTERVAL', 'SET_VALUE_PER_INTERVAL', 'CHANGE_VALUE_PER_INTERVAL', 'CHANGE_PERCENT_PER_INTERVAL', 'SET_VALUE_OVER_RANGE', 'CHANGE_VALUE_OVER_RANGE');
        if (!in_array($modificationType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'modificationType', must be one of 'MINIMUM_PER_INTERVAL', 'MAXIMUM_PER_INTERVAL', 'SET_VALUE_PER_INTERVAL', 'CHANGE_VALUE_PER_INTERVAL', 'CHANGE_PERCENT_PER_INTERVAL', 'SET_VALUE_OVER_RANGE', 'CHANGE_VALUE_OVER_RANGE'");
        }
        $this->container['modificationType'] = $modificationType;

        return $this;
    }

    /**
     * Gets modificationValue
     * @return double
     */
    public function getModificationValue()
    {
        return $this->container['modificationValue'];
    }

    /**
     * Sets modificationValue
     * @param double $modificationValue The value of the modification
     * @return $this
     */
    public function setModificationValue($modificationValue)
    {
        $this->container['modificationValue'] = $modificationValue;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The start of the modified time period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate The end of the modified time period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets attributes
     * @return \PureCloudSDK\ForecastFilterAttributes
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param \PureCloudSDK\ForecastFilterAttributes $attributes The filters for the modification
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Determined if the modification is currently applied
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets lastModifiedDate
     * @return \DateTime
     */
    public function getLastModifiedDate()
    {
        return $this->container['lastModifiedDate'];
    }

    /**
     * Sets lastModifiedDate
     * @param \DateTime $lastModifiedDate The last time the modification was changed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastModifiedDate($lastModifiedDate)
    {
        $this->container['lastModifiedDate'] = $lastModifiedDate;

        return $this;
    }

    /**
     * Gets lastModifiedBy
     * @return \PureCloudSDK\User
     */
    public function getLastModifiedBy()
    {
        return $this->container['lastModifiedBy'];
    }

    /**
     * Sets lastModifiedBy
     * @param \PureCloudSDK\User $lastModifiedBy The last user to change the modification
     * @return $this
     */
    public function setLastModifiedBy($lastModifiedBy)
    {
        $this->container['lastModifiedBy'] = $lastModifiedBy;

        return $this;
    }

    /**
     * Gets notes
     * @return string
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     * @param string $notes Any notes associated with the modification
     * @return $this
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


