<?php
/**
 * HealthCheckInfo
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * HealthCheckInfo Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HealthCheckInfo implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HealthCheckInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'selfUri' => 'string',
        'buildTime' => 'string',
        'buildVersion' => 'string',
        'implementationVersion' => 'string',
        'status' => 'string',
        'pingMs' => 'int',
        'date' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'selfUri' => 'selfUri',
        'buildTime' => 'Build-Time',
        'buildVersion' => 'Build-Version',
        'implementationVersion' => 'Implementation-Version',
        'status' => 'Status',
        'pingMs' => 'Ping-Ms',
        'date' => 'Date'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'selfUri' => 'setSelfUri',
        'buildTime' => 'setBuildTime',
        'buildVersion' => 'setBuildVersion',
        'implementationVersion' => 'setImplementationVersion',
        'status' => 'setStatus',
        'pingMs' => 'setPingMs',
        'date' => 'setDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'selfUri' => 'getSelfUri',
        'buildTime' => 'getBuildTime',
        'buildVersion' => 'getBuildVersion',
        'implementationVersion' => 'getImplementationVersion',
        'status' => 'getStatus',
        'pingMs' => 'getPingMs',
        'date' => 'getDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_OK = 'OK';
    const STATUS_CREATED = 'Created';
    const STATUS_ACCEPTED = 'Accepted';
    const STATUS_NO_CONTENT = 'No Content';
    const STATUS_RESET_CONTENT = 'Reset Content';
    const STATUS_PARTIAL_CONTENT = 'Partial Content';
    const STATUS_MOVED_PERMANENTLY = 'Moved Permanently';
    const STATUS_FOUND = 'Found';
    const STATUS_SEE_OTHER = 'See Other';
    const STATUS_NOT_MODIFIED = 'Not Modified';
    const STATUS_USE_PROXY = 'Use Proxy';
    const STATUS_TEMPORARY_REDIRECT = 'Temporary Redirect';
    const STATUS_BAD_REQUEST = 'Bad Request';
    const STATUS_UNAUTHORIZED = 'Unauthorized';
    const STATUS_PAYMENT_REQUIRED = 'Payment Required';
    const STATUS_FORBIDDEN = 'Forbidden';
    const STATUS_NOT_FOUND = 'Not Found';
    const STATUS_METHOD_NOT_ALLOWED = 'Method Not Allowed';
    const STATUS_NOT_ACCEPTABLE = 'Not Acceptable';
    const STATUS_PROXY_AUTHENTICATION_REQUIRED = 'Proxy Authentication Required';
    const STATUS_REQUEST_TIMEOUT = 'Request Timeout';
    const STATUS_CONFLICT = 'Conflict';
    const STATUS_GONE = 'Gone';
    const STATUS_LENGTH_REQUIRED = 'Length Required';
    const STATUS_PRECONDITION_FAILED = 'Precondition Failed';
    const STATUS_REQUEST_ENTITY_TOO_LARGE = 'Request Entity Too Large';
    const STATUS_REQUEST_URI_TOO_LONG = 'Request-URI Too Long';
    const STATUS_UNSUPPORTED_MEDIA_TYPE = 'Unsupported Media Type';
    const STATUS_REQUESTED_RANGE_NOT_SATISFIABLE = 'Requested Range Not Satisfiable';
    const STATUS_EXPECTATION_FAILED = 'Expectation Failed';
    const STATUS_INTERNAL_SERVER_ERROR = 'Internal Server Error';
    const STATUS_NOT_IMPLEMENTED = 'Not Implemented';
    const STATUS_BAD_GATEWAY = 'Bad Gateway';
    const STATUS_SERVICE_UNAVAILABLE = 'Service Unavailable';
    const STATUS_GATEWAY_TIMEOUT = 'Gateway Timeout';
    const STATUS_HTTP_VERSION_NOT_SUPPORTED = 'HTTP Version Not Supported';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_OK,
            self::STATUS_CREATED,
            self::STATUS_ACCEPTED,
            self::STATUS_NO_CONTENT,
            self::STATUS_RESET_CONTENT,
            self::STATUS_PARTIAL_CONTENT,
            self::STATUS_MOVED_PERMANENTLY,
            self::STATUS_FOUND,
            self::STATUS_SEE_OTHER,
            self::STATUS_NOT_MODIFIED,
            self::STATUS_USE_PROXY,
            self::STATUS_TEMPORARY_REDIRECT,
            self::STATUS_BAD_REQUEST,
            self::STATUS_UNAUTHORIZED,
            self::STATUS_PAYMENT_REQUIRED,
            self::STATUS_FORBIDDEN,
            self::STATUS_NOT_FOUND,
            self::STATUS_METHOD_NOT_ALLOWED,
            self::STATUS_NOT_ACCEPTABLE,
            self::STATUS_PROXY_AUTHENTICATION_REQUIRED,
            self::STATUS_REQUEST_TIMEOUT,
            self::STATUS_CONFLICT,
            self::STATUS_GONE,
            self::STATUS_LENGTH_REQUIRED,
            self::STATUS_PRECONDITION_FAILED,
            self::STATUS_REQUEST_ENTITY_TOO_LARGE,
            self::STATUS_REQUEST_URI_TOO_LONG,
            self::STATUS_UNSUPPORTED_MEDIA_TYPE,
            self::STATUS_REQUESTED_RANGE_NOT_SATISFIABLE,
            self::STATUS_EXPECTATION_FAILED,
            self::STATUS_INTERNAL_SERVER_ERROR,
            self::STATUS_NOT_IMPLEMENTED,
            self::STATUS_BAD_GATEWAY,
            self::STATUS_SERVICE_UNAVAILABLE,
            self::STATUS_GATEWAY_TIMEOUT,
            self::STATUS_HTTP_VERSION_NOT_SUPPORTED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['buildTime'] = isset($data['buildTime']) ? $data['buildTime'] : null;
        $this->container['buildVersion'] = isset($data['buildVersion']) ? $data['buildVersion'] : null;
        $this->container['implementationVersion'] = isset($data['implementationVersion']) ? $data['implementationVersion'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['pingMs'] = isset($data['pingMs']) ? $data['pingMs'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OK", "Created", "Accepted", "No Content", "Reset Content", "Partial Content", "Moved Permanently", "Found", "See Other", "Not Modified", "Use Proxy", "Temporary Redirect", "Bad Request", "Unauthorized", "Payment Required", "Forbidden", "Not Found", "Method Not Allowed", "Not Acceptable", "Proxy Authentication Required", "Request Timeout", "Conflict", "Gone", "Length Required", "Precondition Failed", "Request Entity Too Large", "Request-URI Too Long", "Unsupported Media Type", "Requested Range Not Satisfiable", "Expectation Failed", "Internal Server Error", "Not Implemented", "Bad Gateway", "Service Unavailable", "Gateway Timeout", "HTTP Version Not Supported");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OK", "Created", "Accepted", "No Content", "Reset Content", "Partial Content", "Moved Permanently", "Found", "See Other", "Not Modified", "Use Proxy", "Temporary Redirect", "Bad Request", "Unauthorized", "Payment Required", "Forbidden", "Not Found", "Method Not Allowed", "Not Acceptable", "Proxy Authentication Required", "Request Timeout", "Conflict", "Gone", "Length Required", "Precondition Failed", "Request Entity Too Large", "Request-URI Too Long", "Unsupported Media Type", "Requested Range Not Satisfiable", "Expectation Failed", "Internal Server Error", "Not Implemented", "Bad Gateway", "Service Unavailable", "Gateway Timeout", "HTTP Version Not Supported");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets buildTime
     * @return string
     */
    public function getBuildTime()
    {
        return $this->container['buildTime'];
    }

    /**
     * Sets buildTime
     * @param string $buildTime
     * @return $this
     */
    public function setBuildTime($buildTime)
    {
        $this->container['buildTime'] = $buildTime;

        return $this;
    }

    /**
     * Gets buildVersion
     * @return string
     */
    public function getBuildVersion()
    {
        return $this->container['buildVersion'];
    }

    /**
     * Sets buildVersion
     * @param string $buildVersion
     * @return $this
     */
    public function setBuildVersion($buildVersion)
    {
        $this->container['buildVersion'] = $buildVersion;

        return $this;
    }

    /**
     * Gets implementationVersion
     * @return string
     */
    public function getImplementationVersion()
    {
        return $this->container['implementationVersion'];
    }

    /**
     * Sets implementationVersion
     * @param string $implementationVersion
     * @return $this
     */
    public function setImplementationVersion($implementationVersion)
    {
        $this->container['implementationVersion'] = $implementationVersion;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('OK', 'Created', 'Accepted', 'No Content', 'Reset Content', 'Partial Content', 'Moved Permanently', 'Found', 'See Other', 'Not Modified', 'Use Proxy', 'Temporary Redirect', 'Bad Request', 'Unauthorized', 'Payment Required', 'Forbidden', 'Not Found', 'Method Not Allowed', 'Not Acceptable', 'Proxy Authentication Required', 'Request Timeout', 'Conflict', 'Gone', 'Length Required', 'Precondition Failed', 'Request Entity Too Large', 'Request-URI Too Long', 'Unsupported Media Type', 'Requested Range Not Satisfiable', 'Expectation Failed', 'Internal Server Error', 'Not Implemented', 'Bad Gateway', 'Service Unavailable', 'Gateway Timeout', 'HTTP Version Not Supported');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'OK', 'Created', 'Accepted', 'No Content', 'Reset Content', 'Partial Content', 'Moved Permanently', 'Found', 'See Other', 'Not Modified', 'Use Proxy', 'Temporary Redirect', 'Bad Request', 'Unauthorized', 'Payment Required', 'Forbidden', 'Not Found', 'Method Not Allowed', 'Not Acceptable', 'Proxy Authentication Required', 'Request Timeout', 'Conflict', 'Gone', 'Length Required', 'Precondition Failed', 'Request Entity Too Large', 'Request-URI Too Long', 'Unsupported Media Type', 'Requested Range Not Satisfiable', 'Expectation Failed', 'Internal Server Error', 'Not Implemented', 'Bad Gateway', 'Service Unavailable', 'Gateway Timeout', 'HTTP Version Not Supported'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets pingMs
     * @return int
     */
    public function getPingMs()
    {
        return $this->container['pingMs'];
    }

    /**
     * Sets pingMs
     * @param int $pingMs
     * @return $this
     */
    public function setPingMs($pingMs)
    {
        $this->container['pingMs'] = $pingMs;

        return $this;
    }

    /**
     * Gets date
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \DateTime $date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


