<?php
/**
 * IntegrationType
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * IntegrationType Class Doc Comment
 *
 * @category    Class */
 // @description Descriptor for a type of Integration.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class IntegrationType implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'IntegrationType';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'provider' => 'string',
        'images' => '\PureCloudSDK\UserImage[]',
        'configPropertiesSchemaUri' => 'string',
        'configAdvancedSchemaUri' => 'string',
        'helpUri' => 'string',
        'credentials' => 'map[string,\PureCloudSDK\CredentialType]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'provider' => 'provider',
        'images' => 'images',
        'configPropertiesSchemaUri' => 'configPropertiesSchemaUri',
        'configAdvancedSchemaUri' => 'configAdvancedSchemaUri',
        'helpUri' => 'helpUri',
        'credentials' => 'credentials',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'provider' => 'setProvider',
        'images' => 'setImages',
        'configPropertiesSchemaUri' => 'setConfigPropertiesSchemaUri',
        'configAdvancedSchemaUri' => 'setConfigAdvancedSchemaUri',
        'helpUri' => 'setHelpUri',
        'credentials' => 'setCredentials',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'provider' => 'getProvider',
        'images' => 'getImages',
        'configPropertiesSchemaUri' => 'getConfigPropertiesSchemaUri',
        'configAdvancedSchemaUri' => 'getConfigAdvancedSchemaUri',
        'helpUri' => 'getHelpUri',
        'credentials' => 'getCredentials',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['images'] = isset($data['images']) ? $data['images'] : null;
        $this->container['configPropertiesSchemaUri'] = isset($data['configPropertiesSchemaUri']) ? $data['configPropertiesSchemaUri'] : null;
        $this->container['configAdvancedSchemaUri'] = isset($data['configAdvancedSchemaUri']) ? $data['configAdvancedSchemaUri'] : null;
        $this->container['helpUri'] = isset($data['helpUri']) ? $data['helpUri'] : null;
        $this->container['credentials'] = isset($data['credentials']) ? $data['credentials'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['id'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The ID of the integration type.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Localized description of the integration type.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider PureCloud provider of the integration type.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets images
     * @return \PureCloudSDK\UserImage[]
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     * @param \PureCloudSDK\UserImage[] $images Collection of logos.
     * @return $this
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets configPropertiesSchemaUri
     * @return string
     */
    public function getConfigPropertiesSchemaUri()
    {
        return $this->container['configPropertiesSchemaUri'];
    }

    /**
     * Sets configPropertiesSchemaUri
     * @param string $configPropertiesSchemaUri URI of the schema describing the key-value properties needed to configure an integration of this type.
     * @return $this
     */
    public function setConfigPropertiesSchemaUri($configPropertiesSchemaUri)
    {
        $this->container['configPropertiesSchemaUri'] = $configPropertiesSchemaUri;

        return $this;
    }

    /**
     * Gets configAdvancedSchemaUri
     * @return string
     */
    public function getConfigAdvancedSchemaUri()
    {
        return $this->container['configAdvancedSchemaUri'];
    }

    /**
     * Sets configAdvancedSchemaUri
     * @param string $configAdvancedSchemaUri URI of the schema describing the advanced JSON document needed to configure an integration of this type.
     * @return $this
     */
    public function setConfigAdvancedSchemaUri($configAdvancedSchemaUri)
    {
        $this->container['configAdvancedSchemaUri'] = $configAdvancedSchemaUri;

        return $this;
    }

    /**
     * Gets helpUri
     * @return string
     */
    public function getHelpUri()
    {
        return $this->container['helpUri'];
    }

    /**
     * Sets helpUri
     * @param string $helpUri URI of a page with more information about the integration type
     * @return $this
     */
    public function setHelpUri($helpUri)
    {
        $this->container['helpUri'] = $helpUri;

        return $this;
    }

    /**
     * Gets credentials
     * @return map[string,\PureCloudSDK\CredentialType]
     */
    public function getCredentials()
    {
        return $this->container['credentials'];
    }

    /**
     * Sets credentials
     * @param map[string,\PureCloudSDK\CredentialType] $credentials Map of required credentials for integrations of this type. The key is the name of a credential that must be provided in the credentials property of the integration configuration.
     * @return $this
     */
    public function setCredentials($credentials)
    {
        $this->container['credentials'] = $credentials;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


