<?php
/**
 * NumberOrder
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * NumberOrder Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class NumberOrder implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'NumberOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'did' => 'string',
        'effectiveStartDate' => '\DateTime',
        'effectiveEndDate' => '\DateTime',
        'lastUpdated' => '\DateTime',
        'startAuthUserId' => 'string',
        'endAuthUserId' => 'string',
        'status' => 'string',
        'phoneNumberType' => 'string',
        'porting' => 'bool',
        'portRequestId' => 'string',
        'billingAddress' => '\PureCloudSDK\PortBillingAddress',
        'responsibleContact' => '\PureCloudSDK\PortContact',
        'companyName' => 'string',
        'countryCode' => 'string',
        'envelopeId' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'did' => 'did',
        'effectiveStartDate' => 'effectiveStartDate',
        'effectiveEndDate' => 'effectiveEndDate',
        'lastUpdated' => 'lastUpdated',
        'startAuthUserId' => 'startAuthUserId',
        'endAuthUserId' => 'endAuthUserId',
        'status' => 'status',
        'phoneNumberType' => 'phoneNumberType',
        'porting' => 'porting',
        'portRequestId' => 'portRequestId',
        'billingAddress' => 'billingAddress',
        'responsibleContact' => 'responsibleContact',
        'companyName' => 'companyName',
        'countryCode' => 'countryCode',
        'envelopeId' => 'envelopeId',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'did' => 'setDid',
        'effectiveStartDate' => 'setEffectiveStartDate',
        'effectiveEndDate' => 'setEffectiveEndDate',
        'lastUpdated' => 'setLastUpdated',
        'startAuthUserId' => 'setStartAuthUserId',
        'endAuthUserId' => 'setEndAuthUserId',
        'status' => 'setStatus',
        'phoneNumberType' => 'setPhoneNumberType',
        'porting' => 'setPorting',
        'portRequestId' => 'setPortRequestId',
        'billingAddress' => 'setBillingAddress',
        'responsibleContact' => 'setResponsibleContact',
        'companyName' => 'setCompanyName',
        'countryCode' => 'setCountryCode',
        'envelopeId' => 'setEnvelopeId',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'did' => 'getDid',
        'effectiveStartDate' => 'getEffectiveStartDate',
        'effectiveEndDate' => 'getEffectiveEndDate',
        'lastUpdated' => 'getLastUpdated',
        'startAuthUserId' => 'getStartAuthUserId',
        'endAuthUserId' => 'getEndAuthUserId',
        'status' => 'getStatus',
        'phoneNumberType' => 'getPhoneNumberType',
        'porting' => 'getPorting',
        'portRequestId' => 'getPortRequestId',
        'billingAddress' => 'getBillingAddress',
        'responsibleContact' => 'getResponsibleContact',
        'companyName' => 'getCompanyName',
        'countryCode' => 'getCountryCode',
        'envelopeId' => 'getEnvelopeId',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_COMPLETE = 'COMPLETE';
    const STATUS_CONNECTING = 'CONNECTING';
    const STATUS_FAILED = 'FAILED';
    const STATUS_BACKORDERED = 'BACKORDERED';
    const STATUS_PENDING = 'PENDING';
    const STATUS_ACTIVATING = 'ACTIVATING';
    const STATUS_ACTIVATION_ERROR = 'ACTIVATION_ERROR';
    const STATUS_ERROR = 'ERROR';
    const STATUS_DISCONNECTED = 'DISCONNECTED';
    const STATUS_DISCONNECT_PENDING = 'DISCONNECT_PENDING';
    const STATUS_DEACTIVATING = 'DEACTIVATING';
    const STATUS_DEACTIVATION_ERROR = 'DEACTIVATION_ERROR';
    const STATUS_DISCONNECT_FAILED = 'DISCONNECT_FAILED';
    const STATUS_SUBMITTED = 'SUBMITTED';
    const STATUS_REJECTED = 'REJECTED';
    const STATUS_SUPP = 'SUPP';
    const STATUS_PORT_PENDING = 'PORT_PENDING';
    const STATUS_FOC = 'FOC';
    const PHONE_NUMBER_TYPE_TOLL_FREE = 'TOLL_FREE';
    const PHONE_NUMBER_TYPE_CN_DOMESTIC = 'CN_DOMESTIC';
    const PHONE_NUMBER_TYPE_US_DOMESTIC = 'US_DOMESTIC';
    const PHONE_NUMBER_TYPE_US_TOLLFREE = 'US_TOLLFREE';
    const PHONE_NUMBER_TYPE_XA_TOLLFREE = 'XA_TOLLFREE';
    const PHONE_NUMBER_TYPE_XB_TOLLFREE = 'XB_TOLLFREE';
    const PHONE_NUMBER_TYPE_XC_TOLLFREE = 'XC_TOLLFREE';
    const PHONE_NUMBER_TYPE_AG_DID = 'AG_DID';
    const PHONE_NUMBER_TYPE_AI_DID = 'AI_DID';
    const PHONE_NUMBER_TYPE_BB_DID = 'BB_DID';
    const PHONE_NUMBER_TYPE_BM_DID = 'BM_DID';
    const PHONE_NUMBER_TYPE_BS_DID = 'BS_DID';
    const PHONE_NUMBER_TYPE_CA_DID = 'CA_DID';
    const PHONE_NUMBER_TYPE_DM_DID = 'DM_DID';
    const PHONE_NUMBER_TYPE_DO_DID = 'DO_DID';
    const PHONE_NUMBER_TYPE_GD_DID = 'GD_DID';
    const PHONE_NUMBER_TYPE_JM_DID = 'JM_DID';
    const PHONE_NUMBER_TYPE_KN_DID = 'KN_DID';
    const PHONE_NUMBER_TYPE_KY_DID = 'KY_DID';
    const PHONE_NUMBER_TYPE_KZ_DID = 'KZ_DID';
    const PHONE_NUMBER_TYPE_LC_DID = 'LC_DID';
    const PHONE_NUMBER_TYPE_MP_DID = 'MP_DID';
    const PHONE_NUMBER_TYPE_MS_DID = 'MS_DID';
    const PHONE_NUMBER_TYPE_RU_DID = 'RU_DID';
    const PHONE_NUMBER_TYPE_TC_DID = 'TC_DID';
    const PHONE_NUMBER_TYPE_TT_DID = 'TT_DID';
    const PHONE_NUMBER_TYPE_US_DID = 'US_DID';
    const PHONE_NUMBER_TYPE_VC_DID = 'VC_DID';
    const PHONE_NUMBER_TYPE_VG_DID = 'VG_DID';
    const PHONE_NUMBER_TYPE_AF_DID = 'AF_DID';
    const PHONE_NUMBER_TYPE_AR_DID = 'AR_DID';
    const PHONE_NUMBER_TYPE_AT_DID = 'AT_DID';
    const PHONE_NUMBER_TYPE_AU_DID = 'AU_DID';
    const PHONE_NUMBER_TYPE_BE_DID = 'BE_DID';
    const PHONE_NUMBER_TYPE_BR_DID = 'BR_DID';
    const PHONE_NUMBER_TYPE_CH_DID = 'CH_DID';
    const PHONE_NUMBER_TYPE_CL_DID = 'CL_DID';
    const PHONE_NUMBER_TYPE_CN_DID = 'CN_DID';
    const PHONE_NUMBER_TYPE_CO_DID = 'CO_DID';
    const PHONE_NUMBER_TYPE_CU_DID = 'CU_DID';
    const PHONE_NUMBER_TYPE_DE_DID = 'DE_DID';
    const PHONE_NUMBER_TYPE_DK_DID = 'DK_DID';
    const PHONE_NUMBER_TYPE_EG_DID = 'EG_DID';
    const PHONE_NUMBER_TYPE_ES_DID = 'ES_DID';
    const PHONE_NUMBER_TYPE_FR_DID = 'FR_DID';
    const PHONE_NUMBER_TYPE_GB_DID = 'GB_DID';
    const PHONE_NUMBER_TYPE_GR_DID = 'GR_DID';
    const PHONE_NUMBER_TYPE_HU_DID = 'HU_DID';
    const PHONE_NUMBER_TYPE_ID_DID = 'ID_DID';
    const PHONE_NUMBER_TYPE_IN_DID = 'IN_DID';
    const PHONE_NUMBER_TYPE_IR_DID = 'IR_DID';
    const PHONE_NUMBER_TYPE_IT_DID = 'IT_DID';
    const PHONE_NUMBER_TYPE_JP_DID = 'JP_DID';
    const PHONE_NUMBER_TYPE_KR_DID = 'KR_DID';
    const PHONE_NUMBER_TYPE_LK_DID = 'LK_DID';
    const PHONE_NUMBER_TYPE_MM_DID = 'MM_DID';
    const PHONE_NUMBER_TYPE_MX_DID = 'MX_DID';
    const PHONE_NUMBER_TYPE_MY_DID = 'MY_DID';
    const PHONE_NUMBER_TYPE_NL_DID = 'NL_DID';
    const PHONE_NUMBER_TYPE_NO_DID = 'NO_DID';
    const PHONE_NUMBER_TYPE_NZ_DID = 'NZ_DID';
    const PHONE_NUMBER_TYPE_PE_DID = 'PE_DID';
    const PHONE_NUMBER_TYPE_PH_DID = 'PH_DID';
    const PHONE_NUMBER_TYPE_PK_DID = 'PK_DID';
    const PHONE_NUMBER_TYPE_PL_DID = 'PL_DID';
    const PHONE_NUMBER_TYPE_RO_DID = 'RO_DID';
    const PHONE_NUMBER_TYPE_SE_DID = 'SE_DID';
    const PHONE_NUMBER_TYPE_SG_DID = 'SG_DID';
    const PHONE_NUMBER_TYPE_TH_DID = 'TH_DID';
    const PHONE_NUMBER_TYPE_TR_DID = 'TR_DID';
    const PHONE_NUMBER_TYPE_VE_DID = 'VE_DID';
    const PHONE_NUMBER_TYPE_VN_DID = 'VN_DID';
    const PHONE_NUMBER_TYPE_ZA_DID = 'ZA_DID';
    const PHONE_NUMBER_TYPE_AD_DID = 'AD_DID';
    const PHONE_NUMBER_TYPE_AE_DID = 'AE_DID';
    const PHONE_NUMBER_TYPE_AL_DID = 'AL_DID';
    const PHONE_NUMBER_TYPE_AM_DID = 'AM_DID';
    const PHONE_NUMBER_TYPE_AO_DID = 'AO_DID';
    const PHONE_NUMBER_TYPE_AQ_DID = 'AQ_DID';
    const PHONE_NUMBER_TYPE_AW_DID = 'AW_DID';
    const PHONE_NUMBER_TYPE_AZ_DID = 'AZ_DID';
    const PHONE_NUMBER_TYPE_BA_DID = 'BA_DID';
    const PHONE_NUMBER_TYPE_BD_DID = 'BD_DID';
    const PHONE_NUMBER_TYPE_BF_DID = 'BF_DID';
    const PHONE_NUMBER_TYPE_BG_DID = 'BG_DID';
    const PHONE_NUMBER_TYPE_BH_DID = 'BH_DID';
    const PHONE_NUMBER_TYPE_BI_DID = 'BI_DID';
    const PHONE_NUMBER_TYPE_BJ_DID = 'BJ_DID';
    const PHONE_NUMBER_TYPE_BL_DID = 'BL_DID';
    const PHONE_NUMBER_TYPE_BN_DID = 'BN_DID';
    const PHONE_NUMBER_TYPE_BO_DID = 'BO_DID';
    const PHONE_NUMBER_TYPE_BQ_DID = 'BQ_DID';
    const PHONE_NUMBER_TYPE_BT_DID = 'BT_DID';
    const PHONE_NUMBER_TYPE_BW_DID = 'BW_DID';
    const PHONE_NUMBER_TYPE_BY_DID = 'BY_DID';
    const PHONE_NUMBER_TYPE_BZ_DID = 'BZ_DID';
    const PHONE_NUMBER_TYPE_CD_DID = 'CD_DID';
    const PHONE_NUMBER_TYPE_CF_DID = 'CF_DID';
    const PHONE_NUMBER_TYPE_CG_DID = 'CG_DID';
    const PHONE_NUMBER_TYPE_CI_DID = 'CI_DID';
    const PHONE_NUMBER_TYPE_CK_DID = 'CK_DID';
    const PHONE_NUMBER_TYPE_CM_DID = 'CM_DID';
    const PHONE_NUMBER_TYPE_CR_DID = 'CR_DID';
    const PHONE_NUMBER_TYPE_CV_DID = 'CV_DID';
    const PHONE_NUMBER_TYPE_CY_DID = 'CY_DID';
    const PHONE_NUMBER_TYPE_CZ_DID = 'CZ_DID';
    const PHONE_NUMBER_TYPE_DJ_DID = 'DJ_DID';
    const PHONE_NUMBER_TYPE_DZ_DID = 'DZ_DID';
    const PHONE_NUMBER_TYPE_EC_DID = 'EC_DID';
    const PHONE_NUMBER_TYPE_EE_DID = 'EE_DID';
    const PHONE_NUMBER_TYPE_EH_DID = 'EH_DID';
    const PHONE_NUMBER_TYPE_ER_DID = 'ER_DID';
    const PHONE_NUMBER_TYPE_ET_DID = 'ET_DID';
    const PHONE_NUMBER_TYPE_FI_DID = 'FI_DID';
    const PHONE_NUMBER_TYPE_FJ_DID = 'FJ_DID';
    const PHONE_NUMBER_TYPE_FK_DID = 'FK_DID';
    const PHONE_NUMBER_TYPE_FM_DID = 'FM_DID';
    const PHONE_NUMBER_TYPE_FO_DID = 'FO_DID';
    const PHONE_NUMBER_TYPE_GA_DID = 'GA_DID';
    const PHONE_NUMBER_TYPE_GE_DID = 'GE_DID';
    const PHONE_NUMBER_TYPE_GF_DID = 'GF_DID';
    const PHONE_NUMBER_TYPE_GH_DID = 'GH_DID';
    const PHONE_NUMBER_TYPE_GI_DID = 'GI_DID';
    const PHONE_NUMBER_TYPE_GL_DID = 'GL_DID';
    const PHONE_NUMBER_TYPE_GM_DID = 'GM_DID';
    const PHONE_NUMBER_TYPE_GN_DID = 'GN_DID';
    const PHONE_NUMBER_TYPE_GP_DID = 'GP_DID';
    const PHONE_NUMBER_TYPE_GQ_DID = 'GQ_DID';
    const PHONE_NUMBER_TYPE_GT_DID = 'GT_DID';
    const PHONE_NUMBER_TYPE_GW_DID = 'GW_DID';
    const PHONE_NUMBER_TYPE_GY_DID = 'GY_DID';
    const PHONE_NUMBER_TYPE_HK_DID = 'HK_DID';
    const PHONE_NUMBER_TYPE_HN_DID = 'HN_DID';
    const PHONE_NUMBER_TYPE_HR_DID = 'HR_DID';
    const PHONE_NUMBER_TYPE_HT_DID = 'HT_DID';
    const PHONE_NUMBER_TYPE_IE_DID = 'IE_DID';
    const PHONE_NUMBER_TYPE_IL_DID = 'IL_DID';
    const PHONE_NUMBER_TYPE_IO_DID = 'IO_DID';
    const PHONE_NUMBER_TYPE_IQ_DID = 'IQ_DID';
    const PHONE_NUMBER_TYPE_IS_DID = 'IS_DID';
    const PHONE_NUMBER_TYPE_JO_DID = 'JO_DID';
    const PHONE_NUMBER_TYPE_KE_DID = 'KE_DID';
    const PHONE_NUMBER_TYPE_KG_DID = 'KG_DID';
    const PHONE_NUMBER_TYPE_KH_DID = 'KH_DID';
    const PHONE_NUMBER_TYPE_KI_DID = 'KI_DID';
    const PHONE_NUMBER_TYPE_KM_DID = 'KM_DID';
    const PHONE_NUMBER_TYPE_KP_DID = 'KP_DID';
    const PHONE_NUMBER_TYPE_KW_DID = 'KW_DID';
    const PHONE_NUMBER_TYPE_LA_DID = 'LA_DID';
    const PHONE_NUMBER_TYPE_LB_DID = 'LB_DID';
    const PHONE_NUMBER_TYPE_LI_DID = 'LI_DID';
    const PHONE_NUMBER_TYPE_LR_DID = 'LR_DID';
    const PHONE_NUMBER_TYPE_LS_DID = 'LS_DID';
    const PHONE_NUMBER_TYPE_LT_DID = 'LT_DID';
    const PHONE_NUMBER_TYPE_LU_DID = 'LU_DID';
    const PHONE_NUMBER_TYPE_LV_DID = 'LV_DID';
    const PHONE_NUMBER_TYPE_LY_DID = 'LY_DID';
    const PHONE_NUMBER_TYPE_MA_DID = 'MA_DID';
    const PHONE_NUMBER_TYPE_MC_DID = 'MC_DID';
    const PHONE_NUMBER_TYPE_MD_DID = 'MD_DID';
    const PHONE_NUMBER_TYPE_ME_DID = 'ME_DID';
    const PHONE_NUMBER_TYPE_MF_DID = 'MF_DID';
    const PHONE_NUMBER_TYPE_MG_DID = 'MG_DID';
    const PHONE_NUMBER_TYPE_MH_DID = 'MH_DID';
    const PHONE_NUMBER_TYPE_MK_DID = 'MK_DID';
    const PHONE_NUMBER_TYPE_ML_DID = 'ML_DID';
    const PHONE_NUMBER_TYPE_MN_DID = 'MN_DID';
    const PHONE_NUMBER_TYPE_MO_DID = 'MO_DID';
    const PHONE_NUMBER_TYPE_MQ_DID = 'MQ_DID';
    const PHONE_NUMBER_TYPE_MR_DID = 'MR_DID';
    const PHONE_NUMBER_TYPE_MT_DID = 'MT_DID';
    const PHONE_NUMBER_TYPE_MU_DID = 'MU_DID';
    const PHONE_NUMBER_TYPE_MV_DID = 'MV_DID';
    const PHONE_NUMBER_TYPE_MW_DID = 'MW_DID';
    const PHONE_NUMBER_TYPE_MZ_DID = 'MZ_DID';
    const PHONE_NUMBER_TYPE_NA_DID = 'NA_DID';
    const PHONE_NUMBER_TYPE_NC_DID = 'NC_DID';
    const PHONE_NUMBER_TYPE_NE_DID = 'NE_DID';
    const PHONE_NUMBER_TYPE_NF_DID = 'NF_DID';
    const PHONE_NUMBER_TYPE_NG_DID = 'NG_DID';
    const PHONE_NUMBER_TYPE_NI_DID = 'NI_DID';
    const PHONE_NUMBER_TYPE_NP_DID = 'NP_DID';
    const PHONE_NUMBER_TYPE_NR_DID = 'NR_DID';
    const PHONE_NUMBER_TYPE_NU_DID = 'NU_DID';
    const PHONE_NUMBER_TYPE_OM_DID = 'OM_DID';
    const PHONE_NUMBER_TYPE_PA_DID = 'PA_DID';
    const PHONE_NUMBER_TYPE_PF_DID = 'PF_DID';
    const PHONE_NUMBER_TYPE_PG_DID = 'PG_DID';
    const PHONE_NUMBER_TYPE_PM_DID = 'PM_DID';
    const PHONE_NUMBER_TYPE_PS_DID = 'PS_DID';
    const PHONE_NUMBER_TYPE_PT_DID = 'PT_DID';
    const PHONE_NUMBER_TYPE_PW_DID = 'PW_DID';
    const PHONE_NUMBER_TYPE_PY_DID = 'PY_DID';
    const PHONE_NUMBER_TYPE_QA_DID = 'QA_DID';
    const PHONE_NUMBER_TYPE_RE_DID = 'RE_DID';
    const PHONE_NUMBER_TYPE_RS_DID = 'RS_DID';
    const PHONE_NUMBER_TYPE_RW_DID = 'RW_DID';
    const PHONE_NUMBER_TYPE_SA_DID = 'SA_DID';
    const PHONE_NUMBER_TYPE_SB_DID = 'SB_DID';
    const PHONE_NUMBER_TYPE_SC_DID = 'SC_DID';
    const PHONE_NUMBER_TYPE_SD_DID = 'SD_DID';
    const PHONE_NUMBER_TYPE_SH_247_DID = 'SH_247_DID';
    const PHONE_NUMBER_TYPE_SH_290_DID = 'SH_290_DID';
    const PHONE_NUMBER_TYPE_SI_DID = 'SI_DID';
    const PHONE_NUMBER_TYPE_SK_DID = 'SK_DID';
    const PHONE_NUMBER_TYPE_SL_DID = 'SL_DID';
    const PHONE_NUMBER_TYPE_SM_DID = 'SM_DID';
    const PHONE_NUMBER_TYPE_SN_DID = 'SN_DID';
    const PHONE_NUMBER_TYPE_SO_DID = 'SO_DID';
    const PHONE_NUMBER_TYPE_SR_DID = 'SR_DID';
    const PHONE_NUMBER_TYPE_SS_DID = 'SS_DID';
    const PHONE_NUMBER_TYPE_ST_DID = 'ST_DID';
    const PHONE_NUMBER_TYPE_SV_DID = 'SV_DID';
    const PHONE_NUMBER_TYPE_SY_DID = 'SY_DID';
    const PHONE_NUMBER_TYPE_SZ_DID = 'SZ_DID';
    const PHONE_NUMBER_TYPE_TD_DID = 'TD_DID';
    const PHONE_NUMBER_TYPE_TG_DID = 'TG_DID';
    const PHONE_NUMBER_TYPE_TJ_DID = 'TJ_DID';
    const PHONE_NUMBER_TYPE_TK_DID = 'TK_DID';
    const PHONE_NUMBER_TYPE_TL_DID = 'TL_DID';
    const PHONE_NUMBER_TYPE_TM_DID = 'TM_DID';
    const PHONE_NUMBER_TYPE_TN_DID = 'TN_DID';
    const PHONE_NUMBER_TYPE_TO_DID = 'TO_DID';
    const PHONE_NUMBER_TYPE_TV_DID = 'TV_DID';
    const PHONE_NUMBER_TYPE_TW_DID = 'TW_DID';
    const PHONE_NUMBER_TYPE_TZ_DID = 'TZ_DID';
    const PHONE_NUMBER_TYPE_UA_DID = 'UA_DID';
    const PHONE_NUMBER_TYPE_UG_DID = 'UG_DID';
    const PHONE_NUMBER_TYPE_UY_DID = 'UY_DID';
    const PHONE_NUMBER_TYPE_UZ_DID = 'UZ_DID';
    const PHONE_NUMBER_TYPE_VU_DID = 'VU_DID';
    const PHONE_NUMBER_TYPE_WF_DID = 'WF_DID';
    const PHONE_NUMBER_TYPE_WS_DID = 'WS_DID';
    const PHONE_NUMBER_TYPE_XG_DID = 'XG_DID';
    const PHONE_NUMBER_TYPE_XN_DID = 'XN_DID';
    const PHONE_NUMBER_TYPE_XV_882_DID = 'XV_882_DID';
    const PHONE_NUMBER_TYPE_XV_883_DID = 'XV_883_DID';
    const PHONE_NUMBER_TYPE_YE_DID = 'YE_DID';
    const PHONE_NUMBER_TYPE_YT_DID = 'YT_DID';
    const PHONE_NUMBER_TYPE_ZM_DID = 'ZM_DID';
    const PHONE_NUMBER_TYPE_ZW_DID = 'ZW_DID';
    const PHONE_NUMBER_TYPE_SX_DID = 'SX_DID';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_COMPLETE,
            self::STATUS_CONNECTING,
            self::STATUS_FAILED,
            self::STATUS_BACKORDERED,
            self::STATUS_PENDING,
            self::STATUS_ACTIVATING,
            self::STATUS_ACTIVATION_ERROR,
            self::STATUS_ERROR,
            self::STATUS_DISCONNECTED,
            self::STATUS_DISCONNECT_PENDING,
            self::STATUS_DEACTIVATING,
            self::STATUS_DEACTIVATION_ERROR,
            self::STATUS_DISCONNECT_FAILED,
            self::STATUS_SUBMITTED,
            self::STATUS_REJECTED,
            self::STATUS_SUPP,
            self::STATUS_PORT_PENDING,
            self::STATUS_FOC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPhoneNumberTypeAllowableValues()
    {
        return [
            self::PHONE_NUMBER_TYPE_TOLL_FREE,
            self::PHONE_NUMBER_TYPE_CN_DOMESTIC,
            self::PHONE_NUMBER_TYPE_US_DOMESTIC,
            self::PHONE_NUMBER_TYPE_US_TOLLFREE,
            self::PHONE_NUMBER_TYPE_XA_TOLLFREE,
            self::PHONE_NUMBER_TYPE_XB_TOLLFREE,
            self::PHONE_NUMBER_TYPE_XC_TOLLFREE,
            self::PHONE_NUMBER_TYPE_AG_DID,
            self::PHONE_NUMBER_TYPE_AI_DID,
            self::PHONE_NUMBER_TYPE_BB_DID,
            self::PHONE_NUMBER_TYPE_BM_DID,
            self::PHONE_NUMBER_TYPE_BS_DID,
            self::PHONE_NUMBER_TYPE_CA_DID,
            self::PHONE_NUMBER_TYPE_DM_DID,
            self::PHONE_NUMBER_TYPE_DO_DID,
            self::PHONE_NUMBER_TYPE_GD_DID,
            self::PHONE_NUMBER_TYPE_JM_DID,
            self::PHONE_NUMBER_TYPE_KN_DID,
            self::PHONE_NUMBER_TYPE_KY_DID,
            self::PHONE_NUMBER_TYPE_KZ_DID,
            self::PHONE_NUMBER_TYPE_LC_DID,
            self::PHONE_NUMBER_TYPE_MP_DID,
            self::PHONE_NUMBER_TYPE_MS_DID,
            self::PHONE_NUMBER_TYPE_RU_DID,
            self::PHONE_NUMBER_TYPE_TC_DID,
            self::PHONE_NUMBER_TYPE_TT_DID,
            self::PHONE_NUMBER_TYPE_US_DID,
            self::PHONE_NUMBER_TYPE_VC_DID,
            self::PHONE_NUMBER_TYPE_VG_DID,
            self::PHONE_NUMBER_TYPE_AF_DID,
            self::PHONE_NUMBER_TYPE_AR_DID,
            self::PHONE_NUMBER_TYPE_AT_DID,
            self::PHONE_NUMBER_TYPE_AU_DID,
            self::PHONE_NUMBER_TYPE_BE_DID,
            self::PHONE_NUMBER_TYPE_BR_DID,
            self::PHONE_NUMBER_TYPE_CH_DID,
            self::PHONE_NUMBER_TYPE_CL_DID,
            self::PHONE_NUMBER_TYPE_CN_DID,
            self::PHONE_NUMBER_TYPE_CO_DID,
            self::PHONE_NUMBER_TYPE_CU_DID,
            self::PHONE_NUMBER_TYPE_DE_DID,
            self::PHONE_NUMBER_TYPE_DK_DID,
            self::PHONE_NUMBER_TYPE_EG_DID,
            self::PHONE_NUMBER_TYPE_ES_DID,
            self::PHONE_NUMBER_TYPE_FR_DID,
            self::PHONE_NUMBER_TYPE_GB_DID,
            self::PHONE_NUMBER_TYPE_GR_DID,
            self::PHONE_NUMBER_TYPE_HU_DID,
            self::PHONE_NUMBER_TYPE_ID_DID,
            self::PHONE_NUMBER_TYPE_IN_DID,
            self::PHONE_NUMBER_TYPE_IR_DID,
            self::PHONE_NUMBER_TYPE_IT_DID,
            self::PHONE_NUMBER_TYPE_JP_DID,
            self::PHONE_NUMBER_TYPE_KR_DID,
            self::PHONE_NUMBER_TYPE_LK_DID,
            self::PHONE_NUMBER_TYPE_MM_DID,
            self::PHONE_NUMBER_TYPE_MX_DID,
            self::PHONE_NUMBER_TYPE_MY_DID,
            self::PHONE_NUMBER_TYPE_NL_DID,
            self::PHONE_NUMBER_TYPE_NO_DID,
            self::PHONE_NUMBER_TYPE_NZ_DID,
            self::PHONE_NUMBER_TYPE_PE_DID,
            self::PHONE_NUMBER_TYPE_PH_DID,
            self::PHONE_NUMBER_TYPE_PK_DID,
            self::PHONE_NUMBER_TYPE_PL_DID,
            self::PHONE_NUMBER_TYPE_RO_DID,
            self::PHONE_NUMBER_TYPE_SE_DID,
            self::PHONE_NUMBER_TYPE_SG_DID,
            self::PHONE_NUMBER_TYPE_TH_DID,
            self::PHONE_NUMBER_TYPE_TR_DID,
            self::PHONE_NUMBER_TYPE_VE_DID,
            self::PHONE_NUMBER_TYPE_VN_DID,
            self::PHONE_NUMBER_TYPE_ZA_DID,
            self::PHONE_NUMBER_TYPE_AD_DID,
            self::PHONE_NUMBER_TYPE_AE_DID,
            self::PHONE_NUMBER_TYPE_AL_DID,
            self::PHONE_NUMBER_TYPE_AM_DID,
            self::PHONE_NUMBER_TYPE_AO_DID,
            self::PHONE_NUMBER_TYPE_AQ_DID,
            self::PHONE_NUMBER_TYPE_AW_DID,
            self::PHONE_NUMBER_TYPE_AZ_DID,
            self::PHONE_NUMBER_TYPE_BA_DID,
            self::PHONE_NUMBER_TYPE_BD_DID,
            self::PHONE_NUMBER_TYPE_BF_DID,
            self::PHONE_NUMBER_TYPE_BG_DID,
            self::PHONE_NUMBER_TYPE_BH_DID,
            self::PHONE_NUMBER_TYPE_BI_DID,
            self::PHONE_NUMBER_TYPE_BJ_DID,
            self::PHONE_NUMBER_TYPE_BL_DID,
            self::PHONE_NUMBER_TYPE_BN_DID,
            self::PHONE_NUMBER_TYPE_BO_DID,
            self::PHONE_NUMBER_TYPE_BQ_DID,
            self::PHONE_NUMBER_TYPE_BT_DID,
            self::PHONE_NUMBER_TYPE_BW_DID,
            self::PHONE_NUMBER_TYPE_BY_DID,
            self::PHONE_NUMBER_TYPE_BZ_DID,
            self::PHONE_NUMBER_TYPE_CD_DID,
            self::PHONE_NUMBER_TYPE_CF_DID,
            self::PHONE_NUMBER_TYPE_CG_DID,
            self::PHONE_NUMBER_TYPE_CI_DID,
            self::PHONE_NUMBER_TYPE_CK_DID,
            self::PHONE_NUMBER_TYPE_CM_DID,
            self::PHONE_NUMBER_TYPE_CR_DID,
            self::PHONE_NUMBER_TYPE_CV_DID,
            self::PHONE_NUMBER_TYPE_CY_DID,
            self::PHONE_NUMBER_TYPE_CZ_DID,
            self::PHONE_NUMBER_TYPE_DJ_DID,
            self::PHONE_NUMBER_TYPE_DZ_DID,
            self::PHONE_NUMBER_TYPE_EC_DID,
            self::PHONE_NUMBER_TYPE_EE_DID,
            self::PHONE_NUMBER_TYPE_EH_DID,
            self::PHONE_NUMBER_TYPE_ER_DID,
            self::PHONE_NUMBER_TYPE_ET_DID,
            self::PHONE_NUMBER_TYPE_FI_DID,
            self::PHONE_NUMBER_TYPE_FJ_DID,
            self::PHONE_NUMBER_TYPE_FK_DID,
            self::PHONE_NUMBER_TYPE_FM_DID,
            self::PHONE_NUMBER_TYPE_FO_DID,
            self::PHONE_NUMBER_TYPE_GA_DID,
            self::PHONE_NUMBER_TYPE_GE_DID,
            self::PHONE_NUMBER_TYPE_GF_DID,
            self::PHONE_NUMBER_TYPE_GH_DID,
            self::PHONE_NUMBER_TYPE_GI_DID,
            self::PHONE_NUMBER_TYPE_GL_DID,
            self::PHONE_NUMBER_TYPE_GM_DID,
            self::PHONE_NUMBER_TYPE_GN_DID,
            self::PHONE_NUMBER_TYPE_GP_DID,
            self::PHONE_NUMBER_TYPE_GQ_DID,
            self::PHONE_NUMBER_TYPE_GT_DID,
            self::PHONE_NUMBER_TYPE_GW_DID,
            self::PHONE_NUMBER_TYPE_GY_DID,
            self::PHONE_NUMBER_TYPE_HK_DID,
            self::PHONE_NUMBER_TYPE_HN_DID,
            self::PHONE_NUMBER_TYPE_HR_DID,
            self::PHONE_NUMBER_TYPE_HT_DID,
            self::PHONE_NUMBER_TYPE_IE_DID,
            self::PHONE_NUMBER_TYPE_IL_DID,
            self::PHONE_NUMBER_TYPE_IO_DID,
            self::PHONE_NUMBER_TYPE_IQ_DID,
            self::PHONE_NUMBER_TYPE_IS_DID,
            self::PHONE_NUMBER_TYPE_JO_DID,
            self::PHONE_NUMBER_TYPE_KE_DID,
            self::PHONE_NUMBER_TYPE_KG_DID,
            self::PHONE_NUMBER_TYPE_KH_DID,
            self::PHONE_NUMBER_TYPE_KI_DID,
            self::PHONE_NUMBER_TYPE_KM_DID,
            self::PHONE_NUMBER_TYPE_KP_DID,
            self::PHONE_NUMBER_TYPE_KW_DID,
            self::PHONE_NUMBER_TYPE_LA_DID,
            self::PHONE_NUMBER_TYPE_LB_DID,
            self::PHONE_NUMBER_TYPE_LI_DID,
            self::PHONE_NUMBER_TYPE_LR_DID,
            self::PHONE_NUMBER_TYPE_LS_DID,
            self::PHONE_NUMBER_TYPE_LT_DID,
            self::PHONE_NUMBER_TYPE_LU_DID,
            self::PHONE_NUMBER_TYPE_LV_DID,
            self::PHONE_NUMBER_TYPE_LY_DID,
            self::PHONE_NUMBER_TYPE_MA_DID,
            self::PHONE_NUMBER_TYPE_MC_DID,
            self::PHONE_NUMBER_TYPE_MD_DID,
            self::PHONE_NUMBER_TYPE_ME_DID,
            self::PHONE_NUMBER_TYPE_MF_DID,
            self::PHONE_NUMBER_TYPE_MG_DID,
            self::PHONE_NUMBER_TYPE_MH_DID,
            self::PHONE_NUMBER_TYPE_MK_DID,
            self::PHONE_NUMBER_TYPE_ML_DID,
            self::PHONE_NUMBER_TYPE_MN_DID,
            self::PHONE_NUMBER_TYPE_MO_DID,
            self::PHONE_NUMBER_TYPE_MQ_DID,
            self::PHONE_NUMBER_TYPE_MR_DID,
            self::PHONE_NUMBER_TYPE_MT_DID,
            self::PHONE_NUMBER_TYPE_MU_DID,
            self::PHONE_NUMBER_TYPE_MV_DID,
            self::PHONE_NUMBER_TYPE_MW_DID,
            self::PHONE_NUMBER_TYPE_MZ_DID,
            self::PHONE_NUMBER_TYPE_NA_DID,
            self::PHONE_NUMBER_TYPE_NC_DID,
            self::PHONE_NUMBER_TYPE_NE_DID,
            self::PHONE_NUMBER_TYPE_NF_DID,
            self::PHONE_NUMBER_TYPE_NG_DID,
            self::PHONE_NUMBER_TYPE_NI_DID,
            self::PHONE_NUMBER_TYPE_NP_DID,
            self::PHONE_NUMBER_TYPE_NR_DID,
            self::PHONE_NUMBER_TYPE_NU_DID,
            self::PHONE_NUMBER_TYPE_OM_DID,
            self::PHONE_NUMBER_TYPE_PA_DID,
            self::PHONE_NUMBER_TYPE_PF_DID,
            self::PHONE_NUMBER_TYPE_PG_DID,
            self::PHONE_NUMBER_TYPE_PM_DID,
            self::PHONE_NUMBER_TYPE_PS_DID,
            self::PHONE_NUMBER_TYPE_PT_DID,
            self::PHONE_NUMBER_TYPE_PW_DID,
            self::PHONE_NUMBER_TYPE_PY_DID,
            self::PHONE_NUMBER_TYPE_QA_DID,
            self::PHONE_NUMBER_TYPE_RE_DID,
            self::PHONE_NUMBER_TYPE_RS_DID,
            self::PHONE_NUMBER_TYPE_RW_DID,
            self::PHONE_NUMBER_TYPE_SA_DID,
            self::PHONE_NUMBER_TYPE_SB_DID,
            self::PHONE_NUMBER_TYPE_SC_DID,
            self::PHONE_NUMBER_TYPE_SD_DID,
            self::PHONE_NUMBER_TYPE_SH_247_DID,
            self::PHONE_NUMBER_TYPE_SH_290_DID,
            self::PHONE_NUMBER_TYPE_SI_DID,
            self::PHONE_NUMBER_TYPE_SK_DID,
            self::PHONE_NUMBER_TYPE_SL_DID,
            self::PHONE_NUMBER_TYPE_SM_DID,
            self::PHONE_NUMBER_TYPE_SN_DID,
            self::PHONE_NUMBER_TYPE_SO_DID,
            self::PHONE_NUMBER_TYPE_SR_DID,
            self::PHONE_NUMBER_TYPE_SS_DID,
            self::PHONE_NUMBER_TYPE_ST_DID,
            self::PHONE_NUMBER_TYPE_SV_DID,
            self::PHONE_NUMBER_TYPE_SY_DID,
            self::PHONE_NUMBER_TYPE_SZ_DID,
            self::PHONE_NUMBER_TYPE_TD_DID,
            self::PHONE_NUMBER_TYPE_TG_DID,
            self::PHONE_NUMBER_TYPE_TJ_DID,
            self::PHONE_NUMBER_TYPE_TK_DID,
            self::PHONE_NUMBER_TYPE_TL_DID,
            self::PHONE_NUMBER_TYPE_TM_DID,
            self::PHONE_NUMBER_TYPE_TN_DID,
            self::PHONE_NUMBER_TYPE_TO_DID,
            self::PHONE_NUMBER_TYPE_TV_DID,
            self::PHONE_NUMBER_TYPE_TW_DID,
            self::PHONE_NUMBER_TYPE_TZ_DID,
            self::PHONE_NUMBER_TYPE_UA_DID,
            self::PHONE_NUMBER_TYPE_UG_DID,
            self::PHONE_NUMBER_TYPE_UY_DID,
            self::PHONE_NUMBER_TYPE_UZ_DID,
            self::PHONE_NUMBER_TYPE_VU_DID,
            self::PHONE_NUMBER_TYPE_WF_DID,
            self::PHONE_NUMBER_TYPE_WS_DID,
            self::PHONE_NUMBER_TYPE_XG_DID,
            self::PHONE_NUMBER_TYPE_XN_DID,
            self::PHONE_NUMBER_TYPE_XV_882_DID,
            self::PHONE_NUMBER_TYPE_XV_883_DID,
            self::PHONE_NUMBER_TYPE_YE_DID,
            self::PHONE_NUMBER_TYPE_YT_DID,
            self::PHONE_NUMBER_TYPE_ZM_DID,
            self::PHONE_NUMBER_TYPE_ZW_DID,
            self::PHONE_NUMBER_TYPE_SX_DID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['did'] = isset($data['did']) ? $data['did'] : null;
        $this->container['effectiveStartDate'] = isset($data['effectiveStartDate']) ? $data['effectiveStartDate'] : null;
        $this->container['effectiveEndDate'] = isset($data['effectiveEndDate']) ? $data['effectiveEndDate'] : null;
        $this->container['lastUpdated'] = isset($data['lastUpdated']) ? $data['lastUpdated'] : null;
        $this->container['startAuthUserId'] = isset($data['startAuthUserId']) ? $data['startAuthUserId'] : null;
        $this->container['endAuthUserId'] = isset($data['endAuthUserId']) ? $data['endAuthUserId'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['phoneNumberType'] = isset($data['phoneNumberType']) ? $data['phoneNumberType'] : null;
        $this->container['porting'] = isset($data['porting']) ? $data['porting'] : false;
        $this->container['portRequestId'] = isset($data['portRequestId']) ? $data['portRequestId'] : null;
        $this->container['billingAddress'] = isset($data['billingAddress']) ? $data['billingAddress'] : null;
        $this->container['responsibleContact'] = isset($data['responsibleContact']) ? $data['responsibleContact'] : null;
        $this->container['companyName'] = isset($data['companyName']) ? $data['companyName'] : null;
        $this->container['countryCode'] = isset($data['countryCode']) ? $data['countryCode'] : null;
        $this->container['envelopeId'] = isset($data['envelopeId']) ? $data['envelopeId'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("COMPLETE", "CONNECTING", "FAILED", "BACKORDERED", "PENDING", "ACTIVATING", "ACTIVATION_ERROR", "ERROR", "DISCONNECTED", "DISCONNECT_PENDING", "DEACTIVATING", "DEACTIVATION_ERROR", "DISCONNECT_FAILED", "SUBMITTED", "REJECTED", "SUPP", "PORT_PENDING", "FOC");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("TOLL_FREE", "CN_DOMESTIC", "US_DOMESTIC", "US_TOLLFREE", "XA_TOLLFREE", "XB_TOLLFREE", "XC_TOLLFREE", "AG_DID", "AI_DID", "BB_DID", "BM_DID", "BS_DID", "CA_DID", "DM_DID", "DO_DID", "GD_DID", "JM_DID", "KN_DID", "KY_DID", "KZ_DID", "LC_DID", "MP_DID", "MS_DID", "RU_DID", "TC_DID", "TT_DID", "US_DID", "VC_DID", "VG_DID", "AF_DID", "AR_DID", "AT_DID", "AU_DID", "BE_DID", "BR_DID", "CH_DID", "CL_DID", "CN_DID", "CO_DID", "CU_DID", "DE_DID", "DK_DID", "EG_DID", "ES_DID", "FR_DID", "GB_DID", "GR_DID", "HU_DID", "ID_DID", "IN_DID", "IR_DID", "IT_DID", "JP_DID", "KR_DID", "LK_DID", "MM_DID", "MX_DID", "MY_DID", "NL_DID", "NO_DID", "NZ_DID", "PE_DID", "PH_DID", "PK_DID", "PL_DID", "RO_DID", "SE_DID", "SG_DID", "TH_DID", "TR_DID", "VE_DID", "VN_DID", "ZA_DID", "AD_DID", "AE_DID", "AL_DID", "AM_DID", "AO_DID", "AQ_DID", "AW_DID", "AZ_DID", "BA_DID", "BD_DID", "BF_DID", "BG_DID", "BH_DID", "BI_DID", "BJ_DID", "BL_DID", "BN_DID", "BO_DID", "BQ_DID", "BT_DID", "BW_DID", "BY_DID", "BZ_DID", "CD_DID", "CF_DID", "CG_DID", "CI_DID", "CK_DID", "CM_DID", "CR_DID", "CV_DID", "CY_DID", "CZ_DID", "DJ_DID", "DZ_DID", "EC_DID", "EE_DID", "EH_DID", "ER_DID", "ET_DID", "FI_DID", "FJ_DID", "FK_DID", "FM_DID", "FO_DID", "GA_DID", "GE_DID", "GF_DID", "GH_DID", "GI_DID", "GL_DID", "GM_DID", "GN_DID", "GP_DID", "GQ_DID", "GT_DID", "GW_DID", "GY_DID", "HK_DID", "HN_DID", "HR_DID", "HT_DID", "IE_DID", "IL_DID", "IO_DID", "IQ_DID", "IS_DID", "JO_DID", "KE_DID", "KG_DID", "KH_DID", "KI_DID", "KM_DID", "KP_DID", "KW_DID", "LA_DID", "LB_DID", "LI_DID", "LR_DID", "LS_DID", "LT_DID", "LU_DID", "LV_DID", "LY_DID", "MA_DID", "MC_DID", "MD_DID", "ME_DID", "MF_DID", "MG_DID", "MH_DID", "MK_DID", "ML_DID", "MN_DID", "MO_DID", "MQ_DID", "MR_DID", "MT_DID", "MU_DID", "MV_DID", "MW_DID", "MZ_DID", "NA_DID", "NC_DID", "NE_DID", "NF_DID", "NG_DID", "NI_DID", "NP_DID", "NR_DID", "NU_DID", "OM_DID", "PA_DID", "PF_DID", "PG_DID", "PM_DID", "PS_DID", "PT_DID", "PW_DID", "PY_DID", "QA_DID", "RE_DID", "RS_DID", "RW_DID", "SA_DID", "SB_DID", "SC_DID", "SD_DID", "SH_247_DID", "SH_290_DID", "SI_DID", "SK_DID", "SL_DID", "SM_DID", "SN_DID", "SO_DID", "SR_DID", "SS_DID", "ST_DID", "SV_DID", "SY_DID", "SZ_DID", "TD_DID", "TG_DID", "TJ_DID", "TK_DID", "TL_DID", "TM_DID", "TN_DID", "TO_DID", "TV_DID", "TW_DID", "TZ_DID", "UA_DID", "UG_DID", "UY_DID", "UZ_DID", "VU_DID", "WF_DID", "WS_DID", "XG_DID", "XN_DID", "XV_882_DID", "XV_883_DID", "YE_DID", "YT_DID", "ZM_DID", "ZW_DID", "SX_DID");
        if (!in_array($this->container['phoneNumberType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'phoneNumberType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("COMPLETE", "CONNECTING", "FAILED", "BACKORDERED", "PENDING", "ACTIVATING", "ACTIVATION_ERROR", "ERROR", "DISCONNECTED", "DISCONNECT_PENDING", "DEACTIVATING", "DEACTIVATION_ERROR", "DISCONNECT_FAILED", "SUBMITTED", "REJECTED", "SUPP", "PORT_PENDING", "FOC");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("TOLL_FREE", "CN_DOMESTIC", "US_DOMESTIC", "US_TOLLFREE", "XA_TOLLFREE", "XB_TOLLFREE", "XC_TOLLFREE", "AG_DID", "AI_DID", "BB_DID", "BM_DID", "BS_DID", "CA_DID", "DM_DID", "DO_DID", "GD_DID", "JM_DID", "KN_DID", "KY_DID", "KZ_DID", "LC_DID", "MP_DID", "MS_DID", "RU_DID", "TC_DID", "TT_DID", "US_DID", "VC_DID", "VG_DID", "AF_DID", "AR_DID", "AT_DID", "AU_DID", "BE_DID", "BR_DID", "CH_DID", "CL_DID", "CN_DID", "CO_DID", "CU_DID", "DE_DID", "DK_DID", "EG_DID", "ES_DID", "FR_DID", "GB_DID", "GR_DID", "HU_DID", "ID_DID", "IN_DID", "IR_DID", "IT_DID", "JP_DID", "KR_DID", "LK_DID", "MM_DID", "MX_DID", "MY_DID", "NL_DID", "NO_DID", "NZ_DID", "PE_DID", "PH_DID", "PK_DID", "PL_DID", "RO_DID", "SE_DID", "SG_DID", "TH_DID", "TR_DID", "VE_DID", "VN_DID", "ZA_DID", "AD_DID", "AE_DID", "AL_DID", "AM_DID", "AO_DID", "AQ_DID", "AW_DID", "AZ_DID", "BA_DID", "BD_DID", "BF_DID", "BG_DID", "BH_DID", "BI_DID", "BJ_DID", "BL_DID", "BN_DID", "BO_DID", "BQ_DID", "BT_DID", "BW_DID", "BY_DID", "BZ_DID", "CD_DID", "CF_DID", "CG_DID", "CI_DID", "CK_DID", "CM_DID", "CR_DID", "CV_DID", "CY_DID", "CZ_DID", "DJ_DID", "DZ_DID", "EC_DID", "EE_DID", "EH_DID", "ER_DID", "ET_DID", "FI_DID", "FJ_DID", "FK_DID", "FM_DID", "FO_DID", "GA_DID", "GE_DID", "GF_DID", "GH_DID", "GI_DID", "GL_DID", "GM_DID", "GN_DID", "GP_DID", "GQ_DID", "GT_DID", "GW_DID", "GY_DID", "HK_DID", "HN_DID", "HR_DID", "HT_DID", "IE_DID", "IL_DID", "IO_DID", "IQ_DID", "IS_DID", "JO_DID", "KE_DID", "KG_DID", "KH_DID", "KI_DID", "KM_DID", "KP_DID", "KW_DID", "LA_DID", "LB_DID", "LI_DID", "LR_DID", "LS_DID", "LT_DID", "LU_DID", "LV_DID", "LY_DID", "MA_DID", "MC_DID", "MD_DID", "ME_DID", "MF_DID", "MG_DID", "MH_DID", "MK_DID", "ML_DID", "MN_DID", "MO_DID", "MQ_DID", "MR_DID", "MT_DID", "MU_DID", "MV_DID", "MW_DID", "MZ_DID", "NA_DID", "NC_DID", "NE_DID", "NF_DID", "NG_DID", "NI_DID", "NP_DID", "NR_DID", "NU_DID", "OM_DID", "PA_DID", "PF_DID", "PG_DID", "PM_DID", "PS_DID", "PT_DID", "PW_DID", "PY_DID", "QA_DID", "RE_DID", "RS_DID", "RW_DID", "SA_DID", "SB_DID", "SC_DID", "SD_DID", "SH_247_DID", "SH_290_DID", "SI_DID", "SK_DID", "SL_DID", "SM_DID", "SN_DID", "SO_DID", "SR_DID", "SS_DID", "ST_DID", "SV_DID", "SY_DID", "SZ_DID", "TD_DID", "TG_DID", "TJ_DID", "TK_DID", "TL_DID", "TM_DID", "TN_DID", "TO_DID", "TV_DID", "TW_DID", "TZ_DID", "UA_DID", "UG_DID", "UY_DID", "UZ_DID", "VU_DID", "WF_DID", "WS_DID", "XG_DID", "XN_DID", "XV_882_DID", "XV_883_DID", "YE_DID", "YT_DID", "ZM_DID", "ZW_DID", "SX_DID");
        if (!in_array($this->container['phoneNumberType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets did
     * @return string
     */
    public function getDid()
    {
        return $this->container['did'];
    }

    /**
     * Sets did
     * @param string $did DID purchased
     * @return $this
     */
    public function setDid($did)
    {
        $this->container['did'] = $did;

        return $this;
    }

    /**
     * Gets effectiveStartDate
     * @return \DateTime
     */
    public function getEffectiveStartDate()
    {
        return $this->container['effectiveStartDate'];
    }

    /**
     * Sets effectiveStartDate
     * @param \DateTime $effectiveStartDate Effective date of service for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveStartDate($effectiveStartDate)
    {
        $this->container['effectiveStartDate'] = $effectiveStartDate;

        return $this;
    }

    /**
     * Gets effectiveEndDate
     * @return \DateTime
     */
    public function getEffectiveEndDate()
    {
        return $this->container['effectiveEndDate'];
    }

    /**
     * Sets effectiveEndDate
     * @param \DateTime $effectiveEndDate Effective disconnection date for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveEndDate($effectiveEndDate)
    {
        $this->container['effectiveEndDate'] = $effectiveEndDate;

        return $this;
    }

    /**
     * Gets lastUpdated
     * @return \DateTime
     */
    public function getLastUpdated()
    {
        return $this->container['lastUpdated'];
    }

    /**
     * Sets lastUpdated
     * @param \DateTime $lastUpdated Date of last update. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastUpdated($lastUpdated)
    {
        $this->container['lastUpdated'] = $lastUpdated;

        return $this;
    }

    /**
     * Gets startAuthUserId
     * @return string
     */
    public function getStartAuthUserId()
    {
        return $this->container['startAuthUserId'];
    }

    /**
     * Sets startAuthUserId
     * @param string $startAuthUserId UserId authorizing purchase
     * @return $this
     */
    public function setStartAuthUserId($startAuthUserId)
    {
        $this->container['startAuthUserId'] = $startAuthUserId;

        return $this;
    }

    /**
     * Gets endAuthUserId
     * @return string
     */
    public function getEndAuthUserId()
    {
        return $this->container['endAuthUserId'];
    }

    /**
     * Sets endAuthUserId
     * @param string $endAuthUserId UserId authorizing disconnection
     * @return $this
     */
    public function setEndAuthUserId($endAuthUserId)
    {
        $this->container['endAuthUserId'] = $endAuthUserId;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Current status of this DID order
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('COMPLETE', 'CONNECTING', 'FAILED', 'BACKORDERED', 'PENDING', 'ACTIVATING', 'ACTIVATION_ERROR', 'ERROR', 'DISCONNECTED', 'DISCONNECT_PENDING', 'DEACTIVATING', 'DEACTIVATION_ERROR', 'DISCONNECT_FAILED', 'SUBMITTED', 'REJECTED', 'SUPP', 'PORT_PENDING', 'FOC');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'COMPLETE', 'CONNECTING', 'FAILED', 'BACKORDERED', 'PENDING', 'ACTIVATING', 'ACTIVATION_ERROR', 'ERROR', 'DISCONNECTED', 'DISCONNECT_PENDING', 'DEACTIVATING', 'DEACTIVATION_ERROR', 'DISCONNECT_FAILED', 'SUBMITTED', 'REJECTED', 'SUPP', 'PORT_PENDING', 'FOC'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets phoneNumberType
     * @return string
     */
    public function getPhoneNumberType()
    {
        return $this->container['phoneNumberType'];
    }

    /**
     * Sets phoneNumberType
     * @param string $phoneNumberType Class of DID being purchased (eg. us-domestic, toll-free, etc)
     * @return $this
     */
    public function setPhoneNumberType($phoneNumberType)
    {
        $allowed_values = array('TOLL_FREE', 'CN_DOMESTIC', 'US_DOMESTIC', 'US_TOLLFREE', 'XA_TOLLFREE', 'XB_TOLLFREE', 'XC_TOLLFREE', 'AG_DID', 'AI_DID', 'BB_DID', 'BM_DID', 'BS_DID', 'CA_DID', 'DM_DID', 'DO_DID', 'GD_DID', 'JM_DID', 'KN_DID', 'KY_DID', 'KZ_DID', 'LC_DID', 'MP_DID', 'MS_DID', 'RU_DID', 'TC_DID', 'TT_DID', 'US_DID', 'VC_DID', 'VG_DID', 'AF_DID', 'AR_DID', 'AT_DID', 'AU_DID', 'BE_DID', 'BR_DID', 'CH_DID', 'CL_DID', 'CN_DID', 'CO_DID', 'CU_DID', 'DE_DID', 'DK_DID', 'EG_DID', 'ES_DID', 'FR_DID', 'GB_DID', 'GR_DID', 'HU_DID', 'ID_DID', 'IN_DID', 'IR_DID', 'IT_DID', 'JP_DID', 'KR_DID', 'LK_DID', 'MM_DID', 'MX_DID', 'MY_DID', 'NL_DID', 'NO_DID', 'NZ_DID', 'PE_DID', 'PH_DID', 'PK_DID', 'PL_DID', 'RO_DID', 'SE_DID', 'SG_DID', 'TH_DID', 'TR_DID', 'VE_DID', 'VN_DID', 'ZA_DID', 'AD_DID', 'AE_DID', 'AL_DID', 'AM_DID', 'AO_DID', 'AQ_DID', 'AW_DID', 'AZ_DID', 'BA_DID', 'BD_DID', 'BF_DID', 'BG_DID', 'BH_DID', 'BI_DID', 'BJ_DID', 'BL_DID', 'BN_DID', 'BO_DID', 'BQ_DID', 'BT_DID', 'BW_DID', 'BY_DID', 'BZ_DID', 'CD_DID', 'CF_DID', 'CG_DID', 'CI_DID', 'CK_DID', 'CM_DID', 'CR_DID', 'CV_DID', 'CY_DID', 'CZ_DID', 'DJ_DID', 'DZ_DID', 'EC_DID', 'EE_DID', 'EH_DID', 'ER_DID', 'ET_DID', 'FI_DID', 'FJ_DID', 'FK_DID', 'FM_DID', 'FO_DID', 'GA_DID', 'GE_DID', 'GF_DID', 'GH_DID', 'GI_DID', 'GL_DID', 'GM_DID', 'GN_DID', 'GP_DID', 'GQ_DID', 'GT_DID', 'GW_DID', 'GY_DID', 'HK_DID', 'HN_DID', 'HR_DID', 'HT_DID', 'IE_DID', 'IL_DID', 'IO_DID', 'IQ_DID', 'IS_DID', 'JO_DID', 'KE_DID', 'KG_DID', 'KH_DID', 'KI_DID', 'KM_DID', 'KP_DID', 'KW_DID', 'LA_DID', 'LB_DID', 'LI_DID', 'LR_DID', 'LS_DID', 'LT_DID', 'LU_DID', 'LV_DID', 'LY_DID', 'MA_DID', 'MC_DID', 'MD_DID', 'ME_DID', 'MF_DID', 'MG_DID', 'MH_DID', 'MK_DID', 'ML_DID', 'MN_DID', 'MO_DID', 'MQ_DID', 'MR_DID', 'MT_DID', 'MU_DID', 'MV_DID', 'MW_DID', 'MZ_DID', 'NA_DID', 'NC_DID', 'NE_DID', 'NF_DID', 'NG_DID', 'NI_DID', 'NP_DID', 'NR_DID', 'NU_DID', 'OM_DID', 'PA_DID', 'PF_DID', 'PG_DID', 'PM_DID', 'PS_DID', 'PT_DID', 'PW_DID', 'PY_DID', 'QA_DID', 'RE_DID', 'RS_DID', 'RW_DID', 'SA_DID', 'SB_DID', 'SC_DID', 'SD_DID', 'SH_247_DID', 'SH_290_DID', 'SI_DID', 'SK_DID', 'SL_DID', 'SM_DID', 'SN_DID', 'SO_DID', 'SR_DID', 'SS_DID', 'ST_DID', 'SV_DID', 'SY_DID', 'SZ_DID', 'TD_DID', 'TG_DID', 'TJ_DID', 'TK_DID', 'TL_DID', 'TM_DID', 'TN_DID', 'TO_DID', 'TV_DID', 'TW_DID', 'TZ_DID', 'UA_DID', 'UG_DID', 'UY_DID', 'UZ_DID', 'VU_DID', 'WF_DID', 'WS_DID', 'XG_DID', 'XN_DID', 'XV_882_DID', 'XV_883_DID', 'YE_DID', 'YT_DID', 'ZM_DID', 'ZW_DID', 'SX_DID');
        if (!in_array($phoneNumberType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'phoneNumberType', must be one of 'TOLL_FREE', 'CN_DOMESTIC', 'US_DOMESTIC', 'US_TOLLFREE', 'XA_TOLLFREE', 'XB_TOLLFREE', 'XC_TOLLFREE', 'AG_DID', 'AI_DID', 'BB_DID', 'BM_DID', 'BS_DID', 'CA_DID', 'DM_DID', 'DO_DID', 'GD_DID', 'JM_DID', 'KN_DID', 'KY_DID', 'KZ_DID', 'LC_DID', 'MP_DID', 'MS_DID', 'RU_DID', 'TC_DID', 'TT_DID', 'US_DID', 'VC_DID', 'VG_DID', 'AF_DID', 'AR_DID', 'AT_DID', 'AU_DID', 'BE_DID', 'BR_DID', 'CH_DID', 'CL_DID', 'CN_DID', 'CO_DID', 'CU_DID', 'DE_DID', 'DK_DID', 'EG_DID', 'ES_DID', 'FR_DID', 'GB_DID', 'GR_DID', 'HU_DID', 'ID_DID', 'IN_DID', 'IR_DID', 'IT_DID', 'JP_DID', 'KR_DID', 'LK_DID', 'MM_DID', 'MX_DID', 'MY_DID', 'NL_DID', 'NO_DID', 'NZ_DID', 'PE_DID', 'PH_DID', 'PK_DID', 'PL_DID', 'RO_DID', 'SE_DID', 'SG_DID', 'TH_DID', 'TR_DID', 'VE_DID', 'VN_DID', 'ZA_DID', 'AD_DID', 'AE_DID', 'AL_DID', 'AM_DID', 'AO_DID', 'AQ_DID', 'AW_DID', 'AZ_DID', 'BA_DID', 'BD_DID', 'BF_DID', 'BG_DID', 'BH_DID', 'BI_DID', 'BJ_DID', 'BL_DID', 'BN_DID', 'BO_DID', 'BQ_DID', 'BT_DID', 'BW_DID', 'BY_DID', 'BZ_DID', 'CD_DID', 'CF_DID', 'CG_DID', 'CI_DID', 'CK_DID', 'CM_DID', 'CR_DID', 'CV_DID', 'CY_DID', 'CZ_DID', 'DJ_DID', 'DZ_DID', 'EC_DID', 'EE_DID', 'EH_DID', 'ER_DID', 'ET_DID', 'FI_DID', 'FJ_DID', 'FK_DID', 'FM_DID', 'FO_DID', 'GA_DID', 'GE_DID', 'GF_DID', 'GH_DID', 'GI_DID', 'GL_DID', 'GM_DID', 'GN_DID', 'GP_DID', 'GQ_DID', 'GT_DID', 'GW_DID', 'GY_DID', 'HK_DID', 'HN_DID', 'HR_DID', 'HT_DID', 'IE_DID', 'IL_DID', 'IO_DID', 'IQ_DID', 'IS_DID', 'JO_DID', 'KE_DID', 'KG_DID', 'KH_DID', 'KI_DID', 'KM_DID', 'KP_DID', 'KW_DID', 'LA_DID', 'LB_DID', 'LI_DID', 'LR_DID', 'LS_DID', 'LT_DID', 'LU_DID', 'LV_DID', 'LY_DID', 'MA_DID', 'MC_DID', 'MD_DID', 'ME_DID', 'MF_DID', 'MG_DID', 'MH_DID', 'MK_DID', 'ML_DID', 'MN_DID', 'MO_DID', 'MQ_DID', 'MR_DID', 'MT_DID', 'MU_DID', 'MV_DID', 'MW_DID', 'MZ_DID', 'NA_DID', 'NC_DID', 'NE_DID', 'NF_DID', 'NG_DID', 'NI_DID', 'NP_DID', 'NR_DID', 'NU_DID', 'OM_DID', 'PA_DID', 'PF_DID', 'PG_DID', 'PM_DID', 'PS_DID', 'PT_DID', 'PW_DID', 'PY_DID', 'QA_DID', 'RE_DID', 'RS_DID', 'RW_DID', 'SA_DID', 'SB_DID', 'SC_DID', 'SD_DID', 'SH_247_DID', 'SH_290_DID', 'SI_DID', 'SK_DID', 'SL_DID', 'SM_DID', 'SN_DID', 'SO_DID', 'SR_DID', 'SS_DID', 'ST_DID', 'SV_DID', 'SY_DID', 'SZ_DID', 'TD_DID', 'TG_DID', 'TJ_DID', 'TK_DID', 'TL_DID', 'TM_DID', 'TN_DID', 'TO_DID', 'TV_DID', 'TW_DID', 'TZ_DID', 'UA_DID', 'UG_DID', 'UY_DID', 'UZ_DID', 'VU_DID', 'WF_DID', 'WS_DID', 'XG_DID', 'XN_DID', 'XV_882_DID', 'XV_883_DID', 'YE_DID', 'YT_DID', 'ZM_DID', 'ZW_DID', 'SX_DID'");
        }
        $this->container['phoneNumberType'] = $phoneNumberType;

        return $this;
    }

    /**
     * Gets porting
     * @return bool
     */
    public function getPorting()
    {
        return $this->container['porting'];
    }

    /**
     * Sets porting
     * @param bool $porting Whether or not the number was ported
     * @return $this
     */
    public function setPorting($porting)
    {
        $this->container['porting'] = $porting;

        return $this;
    }

    /**
     * Gets portRequestId
     * @return string
     */
    public function getPortRequestId()
    {
        return $this->container['portRequestId'];
    }

    /**
     * Sets portRequestId
     * @param string $portRequestId If the number was part of an automated port, this is the port request id for that port.
     * @return $this
     */
    public function setPortRequestId($portRequestId)
    {
        $this->container['portRequestId'] = $portRequestId;

        return $this;
    }

    /**
     * Gets billingAddress
     * @return \PureCloudSDK\PortBillingAddress
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     * @param \PureCloudSDK\PortBillingAddress $billingAddress Billing address used for a number port
     * @return $this
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets responsibleContact
     * @return \PureCloudSDK\PortContact
     */
    public function getResponsibleContact()
    {
        return $this->container['responsibleContact'];
    }

    /**
     * Sets responsibleContact
     * @param \PureCloudSDK\PortContact $responsibleContact Company contact for a number port
     * @return $this
     */
    public function setResponsibleContact($responsibleContact)
    {
        $this->container['responsibleContact'] = $responsibleContact;

        return $this;
    }

    /**
     * Gets companyName
     * @return string
     */
    public function getCompanyName()
    {
        return $this->container['companyName'];
    }

    /**
     * Sets companyName
     * @param string $companyName Company name for a number port
     * @return $this
     */
    public function setCompanyName($companyName)
    {
        $this->container['companyName'] = $companyName;

        return $this;
    }

    /**
     * Gets countryCode
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     * @param string $countryCode Country dial in codes (telephone dialing prefixes)
     * @return $this
     */
    public function setCountryCode($countryCode)
    {
        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets envelopeId
     * @return string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelopeId'];
    }

    /**
     * Sets envelopeId
     * @param string $envelopeId Id of the terms and conditions envelope for the order.
     * @return $this
     */
    public function setEnvelopeId($envelopeId)
    {
        $this->container['envelopeId'] = $envelopeId;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


