<?php
/**
 * Operation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Operation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Operation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Operation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'complete' => 'bool',
        'user' => '\PureCloudSDK\User',
        'errorMessage' => 'string',
        'actionName' => 'string',
        'actionStatus' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'complete' => 'complete',
        'user' => 'user',
        'errorMessage' => 'errorMessage',
        'actionName' => 'actionName',
        'actionStatus' => 'actionStatus'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'complete' => 'setComplete',
        'user' => 'setUser',
        'errorMessage' => 'setErrorMessage',
        'actionName' => 'setActionName',
        'actionStatus' => 'setActionStatus'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'complete' => 'getComplete',
        'user' => 'getUser',
        'errorMessage' => 'getErrorMessage',
        'actionName' => 'getActionName',
        'actionStatus' => 'getActionStatus'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ACTION_NAME_DEBUG = 'DEBUG';
    const ACTION_NAME_PUBLISH = 'PUBLISH';
    const ACTION_NAME_DELETE = 'DELETE';
    const ACTION_NAME_STATE_CHANGE = 'STATE_CHANGE';
    const ACTION_STATUS_LOCKED = 'LOCKED';
    const ACTION_STATUS_UNLOCKED = 'UNLOCKED';
    const ACTION_STATUS_STARTED = 'STARTED';
    const ACTION_STATUS_PENDING_GENERATION = 'PENDING_GENERATION';
    const ACTION_STATUS_PENDING_BACKEND_NOTIFICATION = 'PENDING_BACKEND_NOTIFICATION';
    const ACTION_STATUS_SUCCESS = 'SUCCESS';
    const ACTION_STATUS_FAILURE = 'FAILURE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionNameAllowableValues()
    {
        return [
            self::ACTION_NAME_DEBUG,
            self::ACTION_NAME_PUBLISH,
            self::ACTION_NAME_DELETE,
            self::ACTION_NAME_STATE_CHANGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionStatusAllowableValues()
    {
        return [
            self::ACTION_STATUS_LOCKED,
            self::ACTION_STATUS_UNLOCKED,
            self::ACTION_STATUS_STARTED,
            self::ACTION_STATUS_PENDING_GENERATION,
            self::ACTION_STATUS_PENDING_BACKEND_NOTIFICATION,
            self::ACTION_STATUS_SUCCESS,
            self::ACTION_STATUS_FAILURE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['complete'] = isset($data['complete']) ? $data['complete'] : false;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['errorMessage'] = isset($data['errorMessage']) ? $data['errorMessage'] : null;
        $this->container['actionName'] = isset($data['actionName']) ? $data['actionName'] : null;
        $this->container['actionStatus'] = isset($data['actionStatus']) ? $data['actionStatus'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DEBUG", "PUBLISH", "DELETE", "STATE_CHANGE");
        if (!in_array($this->container['actionName'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actionName', must be one of #{allowed_values}.";
        }

        $allowed_values = array("LOCKED", "UNLOCKED", "STARTED", "PENDING_GENERATION", "PENDING_BACKEND_NOTIFICATION", "SUCCESS", "FAILURE");
        if (!in_array($this->container['actionStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actionStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DEBUG", "PUBLISH", "DELETE", "STATE_CHANGE");
        if (!in_array($this->container['actionName'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("LOCKED", "UNLOCKED", "STARTED", "PENDING_GENERATION", "PENDING_BACKEND_NOTIFICATION", "SUCCESS", "FAILURE");
        if (!in_array($this->container['actionStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets complete
     * @return bool
     */
    public function getComplete()
    {
        return $this->container['complete'];
    }

    /**
     * Sets complete
     * @param bool $complete
     * @return $this
     */
    public function setComplete($complete)
    {
        $this->container['complete'] = $complete;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets errorMessage
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['errorMessage'];
    }

    /**
     * Sets errorMessage
     * @param string $errorMessage
     * @return $this
     */
    public function setErrorMessage($errorMessage)
    {
        $this->container['errorMessage'] = $errorMessage;

        return $this;
    }

    /**
     * Gets actionName
     * @return string
     */
    public function getActionName()
    {
        return $this->container['actionName'];
    }

    /**
     * Sets actionName
     * @param string $actionName Action name
     * @return $this
     */
    public function setActionName($actionName)
    {
        $allowed_values = array('DEBUG', 'PUBLISH', 'DELETE', 'STATE_CHANGE');
        if (!in_array($actionName, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actionName', must be one of 'DEBUG', 'PUBLISH', 'DELETE', 'STATE_CHANGE'");
        }
        $this->container['actionName'] = $actionName;

        return $this;
    }

    /**
     * Gets actionStatus
     * @return string
     */
    public function getActionStatus()
    {
        return $this->container['actionStatus'];
    }

    /**
     * Sets actionStatus
     * @param string $actionStatus Action status
     * @return $this
     */
    public function setActionStatus($actionStatus)
    {
        $allowed_values = array('LOCKED', 'UNLOCKED', 'STARTED', 'PENDING_GENERATION', 'PENDING_BACKEND_NOTIFICATION', 'SUCCESS', 'FAILURE');
        if (!in_array($actionStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actionStatus', must be one of 'LOCKED', 'UNLOCKED', 'STARTED', 'PENDING_GENERATION', 'PENDING_BACKEND_NOTIFICATION', 'SUCCESS', 'FAILURE'");
        }
        $this->container['actionStatus'] = $actionStatus;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


