<?php
/**
 * Quote
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Quote Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Quote implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Quote';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'purchaseOrder' => 'string',
        'type' => 'string',
        'status' => 'string',
        'currency' => 'string',
        'createdDate' => '\DateTime',
        'lastUpdatedDate' => '\DateTime',
        'billingContactEmail' => 'string',
        'billingContactFirstName' => 'string',
        'billingContactLastName' => 'string',
        'billingContactPhone' => 'string',
        'includeVoiceCharges' => 'bool',
        'charges' => '\PureCloudSDK\QuoteCharge[]',
        'edgeControlModel' => 'string',
        'referralCodes' => 'string[]',
        'discountCodes' => 'string[]',
        'salesPartnerCode' => 'string',
        'isAnnualPrepay' => 'bool',
        'account' => '\PureCloudSDK\Account',
        'freeDays' => 'int',
        'restrictions' => 'string[]',
        'validUntil' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'purchaseOrder' => 'purchaseOrder',
        'type' => 'type',
        'status' => 'status',
        'currency' => 'currency',
        'createdDate' => 'createdDate',
        'lastUpdatedDate' => 'lastUpdatedDate',
        'billingContactEmail' => 'billingContactEmail',
        'billingContactFirstName' => 'billingContactFirstName',
        'billingContactLastName' => 'billingContactLastName',
        'billingContactPhone' => 'billingContactPhone',
        'includeVoiceCharges' => 'includeVoiceCharges',
        'charges' => 'charges',
        'edgeControlModel' => 'edgeControlModel',
        'referralCodes' => 'referralCodes',
        'discountCodes' => 'discountCodes',
        'salesPartnerCode' => 'salesPartnerCode',
        'isAnnualPrepay' => 'isAnnualPrepay',
        'account' => 'account',
        'freeDays' => 'freeDays',
        'restrictions' => 'restrictions',
        'validUntil' => 'validUntil',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'purchaseOrder' => 'setPurchaseOrder',
        'type' => 'setType',
        'status' => 'setStatus',
        'currency' => 'setCurrency',
        'createdDate' => 'setCreatedDate',
        'lastUpdatedDate' => 'setLastUpdatedDate',
        'billingContactEmail' => 'setBillingContactEmail',
        'billingContactFirstName' => 'setBillingContactFirstName',
        'billingContactLastName' => 'setBillingContactLastName',
        'billingContactPhone' => 'setBillingContactPhone',
        'includeVoiceCharges' => 'setIncludeVoiceCharges',
        'charges' => 'setCharges',
        'edgeControlModel' => 'setEdgeControlModel',
        'referralCodes' => 'setReferralCodes',
        'discountCodes' => 'setDiscountCodes',
        'salesPartnerCode' => 'setSalesPartnerCode',
        'isAnnualPrepay' => 'setIsAnnualPrepay',
        'account' => 'setAccount',
        'freeDays' => 'setFreeDays',
        'restrictions' => 'setRestrictions',
        'validUntil' => 'setValidUntil',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'purchaseOrder' => 'getPurchaseOrder',
        'type' => 'getType',
        'status' => 'getStatus',
        'currency' => 'getCurrency',
        'createdDate' => 'getCreatedDate',
        'lastUpdatedDate' => 'getLastUpdatedDate',
        'billingContactEmail' => 'getBillingContactEmail',
        'billingContactFirstName' => 'getBillingContactFirstName',
        'billingContactLastName' => 'getBillingContactLastName',
        'billingContactPhone' => 'getBillingContactPhone',
        'includeVoiceCharges' => 'getIncludeVoiceCharges',
        'charges' => 'getCharges',
        'edgeControlModel' => 'getEdgeControlModel',
        'referralCodes' => 'getReferralCodes',
        'discountCodes' => 'getDiscountCodes',
        'salesPartnerCode' => 'getSalesPartnerCode',
        'isAnnualPrepay' => 'getIsAnnualPrepay',
        'account' => 'getAccount',
        'freeDays' => 'getFreeDays',
        'restrictions' => 'getRestrictions',
        'validUntil' => 'getValidUntil',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_NEW_SUBSCRIPTION = 'NEW_SUBSCRIPTION';
    const TYPE_AMENDMENT = 'AMENDMENT';
    const TYPE_NEW_VELOCITY_SUBSCRIPTION = 'NEW_VELOCITY_SUBSCRIPTION';
    const TYPE_AMENDMENT_VELOCITY_SUBSCRIPTION = 'AMENDMENT_VELOCITY_SUBSCRIPTION';
    const STATUS_IN_PROGRESS = 'IN_PROGRESS';
    const STATUS_SUBMITTED = 'SUBMITTED';
    const STATUS_FROZEN = 'FROZEN';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_NEW_SUBSCRIPTION,
            self::TYPE_AMENDMENT,
            self::TYPE_NEW_VELOCITY_SUBSCRIPTION,
            self::TYPE_AMENDMENT_VELOCITY_SUBSCRIPTION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_IN_PROGRESS,
            self::STATUS_SUBMITTED,
            self::STATUS_FROZEN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['purchaseOrder'] = isset($data['purchaseOrder']) ? $data['purchaseOrder'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['lastUpdatedDate'] = isset($data['lastUpdatedDate']) ? $data['lastUpdatedDate'] : null;
        $this->container['billingContactEmail'] = isset($data['billingContactEmail']) ? $data['billingContactEmail'] : null;
        $this->container['billingContactFirstName'] = isset($data['billingContactFirstName']) ? $data['billingContactFirstName'] : null;
        $this->container['billingContactLastName'] = isset($data['billingContactLastName']) ? $data['billingContactLastName'] : null;
        $this->container['billingContactPhone'] = isset($data['billingContactPhone']) ? $data['billingContactPhone'] : null;
        $this->container['includeVoiceCharges'] = isset($data['includeVoiceCharges']) ? $data['includeVoiceCharges'] : false;
        $this->container['charges'] = isset($data['charges']) ? $data['charges'] : null;
        $this->container['edgeControlModel'] = isset($data['edgeControlModel']) ? $data['edgeControlModel'] : null;
        $this->container['referralCodes'] = isset($data['referralCodes']) ? $data['referralCodes'] : null;
        $this->container['discountCodes'] = isset($data['discountCodes']) ? $data['discountCodes'] : null;
        $this->container['salesPartnerCode'] = isset($data['salesPartnerCode']) ? $data['salesPartnerCode'] : null;
        $this->container['isAnnualPrepay'] = isset($data['isAnnualPrepay']) ? $data['isAnnualPrepay'] : false;
        $this->container['account'] = isset($data['account']) ? $data['account'] : null;
        $this->container['freeDays'] = isset($data['freeDays']) ? $data['freeDays'] : null;
        $this->container['restrictions'] = isset($data['restrictions']) ? $data['restrictions'] : null;
        $this->container['validUntil'] = isset($data['validUntil']) ? $data['validUntil'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['purchaseOrder'] === null) {
            $invalid_properties[] = "'purchaseOrder' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("NEW_SUBSCRIPTION", "AMENDMENT", "NEW_VELOCITY_SUBSCRIPTION", "AMENDMENT_VELOCITY_SUBSCRIPTION");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("IN_PROGRESS", "SUBMITTED", "FROZEN");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['purchaseOrder'] === null) {
            return false;
        }
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("NEW_SUBSCRIPTION", "AMENDMENT", "NEW_VELOCITY_SUBSCRIPTION", "AMENDMENT_VELOCITY_SUBSCRIPTION");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("IN_PROGRESS", "SUBMITTED", "FROZEN");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets purchaseOrder
     * @return string
     */
    public function getPurchaseOrder()
    {
        return $this->container['purchaseOrder'];
    }

    /**
     * Sets purchaseOrder
     * @param string $purchaseOrder Purchase order
     * @return $this
     */
    public function setPurchaseOrder($purchaseOrder)
    {
        $this->container['purchaseOrder'] = $purchaseOrder;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Quote type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('NEW_SUBSCRIPTION', 'AMENDMENT', 'NEW_VELOCITY_SUBSCRIPTION', 'AMENDMENT_VELOCITY_SUBSCRIPTION');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'NEW_SUBSCRIPTION', 'AMENDMENT', 'NEW_VELOCITY_SUBSCRIPTION', 'AMENDMENT_VELOCITY_SUBSCRIPTION'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Quote Status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('IN_PROGRESS', 'SUBMITTED', 'FROZEN');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'IN_PROGRESS', 'SUBMITTED', 'FROZEN'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets createdDate
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     * @param \DateTime $createdDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets lastUpdatedDate
     * @return \DateTime
     */
    public function getLastUpdatedDate()
    {
        return $this->container['lastUpdatedDate'];
    }

    /**
     * Sets lastUpdatedDate
     * @param \DateTime $lastUpdatedDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastUpdatedDate($lastUpdatedDate)
    {
        $this->container['lastUpdatedDate'] = $lastUpdatedDate;

        return $this;
    }

    /**
     * Gets billingContactEmail
     * @return string
     */
    public function getBillingContactEmail()
    {
        return $this->container['billingContactEmail'];
    }

    /**
     * Sets billingContactEmail
     * @param string $billingContactEmail
     * @return $this
     */
    public function setBillingContactEmail($billingContactEmail)
    {
        $this->container['billingContactEmail'] = $billingContactEmail;

        return $this;
    }

    /**
     * Gets billingContactFirstName
     * @return string
     */
    public function getBillingContactFirstName()
    {
        return $this->container['billingContactFirstName'];
    }

    /**
     * Sets billingContactFirstName
     * @param string $billingContactFirstName
     * @return $this
     */
    public function setBillingContactFirstName($billingContactFirstName)
    {
        $this->container['billingContactFirstName'] = $billingContactFirstName;

        return $this;
    }

    /**
     * Gets billingContactLastName
     * @return string
     */
    public function getBillingContactLastName()
    {
        return $this->container['billingContactLastName'];
    }

    /**
     * Sets billingContactLastName
     * @param string $billingContactLastName
     * @return $this
     */
    public function setBillingContactLastName($billingContactLastName)
    {
        $this->container['billingContactLastName'] = $billingContactLastName;

        return $this;
    }

    /**
     * Gets billingContactPhone
     * @return string
     */
    public function getBillingContactPhone()
    {
        return $this->container['billingContactPhone'];
    }

    /**
     * Sets billingContactPhone
     * @param string $billingContactPhone
     * @return $this
     */
    public function setBillingContactPhone($billingContactPhone)
    {
        $this->container['billingContactPhone'] = $billingContactPhone;

        return $this;
    }

    /**
     * Gets includeVoiceCharges
     * @return bool
     */
    public function getIncludeVoiceCharges()
    {
        return $this->container['includeVoiceCharges'];
    }

    /**
     * Sets includeVoiceCharges
     * @param bool $includeVoiceCharges
     * @return $this
     */
    public function setIncludeVoiceCharges($includeVoiceCharges)
    {
        $this->container['includeVoiceCharges'] = $includeVoiceCharges;

        return $this;
    }

    /**
     * Gets charges
     * @return \PureCloudSDK\QuoteCharge[]
     */
    public function getCharges()
    {
        return $this->container['charges'];
    }

    /**
     * Sets charges
     * @param \PureCloudSDK\QuoteCharge[] $charges
     * @return $this
     */
    public function setCharges($charges)
    {
        $this->container['charges'] = $charges;

        return $this;
    }

    /**
     * Gets edgeControlModel
     * @return string
     */
    public function getEdgeControlModel()
    {
        return $this->container['edgeControlModel'];
    }

    /**
     * Sets edgeControlModel
     * @param string $edgeControlModel
     * @return $this
     */
    public function setEdgeControlModel($edgeControlModel)
    {
        $this->container['edgeControlModel'] = $edgeControlModel;

        return $this;
    }

    /**
     * Gets referralCodes
     * @return string[]
     */
    public function getReferralCodes()
    {
        return $this->container['referralCodes'];
    }

    /**
     * Sets referralCodes
     * @param string[] $referralCodes
     * @return $this
     */
    public function setReferralCodes($referralCodes)
    {
        $this->container['referralCodes'] = $referralCodes;

        return $this;
    }

    /**
     * Gets discountCodes
     * @return string[]
     */
    public function getDiscountCodes()
    {
        return $this->container['discountCodes'];
    }

    /**
     * Sets discountCodes
     * @param string[] $discountCodes
     * @return $this
     */
    public function setDiscountCodes($discountCodes)
    {
        $this->container['discountCodes'] = $discountCodes;

        return $this;
    }

    /**
     * Gets salesPartnerCode
     * @return string
     */
    public function getSalesPartnerCode()
    {
        return $this->container['salesPartnerCode'];
    }

    /**
     * Sets salesPartnerCode
     * @param string $salesPartnerCode
     * @return $this
     */
    public function setSalesPartnerCode($salesPartnerCode)
    {
        $this->container['salesPartnerCode'] = $salesPartnerCode;

        return $this;
    }

    /**
     * Gets isAnnualPrepay
     * @return bool
     */
    public function getIsAnnualPrepay()
    {
        return $this->container['isAnnualPrepay'];
    }

    /**
     * Sets isAnnualPrepay
     * @param bool $isAnnualPrepay
     * @return $this
     */
    public function setIsAnnualPrepay($isAnnualPrepay)
    {
        $this->container['isAnnualPrepay'] = $isAnnualPrepay;

        return $this;
    }

    /**
     * Gets account
     * @return \PureCloudSDK\Account
     */
    public function getAccount()
    {
        return $this->container['account'];
    }

    /**
     * Sets account
     * @param \PureCloudSDK\Account $account
     * @return $this
     */
    public function setAccount($account)
    {
        $this->container['account'] = $account;

        return $this;
    }

    /**
     * Gets freeDays
     * @return int
     */
    public function getFreeDays()
    {
        return $this->container['freeDays'];
    }

    /**
     * Sets freeDays
     * @param int $freeDays
     * @return $this
     */
    public function setFreeDays($freeDays)
    {
        $this->container['freeDays'] = $freeDays;

        return $this;
    }

    /**
     * Gets restrictions
     * @return string[]
     */
    public function getRestrictions()
    {
        return $this->container['restrictions'];
    }

    /**
     * Sets restrictions
     * @param string[] $restrictions
     * @return $this
     */
    public function setRestrictions($restrictions)
    {
        $this->container['restrictions'] = $restrictions;

        return $this;
    }

    /**
     * Gets validUntil
     * @return \DateTime
     */
    public function getValidUntil()
    {
        return $this->container['validUntil'];
    }

    /**
     * Sets validUntil
     * @param \DateTime $validUntil Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setValidUntil($validUntil)
    {
        $this->container['validUntil'] = $validUntil;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


