<?php
/**
 * QuoteCharge
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * QuoteCharge Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QuoteCharge implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QuoteCharge';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'sku' => 'string',
        'name' => 'string',
        'chargeType' => 'string',
        'quantity' => 'int',
        'listTotal' => 'string',
        'total' => 'string',
        'listPriceDisplay' => 'string',
        'discount' => 'string',
        'effectivePrice' => 'string',
        'productShippable' => 'bool',
        'shippingAddress' => '\PureCloudSDK\BillingAddress',
        'forRelatedPart' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'sku' => 'sku',
        'name' => 'name',
        'chargeType' => 'chargeType',
        'quantity' => 'quantity',
        'listTotal' => 'listTotal',
        'total' => 'total',
        'listPriceDisplay' => 'listPriceDisplay',
        'discount' => 'discount',
        'effectivePrice' => 'effectivePrice',
        'productShippable' => 'productShippable',
        'shippingAddress' => 'shippingAddress',
        'forRelatedPart' => 'forRelatedPart'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'sku' => 'setSku',
        'name' => 'setName',
        'chargeType' => 'setChargeType',
        'quantity' => 'setQuantity',
        'listTotal' => 'setListTotal',
        'total' => 'setTotal',
        'listPriceDisplay' => 'setListPriceDisplay',
        'discount' => 'setDiscount',
        'effectivePrice' => 'setEffectivePrice',
        'productShippable' => 'setProductShippable',
        'shippingAddress' => 'setShippingAddress',
        'forRelatedPart' => 'setForRelatedPart'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'sku' => 'getSku',
        'name' => 'getName',
        'chargeType' => 'getChargeType',
        'quantity' => 'getQuantity',
        'listTotal' => 'getListTotal',
        'total' => 'getTotal',
        'listPriceDisplay' => 'getListPriceDisplay',
        'discount' => 'getDiscount',
        'effectivePrice' => 'getEffectivePrice',
        'productShippable' => 'getProductShippable',
        'shippingAddress' => 'getShippingAddress',
        'forRelatedPart' => 'getForRelatedPart'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['sku'] = isset($data['sku']) ? $data['sku'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['chargeType'] = isset($data['chargeType']) ? $data['chargeType'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
        $this->container['listTotal'] = isset($data['listTotal']) ? $data['listTotal'] : null;
        $this->container['total'] = isset($data['total']) ? $data['total'] : null;
        $this->container['listPriceDisplay'] = isset($data['listPriceDisplay']) ? $data['listPriceDisplay'] : null;
        $this->container['discount'] = isset($data['discount']) ? $data['discount'] : null;
        $this->container['effectivePrice'] = isset($data['effectivePrice']) ? $data['effectivePrice'] : null;
        $this->container['productShippable'] = isset($data['productShippable']) ? $data['productShippable'] : false;
        $this->container['shippingAddress'] = isset($data['shippingAddress']) ? $data['shippingAddress'] : null;
        $this->container['forRelatedPart'] = isset($data['forRelatedPart']) ? $data['forRelatedPart'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalid_properties[] = "'sku' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['chargeType'] === null) {
            $invalid_properties[] = "'chargeType' can't be null";
        }
        if ($this->container['quantity'] === null) {
            $invalid_properties[] = "'quantity' can't be null";
        }
        if ($this->container['listTotal'] === null) {
            $invalid_properties[] = "'listTotal' can't be null";
        }
        if ($this->container['total'] === null) {
            $invalid_properties[] = "'total' can't be null";
        }
        if ($this->container['listPriceDisplay'] === null) {
            $invalid_properties[] = "'listPriceDisplay' can't be null";
        }
        if ($this->container['discount'] === null) {
            $invalid_properties[] = "'discount' can't be null";
        }
        if ($this->container['effectivePrice'] === null) {
            $invalid_properties[] = "'effectivePrice' can't be null";
        }
        if ($this->container['productShippable'] === null) {
            $invalid_properties[] = "'productShippable' can't be null";
        }
        if ($this->container['shippingAddress'] === null) {
            $invalid_properties[] = "'shippingAddress' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['id'] === null) {
            return false;
        }
        if ($this->container['sku'] === null) {
            return false;
        }
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['chargeType'] === null) {
            return false;
        }
        if ($this->container['quantity'] === null) {
            return false;
        }
        if ($this->container['listTotal'] === null) {
            return false;
        }
        if ($this->container['total'] === null) {
            return false;
        }
        if ($this->container['listPriceDisplay'] === null) {
            return false;
        }
        if ($this->container['discount'] === null) {
            return false;
        }
        if ($this->container['effectivePrice'] === null) {
            return false;
        }
        if ($this->container['productShippable'] === null) {
            return false;
        }
        if ($this->container['shippingAddress'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The quote charge Id.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets sku
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     * @param string $sku The quote charge SKU.
     * @return $this
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The quote charge name.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets chargeType
     * @return string
     */
    public function getChargeType()
    {
        return $this->container['chargeType'];
    }

    /**
     * Sets chargeType
     * @param string $chargeType The quote charge type.
     * @return $this
     */
    public function setChargeType($chargeType)
    {
        $this->container['chargeType'] = $chargeType;

        return $this;
    }

    /**
     * Gets quantity
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     * @param int $quantity The quote charge quantity.
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets listTotal
     * @return string
     */
    public function getListTotal()
    {
        return $this->container['listTotal'];
    }

    /**
     * Sets listTotal
     * @param string $listTotal The quote charge total price before discounts.
     * @return $this
     */
    public function setListTotal($listTotal)
    {
        $this->container['listTotal'] = $listTotal;

        return $this;
    }

    /**
     * Gets total
     * @return string
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     * @param string $total The quote charge total price after discounts.
     * @return $this
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets listPriceDisplay
     * @return string
     */
    public function getListPriceDisplay()
    {
        return $this->container['listPriceDisplay'];
    }

    /**
     * Sets listPriceDisplay
     * @param string $listPriceDisplay The quote charge list price before discounts.
     * @return $this
     */
    public function setListPriceDisplay($listPriceDisplay)
    {
        $this->container['listPriceDisplay'] = $listPriceDisplay;

        return $this;
    }

    /**
     * Gets discount
     * @return string
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     * @param string $discount The quote charge discount percent.
     * @return $this
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets effectivePrice
     * @return string
     */
    public function getEffectivePrice()
    {
        return $this->container['effectivePrice'];
    }

    /**
     * Sets effectivePrice
     * @param string $effectivePrice The quote charge list price after discounts.
     * @return $this
     */
    public function setEffectivePrice($effectivePrice)
    {
        $this->container['effectivePrice'] = $effectivePrice;

        return $this;
    }

    /**
     * Gets productShippable
     * @return bool
     */
    public function getProductShippable()
    {
        return $this->container['productShippable'];
    }

    /**
     * Sets productShippable
     * @param bool $productShippable Indicates whether the product can be shipped.
     * @return $this
     */
    public function setProductShippable($productShippable)
    {
        $this->container['productShippable'] = $productShippable;

        return $this;
    }

    /**
     * Gets shippingAddress
     * @return \PureCloudSDK\BillingAddress
     */
    public function getShippingAddress()
    {
        return $this->container['shippingAddress'];
    }

    /**
     * Sets shippingAddress
     * @param \PureCloudSDK\BillingAddress $shippingAddress The quote shipping address.
     * @return $this
     */
    public function setShippingAddress($shippingAddress)
    {
        $this->container['shippingAddress'] = $shippingAddress;

        return $this;
    }

    /**
     * Gets forRelatedPart
     * @return string
     */
    public function getForRelatedPart()
    {
        return $this->container['forRelatedPart'];
    }

    /**
     * Sets forRelatedPart
     * @param string $forRelatedPart The part number of a part related to the quote charge.
     * @return $this
     */
    public function setForRelatedPart($forRelatedPart)
    {
        $this->container['forRelatedPart'] = $forRelatedPart;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


