<?php
/**
 * SheetSchema
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * SheetSchema Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SheetSchema implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SheetSchema';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'headerRow' => 'int',
        'dataRow' => 'int',
        'headerMappings' => 'map[string,string]',
        'rateType' => 'string',
        'sheetNumber' => 'int',
        'dateFormat' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'headerRow' => 'HeaderRow',
        'dataRow' => 'DataRow',
        'headerMappings' => 'HeaderMappings',
        'rateType' => 'RateType',
        'sheetNumber' => 'SheetNumber',
        'dateFormat' => 'DateFormat'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'headerRow' => 'setHeaderRow',
        'dataRow' => 'setDataRow',
        'headerMappings' => 'setHeaderMappings',
        'rateType' => 'setRateType',
        'sheetNumber' => 'setSheetNumber',
        'dateFormat' => 'setDateFormat'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'headerRow' => 'getHeaderRow',
        'dataRow' => 'getDataRow',
        'headerMappings' => 'getHeaderMappings',
        'rateType' => 'getRateType',
        'sheetNumber' => 'getSheetNumber',
        'dateFormat' => 'getDateFormat'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const RATE_TYPE_INTRASTATE = 'INTRASTATE';
    const RATE_TYPE_INTERSTATE = 'INTERSTATE';
    const RATE_TYPE_INTERNATIONAL = 'INTERNATIONAL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRateTypeAllowableValues()
    {
        return [
            self::RATE_TYPE_INTRASTATE,
            self::RATE_TYPE_INTERSTATE,
            self::RATE_TYPE_INTERNATIONAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['headerRow'] = isset($data['headerRow']) ? $data['headerRow'] : null;
        $this->container['dataRow'] = isset($data['dataRow']) ? $data['dataRow'] : null;
        $this->container['headerMappings'] = isset($data['headerMappings']) ? $data['headerMappings'] : null;
        $this->container['rateType'] = isset($data['rateType']) ? $data['rateType'] : null;
        $this->container['sheetNumber'] = isset($data['sheetNumber']) ? $data['sheetNumber'] : null;
        $this->container['dateFormat'] = isset($data['dateFormat']) ? $data['dateFormat'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['headerRow'] === null) {
            $invalid_properties[] = "'headerRow' can't be null";
        }
        if ($this->container['dataRow'] === null) {
            $invalid_properties[] = "'dataRow' can't be null";
        }
        if ($this->container['headerMappings'] === null) {
            $invalid_properties[] = "'headerMappings' can't be null";
        }
        if ($this->container['rateType'] === null) {
            $invalid_properties[] = "'rateType' can't be null";
        }
        $allowed_values = array("INTRASTATE", "INTERSTATE", "INTERNATIONAL");
        if (!in_array($this->container['rateType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'rateType', must be one of #{allowed_values}.";
        }

        if ($this->container['sheetNumber'] === null) {
            $invalid_properties[] = "'sheetNumber' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['headerRow'] === null) {
            return false;
        }
        if ($this->container['dataRow'] === null) {
            return false;
        }
        if ($this->container['headerMappings'] === null) {
            return false;
        }
        if ($this->container['rateType'] === null) {
            return false;
        }
        $allowed_values = array("INTRASTATE", "INTERSTATE", "INTERNATIONAL");
        if (!in_array($this->container['rateType'], $allowed_values)) {
            return false;
        }
        if ($this->container['sheetNumber'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets headerRow
     * @return int
     */
    public function getHeaderRow()
    {
        return $this->container['headerRow'];
    }

    /**
     * Sets headerRow
     * @param int $headerRow Row number for the XLSX sheet's headers.  This is zero indexed (i.e. 0 is row 1).
     * @return $this
     */
    public function setHeaderRow($headerRow)
    {
        $this->container['headerRow'] = $headerRow;

        return $this;
    }

    /**
     * Gets dataRow
     * @return int
     */
    public function getDataRow()
    {
        return $this->container['dataRow'];
    }

    /**
     * Sets dataRow
     * @param int $dataRow Row number of the first line of data in the sheet.  This is zero indexed (i.e. 0 is row 1)
     * @return $this
     */
    public function setDataRow($dataRow)
    {
        $this->container['dataRow'] = $dataRow;

        return $this;
    }

    /**
     * Gets headerMappings
     * @return map[string,string]
     */
    public function getHeaderMappings()
    {
        return $this->container['headerMappings'];
    }

    /**
     * Sets headerMappings
     * @param map[string,string] $headerMappings XLSX sheet header name to object name mappings. For example, \"ROUTE_TEL_PREFIX\" to \"Prefix\" might be one such mapping.
     * @return $this
     */
    public function setHeaderMappings($headerMappings)
    {
        $this->container['headerMappings'] = $headerMappings;

        return $this;
    }

    /**
     * Gets rateType
     * @return string
     */
    public function getRateType()
    {
        return $this->container['rateType'];
    }

    /**
     * Sets rateType
     * @param string $rateType Rate type for the sheet.
     * @return $this
     */
    public function setRateType($rateType)
    {
        $allowed_values = array('INTRASTATE', 'INTERSTATE', 'INTERNATIONAL');
        if (!in_array($rateType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'rateType', must be one of 'INTRASTATE', 'INTERSTATE', 'INTERNATIONAL'");
        }
        $this->container['rateType'] = $rateType;

        return $this;
    }

    /**
     * Gets sheetNumber
     * @return int
     */
    public function getSheetNumber()
    {
        return $this->container['sheetNumber'];
    }

    /**
     * Sets sheetNumber
     * @param int $sheetNumber Sheet number within the XLSX file.  This is zero indexed (i.e. 0 is page 1).
     * @return $this
     */
    public function setSheetNumber($sheetNumber)
    {
        $this->container['sheetNumber'] = $sheetNumber;

        return $this;
    }

    /**
     * Gets dateFormat
     * @return string
     */
    public function getDateFormat()
    {
        return $this->container['dateFormat'];
    }

    /**
     * Sets dateFormat
     * @param string $dateFormat A date format that represents the date time stamp you want to parse. This is based on the reference time of Mon Jan 2 15:04:05 MST 2006. For example, if you had the date 13-OCT-2015, this parameter should be 02-Jan-2006. As another example, if you have the date 2014-09-20, this parameter should be 2006-01-02.
     * @return $this
     */
    public function setDateFormat($dateFormat)
    {
        $this->container['dateFormat'] = $dateFormat;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


