<?php
/**
 * UsageRate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UsageRate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UsageRate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UsageRate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'flatRate' => 'double',
        'usageRate' => 'double',
        'defaultCPCGroups' => 'string[]',
        'mobileGroups' => 'string[]',
        'landlineCPCGroups' => 'string[]',
        'payphoneGroups' => 'string[]',
        'outboundGroups' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'flatRate' => 'flatRate',
        'usageRate' => 'usageRate',
        'defaultCPCGroups' => 'defaultCPCGroups',
        'mobileGroups' => 'mobileGroups',
        'landlineCPCGroups' => 'landlineCPCGroups',
        'payphoneGroups' => 'payphoneGroups',
        'outboundGroups' => 'outboundGroups'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'flatRate' => 'setFlatRate',
        'usageRate' => 'setUsageRate',
        'defaultCPCGroups' => 'setDefaultCPCGroups',
        'mobileGroups' => 'setMobileGroups',
        'landlineCPCGroups' => 'setLandlineCPCGroups',
        'payphoneGroups' => 'setPayphoneGroups',
        'outboundGroups' => 'setOutboundGroups'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'flatRate' => 'getFlatRate',
        'usageRate' => 'getUsageRate',
        'defaultCPCGroups' => 'getDefaultCPCGroups',
        'mobileGroups' => 'getMobileGroups',
        'landlineCPCGroups' => 'getLandlineCPCGroups',
        'payphoneGroups' => 'getPayphoneGroups',
        'outboundGroups' => 'getOutboundGroups'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['flatRate'] = isset($data['flatRate']) ? $data['flatRate'] : null;
        $this->container['usageRate'] = isset($data['usageRate']) ? $data['usageRate'] : null;
        $this->container['defaultCPCGroups'] = isset($data['defaultCPCGroups']) ? $data['defaultCPCGroups'] : null;
        $this->container['mobileGroups'] = isset($data['mobileGroups']) ? $data['mobileGroups'] : null;
        $this->container['landlineCPCGroups'] = isset($data['landlineCPCGroups']) ? $data['landlineCPCGroups'] : null;
        $this->container['payphoneGroups'] = isset($data['payphoneGroups']) ? $data['payphoneGroups'] : null;
        $this->container['outboundGroups'] = isset($data['outboundGroups']) ? $data['outboundGroups'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets flatRate
     * @return double
     */
    public function getFlatRate()
    {
        return $this->container['flatRate'];
    }

    /**
     * Sets flatRate
     * @param double $flatRate
     * @return $this
     */
    public function setFlatRate($flatRate)
    {
        $this->container['flatRate'] = $flatRate;

        return $this;
    }

    /**
     * Gets usageRate
     * @return double
     */
    public function getUsageRate()
    {
        return $this->container['usageRate'];
    }

    /**
     * Sets usageRate
     * @param double $usageRate
     * @return $this
     */
    public function setUsageRate($usageRate)
    {
        $this->container['usageRate'] = $usageRate;

        return $this;
    }

    /**
     * Gets defaultCPCGroups
     * @return string[]
     */
    public function getDefaultCPCGroups()
    {
        return $this->container['defaultCPCGroups'];
    }

    /**
     * Sets defaultCPCGroups
     * @param string[] $defaultCPCGroups
     * @return $this
     */
    public function setDefaultCPCGroups($defaultCPCGroups)
    {
        $this->container['defaultCPCGroups'] = $defaultCPCGroups;

        return $this;
    }

    /**
     * Gets mobileGroups
     * @return string[]
     */
    public function getMobileGroups()
    {
        return $this->container['mobileGroups'];
    }

    /**
     * Sets mobileGroups
     * @param string[] $mobileGroups
     * @return $this
     */
    public function setMobileGroups($mobileGroups)
    {
        $this->container['mobileGroups'] = $mobileGroups;

        return $this;
    }

    /**
     * Gets landlineCPCGroups
     * @return string[]
     */
    public function getLandlineCPCGroups()
    {
        return $this->container['landlineCPCGroups'];
    }

    /**
     * Sets landlineCPCGroups
     * @param string[] $landlineCPCGroups
     * @return $this
     */
    public function setLandlineCPCGroups($landlineCPCGroups)
    {
        $this->container['landlineCPCGroups'] = $landlineCPCGroups;

        return $this;
    }

    /**
     * Gets payphoneGroups
     * @return string[]
     */
    public function getPayphoneGroups()
    {
        return $this->container['payphoneGroups'];
    }

    /**
     * Sets payphoneGroups
     * @param string[] $payphoneGroups
     * @return $this
     */
    public function setPayphoneGroups($payphoneGroups)
    {
        $this->container['payphoneGroups'] = $payphoneGroups;

        return $this;
    }

    /**
     * Gets outboundGroups
     * @return string[]
     */
    public function getOutboundGroups()
    {
        return $this->container['outboundGroups'];
    }

    /**
     * Sets outboundGroups
     * @param string[] $outboundGroups
     * @return $this
     */
    public function setOutboundGroups($outboundGroups)
    {
        $this->container['outboundGroups'] = $outboundGroups;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


