<?php
/**
 * VoiceRateExtended
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoiceRateExtended Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoiceRateExtended implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoiceRateExtended';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'currency' => 'string',
        'amendmentId' => 'string',
        'type' => 'string',
        'effectiveDate' => '\DateTime',
        'groupName' => 'string',
        'areaCode' => 'string',
        'deletionMarker' => 'bool',
        'outboundRate' => 'float',
        'outboundDurationMinimumSeconds' => 'int',
        'outboundDurationIncrementSeconds' => 'int',
        'inboundTolledRate' => 'float',
        'inboundTolledDurationMinimumSeconds' => 'int',
        'inboundTolledDurationIncrementSeconds' => 'int',
        'inboundTollFreeRate' => 'float',
        'inboundTollFreeDurationMinimumSeconds' => 'int',
        'inboundTollFreeDurationIncrementSeconds' => 'int',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'currency' => 'currency',
        'amendmentId' => 'amendmentId',
        'type' => 'type',
        'effectiveDate' => 'effectiveDate',
        'groupName' => 'groupName',
        'areaCode' => 'areaCode',
        'deletionMarker' => 'deletionMarker',
        'outboundRate' => 'outboundRate',
        'outboundDurationMinimumSeconds' => 'outboundDurationMinimumSeconds',
        'outboundDurationIncrementSeconds' => 'outboundDurationIncrementSeconds',
        'inboundTolledRate' => 'inboundTolledRate',
        'inboundTolledDurationMinimumSeconds' => 'inboundTolledDurationMinimumSeconds',
        'inboundTolledDurationIncrementSeconds' => 'inboundTolledDurationIncrementSeconds',
        'inboundTollFreeRate' => 'inboundTollFreeRate',
        'inboundTollFreeDurationMinimumSeconds' => 'inboundTollFreeDurationMinimumSeconds',
        'inboundTollFreeDurationIncrementSeconds' => 'inboundTollFreeDurationIncrementSeconds',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'currency' => 'setCurrency',
        'amendmentId' => 'setAmendmentId',
        'type' => 'setType',
        'effectiveDate' => 'setEffectiveDate',
        'groupName' => 'setGroupName',
        'areaCode' => 'setAreaCode',
        'deletionMarker' => 'setDeletionMarker',
        'outboundRate' => 'setOutboundRate',
        'outboundDurationMinimumSeconds' => 'setOutboundDurationMinimumSeconds',
        'outboundDurationIncrementSeconds' => 'setOutboundDurationIncrementSeconds',
        'inboundTolledRate' => 'setInboundTolledRate',
        'inboundTolledDurationMinimumSeconds' => 'setInboundTolledDurationMinimumSeconds',
        'inboundTolledDurationIncrementSeconds' => 'setInboundTolledDurationIncrementSeconds',
        'inboundTollFreeRate' => 'setInboundTollFreeRate',
        'inboundTollFreeDurationMinimumSeconds' => 'setInboundTollFreeDurationMinimumSeconds',
        'inboundTollFreeDurationIncrementSeconds' => 'setInboundTollFreeDurationIncrementSeconds',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'currency' => 'getCurrency',
        'amendmentId' => 'getAmendmentId',
        'type' => 'getType',
        'effectiveDate' => 'getEffectiveDate',
        'groupName' => 'getGroupName',
        'areaCode' => 'getAreaCode',
        'deletionMarker' => 'getDeletionMarker',
        'outboundRate' => 'getOutboundRate',
        'outboundDurationMinimumSeconds' => 'getOutboundDurationMinimumSeconds',
        'outboundDurationIncrementSeconds' => 'getOutboundDurationIncrementSeconds',
        'inboundTolledRate' => 'getInboundTolledRate',
        'inboundTolledDurationMinimumSeconds' => 'getInboundTolledDurationMinimumSeconds',
        'inboundTolledDurationIncrementSeconds' => 'getInboundTolledDurationIncrementSeconds',
        'inboundTollFreeRate' => 'getInboundTollFreeRate',
        'inboundTollFreeDurationMinimumSeconds' => 'getInboundTollFreeDurationMinimumSeconds',
        'inboundTollFreeDurationIncrementSeconds' => 'getInboundTollFreeDurationIncrementSeconds',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_RATE_TOLL_FREE = 'RATE_TOLL_FREE';
    const TYPE_RATE_TOLLED = 'RATE_TOLLED';
    const TYPE_OUTBOUND_INTERSTATE = 'OUTBOUND_INTERSTATE';
    const TYPE_OUTBOUND_INTRASTATE = 'OUTBOUND_INTRASTATE';
    const TYPE_OUTBOUND_LOCAL = 'OUTBOUND_LOCAL';
    const TYPE_EXTENDED = 'EXTENDED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_RATE_TOLL_FREE,
            self::TYPE_RATE_TOLLED,
            self::TYPE_OUTBOUND_INTERSTATE,
            self::TYPE_OUTBOUND_INTRASTATE,
            self::TYPE_OUTBOUND_LOCAL,
            self::TYPE_EXTENDED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['amendmentId'] = isset($data['amendmentId']) ? $data['amendmentId'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['effectiveDate'] = isset($data['effectiveDate']) ? $data['effectiveDate'] : null;
        $this->container['groupName'] = isset($data['groupName']) ? $data['groupName'] : null;
        $this->container['areaCode'] = isset($data['areaCode']) ? $data['areaCode'] : null;
        $this->container['deletionMarker'] = isset($data['deletionMarker']) ? $data['deletionMarker'] : false;
        $this->container['outboundRate'] = isset($data['outboundRate']) ? $data['outboundRate'] : null;
        $this->container['outboundDurationMinimumSeconds'] = isset($data['outboundDurationMinimumSeconds']) ? $data['outboundDurationMinimumSeconds'] : null;
        $this->container['outboundDurationIncrementSeconds'] = isset($data['outboundDurationIncrementSeconds']) ? $data['outboundDurationIncrementSeconds'] : null;
        $this->container['inboundTolledRate'] = isset($data['inboundTolledRate']) ? $data['inboundTolledRate'] : null;
        $this->container['inboundTolledDurationMinimumSeconds'] = isset($data['inboundTolledDurationMinimumSeconds']) ? $data['inboundTolledDurationMinimumSeconds'] : null;
        $this->container['inboundTolledDurationIncrementSeconds'] = isset($data['inboundTolledDurationIncrementSeconds']) ? $data['inboundTolledDurationIncrementSeconds'] : null;
        $this->container['inboundTollFreeRate'] = isset($data['inboundTollFreeRate']) ? $data['inboundTollFreeRate'] : null;
        $this->container['inboundTollFreeDurationMinimumSeconds'] = isset($data['inboundTollFreeDurationMinimumSeconds']) ? $data['inboundTollFreeDurationMinimumSeconds'] : null;
        $this->container['inboundTollFreeDurationIncrementSeconds'] = isset($data['inboundTollFreeDurationIncrementSeconds']) ? $data['inboundTollFreeDurationIncrementSeconds'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['currency'] === null) {
            $invalid_properties[] = "'currency' can't be null";
        }
        if ($this->container['amendmentId'] === null) {
            $invalid_properties[] = "'amendmentId' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['effectiveDate'] === null) {
            $invalid_properties[] = "'effectiveDate' can't be null";
        }
        if ($this->container['groupName'] === null) {
            $invalid_properties[] = "'groupName' can't be null";
        }
        if ($this->container['areaCode'] === null) {
            $invalid_properties[] = "'areaCode' can't be null";
        }
        if ($this->container['deletionMarker'] === null) {
            $invalid_properties[] = "'deletionMarker' can't be null";
        }
        if ($this->container['outboundRate'] === null) {
            $invalid_properties[] = "'outboundRate' can't be null";
        }
        if ($this->container['outboundDurationMinimumSeconds'] === null) {
            $invalid_properties[] = "'outboundDurationMinimumSeconds' can't be null";
        }
        if ($this->container['outboundDurationIncrementSeconds'] === null) {
            $invalid_properties[] = "'outboundDurationIncrementSeconds' can't be null";
        }
        if ($this->container['inboundTolledRate'] === null) {
            $invalid_properties[] = "'inboundTolledRate' can't be null";
        }
        if ($this->container['inboundTolledDurationMinimumSeconds'] === null) {
            $invalid_properties[] = "'inboundTolledDurationMinimumSeconds' can't be null";
        }
        if ($this->container['inboundTolledDurationIncrementSeconds'] === null) {
            $invalid_properties[] = "'inboundTolledDurationIncrementSeconds' can't be null";
        }
        if ($this->container['inboundTollFreeRate'] === null) {
            $invalid_properties[] = "'inboundTollFreeRate' can't be null";
        }
        if ($this->container['inboundTollFreeDurationMinimumSeconds'] === null) {
            $invalid_properties[] = "'inboundTollFreeDurationMinimumSeconds' can't be null";
        }
        if ($this->container['inboundTollFreeDurationIncrementSeconds'] === null) {
            $invalid_properties[] = "'inboundTollFreeDurationIncrementSeconds' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['currency'] === null) {
            return false;
        }
        if ($this->container['amendmentId'] === null) {
            return false;
        }
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['effectiveDate'] === null) {
            return false;
        }
        if ($this->container['groupName'] === null) {
            return false;
        }
        if ($this->container['areaCode'] === null) {
            return false;
        }
        if ($this->container['deletionMarker'] === null) {
            return false;
        }
        if ($this->container['outboundRate'] === null) {
            return false;
        }
        if ($this->container['outboundDurationMinimumSeconds'] === null) {
            return false;
        }
        if ($this->container['outboundDurationIncrementSeconds'] === null) {
            return false;
        }
        if ($this->container['inboundTolledRate'] === null) {
            return false;
        }
        if ($this->container['inboundTolledDurationMinimumSeconds'] === null) {
            return false;
        }
        if ($this->container['inboundTolledDurationIncrementSeconds'] === null) {
            return false;
        }
        if ($this->container['inboundTollFreeRate'] === null) {
            return false;
        }
        if ($this->container['inboundTollFreeDurationMinimumSeconds'] === null) {
            return false;
        }
        if ($this->container['inboundTollFreeDurationIncrementSeconds'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency The ISO 4217 currency code of the voice rate.
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets amendmentId
     * @return string
     */
    public function getAmendmentId()
    {
        return $this->container['amendmentId'];
    }

    /**
     * Sets amendmentId
     * @param string $amendmentId The amendment Id of the voice rate.
     * @return $this
     */
    public function setAmendmentId($amendmentId)
    {
        $this->container['amendmentId'] = $amendmentId;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The voice rate type.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('RATE_TOLL_FREE', 'RATE_TOLLED', 'OUTBOUND_INTERSTATE', 'OUTBOUND_INTRASTATE', 'OUTBOUND_LOCAL', 'EXTENDED');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'RATE_TOLL_FREE', 'RATE_TOLLED', 'OUTBOUND_INTERSTATE', 'OUTBOUND_INTRASTATE', 'OUTBOUND_LOCAL', 'EXTENDED'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets effectiveDate
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
        return $this->container['effectiveDate'];
    }

    /**
     * Sets effectiveDate
     * @param \DateTime $effectiveDate The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveDate($effectiveDate)
    {
        $this->container['effectiveDate'] = $effectiveDate;

        return $this;
    }

    /**
     * Gets groupName
     * @return string
     */
    public function getGroupName()
    {
        return $this->container['groupName'];
    }

    /**
     * Sets groupName
     * @param string $groupName The group containing this area code.
     * @return $this
     */
    public function setGroupName($groupName)
    {
        $this->container['groupName'] = $groupName;

        return $this;
    }

    /**
     * Gets areaCode
     * @return string
     */
    public function getAreaCode()
    {
        return $this->container['areaCode'];
    }

    /**
     * Sets areaCode
     * @param string $areaCode The area code.
     * @return $this
     */
    public function setAreaCode($areaCode)
    {
        $this->container['areaCode'] = $areaCode;

        return $this;
    }

    /**
     * Gets deletionMarker
     * @return bool
     */
    public function getDeletionMarker()
    {
        return $this->container['deletionMarker'];
    }

    /**
     * Sets deletionMarker
     * @param bool $deletionMarker The deletion marker.
     * @return $this
     */
    public function setDeletionMarker($deletionMarker)
    {
        $this->container['deletionMarker'] = $deletionMarker;

        return $this;
    }

    /**
     * Gets outboundRate
     * @return float
     */
    public function getOutboundRate()
    {
        return $this->container['outboundRate'];
    }

    /**
     * Sets outboundRate
     * @param float $outboundRate The outbound extended rate.
     * @return $this
     */
    public function setOutboundRate($outboundRate)
    {
        $this->container['outboundRate'] = $outboundRate;

        return $this;
    }

    /**
     * Gets outboundDurationMinimumSeconds
     * @return int
     */
    public function getOutboundDurationMinimumSeconds()
    {
        return $this->container['outboundDurationMinimumSeconds'];
    }

    /**
     * Sets outboundDurationMinimumSeconds
     * @param int $outboundDurationMinimumSeconds The minimum duration charged in seconds.
     * @return $this
     */
    public function setOutboundDurationMinimumSeconds($outboundDurationMinimumSeconds)
    {
        $this->container['outboundDurationMinimumSeconds'] = $outboundDurationMinimumSeconds;

        return $this;
    }

    /**
     * Gets outboundDurationIncrementSeconds
     * @return int
     */
    public function getOutboundDurationIncrementSeconds()
    {
        return $this->container['outboundDurationIncrementSeconds'];
    }

    /**
     * Sets outboundDurationIncrementSeconds
     * @param int $outboundDurationIncrementSeconds The billing duration increment in seconds.
     * @return $this
     */
    public function setOutboundDurationIncrementSeconds($outboundDurationIncrementSeconds)
    {
        $this->container['outboundDurationIncrementSeconds'] = $outboundDurationIncrementSeconds;

        return $this;
    }

    /**
     * Gets inboundTolledRate
     * @return float
     */
    public function getInboundTolledRate()
    {
        return $this->container['inboundTolledRate'];
    }

    /**
     * Sets inboundTolledRate
     * @param float $inboundTolledRate The inbound tolled rate.
     * @return $this
     */
    public function setInboundTolledRate($inboundTolledRate)
    {
        $this->container['inboundTolledRate'] = $inboundTolledRate;

        return $this;
    }

    /**
     * Gets inboundTolledDurationMinimumSeconds
     * @return int
     */
    public function getInboundTolledDurationMinimumSeconds()
    {
        return $this->container['inboundTolledDurationMinimumSeconds'];
    }

    /**
     * Sets inboundTolledDurationMinimumSeconds
     * @param int $inboundTolledDurationMinimumSeconds The minimum duration charged in seconds.
     * @return $this
     */
    public function setInboundTolledDurationMinimumSeconds($inboundTolledDurationMinimumSeconds)
    {
        $this->container['inboundTolledDurationMinimumSeconds'] = $inboundTolledDurationMinimumSeconds;

        return $this;
    }

    /**
     * Gets inboundTolledDurationIncrementSeconds
     * @return int
     */
    public function getInboundTolledDurationIncrementSeconds()
    {
        return $this->container['inboundTolledDurationIncrementSeconds'];
    }

    /**
     * Sets inboundTolledDurationIncrementSeconds
     * @param int $inboundTolledDurationIncrementSeconds The billing duration increment in seconds.
     * @return $this
     */
    public function setInboundTolledDurationIncrementSeconds($inboundTolledDurationIncrementSeconds)
    {
        $this->container['inboundTolledDurationIncrementSeconds'] = $inboundTolledDurationIncrementSeconds;

        return $this;
    }

    /**
     * Gets inboundTollFreeRate
     * @return float
     */
    public function getInboundTollFreeRate()
    {
        return $this->container['inboundTollFreeRate'];
    }

    /**
     * Sets inboundTollFreeRate
     * @param float $inboundTollFreeRate The inbound toll-free rate.
     * @return $this
     */
    public function setInboundTollFreeRate($inboundTollFreeRate)
    {
        $this->container['inboundTollFreeRate'] = $inboundTollFreeRate;

        return $this;
    }

    /**
     * Gets inboundTollFreeDurationMinimumSeconds
     * @return int
     */
    public function getInboundTollFreeDurationMinimumSeconds()
    {
        return $this->container['inboundTollFreeDurationMinimumSeconds'];
    }

    /**
     * Sets inboundTollFreeDurationMinimumSeconds
     * @param int $inboundTollFreeDurationMinimumSeconds The minimum duration charged in seconds.
     * @return $this
     */
    public function setInboundTollFreeDurationMinimumSeconds($inboundTollFreeDurationMinimumSeconds)
    {
        $this->container['inboundTollFreeDurationMinimumSeconds'] = $inboundTollFreeDurationMinimumSeconds;

        return $this;
    }

    /**
     * Gets inboundTollFreeDurationIncrementSeconds
     * @return int
     */
    public function getInboundTollFreeDurationIncrementSeconds()
    {
        return $this->container['inboundTollFreeDurationIncrementSeconds'];
    }

    /**
     * Sets inboundTollFreeDurationIncrementSeconds
     * @param int $inboundTollFreeDurationIncrementSeconds The billing duration increment in seconds.
     * @return $this
     */
    public function setInboundTollFreeDurationIncrementSeconds($inboundTollFreeDurationIncrementSeconds)
    {
        $this->container['inboundTollFreeDurationIncrementSeconds'] = $inboundTollFreeDurationIncrementSeconds;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


