<?php
/**
 * WorkItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * WorkItem Class Doc Comment
 *
 * @category    Class */
 // @description Information about the work item associated with a history item.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WorkItem implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WorkItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'workItemExecId' => 'string',
        'workItemConfigId' => 'string',
        'workItemName' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'workItemExecId' => 'workItemExecId',
        'workItemConfigId' => 'workItemConfigId',
        'workItemName' => 'workItemName'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'workItemExecId' => 'setWorkItemExecId',
        'workItemConfigId' => 'setWorkItemConfigId',
        'workItemName' => 'setWorkItemName'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'workItemExecId' => 'getWorkItemExecId',
        'workItemConfigId' => 'getWorkItemConfigId',
        'workItemName' => 'getWorkItemName'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['workItemExecId'] = isset($data['workItemExecId']) ? $data['workItemExecId'] : null;
        $this->container['workItemConfigId'] = isset($data['workItemConfigId']) ? $data['workItemConfigId'] : null;
        $this->container['workItemName'] = isset($data['workItemName']) ? $data['workItemName'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['workItemExecId'] === null) {
            $invalid_properties[] = "'workItemExecId' can't be null";
        }
        if ($this->container['workItemConfigId'] === null) {
            $invalid_properties[] = "'workItemConfigId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['workItemExecId'] === null) {
            return false;
        }
        if ($this->container['workItemConfigId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets workItemExecId
     * @return string
     */
    public function getWorkItemExecId()
    {
        return $this->container['workItemExecId'];
    }

    /**
     * Sets workItemExecId
     * @param string $workItemExecId The work item execution id.
     * @return $this
     */
    public function setWorkItemExecId($workItemExecId)
    {
        $this->container['workItemExecId'] = $workItemExecId;

        return $this;
    }

    /**
     * Gets workItemConfigId
     * @return string
     */
    public function getWorkItemConfigId()
    {
        return $this->container['workItemConfigId'];
    }

    /**
     * Sets workItemConfigId
     * @param string $workItemConfigId The work item definition id.
     * @return $this
     */
    public function setWorkItemConfigId($workItemConfigId)
    {
        $this->container['workItemConfigId'] = $workItemConfigId;

        return $this;
    }

    /**
     * Gets workItemName
     * @return string
     */
    public function getWorkItemName()
    {
        return $this->container['workItemName'];
    }

    /**
     * Sets workItemName
     * @param string $workItemName The work item displayable name.
     * @return $this
     */
    public function setWorkItemName($workItemName)
    {
        $this->container['workItemName'] = $workItemName;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


