# PureCloudSDK\AttributesApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttributesAttributeId**](AttributesApi.md#deleteAttributesAttributeId) | **DELETE** /api/v2/attributes/{attributeId} | Delete an existing Attribute.
[**getAttributes**](AttributesApi.md#getAttributes) | **GET** /api/v2/attributes | Gets a list of existing attributes.
[**getAttributesAttributeId**](AttributesApi.md#getAttributesAttributeId) | **GET** /api/v2/attributes/{attributeId} | Get details about an existing attribute.
[**postAttributes**](AttributesApi.md#postAttributes) | **POST** /api/v2/attributes | Create an attribute.
[**postAttributesQuery**](AttributesApi.md#postAttributesQuery) | **POST** /api/v2/attributes/query | Query attributes
[**putAttributesAttributeId**](AttributesApi.md#putAttributesAttributeId) | **PUT** /api/v2/attributes/{attributeId} | Update an existing attribute.


# **deleteAttributesAttributeId**
> deleteAttributesAttributeId($attributeId)

Delete an existing Attribute.

This will remove attribute.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID

try {
    $api_instance->deleteAttributesAttributeId($attributeId);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->deleteAttributesAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributes**
> \PureCloudSDK\AttributeEntityListing getAttributes($pageNumber, $pageSize)

Gets a list of existing attributes.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getAttributes($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributesAttributeId**
> \PureCloudSDK\Attribute getAttributesAttributeId($attributeId)

Get details about an existing attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID

try {
    $result = $api_instance->getAttributesAttributeId($attributeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributesAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAttributes**
> \PureCloudSDK\Attribute postAttributes($body)

Create an attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->postAttributes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAttributesQuery**
> \PureCloudSDK\AttributeEntityListing postAttributesQuery($body)

Query attributes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\AttributeQueryRequest(); // \PureCloudSDK\AttributeQueryRequest | query

try {
    $result = $api_instance->postAttributesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postAttributesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AttributeQueryRequest**](../Model/\PureCloudSDK\AttributeQueryRequest.md)| query |

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAttributesAttributeId**
> \PureCloudSDK\Attribute putAttributesAttributeId($attributeId, $body)

Update an existing attribute.

Fields that can be updated: name, description. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->putAttributesAttributeId($attributeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->putAttributesAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

