# PureCloudSDK\ContentManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContentmanagementDocumentsDocumentId**](ContentManagementApi.md#deleteContentmanagementDocumentsDocumentId) | **DELETE** /api/v2/contentmanagement/documents/{documentId} | Delete a document.
[**deleteContentmanagementSharesShareId**](ContentManagementApi.md#deleteContentmanagementSharesShareId) | **DELETE** /api/v2/contentmanagement/shares/{shareId} | Deletes an existing share.
[**deleteContentmanagementStatusStatusId**](ContentManagementApi.md#deleteContentmanagementStatusStatusId) | **DELETE** /api/v2/contentmanagement/status/{statusId} | Cancel the command for this status
[**deleteContentmanagementWorkspacesWorkspaceId**](ContentManagementApi.md#deleteContentmanagementWorkspacesWorkspaceId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId} | Delete a workspace
[**deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Delete a member from a workspace
[**deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Delete workspace tag
[**getContentmanagementDocuments**](ContentManagementApi.md#getContentmanagementDocuments) | **GET** /api/v2/contentmanagement/documents | Get a list of documents.
[**getContentmanagementDocumentsDocumentId**](ContentManagementApi.md#getContentmanagementDocumentsDocumentId) | **GET** /api/v2/contentmanagement/documents/{documentId} | Get a document.
[**getContentmanagementDocumentsDocumentIdAudits**](ContentManagementApi.md#getContentmanagementDocumentsDocumentIdAudits) | **GET** /api/v2/contentmanagement/documents/{documentId}/audits | Get a list of audits for a document.
[**getContentmanagementDocumentsDocumentIdContent**](ContentManagementApi.md#getContentmanagementDocumentsDocumentIdContent) | **GET** /api/v2/contentmanagement/documents/{documentId}/content | Download a document.
[**getContentmanagementQuery**](ContentManagementApi.md#getContentmanagementQuery) | **GET** /api/v2/contentmanagement/query | Query content
[**getContentmanagementSecurityprofiles**](ContentManagementApi.md#getContentmanagementSecurityprofiles) | **GET** /api/v2/contentmanagement/securityprofiles | Get a List of Security Profiles
[**getContentmanagementSecurityprofilesSecurityprofileId**](ContentManagementApi.md#getContentmanagementSecurityprofilesSecurityprofileId) | **GET** /api/v2/contentmanagement/securityprofiles/{securityProfileId} | Get a Security Profile
[**getContentmanagementSharedSharedId**](ContentManagementApi.md#getContentmanagementSharedSharedId) | **GET** /api/v2/contentmanagement/shared/{sharedId} | Get shared documents. Securely download a shared document.
[**getContentmanagementShares**](ContentManagementApi.md#getContentmanagementShares) | **GET** /api/v2/contentmanagement/shares | Gets a list of shares.  You must specify at least one filter (e.g. entityId).
[**getContentmanagementSharesShareId**](ContentManagementApi.md#getContentmanagementSharesShareId) | **GET** /api/v2/contentmanagement/shares/{shareId} | Retrieve details about an existing share.
[**getContentmanagementStatus**](ContentManagementApi.md#getContentmanagementStatus) | **GET** /api/v2/contentmanagement/status | Get a list of statuses for pending operations
[**getContentmanagementStatusStatusId**](ContentManagementApi.md#getContentmanagementStatusStatusId) | **GET** /api/v2/contentmanagement/status/{statusId} | Get a status.
[**getContentmanagementUsage**](ContentManagementApi.md#getContentmanagementUsage) | **GET** /api/v2/contentmanagement/usage | Get usage details.
[**getContentmanagementWorkspaces**](ContentManagementApi.md#getContentmanagementWorkspaces) | **GET** /api/v2/contentmanagement/workspaces | Get a list of workspaces.
[**getContentmanagementWorkspacesWorkspaceId**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId} | Get a workspace.
[**getContentmanagementWorkspacesWorkspaceIdDocuments**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceIdDocuments) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/documents | Get a list of documents.
[**getContentmanagementWorkspacesWorkspaceIdMembers**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceIdMembers) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members | Get a list workspace members
[**getContentmanagementWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceIdMembersMemberId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Get a workspace member
[**getContentmanagementWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceIdTagvalues) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Get a list of workspace tags
[**getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Get a workspace tag
[**postContentmanagementAuditquery**](ContentManagementApi.md#postContentmanagementAuditquery) | **POST** /api/v2/contentmanagement/auditquery | Query audits
[**postContentmanagementDocuments**](ContentManagementApi.md#postContentmanagementDocuments) | **POST** /api/v2/contentmanagement/documents | Add a document.
[**postContentmanagementDocumentsDocumentId**](ContentManagementApi.md#postContentmanagementDocumentsDocumentId) | **POST** /api/v2/contentmanagement/documents/{documentId} | Update a document.
[**postContentmanagementDocumentsDocumentIdContent**](ContentManagementApi.md#postContentmanagementDocumentsDocumentIdContent) | **POST** /api/v2/contentmanagement/documents/{documentId}/content | Replace the contents of a document.
[**postContentmanagementQuery**](ContentManagementApi.md#postContentmanagementQuery) | **POST** /api/v2/contentmanagement/query | Query content
[**postContentmanagementShares**](ContentManagementApi.md#postContentmanagementShares) | **POST** /api/v2/contentmanagement/shares | Creates a new share or updates an existing share if the entity has already been shared
[**postContentmanagementWorkspaces**](ContentManagementApi.md#postContentmanagementWorkspaces) | **POST** /api/v2/contentmanagement/workspaces | Create a group workspace
[**postContentmanagementWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#postContentmanagementWorkspacesWorkspaceIdTagvalues) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Create a workspace tag
[**postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery**](ContentManagementApi.md#postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query | Perform a prefix query on tags in the workspace
[**putContentmanagementWorkspacesWorkspaceId**](ContentManagementApi.md#putContentmanagementWorkspacesWorkspaceId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId} | Update a workspace
[**putContentmanagementWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#putContentmanagementWorkspacesWorkspaceIdMembersMemberId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Add a member to a workspace
[**putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Update a workspace tag. Will update all documents with the new tag value.


# **deleteContentmanagementDocumentsDocumentId**
> deleteContentmanagementDocumentsDocumentId($documentId, $override)

Delete a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$override = true; // bool | Override any lock on the document

try {
    $api_instance->deleteContentmanagementDocumentsDocumentId($documentId, $override);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContentmanagementSharesShareId**
> deleteContentmanagementSharesShareId($shareId)

Deletes an existing share.

This revokes sharing rights specified in the share record

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$shareId = "shareId_example"; // string | Share ID

try {
    $api_instance->deleteContentmanagementSharesShareId($shareId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shareId** | **string**| Share ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContentmanagementStatusStatusId**
> deleteContentmanagementStatusStatusId($statusId)

Cancel the command for this status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$statusId = "statusId_example"; // string | Status ID

try {
    $api_instance->deleteContentmanagementStatusStatusId($statusId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Status ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContentmanagementWorkspacesWorkspaceId**
> deleteContentmanagementWorkspacesWorkspaceId($workspaceId, $moveChildrenToWorkspaceId)

Delete a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$moveChildrenToWorkspaceId = "moveChildrenToWorkspaceId_example"; // string | New location for objects in deleted workspace.

try {
    $api_instance->deleteContentmanagementWorkspacesWorkspaceId($workspaceId, $moveChildrenToWorkspaceId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **moveChildrenToWorkspaceId** | **string**| New location for objects in deleted workspace. | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId**
> deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId)

Delete a member from a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID

try {
    $api_instance->deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**
> deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId)

Delete workspace tag

Delete a tag from a workspace. Will remove this tag from all documents.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID

try {
    $api_instance->deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteContentmanagementWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementDocuments**
> \PureCloudSDK\DocumentEntityListing getContentmanagementDocuments($workspaceId, $name, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder)

Get a list of documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$name = "name_example"; // string | Name
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "sortBy_example"; // string | name or dateCreated
$sortOrder = "ascending"; // string | ascending or descending

try {
    $result = $api_instance->getContentmanagementDocuments($workspaceId, $name, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **name** | **string**| Name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| name or dateCreated | [optional]
 **sortOrder** | **string**| ascending or descending | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentEntityListing**](../Model/DocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementDocumentsDocumentId**
> \PureCloudSDK\Document getContentmanagementDocumentsDocumentId($documentId, $expand)

Get a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementDocumentsDocumentId($documentId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementDocumentsDocumentIdAudits**
> \PureCloudSDK\DocumentAuditEntityListing getContentmanagementDocumentsDocumentIdAudits($documentId, $pageSize, $pageNumber, $transactionFilter, $level, $sortBy, $sortOrder)

Get a list of audits for a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$transactionFilter = "transactionFilter_example"; // string | Transaction filter
$level = "USER"; // string | level
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "ascending"; // string | Sort order

try {
    $result = $api_instance->getContentmanagementDocumentsDocumentIdAudits($documentId, $pageSize, $pageNumber, $transactionFilter, $level, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementDocumentsDocumentIdAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **transactionFilter** | **string**| Transaction filter | [optional]
 **level** | **string**| level | [optional] [default to USER]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentAuditEntityListing**](../Model/DocumentAuditEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementDocumentsDocumentIdContent**
> \PureCloudSDK\DownloadResponse getContentmanagementDocumentsDocumentIdContent($documentId, $disposition, $contentType)

Download a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$disposition = "disposition_example"; // string | Request how the content will be downloaded: a file attachment or inline. Default is attachment.
$contentType = "contentType_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav

try {
    $result = $api_instance->getContentmanagementDocumentsDocumentIdContent($documentId, $disposition, $contentType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **disposition** | **string**| Request how the content will be downloaded: a file attachment or inline. Default is attachment. | [optional]
 **contentType** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementQuery**
> \PureCloudSDK\QueryResults getContentmanagementQuery($queryPhrase, $pageSize, $pageNumber, $sortBy, $sortOrder, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$queryPhrase = "queryPhrase_example"; // string | Phrase tokens are ANDed together over all searchable fields
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | name or dateCreated
$sortOrder = "ascending"; // string | ascending or descending
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementQuery($queryPhrase, $pageSize, $pageNumber, $sortBy, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queryPhrase** | **string**| Phrase tokens are ANDed together over all searchable fields |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| name or dateCreated | [optional] [default to name]
 **sortOrder** | **string**| ascending or descending | [optional] [default to ascending]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementSecurityprofiles**
> \PureCloudSDK\SecurityProfileEntityListing getContentmanagementSecurityprofiles()

Get a List of Security Profiles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getContentmanagementSecurityprofiles();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementSecurityprofiles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SecurityProfileEntityListing**](../Model/SecurityProfileEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementSecurityprofilesSecurityprofileId**
> \PureCloudSDK\SecurityProfile getContentmanagementSecurityprofilesSecurityprofileId($securityProfileId)

Get a Security Profile



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$securityProfileId = "securityProfileId_example"; // string | Security Profile Id

try {
    $result = $api_instance->getContentmanagementSecurityprofilesSecurityprofileId($securityProfileId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementSecurityprofilesSecurityprofileId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **securityProfileId** | **string**| Security Profile Id |

### Return type

[**\PureCloudSDK\SecurityProfile**](../Model/SecurityProfile.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementSharedSharedId**
> getContentmanagementSharedSharedId($sharedId, $redirect, $disposition, $contentType, $expand)

Get shared documents. Securely download a shared document.

This method requires the download sharing URI obtained in the get document response (downloadSharingUri). Documents may be shared between users in the same workspace. Documents may also be shared between any user by creating a content management share.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$sharedId = "sharedId_example"; // string | Shared ID
$redirect = true; // bool | Turn on or off redirect
$disposition = "attachment"; // string | Request how the share content will be downloaded: attached as a file or inline. Default is attachment.
$contentType = "contentType_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
$expand = "expand_example"; // string | Expand some document fields

try {
    $api_instance->getContentmanagementSharedSharedId($sharedId, $redirect, $disposition, $contentType, $expand);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementSharedSharedId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sharedId** | **string**| Shared ID |
 **redirect** | **bool**| Turn on or off redirect | [optional] [default to true]
 **disposition** | **string**| Request how the share content will be downloaded: attached as a file or inline. Default is attachment. | [optional] [default to attachment]
 **contentType** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]
 **expand** | **string**| Expand some document fields | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementShares**
> \PureCloudSDK\ShareEntityListing getContentmanagementShares($entityId, $expand, $pageSize, $pageNumber)

Gets a list of shares.  You must specify at least one filter (e.g. entityId).

Failing to specify a filter will return 400.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$entityId = "entityId_example"; // string | Filters the shares returned to only the entity specified by the value of this parameter.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getContentmanagementShares($entityId, $expand, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **entityId** | **string**| Filters the shares returned to only the entity specified by the value of this parameter. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ShareEntityListing**](../Model/ShareEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementSharesShareId**
> \PureCloudSDK\Share getContentmanagementSharesShareId($shareId, $expand)

Retrieve details about an existing share.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$shareId = "shareId_example"; // string | Share ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementSharesShareId($shareId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shareId** | **string**| Share ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Share**](../Model/Share.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementStatus**
> \PureCloudSDK\CommandStatusEntityListing getContentmanagementStatus($pageSize, $pageNumber)

Get a list of statuses for pending operations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getContentmanagementStatus($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementStatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\CommandStatusEntityListing**](../Model/CommandStatusEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementStatusStatusId**
> \PureCloudSDK\CommandStatus getContentmanagementStatusStatusId($statusId)

Get a status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$statusId = "statusId_example"; // string | Status ID

try {
    $result = $api_instance->getContentmanagementStatusStatusId($statusId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Status ID |

### Return type

[**\PureCloudSDK\CommandStatus**](../Model/CommandStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementUsage**
> \PureCloudSDK\Usage getContentmanagementUsage()

Get usage details.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getContentmanagementUsage();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Usage**](../Model/Usage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspaces**
> \PureCloudSDK\WorkspaceEntityListing getContentmanagementWorkspaces($pageSize, $pageNumber, $access, $expand)

Get a list of workspaces.

Specifying 'content' access will return all workspaces the user has document access to, while 'admin' access will return all group workspaces the user has administrative rights to.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$access = array("access_example"); // string[] | Requested access level.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspaces($pageSize, $pageNumber, $access, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **access** | [**string[]**](../Model/string.md)| Requested access level. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceEntityListing**](../Model/WorkspaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace getContentmanagementWorkspacesWorkspaceId($workspaceId, $expand)

Get a workspace.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceId($workspaceId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceIdDocuments**
> \PureCloudSDK\DocumentEntityListing getContentmanagementWorkspacesWorkspaceIdDocuments($workspaceId, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder)

Get a list of documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "sortBy_example"; // string | name or dateCreated
$sortOrder = "ascending"; // string | ascending or descending

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceIdDocuments($workspaceId, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceIdDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| name or dateCreated | [optional]
 **sortOrder** | **string**| ascending or descending | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentEntityListing**](../Model/DocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceIdMembers**
> \PureCloudSDK\WorkspaceMemberEntityListing getContentmanagementWorkspacesWorkspaceIdMembers($workspaceId, $pageSize, $pageNumber, $expand)

Get a list workspace members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceIdMembers($workspaceId, $pageSize, $pageNumber, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMemberEntityListing**](../Model/WorkspaceMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember getContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $expand)

Get a workspace member



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValueEntityListing getContentmanagementWorkspacesWorkspaceIdTagvalues($workspaceId, $value, $pageSize, $pageNumber, $expand)

Get a list of workspace tags



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$value = "value_example"; // string | filter the list of tags returned
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceIdTagvalues($workspaceId, $value, $pageSize, $pageNumber, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **value** | **string**| filter the list of tags returned | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $expand)

Get a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getContentmanagementWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementAuditquery**
> \PureCloudSDK\QueryResults postContentmanagementAuditquery($body)

Query audits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\ContentQueryRequest(); // \PureCloudSDK\ContentQueryRequest | Allows for a filtered query returning facet information

try {
    $result = $api_instance->postContentmanagementAuditquery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementAuditquery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ContentQueryRequest**](../Model/\PureCloudSDK\ContentQueryRequest.md)| Allows for a filtered query returning facet information |

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementDocuments**
> \PureCloudSDK\Document postContentmanagementDocuments($body, $copySource, $moveSource, $override)

Add a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\DocumentUpload(); // \PureCloudSDK\DocumentUpload | Document
$copySource = "copySource_example"; // string | Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source.
$moveSource = "moveSource_example"; // string | Move a document to a new workspace. Provide a document ID as the move source.
$override = true; // bool | Override any lock on the source document

try {
    $result = $api_instance->postContentmanagementDocuments($body, $copySource, $moveSource, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DocumentUpload**](../Model/\PureCloudSDK\DocumentUpload.md)| Document |
 **copySource** | **string**| Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source. | [optional]
 **moveSource** | **string**| Move a document to a new workspace. Provide a document ID as the move source. | [optional]
 **override** | **bool**| Override any lock on the source document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementDocumentsDocumentId**
> \PureCloudSDK\Document postContentmanagementDocumentsDocumentId($documentId, $body, $expand, $override)

Update a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\DocumentUpdate(); // \PureCloudSDK\DocumentUpdate | Document
$expand = "expand_example"; // string | Expand some document fields
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postContentmanagementDocumentsDocumentId($documentId, $body, $expand, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\DocumentUpdate**](../Model/\PureCloudSDK\DocumentUpdate.md)| Document |
 **expand** | **string**| Expand some document fields | [optional]
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementDocumentsDocumentIdContent**
> \PureCloudSDK\ReplaceResponse postContentmanagementDocumentsDocumentIdContent($documentId, $body, $override)

Replace the contents of a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\ReplaceRequest(); // \PureCloudSDK\ReplaceRequest | Replace Request
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postContentmanagementDocumentsDocumentIdContent($documentId, $body, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\ReplaceRequest**](../Model/\PureCloudSDK\ReplaceRequest.md)| Replace Request |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\ReplaceResponse**](../Model/ReplaceResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementQuery**
> \PureCloudSDK\QueryResults postContentmanagementQuery($body, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\QueryRequest(); // \PureCloudSDK\QueryRequest | Allows for a filtered query returning facet information
$expand = "expand_example"; // string | Expand some document fields

try {
    $result = $api_instance->postContentmanagementQuery($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\QueryRequest**](../Model/\PureCloudSDK\QueryRequest.md)| Allows for a filtered query returning facet information |
 **expand** | **string**| Expand some document fields | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementShares**
> \PureCloudSDK\CreateShareResponse postContentmanagementShares($body)

Creates a new share or updates an existing share if the entity has already been shared



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\CreateShareRequest(); // \PureCloudSDK\CreateShareRequest | CreateShareRequest - entity id and type and a single member or list of members are required

try {
    $result = $api_instance->postContentmanagementShares($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateShareRequest**](../Model/\PureCloudSDK\CreateShareRequest.md)| CreateShareRequest - entity id and type and a single member or list of members are required |

### Return type

[**\PureCloudSDK\CreateShareResponse**](../Model/CreateShareResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementWorkspaces**
> \PureCloudSDK\Workspace postContentmanagementWorkspaces($body)

Create a group workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\WorkspaceCreate(); // \PureCloudSDK\WorkspaceCreate | Workspace

try {
    $result = $api_instance->postContentmanagementWorkspaces($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WorkspaceCreate**](../Model/\PureCloudSDK\WorkspaceCreate.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValue postContentmanagementWorkspacesWorkspaceIdTagvalues($workspaceId, $body)

Create a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | tag

try {
    $result = $api_instance->postContentmanagementWorkspacesWorkspaceIdTagvalues($workspaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| tag |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery**
> \PureCloudSDK\TagValueEntityListing postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery($workspaceId, $body, $expand)

Perform a prefix query on tags in the workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagQueryRequest(); // \PureCloudSDK\TagQueryRequest | query
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery($workspaceId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postContentmanagementWorkspacesWorkspaceIdTagvaluesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagQueryRequest**](../Model/\PureCloudSDK\TagQueryRequest.md)| query |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putContentmanagementWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace putContentmanagementWorkspacesWorkspaceId($workspaceId, $body)

Update a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\Workspace(); // \PureCloudSDK\Workspace | Workspace

try {
    $result = $api_instance->putContentmanagementWorkspacesWorkspaceId($workspaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putContentmanagementWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\Workspace**](../Model/\PureCloudSDK\Workspace.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putContentmanagementWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember putContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $body)

Add a member to a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID
$body = new \PureCloudSDK\WorkspaceMember(); // \PureCloudSDK\WorkspaceMember | Workspace Member

try {
    $result = $api_instance->putContentmanagementWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putContentmanagementWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |
 **body** | [**\PureCloudSDK\WorkspaceMember**](../Model/\PureCloudSDK\WorkspaceMember.md)| Workspace Member |

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $body)

Update a workspace tag. Will update all documents with the new tag value.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | Workspace

try {
    $result = $api_instance->putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putContentmanagementWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| Workspace |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

