# PureCloudSDK\GeolocationApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getGeolocationsSettings**](GeolocationApi.md#getGeolocationsSettings) | **GET** /api/v2/geolocations/settings | Get a organization&#39;s GeolocationSettings
[**getUsersUserIdGeolocationsClientId**](GeolocationApi.md#getUsersUserIdGeolocationsClientId) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
[**patchGeolocationsSettings**](GeolocationApi.md#patchGeolocationsSettings) | **PATCH** /api/v2/geolocations/settings | Patch a organization&#39;s GeolocationSettings
[**patchUsersUserIdGeolocationsClientId**](GeolocationApi.md#patchUsersUserIdGeolocationsClientId) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation


# **getGeolocationsSettings**
> \PureCloudSDK\GeolocationSettings getGeolocationsSettings()

Get a organization's GeolocationSettings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GeolocationApi();

try {
    $result = $api_instance->getGeolocationsSettings();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GeolocationApi->getGeolocationsSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\GeolocationSettings**](../Model/GeolocationSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation getUsersUserIdGeolocationsClientId($userId, $clientId)

Get a user's Geolocation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GeolocationApi();
$userId = "userId_example"; // string | user Id
$clientId = "clientId_example"; // string | client Id

try {
    $result = $api_instance->getUsersUserIdGeolocationsClientId($userId, $clientId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GeolocationApi->getUsersUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **clientId** | **string**| client Id |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchGeolocationsSettings**
> \PureCloudSDK\GeolocationSettings patchGeolocationsSettings($body)

Patch a organization's GeolocationSettings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GeolocationApi();
$body = new \PureCloudSDK\GeolocationSettings(); // \PureCloudSDK\GeolocationSettings | Geolocation settings

try {
    $result = $api_instance->patchGeolocationsSettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GeolocationApi->patchGeolocationsSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GeolocationSettings**](../Model/\PureCloudSDK\GeolocationSettings.md)| Geolocation settings |

### Return type

[**\PureCloudSDK\GeolocationSettings**](../Model/GeolocationSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation patchUsersUserIdGeolocationsClientId($userId, $clientId, $body)

Patch a user's Geolocation

The geolocation object can be patched one of three ways. Option 1: Set the 'primary' property to true. This will set the client as the user's primary geolocation source.  Option 2: Provide the 'latitude' and 'longitude' values.  This will enqueue an asynchronous update of the 'city', 'region', and 'country', generating a notification. A subsequent GET operation will include the new values for 'city', 'region' and 'country'.  Option 3:  Provide the 'city', 'region', 'country' values.  Option 1 can be combined with Option 2 or Option 3.  For example, update the client as primary and provide latitude and longitude values.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GeolocationApi();
$userId = "userId_example"; // string | user Id
$clientId = "clientId_example"; // string | client Id
$body = new \PureCloudSDK\Geolocation(); // \PureCloudSDK\Geolocation | Geolocation

try {
    $result = $api_instance->patchUsersUserIdGeolocationsClientId($userId, $clientId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GeolocationApi->patchUsersUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **clientId** | **string**| client Id |
 **body** | [**\PureCloudSDK\Geolocation**](../Model/\PureCloudSDK\Geolocation.md)| Geolocation |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

