# PureCloudSDK\GreetingsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteGreetingsGreetingId**](GreetingsApi.md#deleteGreetingsGreetingId) | **DELETE** /api/v2/greetings/{greetingId} | Deletes a Greeting with the given GreetingId
[**getGreetings**](GreetingsApi.md#getGreetings) | **GET** /api/v2/greetings | Gets an Organization&#39;s Greetings
[**getGreetingsDefaults**](GreetingsApi.md#getGreetingsDefaults) | **GET** /api/v2/greetings/defaults | Get an Organization&#39;s DefaultGreetingList
[**getGreetingsGreetingId**](GreetingsApi.md#getGreetingsGreetingId) | **GET** /api/v2/greetings/{greetingId} | Get a Greeting with the given GreetingId
[**getGreetingsGreetingIdMedia**](GreetingsApi.md#getGreetingsGreetingIdMedia) | **GET** /api/v2/greetings/{greetingId}/media | Get media playback URI for this greeting
[**getUsersUserIdGreetings**](GreetingsApi.md#getUsersUserIdGreetings) | **GET** /api/v2/users/{userId}/greetings | Get a list of the User&#39;s Greetings
[**getUsersUserIdGreetingsDefaults**](GreetingsApi.md#getUsersUserIdGreetingsDefaults) | **GET** /api/v2/users/{userId}/greetings/defaults | Grabs the list of Default Greetings given a User&#39;s ID
[**postGreetings**](GreetingsApi.md#postGreetings) | **POST** /api/v2/greetings | Create a Greeting for an Organization
[**postUsersUserIdGreetings**](GreetingsApi.md#postUsersUserIdGreetings) | **POST** /api/v2/users/{userId}/greetings | Creates a Greeting for a User
[**putGreetingsDefaults**](GreetingsApi.md#putGreetingsDefaults) | **PUT** /api/v2/greetings/defaults | Update an Organization&#39;s DefaultGreetingList
[**putGreetingsGreetingId**](GreetingsApi.md#putGreetingsGreetingId) | **PUT** /api/v2/greetings/{greetingId} | Updates the Greeting with the given GreetingId
[**putUsersUserIdGreetingsDefaults**](GreetingsApi.md#putUsersUserIdGreetingsDefaults) | **PUT** /api/v2/users/{userId}/greetings/defaults | Updates the DefaultGreetingList of the specified User


# **deleteGreetingsGreetingId**
> \PureCloudSDK\Greeting deleteGreetingsGreetingId($greetingId)

Deletes a Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greetingId = "greetingId_example"; // string | Greeting ID

try {
    $result = $api_instance->deleteGreetingsGreetingId($greetingId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->deleteGreetingsGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greetingId** | **string**| Greeting ID |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetings**
> \PureCloudSDK\DomainEntityListing getGreetings($pageSize, $pageNumber)

Gets an Organization's Greetings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getGreetings($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\DomainEntityListing**](../Model/DomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList getGreetingsDefaults()

Get an Organization's DefaultGreetingList



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();

try {
    $result = $api_instance->getGreetingsDefaults();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetingsGreetingId**
> \PureCloudSDK\Greeting getGreetingsGreetingId($greetingId)

Get a Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greetingId = "greetingId_example"; // string | Greeting ID

try {
    $result = $api_instance->getGreetingsGreetingId($greetingId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetingsGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greetingId** | **string**| Greeting ID |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetingsGreetingIdMedia**
> \PureCloudSDK\GreetingMediaInfo getGreetingsGreetingIdMedia($greetingId, $formatId)

Get media playback URI for this greeting



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greetingId = "greetingId_example"; // string | Greeting ID
$formatId = "WAV"; // string | The desired media format.

try {
    $result = $api_instance->getGreetingsGreetingIdMedia($greetingId, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetingsGreetingIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greetingId** | **string**| Greeting ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WAV]

### Return type

[**\PureCloudSDK\GreetingMediaInfo**](../Model/GreetingMediaInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdGreetings**
> \PureCloudSDK\DomainEntityListing getUsersUserIdGreetings($userId, $pageSize, $pageNumber)

Get a list of the User's Greetings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$userId = "userId_example"; // string | User ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getUsersUserIdGreetings($userId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getUsersUserIdGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\DomainEntityListing**](../Model/DomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList getUsersUserIdGreetingsDefaults($userId)

Grabs the list of Default Greetings given a User's ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdGreetingsDefaults($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getUsersUserIdGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGreetings**
> \PureCloudSDK\DefaultGreetingList postGreetings($body)

Create a Greeting for an Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The Greeting to create

try {
    $result = $api_instance->postGreetings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->postGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The Greeting to create |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersUserIdGreetings**
> \PureCloudSDK\Greeting postUsersUserIdGreetings($userId, $body)

Creates a Greeting for a User



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The Greeting to create

try {
    $result = $api_instance->postUsersUserIdGreetings($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->postUsersUserIdGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The Greeting to create |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList putGreetingsDefaults($body)

Update an Organization's DefaultGreetingList



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$body = new \PureCloudSDK\DefaultGreetingList(); // \PureCloudSDK\DefaultGreetingList | The updated defaultGreetingList

try {
    $result = $api_instance->putGreetingsDefaults($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DefaultGreetingList**](../Model/\PureCloudSDK\DefaultGreetingList.md)| The updated defaultGreetingList |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putGreetingsGreetingId**
> \PureCloudSDK\Greeting putGreetingsGreetingId($greetingId, $body)

Updates the Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greetingId = "greetingId_example"; // string | Greeting ID
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The updated Greeting

try {
    $result = $api_instance->putGreetingsGreetingId($greetingId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putGreetingsGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greetingId** | **string**| Greeting ID |
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The updated Greeting |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList putUsersUserIdGreetingsDefaults($userId, $body)

Updates the DefaultGreetingList of the specified User



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\DefaultGreetingList(); // \PureCloudSDK\DefaultGreetingList | The updated defaultGreetingList

try {
    $result = $api_instance->putUsersUserIdGreetingsDefaults($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putUsersUserIdGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\DefaultGreetingList**](../Model/\PureCloudSDK\DefaultGreetingList.md)| The updated defaultGreetingList |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

