# PureCloudSDK\IdentityProviderApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteIdentityprovidersAdfs**](IdentityProviderApi.md#deleteIdentityprovidersAdfs) | **DELETE** /api/v2/identityproviders/adfs | Delete ADFS Identity Provider
[**deleteIdentityprovidersCic**](IdentityProviderApi.md#deleteIdentityprovidersCic) | **DELETE** /api/v2/identityproviders/cic | Delete Customer Interaction Center (CIC) Identity Provider
[**deleteIdentityprovidersOkta**](IdentityProviderApi.md#deleteIdentityprovidersOkta) | **DELETE** /api/v2/identityproviders/okta | Delete Okta Identity Provider
[**deleteIdentityprovidersOnelogin**](IdentityProviderApi.md#deleteIdentityprovidersOnelogin) | **DELETE** /api/v2/identityproviders/onelogin | Delete OneLogin Identity Provider
[**deleteIdentityprovidersProviderId**](IdentityProviderApi.md#deleteIdentityprovidersProviderId) | **DELETE** /api/v2/identityproviders/{providerId} | Delete an identity provider
[**deleteIdentityprovidersPurecloud**](IdentityProviderApi.md#deleteIdentityprovidersPurecloud) | **DELETE** /api/v2/identityproviders/purecloud | Delete PureCloud Identity Provider
[**deleteIdentityprovidersSalesforce**](IdentityProviderApi.md#deleteIdentityprovidersSalesforce) | **DELETE** /api/v2/identityproviders/salesforce | Delete Salesforce Identity Provider
[**getIdentityproviders**](IdentityProviderApi.md#getIdentityproviders) | **GET** /api/v2/identityproviders | The list of identity providers
[**getIdentityprovidersAdfs**](IdentityProviderApi.md#getIdentityprovidersAdfs) | **GET** /api/v2/identityproviders/adfs | Get ADFS Identity Provider
[**getIdentityprovidersCic**](IdentityProviderApi.md#getIdentityprovidersCic) | **GET** /api/v2/identityproviders/cic | Get Customer Interaction Center (CIC) Identity Provider
[**getIdentityprovidersOkta**](IdentityProviderApi.md#getIdentityprovidersOkta) | **GET** /api/v2/identityproviders/okta | Get Okta Identity Provider
[**getIdentityprovidersOnelogin**](IdentityProviderApi.md#getIdentityprovidersOnelogin) | **GET** /api/v2/identityproviders/onelogin | Get OneLogin Identity Provider
[**getIdentityprovidersProviderId**](IdentityProviderApi.md#getIdentityprovidersProviderId) | **GET** /api/v2/identityproviders/{providerId} | Get an identity provider
[**getIdentityprovidersPurecloud**](IdentityProviderApi.md#getIdentityprovidersPurecloud) | **GET** /api/v2/identityproviders/purecloud | Get PureCloud Identity Provider
[**getIdentityprovidersSalesforce**](IdentityProviderApi.md#getIdentityprovidersSalesforce) | **GET** /api/v2/identityproviders/salesforce | Get Salesforce Identity Provider
[**putIdentityprovidersAdfs**](IdentityProviderApi.md#putIdentityprovidersAdfs) | **PUT** /api/v2/identityproviders/adfs | Update/Create ADFS Identity Provider
[**putIdentityprovidersCic**](IdentityProviderApi.md#putIdentityprovidersCic) | **PUT** /api/v2/identityproviders/cic | Update/Create Customer Interaction Center (CIC) Identity Provider
[**putIdentityprovidersOkta**](IdentityProviderApi.md#putIdentityprovidersOkta) | **PUT** /api/v2/identityproviders/okta | Update/Create Okta Identity Provider
[**putIdentityprovidersOnelogin**](IdentityProviderApi.md#putIdentityprovidersOnelogin) | **PUT** /api/v2/identityproviders/onelogin | Update/Create OneLogin Identity Provider
[**putIdentityprovidersProviderId**](IdentityProviderApi.md#putIdentityprovidersProviderId) | **PUT** /api/v2/identityproviders/{providerId} | Update an identity provider
[**putIdentityprovidersPurecloud**](IdentityProviderApi.md#putIdentityprovidersPurecloud) | **PUT** /api/v2/identityproviders/purecloud | Update/Create PureCloud Identity Provider
[**putIdentityprovidersSalesforce**](IdentityProviderApi.md#putIdentityprovidersSalesforce) | **PUT** /api/v2/identityproviders/salesforce | Update/Create Salesforce Identity Provider


# **deleteIdentityprovidersAdfs**
> deleteIdentityprovidersAdfs()

Delete ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersAdfs();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersCic**
> deleteIdentityprovidersCic()

Delete Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersCic();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersOkta**
> deleteIdentityprovidersOkta()

Delete Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersOkta();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersOnelogin**
> deleteIdentityprovidersOnelogin()

Delete OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersOnelogin();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersProviderId**
> deleteIdentityprovidersProviderId()

Delete an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersProviderId();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersPurecloud**
> deleteIdentityprovidersPurecloud()

Delete PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersPurecloud();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersSalesforce**
> deleteIdentityprovidersSalesforce()

Delete Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteIdentityprovidersSalesforce();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityproviders**
> \PureCloudSDK\OAuthProviderEntityListing getIdentityproviders()

The list of identity providers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityproviders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityproviders: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthProviderEntityListing**](../Model/OAuthProviderEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersAdfs**
> \PureCloudSDK\ADFS getIdentityprovidersAdfs()

Get ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersAdfs();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ADFS**](../Model/ADFS.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersCic**
> \PureCloudSDK\CustomerInteractionCenter getIdentityprovidersCic()

Get Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersCic();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CustomerInteractionCenter**](../Model/CustomerInteractionCenter.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersOkta**
> \PureCloudSDK\Okta getIdentityprovidersOkta()

Get Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersOkta();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Okta**](../Model/Okta.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersOnelogin**
> \PureCloudSDK\OneLogin getIdentityprovidersOnelogin()

Get OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersOnelogin();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OneLogin**](../Model/OneLogin.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersProviderId**
> \PureCloudSDK\OAuthProvider getIdentityprovidersProviderId()

Get an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersProviderId();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersPurecloud**
> \PureCloudSDK\PureCloud getIdentityprovidersPurecloud()

Get PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersPurecloud();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\PureCloud**](../Model/PureCloud.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersSalesforce**
> \PureCloudSDK\Salesforce getIdentityprovidersSalesforce()

Get Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersSalesforce();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Salesforce**](../Model/Salesforce.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersAdfs**
> putIdentityprovidersAdfs($body)

Update/Create ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\ADFS(); // \PureCloudSDK\ADFS | Provider

try {
    $api_instance->putIdentityprovidersAdfs($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ADFS**](../Model/\PureCloudSDK\ADFS.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersCic**
> putIdentityprovidersCic($body)

Update/Create Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\CustomerInteractionCenter(); // \PureCloudSDK\CustomerInteractionCenter | Provider

try {
    $api_instance->putIdentityprovidersCic($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CustomerInteractionCenter**](../Model/\PureCloudSDK\CustomerInteractionCenter.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersOkta**
> putIdentityprovidersOkta($body)

Update/Create Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Okta(); // \PureCloudSDK\Okta | Provider

try {
    $api_instance->putIdentityprovidersOkta($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Okta**](../Model/\PureCloudSDK\Okta.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersOnelogin**
> putIdentityprovidersOnelogin($body)

Update/Create OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\OneLogin(); // \PureCloudSDK\OneLogin | Provider

try {
    $api_instance->putIdentityprovidersOnelogin($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OneLogin**](../Model/\PureCloudSDK\OneLogin.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersProviderId**
> putIdentityprovidersProviderId($body)

Update an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\OAuthProvider(); // \PureCloudSDK\OAuthProvider | Provider

try {
    $api_instance->putIdentityprovidersProviderId($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OAuthProvider**](../Model/\PureCloudSDK\OAuthProvider.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersPurecloud**
> putIdentityprovidersPurecloud($body)

Update/Create PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\PureCloud(); // \PureCloudSDK\PureCloud | Provider

try {
    $api_instance->putIdentityprovidersPurecloud($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PureCloud**](../Model/\PureCloudSDK\PureCloud.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersSalesforce**
> putIdentityprovidersSalesforce($body)

Update/Create Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Salesforce(); // \PureCloudSDK\Salesforce | Provider

try {
    $api_instance->putIdentityprovidersSalesforce($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Salesforce**](../Model/\PureCloudSDK\Salesforce.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

