# PureCloudSDK\OutboundApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOutboundAttemptlimitsAttemptlimitsId**](OutboundApi.md#deleteOutboundAttemptlimitsAttemptlimitsId) | **DELETE** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Delete attempt limits
[**deleteOutboundCallabletimesetsCallabletimesetId**](OutboundApi.md#deleteOutboundCallabletimesetsCallabletimesetId) | **DELETE** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Delete callable time set
[**deleteOutboundCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#deleteOutboundCallanalysisresponsesetsCallanalysissetId) | **DELETE** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Delete a dialer call analysis response set.
[**deleteOutboundCampaignsCampaignId**](OutboundApi.md#deleteOutboundCampaignsCampaignId) | **DELETE** /api/v2/outbound/campaigns/{campaignId} | Delete a campaign.
[**deleteOutboundCampaignsCampaignIdProgress**](OutboundApi.md#deleteOutboundCampaignsCampaignIdProgress) | **DELETE** /api/v2/outbound/campaigns/{campaignId}/progress | Reset campaign progress and recycle the campaign
[**deleteOutboundContactlistsContactlistId**](OutboundApi.md#deleteOutboundContactlistsContactlistId) | **DELETE** /api/v2/outbound/contactlists/{contactListId} | Delete a contact list.
[**deleteOutboundContactlistsContactlistIdContactsContactId**](OutboundApi.md#deleteOutboundContactlistsContactlistIdContactsContactId) | **DELETE** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Delete a contact.
[**deleteOutboundDnclistsDnclistId**](OutboundApi.md#deleteOutboundDnclistsDnclistId) | **DELETE** /api/v2/outbound/dnclists/{dncListId} | Delete dialer DNC list
[**deleteOutboundRulesetsRulesetId**](OutboundApi.md#deleteOutboundRulesetsRulesetId) | **DELETE** /api/v2/outbound/rulesets/{ruleSetId} | Delete a Rule set.
[**deleteOutboundSchedulesCampaignsCampaignId**](OutboundApi.md#deleteOutboundSchedulesCampaignsCampaignId) | **DELETE** /api/v2/outbound/schedules/campaigns/{campaignId} | Delete a dialer campaign schedule.
[**deleteOutboundSchedulesSequencesSequenceId**](OutboundApi.md#deleteOutboundSchedulesSequencesSequenceId) | **DELETE** /api/v2/outbound/schedules/sequences/{sequenceId} | Delete a dialer sequence schedule.
[**deleteOutboundSequencesSequenceId**](OutboundApi.md#deleteOutboundSequencesSequenceId) | **DELETE** /api/v2/outbound/sequences/{sequenceId} | Delete a dialer campaign sequence.
[**getOutboundAttemptlimits**](OutboundApi.md#getOutboundAttemptlimits) | **GET** /api/v2/outbound/attemptlimits | Query attempt limits list
[**getOutboundAttemptlimitsAttemptlimitsId**](OutboundApi.md#getOutboundAttemptlimitsAttemptlimitsId) | **GET** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Get attempt limits
[**getOutboundCallabletimesets**](OutboundApi.md#getOutboundCallabletimesets) | **GET** /api/v2/outbound/callabletimesets | Query callable time set list
[**getOutboundCallabletimesetsCallabletimesetId**](OutboundApi.md#getOutboundCallabletimesetsCallabletimesetId) | **GET** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Get callable time set
[**getOutboundCallanalysisresponsesets**](OutboundApi.md#getOutboundCallanalysisresponsesets) | **GET** /api/v2/outbound/callanalysisresponsesets | Query a list of dialer call analysis response sets.
[**getOutboundCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#getOutboundCallanalysisresponsesetsCallanalysissetId) | **GET** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Get a dialer call analysis response set.
[**getOutboundCampaigns**](OutboundApi.md#getOutboundCampaigns) | **GET** /api/v2/outbound/campaigns | Query a list of dialer campaigns.
[**getOutboundCampaignsCampaignId**](OutboundApi.md#getOutboundCampaignsCampaignId) | **GET** /api/v2/outbound/campaigns/{campaignId} | Get dialer campaign.
[**getOutboundCampaignsCampaignIdDiagnostics**](OutboundApi.md#getOutboundCampaignsCampaignIdDiagnostics) | **GET** /api/v2/outbound/campaigns/{campaignId}/diagnostics | Get campaign diagnostics
[**getOutboundCampaignsCampaignIdInteractions**](OutboundApi.md#getOutboundCampaignsCampaignIdInteractions) | **GET** /api/v2/outbound/campaigns/{campaignId}/interactions | Get dialer campaign interactions.
[**getOutboundCampaignsCampaignIdProgress**](OutboundApi.md#getOutboundCampaignsCampaignIdProgress) | **GET** /api/v2/outbound/campaigns/{campaignId}/progress | Get campaign progress
[**getOutboundCampaignsCampaignIdStats**](OutboundApi.md#getOutboundCampaignsCampaignIdStats) | **GET** /api/v2/outbound/campaigns/{campaignId}/stats | Get statistics about a Dialer Campaign
[**getOutboundContactlists**](OutboundApi.md#getOutboundContactlists) | **GET** /api/v2/outbound/contactlists | Query a list of contact lists.
[**getOutboundContactlistsContactlistId**](OutboundApi.md#getOutboundContactlistsContactlistId) | **GET** /api/v2/outbound/contactlists/{contactListId} | Get a dialer contact list.
[**getOutboundContactlistsContactlistIdContactsContactId**](OutboundApi.md#getOutboundContactlistsContactlistIdContactsContactId) | **GET** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Get a contact.
[**getOutboundContactlistsContactlistIdExport**](OutboundApi.md#getOutboundContactlistsContactlistIdExport) | **GET** /api/v2/outbound/contactlists/{contactListId}/export | Get the URI of a contact list export.
[**getOutboundContactlistsContactlistIdImportstatus**](OutboundApi.md#getOutboundContactlistsContactlistIdImportstatus) | **GET** /api/v2/outbound/contactlists/{contactListId}/importstatus | Get dialer contactList import status.
[**getOutboundDnclists**](OutboundApi.md#getOutboundDnclists) | **GET** /api/v2/outbound/dnclists | Query dialer DNC lists
[**getOutboundDnclistsDnclistId**](OutboundApi.md#getOutboundDnclistsDnclistId) | **GET** /api/v2/outbound/dnclists/{dncListId} | Get dialer DNC list
[**getOutboundDnclistsDnclistIdExport**](OutboundApi.md#getOutboundDnclistsDnclistIdExport) | **GET** /api/v2/outbound/dnclists/{dncListId}/export | Get the URI of a DNC list export.
[**getOutboundDnclistsDnclistIdImportstatus**](OutboundApi.md#getOutboundDnclistsDnclistIdImportstatus) | **GET** /api/v2/outbound/dnclists/{dncListId}/importstatus | Get dialer dncList import status.
[**getOutboundRulesets**](OutboundApi.md#getOutboundRulesets) | **GET** /api/v2/outbound/rulesets | Query a list of Rule Sets.
[**getOutboundRulesetsRulesetId**](OutboundApi.md#getOutboundRulesetsRulesetId) | **GET** /api/v2/outbound/rulesets/{ruleSetId} | Get a Rule Set by ID.
[**getOutboundSchedulesCampaigns**](OutboundApi.md#getOutboundSchedulesCampaigns) | **GET** /api/v2/outbound/schedules/campaigns | Query for a list of dialer campaign schedules.
[**getOutboundSchedulesCampaignsCampaignId**](OutboundApi.md#getOutboundSchedulesCampaignsCampaignId) | **GET** /api/v2/outbound/schedules/campaigns/{campaignId} | Get a dialer campaign schedule.
[**getOutboundSchedulesSequences**](OutboundApi.md#getOutboundSchedulesSequences) | **GET** /api/v2/outbound/schedules/sequences | Query for a list of dialer sequence schedules.
[**getOutboundSchedulesSequencesSequenceId**](OutboundApi.md#getOutboundSchedulesSequencesSequenceId) | **GET** /api/v2/outbound/schedules/sequences/{sequenceId} | Get a dialer sequence schedule.
[**getOutboundSequences**](OutboundApi.md#getOutboundSequences) | **GET** /api/v2/outbound/sequences | Query a list of dialer campaign sequences.
[**getOutboundSequencesSequenceId**](OutboundApi.md#getOutboundSequencesSequenceId) | **GET** /api/v2/outbound/sequences/{sequenceId} | Get a dialer campaign sequence.
[**getOutboundWrapupcodemappings**](OutboundApi.md#getOutboundWrapupcodemappings) | **GET** /api/v2/outbound/wrapupcodemappings | Get the Dialer wrap up code mapping.
[**postOutboundAttemptlimits**](OutboundApi.md#postOutboundAttemptlimits) | **POST** /api/v2/outbound/attemptlimits | Create attempt limits
[**postOutboundAudits**](OutboundApi.md#postOutboundAudits) | **POST** /api/v2/outbound/audits | Retrieves audits for dialer.
[**postOutboundCallabletimesets**](OutboundApi.md#postOutboundCallabletimesets) | **POST** /api/v2/outbound/callabletimesets | Create callable time set
[**postOutboundCallanalysisresponsesets**](OutboundApi.md#postOutboundCallanalysisresponsesets) | **POST** /api/v2/outbound/callanalysisresponsesets | Create a dialer call analysis response set.
[**postOutboundCampaigns**](OutboundApi.md#postOutboundCampaigns) | **POST** /api/v2/outbound/campaigns | Create a campaign.
[**postOutboundCampaignsCampaignIdCallbackSchedule**](OutboundApi.md#postOutboundCampaignsCampaignIdCallbackSchedule) | **POST** /api/v2/outbound/campaigns/{campaignId}/callback/schedule | Schedule a Callback for a Dialer Campaign (Deprecated)
[**postOutboundCampaignsProgress**](OutboundApi.md#postOutboundCampaignsProgress) | **POST** /api/v2/outbound/campaigns/progress | Get progress for a list of campaigns
[**postOutboundContactlists**](OutboundApi.md#postOutboundContactlists) | **POST** /api/v2/outbound/contactlists | Create a contact List.
[**postOutboundContactlistsContactlistIdContacts**](OutboundApi.md#postOutboundContactlistsContactlistIdContacts) | **POST** /api/v2/outbound/contactlists/{contactListId}/contacts | Add contacts to a contact list.
[**postOutboundContactlistsContactlistIdExport**](OutboundApi.md#postOutboundContactlistsContactlistIdExport) | **POST** /api/v2/outbound/contactlists/{contactListId}/export | Initiate the export of a contact list.
[**postOutboundConversationsConversationIdDnc**](OutboundApi.md#postOutboundConversationsConversationIdDnc) | **POST** /api/v2/outbound/conversations/{conversationId}/dnc | Add phone numbers to a Dialer DNC list.
[**postOutboundDnclists**](OutboundApi.md#postOutboundDnclists) | **POST** /api/v2/outbound/dnclists | Create dialer DNC list
[**postOutboundDnclistsDnclistIdExport**](OutboundApi.md#postOutboundDnclistsDnclistIdExport) | **POST** /api/v2/outbound/dnclists/{dncListId}/export | Initiate the export of a dnc list.
[**postOutboundDnclistsDnclistIdPhonenumbers**](OutboundApi.md#postOutboundDnclistsDnclistIdPhonenumbers) | **POST** /api/v2/outbound/dnclists/{dncListId}/phonenumbers | Add phone numbers to a Dialer DNC list.
[**postOutboundRulesets**](OutboundApi.md#postOutboundRulesets) | **POST** /api/v2/outbound/rulesets | Create a Dialer Call Analysis Response Set.
[**postOutboundSequences**](OutboundApi.md#postOutboundSequences) | **POST** /api/v2/outbound/sequences | Create a new campaign sequence.
[**putOutboundAttemptlimitsAttemptlimitsId**](OutboundApi.md#putOutboundAttemptlimitsAttemptlimitsId) | **PUT** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Update attempt limits
[**putOutboundCallabletimesetsCallabletimesetId**](OutboundApi.md#putOutboundCallabletimesetsCallabletimesetId) | **PUT** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Update callable time set
[**putOutboundCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#putOutboundCallanalysisresponsesetsCallanalysissetId) | **PUT** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Update a dialer call analysis response set.
[**putOutboundCampaignsCampaignId**](OutboundApi.md#putOutboundCampaignsCampaignId) | **PUT** /api/v2/outbound/campaigns/{campaignId} | Update a campaign.
[**putOutboundCampaignsCampaignIdAgentsUserId**](OutboundApi.md#putOutboundCampaignsCampaignIdAgentsUserId) | **PUT** /api/v2/outbound/campaigns/{campaignId}/agents/{userId} | Send notification that an agent&#39;s state changed
[**putOutboundContactlistsContactlistId**](OutboundApi.md#putOutboundContactlistsContactlistId) | **PUT** /api/v2/outbound/contactlists/{contactListId} | Update a contact list.
[**putOutboundContactlistsContactlistIdContactsContactId**](OutboundApi.md#putOutboundContactlistsContactlistIdContactsContactId) | **PUT** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Update a contact.
[**putOutboundDnclistsDnclistId**](OutboundApi.md#putOutboundDnclistsDnclistId) | **PUT** /api/v2/outbound/dnclists/{dncListId} | Update dialer DNC list
[**putOutboundRulesetsRulesetId**](OutboundApi.md#putOutboundRulesetsRulesetId) | **PUT** /api/v2/outbound/rulesets/{ruleSetId} | Update a RuleSet.
[**putOutboundSchedulesCampaignsCampaignId**](OutboundApi.md#putOutboundSchedulesCampaignsCampaignId) | **PUT** /api/v2/outbound/schedules/campaigns/{campaignId} | Update a new campaign schedule.
[**putOutboundSchedulesSequencesSequenceId**](OutboundApi.md#putOutboundSchedulesSequencesSequenceId) | **PUT** /api/v2/outbound/schedules/sequences/{sequenceId} | Update a new sequence schedule.
[**putOutboundSequencesSequenceId**](OutboundApi.md#putOutboundSequencesSequenceId) | **PUT** /api/v2/outbound/sequences/{sequenceId} | Update a new campaign sequence.
[**putOutboundWrapupcodemappings**](OutboundApi.md#putOutboundWrapupcodemappings) | **PUT** /api/v2/outbound/wrapupcodemappings | Update the Dialer wrap up code mapping.


# **deleteOutboundAttemptlimitsAttemptlimitsId**
> string deleteOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId)

Delete attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID

try {
    $result = $api_instance->deleteOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundCallabletimesetsCallabletimesetId**
> string deleteOutboundCallabletimesetsCallabletimesetId($callableTimeSetId)

Delete callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID

try {
    $result = $api_instance->deleteOutboundCallabletimesetsCallabletimesetId($callableTimeSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundCallanalysisresponsesetsCallanalysissetId**
> string deleteOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId)

Delete a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID

try {
    $result = $api_instance->deleteOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundCampaignsCampaignId**
> string deleteOutboundCampaignsCampaignId($campaignId)

Delete a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteOutboundCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundCampaignsCampaignIdProgress**
> string deleteOutboundCampaignsCampaignIdProgress($campaignId)

Reset campaign progress and recycle the campaign



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteOutboundCampaignsCampaignIdProgress($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundCampaignsCampaignIdProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundContactlistsContactlistId**
> string deleteOutboundContactlistsContactlistId($contactListId)

Delete a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->deleteOutboundContactlistsContactlistId($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundContactlistsContactlistIdContactsContactId**
> string deleteOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId)

Delete a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID

try {
    $result = $api_instance->deleteOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundDnclistsDnclistId**
> string deleteOutboundDnclistsDnclistId($dncListId)

Delete dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->deleteOutboundDnclistsDnclistId($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundRulesetsRulesetId**
> string deleteOutboundRulesetsRulesetId($ruleSetId)

Delete a Rule set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID

try {
    $result = $api_instance->deleteOutboundRulesetsRulesetId($ruleSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundSchedulesCampaignsCampaignId**
> string deleteOutboundSchedulesCampaignsCampaignId($campaignId)

Delete a dialer campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteOutboundSchedulesCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundSchedulesSequencesSequenceId**
> string deleteOutboundSchedulesSequencesSequenceId($sequenceId)

Delete a dialer sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID

try {
    $result = $api_instance->deleteOutboundSchedulesSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOutboundSequencesSequenceId**
> string deleteOutboundSequencesSequenceId($sequenceId)

Delete a dialer campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID

try {
    $result = $api_instance->deleteOutboundSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteOutboundSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundAttemptlimits**
> \PureCloudSDK\AttemptLimitsEntityListing getOutboundAttemptlimits($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query attempt limits list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundAttemptlimits($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundAttemptlimits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\AttemptLimitsEntityListing**](../Model/AttemptLimitsEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundAttemptlimitsAttemptlimitsId**
> \PureCloudSDK\AttemptLimits getOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId)

Get attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID

try {
    $result = $api_instance->getOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCallabletimesets**
> \PureCloudSDK\CallableTimeSetEntityListing getOutboundCallabletimesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query callable time set list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundCallabletimesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCallabletimesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CallableTimeSetEntityListing**](../Model/CallableTimeSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCallabletimesetsCallabletimesetId**
> \PureCloudSDK\CallableTimeSet getOutboundCallabletimesetsCallabletimesetId($callableTimeSetId)

Get callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID

try {
    $result = $api_instance->getOutboundCallabletimesetsCallabletimesetId($callableTimeSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCallanalysisresponsesets**
> \PureCloudSDK\ResponseSetEntityListing getOutboundCallanalysisresponsesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of dialer call analysis response sets.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundCallanalysisresponsesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCallanalysisresponsesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\ResponseSetEntityListing**](../Model/ResponseSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCallanalysisresponsesetsCallanalysissetId**
> \PureCloudSDK\ResponseSet getOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId)

Get a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID

try {
    $result = $api_instance->getOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaigns**
> \PureCloudSDK\CampaignEntityListing getOutboundCampaigns($pageSize, $pageNumber, $filterType, $name, $contactListId, $dncListId, $distributionQueueId, $edgeGroupId, $callAnalysisResponseSetId, $sortBy, $sortOrder)

Query a list of dialer campaigns.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$contactListId = "contactListId_example"; // string | Contact List ID
$dncListId = "dncListId_example"; // string | DNC list ID
$distributionQueueId = "distributionQueueId_example"; // string | Distribution queue ID
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$callAnalysisResponseSetId = "callAnalysisResponseSetId_example"; // string | Call analysis response set ID
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundCampaigns($pageSize, $pageNumber, $filterType, $name, $contactListId, $dncListId, $distributionQueueId, $edgeGroupId, $callAnalysisResponseSetId, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **contactListId** | **string**| Contact List ID | [optional]
 **dncListId** | **string**| DNC list ID | [optional]
 **distributionQueueId** | **string**| Distribution queue ID | [optional]
 **edgeGroupId** | **string**| Edge group ID | [optional]
 **callAnalysisResponseSetId** | **string**| Call analysis response set ID | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CampaignEntityListing**](../Model/CampaignEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaignsCampaignId**
> \PureCloudSDK\Campaign getOutboundCampaignsCampaignId($campaignId)

Get dialer campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaignsCampaignIdDiagnostics**
> \PureCloudSDK\CampaignDiagnostics getOutboundCampaignsCampaignIdDiagnostics($campaignId)

Get campaign diagnostics



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundCampaignsCampaignIdDiagnostics($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaignsCampaignIdDiagnostics: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignDiagnostics**](../Model/CampaignDiagnostics.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaignsCampaignIdInteractions**
> \PureCloudSDK\CampaignInteractions getOutboundCampaignsCampaignIdInteractions($campaignId)

Get dialer campaign interactions.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundCampaignsCampaignIdInteractions($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaignsCampaignIdInteractions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignInteractions**](../Model/CampaignInteractions.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaignsCampaignIdProgress**
> \PureCloudSDK\CampaignProgress getOutboundCampaignsCampaignIdProgress($campaignId)

Get campaign progress



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundCampaignsCampaignIdProgress($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaignsCampaignIdProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignProgress**](../Model/CampaignProgress.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundCampaignsCampaignIdStats**
> \PureCloudSDK\CampaignStats getOutboundCampaignsCampaignIdStats($campaignId)

Get statistics about a Dialer Campaign



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundCampaignsCampaignIdStats($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundCampaignsCampaignIdStats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignStats**](../Model/CampaignStats.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundContactlists**
> \PureCloudSDK\ContactListEntityListing getOutboundContactlists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of contact lists.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$includeImportStatus = false; // bool | Include import status
$includeSize = false; // bool | Include size
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundContactlists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundContactlists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **includeImportStatus** | **bool**| Include import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\ContactListEntityListing**](../Model/ContactListEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundContactlistsContactlistId**
> \PureCloudSDK\ContactList getOutboundContactlistsContactlistId($contactListId, $includeImportStatus, $includeSize)

Get a dialer contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size

try {
    $result = $api_instance->getOutboundContactlistsContactlistId($contactListId, $includeImportStatus, $includeSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundContactlistsContactlistIdContactsContactId**
> \PureCloudSDK\DialerContact getOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId)

Get a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID

try {
    $result = $api_instance->getOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |

### Return type

[**\PureCloudSDK\DialerContact**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundContactlistsContactlistIdExport**
> \PureCloudSDK\ExportUri getOutboundContactlistsContactlistIdExport($contactListId, $download)

Get the URI of a contact list export.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$download = "false"; // string | Redirect to download uri

try {
    $result = $api_instance->getOutboundContactlistsContactlistIdExport($contactListId, $download);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundContactlistsContactlistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **download** | **string**| Redirect to download uri | [optional] [default to false]

### Return type

[**\PureCloudSDK\ExportUri**](../Model/ExportUri.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundContactlistsContactlistIdImportstatus**
> \PureCloudSDK\ImportStatus getOutboundContactlistsContactlistIdImportstatus($contactListId)

Get dialer contactList import status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->getOutboundContactlistsContactlistIdImportstatus($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundContactlistsContactlistIdImportstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

[**\PureCloudSDK\ImportStatus**](../Model/ImportStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundDnclists**
> \PureCloudSDK\DncListEntityListing getOutboundDnclists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query dialer DNC lists



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "sortOrder_example"; // string | Sort order

try {
    $result = $api_instance->getOutboundDnclists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundDnclists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional]

### Return type

[**\PureCloudSDK\DncListEntityListing**](../Model/DncListEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundDnclistsDnclistId**
> \PureCloudSDK\DncList getOutboundDnclistsDnclistId($dncListId, $includeImportStatus, $includeSize)

Get dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size

try {
    $result = $api_instance->getOutboundDnclistsDnclistId($dncListId, $includeImportStatus, $includeSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundDnclistsDnclistIdExport**
> \PureCloudSDK\ExportUri getOutboundDnclistsDnclistIdExport($dncListId, $download)

Get the URI of a DNC list export.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$download = "false"; // string | Redirect to download uri

try {
    $result = $api_instance->getOutboundDnclistsDnclistIdExport($dncListId, $download);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundDnclistsDnclistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **download** | **string**| Redirect to download uri | [optional] [default to false]

### Return type

[**\PureCloudSDK\ExportUri**](../Model/ExportUri.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundDnclistsDnclistIdImportstatus**
> \PureCloudSDK\ImportStatus getOutboundDnclistsDnclistIdImportstatus($dncListId)

Get dialer dncList import status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->getOutboundDnclistsDnclistIdImportstatus($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundDnclistsDnclistIdImportstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

[**\PureCloudSDK\ImportStatus**](../Model/ImportStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundRulesets**
> \PureCloudSDK\RuleSetEntityListing getOutboundRulesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of Rule Sets.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundRulesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundRulesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\RuleSetEntityListing**](../Model/RuleSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundRulesetsRulesetId**
> \PureCloudSDK\RuleSet getOutboundRulesetsRulesetId($ruleSetId)

Get a Rule Set by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID

try {
    $result = $api_instance->getOutboundRulesetsRulesetId($ruleSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSchedulesCampaigns**
> \PureCloudSDK\CampaignSchedule[] getOutboundSchedulesCampaigns()

Query for a list of dialer campaign schedules.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getOutboundSchedulesCampaigns();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSchedulesCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CampaignSchedule[]**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSchedulesCampaignsCampaignId**
> \PureCloudSDK\CampaignSchedule getOutboundSchedulesCampaignsCampaignId($campaignId)

Get a dialer campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getOutboundSchedulesCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignSchedule**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSchedulesSequences**
> \PureCloudSDK\SequenceSchedule[] getOutboundSchedulesSequences()

Query for a list of dialer sequence schedules.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getOutboundSchedulesSequences();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSchedulesSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SequenceSchedule[]**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSchedulesSequencesSequenceId**
> \PureCloudSDK\SequenceSchedule getOutboundSchedulesSequencesSequenceId($sequenceId)

Get a dialer sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID

try {
    $result = $api_instance->getOutboundSchedulesSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |

### Return type

[**\PureCloudSDK\SequenceSchedule**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSequences**
> \PureCloudSDK\CampaignSequenceEntityListing getOutboundSequences($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of dialer campaign sequences.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getOutboundSequences($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CampaignSequenceEntityListing**](../Model/CampaignSequenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundSequencesSequenceId**
> \PureCloudSDK\CampaignSequence getOutboundSequencesSequenceId($sequenceId)

Get a dialer campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID

try {
    $result = $api_instance->getOutboundSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOutboundWrapupcodemappings**
> \PureCloudSDK\WrapUpCodeMapping getOutboundWrapupcodemappings()

Get the Dialer wrap up code mapping.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getOutboundWrapupcodemappings();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getOutboundWrapupcodemappings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\WrapUpCodeMapping**](../Model/WrapUpCodeMapping.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundAttemptlimits**
> \PureCloudSDK\AttemptLimits postOutboundAttemptlimits($body)

Create attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\AttemptLimits(); // \PureCloudSDK\AttemptLimits | AttemptLimits

try {
    $result = $api_instance->postOutboundAttemptlimits($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundAttemptlimits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AttemptLimits**](../Model/\PureCloudSDK\AttemptLimits.md)| AttemptLimits |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundAudits**
> \PureCloudSDK\AuditSearchResult postOutboundAudits($body, $pageSize, $pageNumber, $sortBy, $sortOrder, $facetsOnly)

Retrieves audits for dialer.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\DialerAuditRequest(); // \PureCloudSDK\DialerAuditRequest | AuditSearch
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "entity.name"; // string | Sort by
$sortOrder = "ascending"; // string | Sort order
$facetsOnly = false; // bool | Facets only

try {
    $result = $api_instance->postOutboundAudits($body, $pageSize, $pageNumber, $sortBy, $sortOrder, $facetsOnly);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DialerAuditRequest**](../Model/\PureCloudSDK\DialerAuditRequest.md)| AuditSearch |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to entity.name]
 **sortOrder** | **string**| Sort order | [optional] [default to ascending]
 **facetsOnly** | **bool**| Facets only | [optional] [default to false]

### Return type

[**\PureCloudSDK\AuditSearchResult**](../Model/AuditSearchResult.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundCallabletimesets**
> \PureCloudSDK\CallableTimeSet postOutboundCallabletimesets($body)

Create callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\CallableTimeSet(); // \PureCloudSDK\CallableTimeSet | DialerCallableTimeSet

try {
    $result = $api_instance->postOutboundCallabletimesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundCallabletimesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CallableTimeSet**](../Model/\PureCloudSDK\CallableTimeSet.md)| DialerCallableTimeSet |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundCallanalysisresponsesets**
> \PureCloudSDK\ResponseSet postOutboundCallanalysisresponsesets($body)

Create a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\ResponseSet(); // \PureCloudSDK\ResponseSet | ResponseSet

try {
    $result = $api_instance->postOutboundCallanalysisresponsesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundCallanalysisresponsesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ResponseSet**](../Model/\PureCloudSDK\ResponseSet.md)| ResponseSet |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundCampaigns**
> \PureCloudSDK\Campaign postOutboundCampaigns($body)

Create a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\Campaign(); // \PureCloudSDK\Campaign | Campaign

try {
    $result = $api_instance->postOutboundCampaigns($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Campaign**](../Model/\PureCloudSDK\Campaign.md)| Campaign |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundCampaignsCampaignIdCallbackSchedule**
> \PureCloudSDK\ContactCallbackRequest postOutboundCampaignsCampaignIdCallbackSchedule($campaignId, $body)

Schedule a Callback for a Dialer Campaign (Deprecated)

This endpoint is deprecated and may have unexpected results. Please use \"/conversations/{conversationId}/participants/{participantId}/callbacks instead.\"

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\ContactCallbackRequest(); // \PureCloudSDK\ContactCallbackRequest | ContactCallbackRequest

try {
    $result = $api_instance->postOutboundCampaignsCampaignIdCallbackSchedule($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundCampaignsCampaignIdCallbackSchedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\ContactCallbackRequest**](../Model/\PureCloudSDK\ContactCallbackRequest.md)| ContactCallbackRequest |

### Return type

[**\PureCloudSDK\ContactCallbackRequest**](../Model/ContactCallbackRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundCampaignsProgress**
> \PureCloudSDK\CampaignProgress[] postOutboundCampaignsProgress($body)

Get progress for a list of campaigns



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = array(new string[]()); // string[] | Campaign IDs

try {
    $result = $api_instance->postOutboundCampaignsProgress($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundCampaignsProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | **string[]**| Campaign IDs |

### Return type

[**\PureCloudSDK\CampaignProgress[]**](../Model/CampaignProgress.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundContactlists**
> \PureCloudSDK\ContactList postOutboundContactlists($body)

Create a contact List.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\ContactList(); // \PureCloudSDK\ContactList | ContactList

try {
    $result = $api_instance->postOutboundContactlists($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundContactlists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ContactList**](../Model/\PureCloudSDK\ContactList.md)| ContactList |

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundContactlistsContactlistIdContacts**
> \PureCloudSDK\DialerContact[] postOutboundContactlistsContactlistIdContacts($contactListId, $body, $priority)

Add contacts to a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$body = array(new DialerContact()); // \PureCloudSDK\DialerContact[] | Contact
$priority = true; // bool | Contact priority.  True means the contact(s) will go to the beginning of the list, false means at the end.

try {
    $result = $api_instance->postOutboundContactlistsContactlistIdContacts($contactListId, $body, $priority);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundContactlistsContactlistIdContacts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **body** | [**\PureCloudSDK\DialerContact[]**](../Model/DialerContact.md)| Contact |
 **priority** | **bool**| Contact priority.  True means the contact(s) will go to the beginning of the list, false means at the end. | [optional]

### Return type

[**\PureCloudSDK\DialerContact[]**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundContactlistsContactlistIdExport**
> string postOutboundContactlistsContactlistIdExport($contactListId)

Initiate the export of a contact list.

Returns 200 if received OK.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->postOutboundContactlistsContactlistIdExport($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundContactlistsContactlistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundConversationsConversationIdDnc**
> postOutboundConversationsConversationIdDnc($conversationId)

Add phone numbers to a Dialer DNC list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$conversationId = "conversationId_example"; // string | Conversation ID

try {
    $api_instance->postOutboundConversationsConversationIdDnc($conversationId);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundConversationsConversationIdDnc: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundDnclists**
> \PureCloudSDK\DncList postOutboundDnclists($body)

Create dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\DncList(); // \PureCloudSDK\DncList | DncList

try {
    $result = $api_instance->postOutboundDnclists($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundDnclists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DncList**](../Model/\PureCloudSDK\DncList.md)| DncList |

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundDnclistsDnclistIdExport**
> string postOutboundDnclistsDnclistIdExport($dncListId)

Initiate the export of a dnc list.

Returns 200 if received OK.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->postOutboundDnclistsDnclistIdExport($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundDnclistsDnclistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundDnclistsDnclistIdPhonenumbers**
> postOutboundDnclistsDnclistIdPhonenumbers($dncListId, $body)

Add phone numbers to a Dialer DNC list.

Only Internal DNC lists may be appended to

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$body = array(new string[]()); // string[] | DNC Phone Numbers

try {
    $api_instance->postOutboundDnclistsDnclistIdPhonenumbers($dncListId, $body);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundDnclistsDnclistIdPhonenumbers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **body** | **string[]**| DNC Phone Numbers |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundRulesets**
> \PureCloudSDK\RuleSet postOutboundRulesets($body)

Create a Dialer Call Analysis Response Set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\RuleSet(); // \PureCloudSDK\RuleSet | RuleSet

try {
    $result = $api_instance->postOutboundRulesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundRulesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RuleSet**](../Model/\PureCloudSDK\RuleSet.md)| RuleSet |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postOutboundSequences**
> \PureCloudSDK\CampaignSequence postOutboundSequences($body)

Create a new campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\CampaignSequence(); // \PureCloudSDK\CampaignSequence | Organization

try {
    $result = $api_instance->postOutboundSequences($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postOutboundSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CampaignSequence**](../Model/\PureCloudSDK\CampaignSequence.md)| Organization |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundAttemptlimitsAttemptlimitsId**
> \PureCloudSDK\AttemptLimits putOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId, $body)

Update attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID
$body = new \PureCloudSDK\AttemptLimits(); // \PureCloudSDK\AttemptLimits | AttemptLimits

try {
    $result = $api_instance->putOutboundAttemptlimitsAttemptlimitsId($attemptLimitsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |
 **body** | [**\PureCloudSDK\AttemptLimits**](../Model/\PureCloudSDK\AttemptLimits.md)| AttemptLimits |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundCallabletimesetsCallabletimesetId**
> \PureCloudSDK\CallableTimeSet putOutboundCallabletimesetsCallabletimesetId($callableTimeSetId, $body)

Update callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID
$body = new \PureCloudSDK\CallableTimeSet(); // \PureCloudSDK\CallableTimeSet | DialerCallableTimeSet

try {
    $result = $api_instance->putOutboundCallabletimesetsCallabletimesetId($callableTimeSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |
 **body** | [**\PureCloudSDK\CallableTimeSet**](../Model/\PureCloudSDK\CallableTimeSet.md)| DialerCallableTimeSet |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundCallanalysisresponsesetsCallanalysissetId**
> \PureCloudSDK\ResponseSet putOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId, $body)

Update a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID
$body = new \PureCloudSDK\ResponseSet(); // \PureCloudSDK\ResponseSet | ResponseSet

try {
    $result = $api_instance->putOutboundCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |
 **body** | [**\PureCloudSDK\ResponseSet**](../Model/\PureCloudSDK\ResponseSet.md)| ResponseSet |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundCampaignsCampaignId**
> \PureCloudSDK\Campaign putOutboundCampaignsCampaignId($campaignId, $body)

Update a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\Campaign(); // \PureCloudSDK\Campaign | Campaign

try {
    $result = $api_instance->putOutboundCampaignsCampaignId($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\Campaign**](../Model/\PureCloudSDK\Campaign.md)| Campaign |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundCampaignsCampaignIdAgentsUserId**
> string putOutboundCampaignsCampaignIdAgentsUserId($campaignId, $userId, $body)

Send notification that an agent's state changed

New agent state.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$userId = "userId_example"; // string | Agent's user ID
$body = new \PureCloudSDK\Agent(); // \PureCloudSDK\Agent | agent

try {
    $result = $api_instance->putOutboundCampaignsCampaignIdAgentsUserId($campaignId, $userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundCampaignsCampaignIdAgentsUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **userId** | **string**| Agent&#39;s user ID |
 **body** | [**\PureCloudSDK\Agent**](../Model/\PureCloudSDK\Agent.md)| agent |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundContactlistsContactlistId**
> \PureCloudSDK\ContactList putOutboundContactlistsContactlistId($contactListId, $body)

Update a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$body = new \PureCloudSDK\ContactList(); // \PureCloudSDK\ContactList | ContactList

try {
    $result = $api_instance->putOutboundContactlistsContactlistId($contactListId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **body** | [**\PureCloudSDK\ContactList**](../Model/\PureCloudSDK\ContactList.md)| ContactList |

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundContactlistsContactlistIdContactsContactId**
> \PureCloudSDK\DialerContact putOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId, $body)

Update a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID
$body = new \PureCloudSDK\DialerContact(); // \PureCloudSDK\DialerContact | Contact

try {
    $result = $api_instance->putOutboundContactlistsContactlistIdContactsContactId($contactListId, $contactId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |
 **body** | [**\PureCloudSDK\DialerContact**](../Model/\PureCloudSDK\DialerContact.md)| Contact |

### Return type

[**\PureCloudSDK\DialerContact**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundDnclistsDnclistId**
> \PureCloudSDK\DncList putOutboundDnclistsDnclistId($dncListId, $body)

Update dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$body = new \PureCloudSDK\DncList(); // \PureCloudSDK\DncList | DncList

try {
    $result = $api_instance->putOutboundDnclistsDnclistId($dncListId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **body** | [**\PureCloudSDK\DncList**](../Model/\PureCloudSDK\DncList.md)| DncList |

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundRulesetsRulesetId**
> \PureCloudSDK\RuleSet putOutboundRulesetsRulesetId($ruleSetId, $body)

Update a RuleSet.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID
$body = new \PureCloudSDK\RuleSet(); // \PureCloudSDK\RuleSet | RuleSet

try {
    $result = $api_instance->putOutboundRulesetsRulesetId($ruleSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |
 **body** | [**\PureCloudSDK\RuleSet**](../Model/\PureCloudSDK\RuleSet.md)| RuleSet |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundSchedulesCampaignsCampaignId**
> \PureCloudSDK\CampaignSchedule putOutboundSchedulesCampaignsCampaignId($campaignId, $body)

Update a new campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\CampaignSchedule(); // \PureCloudSDK\CampaignSchedule | CampaignSchedule

try {
    $result = $api_instance->putOutboundSchedulesCampaignsCampaignId($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\CampaignSchedule**](../Model/\PureCloudSDK\CampaignSchedule.md)| CampaignSchedule |

### Return type

[**\PureCloudSDK\CampaignSchedule**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundSchedulesSequencesSequenceId**
> \PureCloudSDK\SequenceSchedule putOutboundSchedulesSequencesSequenceId($sequenceId, $body)

Update a new sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID
$body = new \PureCloudSDK\SequenceSchedule(); // \PureCloudSDK\SequenceSchedule | SequenceSchedule

try {
    $result = $api_instance->putOutboundSchedulesSequencesSequenceId($sequenceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |
 **body** | [**\PureCloudSDK\SequenceSchedule**](../Model/\PureCloudSDK\SequenceSchedule.md)| SequenceSchedule |

### Return type

[**\PureCloudSDK\SequenceSchedule**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundSequencesSequenceId**
> \PureCloudSDK\CampaignSequence putOutboundSequencesSequenceId($sequenceId, $body)

Update a new campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID
$body = new \PureCloudSDK\CampaignSequence(); // \PureCloudSDK\CampaignSequence | Organization

try {
    $result = $api_instance->putOutboundSequencesSequenceId($sequenceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |
 **body** | [**\PureCloudSDK\CampaignSequence**](../Model/\PureCloudSDK\CampaignSequence.md)| Organization |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOutboundWrapupcodemappings**
> \PureCloudSDK\WrapUpCodeMapping putOutboundWrapupcodemappings($body)

Update the Dialer wrap up code mapping.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\WrapUpCodeMapping(); // \PureCloudSDK\WrapUpCodeMapping | wrapUpCodeMapping

try {
    $result = $api_instance->putOutboundWrapupcodemappings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putOutboundWrapupcodemappings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WrapUpCodeMapping**](../Model/\PureCloudSDK\WrapUpCodeMapping.md)| wrapUpCodeMapping |

### Return type

[**\PureCloudSDK\WrapUpCodeMapping**](../Model/WrapUpCodeMapping.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

