# PureCloudSDK\VoicemailApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteVoicemailMessages**](VoicemailApi.md#deleteVoicemailMessages) | **DELETE** /api/v2/voicemail/messages | Delete all voicemail messages
[**deleteVoicemailMessagesMessageId**](VoicemailApi.md#deleteVoicemailMessagesMessageId) | **DELETE** /api/v2/voicemail/messages/{messageId} | Delete a message.
[**getVoicemailMailbox**](VoicemailApi.md#getVoicemailMailbox) | **GET** /api/v2/voicemail/mailbox | Get mailbox information
[**getVoicemailMessages**](VoicemailApi.md#getVoicemailMessages) | **GET** /api/v2/voicemail/messages | List voicemail messages
[**getVoicemailMessagesMessageId**](VoicemailApi.md#getVoicemailMessagesMessageId) | **GET** /api/v2/voicemail/messages/{messageId} | Get message.
[**getVoicemailMessagesMessageIdMedia**](VoicemailApi.md#getVoicemailMessagesMessageIdMedia) | **GET** /api/v2/voicemail/messages/{messageId}/media | Get media playback URI for this message
[**getVoicemailPolicy**](VoicemailApi.md#getVoicemailPolicy) | **GET** /api/v2/voicemail/policy | Get a policy
[**getVoicemailUserpoliciesUserId**](VoicemailApi.md#getVoicemailUserpoliciesUserId) | **GET** /api/v2/voicemail/userpolicies/{userId} | Get a user&#39;s voicemail policy
[**patchVoicemailUserpoliciesUserId**](VoicemailApi.md#patchVoicemailUserpoliciesUserId) | **PATCH** /api/v2/voicemail/userpolicies/{userId} | Update a user&#39;s voicemail policy
[**putVoicemailMessagesMessageId**](VoicemailApi.md#putVoicemailMessagesMessageId) | **PUT** /api/v2/voicemail/messages/{messageId} | Update a message.
[**putVoicemailPolicy**](VoicemailApi.md#putVoicemailPolicy) | **PUT** /api/v2/voicemail/policy | Update a policy


# **deleteVoicemailMessages**
> string deleteVoicemailMessages()

Delete all voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->deleteVoicemailMessages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteVoicemailMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteVoicemailMessagesMessageId**
> string deleteVoicemailMessagesMessageId($messageId)

Delete a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID

try {
    $result = $api_instance->deleteVoicemailMessagesMessageId($messageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMailbox**
> \PureCloudSDK\VoicemailMailboxInfo getVoicemailMailbox()

Get mailbox information



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailMailbox();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMailbox: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMailboxInfo**](../Model/VoicemailMailboxInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessages**
> \PureCloudSDK\VoicemailMessageEntityListing getVoicemailMessages()

List voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailMessages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMessageEntityListing**](../Model/VoicemailMessageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessagesMessageId**
> \PureCloudSDK\VoicemailMessage getVoicemailMessagesMessageId($messageId)

Get message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID

try {
    $result = $api_instance->getVoicemailMessagesMessageId($messageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessagesMessageIdMedia**
> \PureCloudSDK\VoicemailMediaInfo getVoicemailMessagesMessageIdMedia($messageId, $formatId)

Get media playback URI for this message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID
$formatId = "WEBM"; // string | The desired media format.

try {
    $result = $api_instance->getVoicemailMessagesMessageIdMedia($messageId, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessagesMessageIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\VoicemailMediaInfo**](../Model/VoicemailMediaInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy getVoicemailPolicy()

Get a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailPolicy();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy getVoicemailUserpoliciesUserId($userId)

Get a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getVoicemailUserpoliciesUserId($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchVoicemailUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy patchVoicemailUserpoliciesUserId($userId, $body)

Update a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\VoicemailUserPolicy(); // \PureCloudSDK\VoicemailUserPolicy | The user's voicemail policy

try {
    $result = $api_instance->patchVoicemailUserpoliciesUserId($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->patchVoicemailUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\VoicemailUserPolicy**](../Model/\PureCloudSDK\VoicemailUserPolicy.md)| The user&#39;s voicemail policy |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putVoicemailMessagesMessageId**
> \PureCloudSDK\VoicemailMessage putVoicemailMessagesMessageId($messageId, $body)

Update a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID
$body = new \PureCloudSDK\VoicemailMessage(); // \PureCloudSDK\VoicemailMessage | VoicemailMessage

try {
    $result = $api_instance->putVoicemailMessagesMessageId($messageId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |
 **body** | [**\PureCloudSDK\VoicemailMessage**](../Model/\PureCloudSDK\VoicemailMessage.md)| VoicemailMessage |

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putVoicemailPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy putVoicemailPolicy($body)

Update a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\VoicemailOrganizationPolicy(); // \PureCloudSDK\VoicemailOrganizationPolicy | Policy

try {
    $result = $api_instance->putVoicemailPolicy($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putVoicemailPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/\PureCloudSDK\VoicemailOrganizationPolicy.md)| Policy |

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

