# PureCloudSDK\WorkforceManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getWorkforcemanagementAdherence**](WorkforceManagementApi.md#getWorkforcemanagementAdherence) | **GET** /api/v2/workforcemanagement/adherence | Get a list of UserScheduleAdherence records for the requested users
[**getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests**](WorkforceManagementApi.md#getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests | Get a list of time off requests for any user
[**getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId**](WorkforceManagementApi.md#getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId) | **GET** /api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId} | Get a time off request by id
[**getWorkforcemanagementTimeoffrequests**](WorkforceManagementApi.md#getWorkforcemanagementTimeoffrequests) | **GET** /api/v2/workforcemanagement/timeoffrequests | Get a list of time off requests for the current user
[**getWorkforcemanagementTimeoffrequestsTimeoffrequestId**](WorkforceManagementApi.md#getWorkforcemanagementTimeoffrequestsTimeoffrequestId) | **GET** /api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId} | Get a time off request for the current user by id
[**patchWorkforcemanagementTimeoffrequestsTimeoffrequestId**](WorkforceManagementApi.md#patchWorkforcemanagementTimeoffrequestsTimeoffrequestId) | **PATCH** /api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId} | Mark a time off request for the current user as read or unread
[**postWorkforcemanagementLongtermforecasts**](WorkforceManagementApi.md#postWorkforcemanagementLongtermforecasts) | **POST** /api/v2/workforcemanagement/longtermforecasts | Create a forecast


# **getWorkforcemanagementAdherence**
> \PureCloudSDK\UserScheduleAdherence getWorkforcemanagementAdherence($userId)

Get a list of UserScheduleAdherence records for the requested users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$userId = array("userId_example"); // string[] | User Id(s) for which to fetch current schedule adherence information.  Max of 100 userIds per request

try {
    $result = $api_instance->getWorkforcemanagementAdherence($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getWorkforcemanagementAdherence: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | [**string[]**](../Model/string.md)| User Id(s) for which to fetch current schedule adherence information.  Max of 100 userIds per request |

### Return type

[**\PureCloudSDK\UserScheduleAdherence**](../Model/UserScheduleAdherence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests**
> \PureCloudSDK\TimeOffRequestList getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests($muId, $userId, $recentlyReviewed)

Get a list of time off requests for any user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$muId = "muId_example"; // string | The muId of the management unit.
$userId = "userId_example"; // string | The userId to whom the Time Off Request applies.
$recentlyReviewed = false; // bool | Limit results to requests that have been reviewed within the preceding 30 days

try {
    $result = $api_instance->getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests($muId, $userId, $recentlyReviewed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequests: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **muId** | **string**| The muId of the management unit. |
 **userId** | **string**| The userId to whom the Time Off Request applies. |
 **recentlyReviewed** | **bool**| Limit results to requests that have been reviewed within the preceding 30 days | [optional] [default to false]

### Return type

[**\PureCloudSDK\TimeOffRequestList**](../Model/TimeOffRequestList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId**
> \PureCloudSDK\TimeOffRequest getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId($muId, $userId, $timeOffRequestId)

Get a time off request by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$muId = "muId_example"; // string | The muId of the management unit.
$userId = "userId_example"; // string | The userId to whom the Time Off Request applies.
$timeOffRequestId = "timeOffRequestId_example"; // string | Time Off Request Id

try {
    $result = $api_instance->getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId($muId, $userId, $timeOffRequestId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getWorkforcemanagementManagementunitsMuIdUsersUserIdTimeoffrequestsTimeoffrequestId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **muId** | **string**| The muId of the management unit. |
 **userId** | **string**| The userId to whom the Time Off Request applies. |
 **timeOffRequestId** | **string**| Time Off Request Id |

### Return type

[**\PureCloudSDK\TimeOffRequest**](../Model/TimeOffRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkforcemanagementTimeoffrequests**
> \PureCloudSDK\TimeOffRequestList getWorkforcemanagementTimeoffrequests($recentlyReviewed)

Get a list of time off requests for the current user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$recentlyReviewed = false; // bool | Limit results to requests that have been reviewed within the preceding 30 days

try {
    $result = $api_instance->getWorkforcemanagementTimeoffrequests($recentlyReviewed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getWorkforcemanagementTimeoffrequests: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recentlyReviewed** | **bool**| Limit results to requests that have been reviewed within the preceding 30 days | [optional] [default to false]

### Return type

[**\PureCloudSDK\TimeOffRequestList**](../Model/TimeOffRequestList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkforcemanagementTimeoffrequestsTimeoffrequestId**
> \PureCloudSDK\TimeOffRequest getWorkforcemanagementTimeoffrequestsTimeoffrequestId($timeOffRequestId)

Get a time off request for the current user by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$timeOffRequestId = "timeOffRequestId_example"; // string | Time Off Request Id

try {
    $result = $api_instance->getWorkforcemanagementTimeoffrequestsTimeoffrequestId($timeOffRequestId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getWorkforcemanagementTimeoffrequestsTimeoffrequestId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **timeOffRequestId** | **string**| Time Off Request Id |

### Return type

[**\PureCloudSDK\TimeOffRequest**](../Model/TimeOffRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchWorkforcemanagementTimeoffrequestsTimeoffrequestId**
> patchWorkforcemanagementTimeoffrequestsTimeoffrequestId($timeOffRequestId, $body)

Mark a time off request for the current user as read or unread



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$timeOffRequestId = "timeOffRequestId_example"; // string | Time Off Request Id
$body = new \PureCloudSDK\TimeOffRequestPatch(); // \PureCloudSDK\TimeOffRequestPatch | 

try {
    $api_instance->patchWorkforcemanagementTimeoffrequestsTimeoffrequestId($timeOffRequestId, $body);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->patchWorkforcemanagementTimeoffrequestsTimeoffrequestId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **timeOffRequestId** | **string**| Time Off Request Id |
 **body** | [**\PureCloudSDK\TimeOffRequestPatch**](../Model/\PureCloudSDK\TimeOffRequestPatch.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkforcemanagementLongtermforecasts**
> \PureCloudSDK\ForecastCreationCompletion postWorkforcemanagementLongtermforecasts($body)

Create a forecast



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$body = new \PureCloudSDK\ForecastCreation(); // \PureCloudSDK\ForecastCreation | The request body

try {
    $result = $api_instance->postWorkforcemanagementLongtermforecasts($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->postWorkforcemanagementLongtermforecasts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ForecastCreation**](../Model/\PureCloudSDK\ForecastCreation.md)| The request body |

### Return type

[**\PureCloudSDK\ForecastCreationCompletion**](../Model/ForecastCreationCompletion.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

