# DomainLogicalInterface

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** | The name of the entity. | 
**description** | **string** |  | [optional] 
**version** | **int** |  | [optional] 
**dateCreated** | [**\DateTime**](\DateTime.md) | Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**dateModified** | [**\DateTime**](\DateTime.md) | Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**modifiedBy** | **string** |  | [optional] 
**createdBy** | **string** |  | [optional] 
**state** | **string** |  | [optional] 
**modifiedByApp** | **string** |  | [optional] 
**createdByApp** | **string** |  | [optional] 
**edgeUri** | **string** |  | [optional] 
**edgeAssignedId** | **string** |  | [optional] 
**friendlyName** | **string** | Friendly Name | 
**vlanTagId** | **int** |  | [optional] 
**hardwareAddress** | **string** | Hardware Address | 
**physicalAdapterId** | **string** | Physical Adapter Id | 
**ifStatus** | **string** |  | [optional] 
**interfaceType** | **string** | The type of this network interface. | [optional] 
**routes** | [**\PureCloudSDK\DomainNetworkRoute[]**](DomainNetworkRoute.md) | The list of routes assigned to this interface. | [optional] 
**addresses** | [**\PureCloudSDK\DomainNetworkAddress[]**](DomainNetworkAddress.md) | The list of IP addresses on this interface.  Priority of dns addresses are based on order in the list. | [optional] 
**ipv4Capabilities** | [**\PureCloudSDK\DomainCapabilities**](DomainCapabilities.md) | IPv4 interface settings. | [optional] 
**ipv6Capabilities** | [**\PureCloudSDK\DomainCapabilities**](DomainCapabilities.md) | IPv6 interface settings. | [optional] 
**currentState** | **string** |  | [optional] 
**lastModifiedUserId** | **string** |  | [optional] 
**lastModifiedCorrelationId** | **string** |  | [optional] 
**commandResponses** | [**\PureCloudSDK\DomainNetworkCommandResponse[]**](DomainNetworkCommandResponse.md) |  | [optional] 
**inheritPhoneTrunkBasesIPv4** | **bool** | The IPv4 phone trunk base assignment will be inherited from the Edge Group. | [optional] [default to false]
**inheritPhoneTrunkBasesIPv6** | **bool** | The IPv6 phone trunk base assignment will be inherited from the Edge Group. | [optional] [default to false]
**useForInternalEdgeCommunication** | **bool** | This interface will be used for all internal edge-to-edge communication using settings from the edgeTrunkBaseAssignment on the Edge Group. | [optional] [default to false]
**externalTrunkBaseAssignments** | [**\PureCloudSDK\TrunkBaseAssignment[]**](TrunkBaseAssignment.md) | External trunk base settings to use for external communication from this interface. | [optional] 
**phoneTrunkBaseAssignments** | [**\PureCloudSDK\TrunkBaseAssignment[]**](TrunkBaseAssignment.md) | Phone trunk base settings to use for phone communication from this interface.  These settings will be ignored when \&quot;inheritPhoneTrunkBases\&quot; is true. | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


