<?php

/**
 * CreateActivityCodeRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateActivityCodeRequest Class Doc Comment
 *
 * @category    Class */
 // @description Activity Code
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateActivityCodeRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateActivityCodeRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'category' => 'string',
        'lengthInMinutes' => 'int',
        'countsAsPaidTime' => 'bool',
        'countsAsWorkTime' => 'bool',
        'agentTimeOffSelectable' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'category' => 'category',
        'lengthInMinutes' => 'lengthInMinutes',
        'countsAsPaidTime' => 'countsAsPaidTime',
        'countsAsWorkTime' => 'countsAsWorkTime',
        'agentTimeOffSelectable' => 'agentTimeOffSelectable'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'category' => 'setCategory',
        'lengthInMinutes' => 'setLengthInMinutes',
        'countsAsPaidTime' => 'setCountsAsPaidTime',
        'countsAsWorkTime' => 'setCountsAsWorkTime',
        'agentTimeOffSelectable' => 'setAgentTimeOffSelectable'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'category' => 'getCategory',
        'lengthInMinutes' => 'getLengthInMinutes',
        'countsAsPaidTime' => 'getCountsAsPaidTime',
        'countsAsWorkTime' => 'getCountsAsWorkTime',
        'agentTimeOffSelectable' => 'getAgentTimeOffSelectable'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const CATEGORY_BREAK = 'Break';
    public const CATEGORY_MEAL = 'Meal';
    public const CATEGORY_MEETING = 'Meeting';
    public const CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const CATEGORY_TIME_OFF = 'TimeOff';
    public const CATEGORY_TRAINING = 'Training';
    public const CATEGORY_UNAVAILABLE = 'Unavailable';
    public const CATEGORY_UNSCHEDULED = 'Unscheduled';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCategoryAllowableValues()
    {
        return [
            self::CATEGORY_ON_QUEUE_WORK,
            self::CATEGORY_BREAK,
            self::CATEGORY_MEAL,
            self::CATEGORY_MEETING,
            self::CATEGORY_OFF_QUEUE_WORK,
            self::CATEGORY_TIME_OFF,
            self::CATEGORY_TRAINING,
            self::CATEGORY_UNAVAILABLE,
            self::CATEGORY_UNSCHEDULED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['category'] = isset($data['category']) ? $data['category'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['countsAsPaidTime'] = isset($data['countsAsPaidTime']) ? $data['countsAsPaidTime'] : null;
        $this->container['countsAsWorkTime'] = isset($data['countsAsWorkTime']) ? $data['countsAsWorkTime'] : null;
        $this->container['agentTimeOffSelectable'] = isset($data['agentTimeOffSelectable']) ? $data['agentTimeOffSelectable'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['category'] === null) {
            $invalid_properties[] = "'category' can't be null";
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['category'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'category', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['category'] === null) {
            return false;
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['category'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the activity code
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets category
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     * @param string $category The activity code's category
     * @return $this
     */
    public function setCategory($category)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($category, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'category', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes The default length of the activity in minutes
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets countsAsPaidTime
     * @return bool
     */
    public function getCountsAsPaidTime()
    {
        return $this->container['countsAsPaidTime'];
    }

    /**
     * Sets countsAsPaidTime
     * @param bool $countsAsPaidTime Whether an agent is paid while performing this activity
     * @return $this
     */
    public function setCountsAsPaidTime($countsAsPaidTime)
    {
        $this->container['countsAsPaidTime'] = $countsAsPaidTime;

        return $this;
    }

    /**
     * Gets countsAsWorkTime
     * @return bool
     */
    public function getCountsAsWorkTime()
    {
        return $this->container['countsAsWorkTime'];
    }

    /**
     * Sets countsAsWorkTime
     * @param bool $countsAsWorkTime Indicates whether or not the activity should be counted as work time
     * @return $this
     */
    public function setCountsAsWorkTime($countsAsWorkTime)
    {
        $this->container['countsAsWorkTime'] = $countsAsWorkTime;

        return $this;
    }

    /**
     * Gets agentTimeOffSelectable
     * @return bool
     */
    public function getAgentTimeOffSelectable()
    {
        return $this->container['agentTimeOffSelectable'];
    }

    /**
     * Sets agentTimeOffSelectable
     * @param bool $agentTimeOffSelectable Whether an agent can select this activity code when creating or editing a time off request
     * @return $this
     */
    public function setAgentTimeOffSelectable($agentTimeOffSelectable)
    {
        $this->container['agentTimeOffSelectable'] = $agentTimeOffSelectable;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


