<?php

/**
 * CreateManagementUnitApiRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateManagementUnitApiRequest Class Doc Comment
 *
 * @category    Class */
 // @description Create Management Unit
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateManagementUnitApiRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateManagementUnitApiRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'timeZone' => 'string',
        'startDayOfWeek' => 'string',
        'settings' => '\PureCloudSDK\CreateManagementUnitSettings',
        'divisionId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'timeZone' => 'timeZone',
        'startDayOfWeek' => 'startDayOfWeek',
        'settings' => 'settings',
        'divisionId' => 'divisionId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'timeZone' => 'setTimeZone',
        'startDayOfWeek' => 'setStartDayOfWeek',
        'settings' => 'setSettings',
        'divisionId' => 'setDivisionId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'timeZone' => 'getTimeZone',
        'startDayOfWeek' => 'getStartDayOfWeek',
        'settings' => 'getSettings',
        'divisionId' => 'getDivisionId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const START_DAY_OF_WEEK_SUNDAY = 'Sunday';
    public const START_DAY_OF_WEEK_MONDAY = 'Monday';
    public const START_DAY_OF_WEEK_TUESDAY = 'Tuesday';
    public const START_DAY_OF_WEEK_WEDNESDAY = 'Wednesday';
    public const START_DAY_OF_WEEK_THURSDAY = 'Thursday';
    public const START_DAY_OF_WEEK_FRIDAY = 'Friday';
    public const START_DAY_OF_WEEK_SATURDAY = 'Saturday';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStartDayOfWeekAllowableValues()
    {
        return [
            self::START_DAY_OF_WEEK_SUNDAY,
            self::START_DAY_OF_WEEK_MONDAY,
            self::START_DAY_OF_WEEK_TUESDAY,
            self::START_DAY_OF_WEEK_WEDNESDAY,
            self::START_DAY_OF_WEEK_THURSDAY,
            self::START_DAY_OF_WEEK_FRIDAY,
            self::START_DAY_OF_WEEK_SATURDAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['startDayOfWeek'] = isset($data['startDayOfWeek']) ? $data['startDayOfWeek'] : null;
        $this->container['settings'] = isset($data['settings']) ? $data['settings'] : null;
        $this->container['divisionId'] = isset($data['divisionId']) ? $data['divisionId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['timeZone'] === null) {
            $invalid_properties[] = "'timeZone' can't be null";
        }
        if ($this->container['startDayOfWeek'] === null) {
            $invalid_properties[] = "'startDayOfWeek' can't be null";
        }
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'startDayOfWeek', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['timeZone'] === null) {
            return false;
        }
        if ($this->container['startDayOfWeek'] === null) {
            return false;
        }
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the management unit
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone The default time zone to use for this management unit
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets startDayOfWeek
     * @return string
     */
    public function getStartDayOfWeek()
    {
        return $this->container['startDayOfWeek'];
    }

    /**
     * Sets startDayOfWeek
     * @param string $startDayOfWeek The configured first day of the week for scheduling and forecasting purposes
     * @return $this
     */
    public function setStartDayOfWeek($startDayOfWeek)
    {
        $allowed_values = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        if (!in_array($startDayOfWeek, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'startDayOfWeek', must be one of 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'");
        }
        $this->container['startDayOfWeek'] = $startDayOfWeek;

        return $this;
    }

    /**
     * Gets settings
     * @return \PureCloudSDK\CreateManagementUnitSettings
     */
    public function getSettings()
    {
        return $this->container['settings'];
    }

    /**
     * Sets settings
     * @param \PureCloudSDK\CreateManagementUnitSettings $settings The configuration for the management unit.  If omitted, reasonable defaults will be assigned
     * @return $this
     */
    public function setSettings($settings)
    {
        $this->container['settings'] = $settings;

        return $this;
    }

    /**
     * Gets divisionId
     * @return string
     */
    public function getDivisionId()
    {
        return $this->container['divisionId'];
    }

    /**
     * Sets divisionId
     * @param string $divisionId The division to which this management unit belongs.  Defaults to home division ID
     * @return $this
     */
    public function setDivisionId($divisionId)
    {
        $this->container['divisionId'] = $divisionId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


