<?php

/**
 * ShiftTradeActivityRule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ShiftTradeActivityRule Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ShiftTradeActivityRule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ShiftTradeActivityRule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'activityCategory' => 'string',
        'action' => 'string',
        'activityCodeIdReplacement' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'activityCategory' => 'activityCategory',
        'action' => 'action',
        'activityCodeIdReplacement' => 'activityCodeIdReplacement'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'activityCategory' => 'setActivityCategory',
        'action' => 'setAction',
        'activityCodeIdReplacement' => 'setActivityCodeIdReplacement'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'activityCategory' => 'getActivityCategory',
        'action' => 'getAction',
        'activityCodeIdReplacement' => 'getActivityCodeIdReplacement'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const ACTIVITY_CATEGORY_BREAK = 'Break';
    public const ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    public const ACTION_REPLACE = 'Replace';
    public const ACTION_DO_NOT_ALLOW_TRADE = 'DoNotAllowTrade';
    public const ACTION_KEEP_WITH_SCHEDULE = 'KeepWithSchedule';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActivityCategoryAllowableValues()
    {
        return [
            self::ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::ACTIVITY_CATEGORY_BREAK,
            self::ACTIVITY_CATEGORY_MEAL,
            self::ACTIVITY_CATEGORY_MEETING,
            self::ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::ACTIVITY_CATEGORY_TIME_OFF,
            self::ACTIVITY_CATEGORY_TRAINING,
            self::ACTIVITY_CATEGORY_UNAVAILABLE,
            self::ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionAllowableValues()
    {
        return [
            self::ACTION_REPLACE,
            self::ACTION_DO_NOT_ALLOW_TRADE,
            self::ACTION_KEEP_WITH_SCHEDULE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['activityCategory'] = isset($data['activityCategory']) ? $data['activityCategory'] : null;
        $this->container['action'] = isset($data['action']) ? $data['action'] : null;
        $this->container['activityCodeIdReplacement'] = isset($data['activityCodeIdReplacement']) ? $data['activityCodeIdReplacement'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['activityCategory'] === null) {
            $invalid_properties[] = "'activityCategory' can't be null";
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['activityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'activityCategory', must be one of #{allowed_values}.";
        }

        if ($this->container['action'] === null) {
            $invalid_properties[] = "'action' can't be null";
        }
        $allowed_values = array("Replace", "DoNotAllowTrade", "KeepWithSchedule");
        if (!in_array($this->container['action'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'action', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['activityCategory'] === null) {
            return false;
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['activityCategory'], $allowed_values)) {
            return false;
        }
        if ($this->container['action'] === null) {
            return false;
        }
        $allowed_values = array("Replace", "DoNotAllowTrade", "KeepWithSchedule");
        if (!in_array($this->container['action'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets activityCategory
     * @return string
     */
    public function getActivityCategory()
    {
        return $this->container['activityCategory'];
    }

    /**
     * Sets activityCategory
     * @param string $activityCategory The activity category to which to apply this rule
     * @return $this
     */
    public function setActivityCategory($activityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($activityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'activityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['activityCategory'] = $activityCategory;

        return $this;
    }

    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     * @param string $action The action this rule invokes
     * @return $this
     */
    public function setAction($action)
    {
        $allowed_values = array('Replace', 'DoNotAllowTrade', 'KeepWithSchedule');
        if (!in_array($action, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'action', must be one of 'Replace', 'DoNotAllowTrade', 'KeepWithSchedule'");
        }
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets activityCodeIdReplacement
     * @return string
     */
    public function getActivityCodeIdReplacement()
    {
        return $this->container['activityCodeIdReplacement'];
    }

    /**
     * Sets activityCodeIdReplacement
     * @param string $activityCodeIdReplacement The activity code ID with which to replace activities belonging to the original category if applicable (required if action == Replace, must be a default activity code ID)
     * @return $this
     */
    public function setActivityCodeIdReplacement($activityCodeIdReplacement)
    {
        $this->container['activityCodeIdReplacement'] = $activityCodeIdReplacement;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


