<?php

/**
 * TimeZoneMappingPreview
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TimeZoneMappingPreview Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TimeZoneMappingPreview implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TimeZoneMappingPreview';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'contactList' => '\PureCloudSDK\UriReference',
        'contactsPerTimeZone' => 'map[string,int]',
        'contactsMappedUsingZipCode' => 'map[string,int]',
        'contactsMappedToASingleZone' => 'int',
        'contactsMappedToASingleZoneUsingZipCode' => 'int',
        'contactsMappedToMultipleZones' => 'int',
        'contactsMappedToMultipleZonesUsingZipCode' => 'int',
        'contactsInDefaultWindow' => 'int',
        'contactListSize' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'contactList' => 'contactList',
        'contactsPerTimeZone' => 'contactsPerTimeZone',
        'contactsMappedUsingZipCode' => 'contactsMappedUsingZipCode',
        'contactsMappedToASingleZone' => 'contactsMappedToASingleZone',
        'contactsMappedToASingleZoneUsingZipCode' => 'contactsMappedToASingleZoneUsingZipCode',
        'contactsMappedToMultipleZones' => 'contactsMappedToMultipleZones',
        'contactsMappedToMultipleZonesUsingZipCode' => 'contactsMappedToMultipleZonesUsingZipCode',
        'contactsInDefaultWindow' => 'contactsInDefaultWindow',
        'contactListSize' => 'contactListSize'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'contactList' => 'setContactList',
        'contactsPerTimeZone' => 'setContactsPerTimeZone',
        'contactsMappedUsingZipCode' => 'setContactsMappedUsingZipCode',
        'contactsMappedToASingleZone' => 'setContactsMappedToASingleZone',
        'contactsMappedToASingleZoneUsingZipCode' => 'setContactsMappedToASingleZoneUsingZipCode',
        'contactsMappedToMultipleZones' => 'setContactsMappedToMultipleZones',
        'contactsMappedToMultipleZonesUsingZipCode' => 'setContactsMappedToMultipleZonesUsingZipCode',
        'contactsInDefaultWindow' => 'setContactsInDefaultWindow',
        'contactListSize' => 'setContactListSize'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'contactList' => 'getContactList',
        'contactsPerTimeZone' => 'getContactsPerTimeZone',
        'contactsMappedUsingZipCode' => 'getContactsMappedUsingZipCode',
        'contactsMappedToASingleZone' => 'getContactsMappedToASingleZone',
        'contactsMappedToASingleZoneUsingZipCode' => 'getContactsMappedToASingleZoneUsingZipCode',
        'contactsMappedToMultipleZones' => 'getContactsMappedToMultipleZones',
        'contactsMappedToMultipleZonesUsingZipCode' => 'getContactsMappedToMultipleZonesUsingZipCode',
        'contactsInDefaultWindow' => 'getContactsInDefaultWindow',
        'contactListSize' => 'getContactListSize'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['contactList'] = isset($data['contactList']) ? $data['contactList'] : null;
        $this->container['contactsPerTimeZone'] = isset($data['contactsPerTimeZone']) ? $data['contactsPerTimeZone'] : null;
        $this->container['contactsMappedUsingZipCode'] = isset($data['contactsMappedUsingZipCode']) ? $data['contactsMappedUsingZipCode'] : null;
        $this->container['contactsMappedToASingleZone'] = isset($data['contactsMappedToASingleZone']) ? $data['contactsMappedToASingleZone'] : null;
        $this->container['contactsMappedToASingleZoneUsingZipCode'] = isset($data['contactsMappedToASingleZoneUsingZipCode']) ? $data['contactsMappedToASingleZoneUsingZipCode'] : null;
        $this->container['contactsMappedToMultipleZones'] = isset($data['contactsMappedToMultipleZones']) ? $data['contactsMappedToMultipleZones'] : null;
        $this->container['contactsMappedToMultipleZonesUsingZipCode'] = isset($data['contactsMappedToMultipleZonesUsingZipCode']) ? $data['contactsMappedToMultipleZonesUsingZipCode'] : null;
        $this->container['contactsInDefaultWindow'] = isset($data['contactsInDefaultWindow']) ? $data['contactsInDefaultWindow'] : null;
        $this->container['contactListSize'] = isset($data['contactListSize']) ? $data['contactListSize'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets contactList
     * @return \PureCloudSDK\UriReference
     */
    public function getContactList()
    {
        return $this->container['contactList'];
    }

    /**
     * Sets contactList
     * @param \PureCloudSDK\UriReference $contactList The associated ContactList
     * @return $this
     */
    public function setContactList($contactList)
    {
        $this->container['contactList'] = $contactList;

        return $this;
    }

    /**
     * Gets contactsPerTimeZone
     * @return map[string,int]
     */
    public function getContactsPerTimeZone()
    {
        return $this->container['contactsPerTimeZone'];
    }

    /**
     * Sets contactsPerTimeZone
     * @param map[string,int] $contactsPerTimeZone The number of contacts per time zone that mapped to only that time zone
     * @return $this
     */
    public function setContactsPerTimeZone($contactsPerTimeZone)
    {
        $this->container['contactsPerTimeZone'] = $contactsPerTimeZone;

        return $this;
    }

    /**
     * Gets contactsMappedUsingZipCode
     * @return map[string,int]
     */
    public function getContactsMappedUsingZipCode()
    {
        return $this->container['contactsMappedUsingZipCode'];
    }

    /**
     * Sets contactsMappedUsingZipCode
     * @param map[string,int] $contactsMappedUsingZipCode The number of contacts per time zone that mapped to only that time zone and were mapped using the zip code column
     * @return $this
     */
    public function setContactsMappedUsingZipCode($contactsMappedUsingZipCode)
    {
        $this->container['contactsMappedUsingZipCode'] = $contactsMappedUsingZipCode;

        return $this;
    }

    /**
     * Gets contactsMappedToASingleZone
     * @return int
     */
    public function getContactsMappedToASingleZone()
    {
        return $this->container['contactsMappedToASingleZone'];
    }

    /**
     * Sets contactsMappedToASingleZone
     * @param int $contactsMappedToASingleZone The total number of contacts that mapped to a single time zone
     * @return $this
     */
    public function setContactsMappedToASingleZone($contactsMappedToASingleZone)
    {
        $this->container['contactsMappedToASingleZone'] = $contactsMappedToASingleZone;

        return $this;
    }

    /**
     * Gets contactsMappedToASingleZoneUsingZipCode
     * @return int
     */
    public function getContactsMappedToASingleZoneUsingZipCode()
    {
        return $this->container['contactsMappedToASingleZoneUsingZipCode'];
    }

    /**
     * Sets contactsMappedToASingleZoneUsingZipCode
     * @param int $contactsMappedToASingleZoneUsingZipCode The total number of contacts that mapped to a single time zone and were mapped using the zip code column
     * @return $this
     */
    public function setContactsMappedToASingleZoneUsingZipCode($contactsMappedToASingleZoneUsingZipCode)
    {
        $this->container['contactsMappedToASingleZoneUsingZipCode'] = $contactsMappedToASingleZoneUsingZipCode;

        return $this;
    }

    /**
     * Gets contactsMappedToMultipleZones
     * @return int
     */
    public function getContactsMappedToMultipleZones()
    {
        return $this->container['contactsMappedToMultipleZones'];
    }

    /**
     * Sets contactsMappedToMultipleZones
     * @param int $contactsMappedToMultipleZones The total number of contacts that mapped to multiple time zones
     * @return $this
     */
    public function setContactsMappedToMultipleZones($contactsMappedToMultipleZones)
    {
        $this->container['contactsMappedToMultipleZones'] = $contactsMappedToMultipleZones;

        return $this;
    }

    /**
     * Gets contactsMappedToMultipleZonesUsingZipCode
     * @return int
     */
    public function getContactsMappedToMultipleZonesUsingZipCode()
    {
        return $this->container['contactsMappedToMultipleZonesUsingZipCode'];
    }

    /**
     * Sets contactsMappedToMultipleZonesUsingZipCode
     * @param int $contactsMappedToMultipleZonesUsingZipCode The total number of contacts that mapped to multiple time zones and were mapped using the zip code column
     * @return $this
     */
    public function setContactsMappedToMultipleZonesUsingZipCode($contactsMappedToMultipleZonesUsingZipCode)
    {
        $this->container['contactsMappedToMultipleZonesUsingZipCode'] = $contactsMappedToMultipleZonesUsingZipCode;

        return $this;
    }

    /**
     * Gets contactsInDefaultWindow
     * @return int
     */
    public function getContactsInDefaultWindow()
    {
        return $this->container['contactsInDefaultWindow'];
    }

    /**
     * Sets contactsInDefaultWindow
     * @param int $contactsInDefaultWindow The total number of contacts that will be dialed during the default window
     * @return $this
     */
    public function setContactsInDefaultWindow($contactsInDefaultWindow)
    {
        $this->container['contactsInDefaultWindow'] = $contactsInDefaultWindow;

        return $this;
    }

    /**
     * Gets contactListSize
     * @return int
     */
    public function getContactListSize()
    {
        return $this->container['contactListSize'];
    }

    /**
     * Sets contactListSize
     * @param int $contactListSize The total number of contacts in the contact list
     * @return $this
     */
    public function setContactListSize($contactListSize)
    {
        $this->container['contactListSize'] = $contactListSize;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


