<?php

/**
 * ContentManagementApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * ContentManagementApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ContentManagementApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return ContentManagementApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteContentmanagementDocument
     *
     * Delete a document.
     *
     * @param string $documentId Document ID (required)
     * @param bool $override Override any lock on the document (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementDocument($documentId, $override = null)
    {
        list($response) = $this->deleteContentmanagementDocumentWithHttpInfo($documentId, $override);
        return $response;
    }

    /**
     * Operation deleteContentmanagementDocumentWithHttpInfo
     *
     * Delete a document.
     *
     * @param string $documentId Document ID (required)
     * @param bool $override Override any lock on the document (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementDocumentWithHttpInfo($documentId, $override = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling deleteContentmanagementDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($override !== null) {
            $queryParams['override'] = $this->apiClient->getSerializer()->toQueryValue($override);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/documents/{documentId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContentmanagementShare
     *
     * Deletes an existing share.
     *
     * @param string $shareId Share ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementShare($shareId)
    {
        list($response) = $this->deleteContentmanagementShareWithHttpInfo($shareId);
        return $response;
    }

    /**
     * Operation deleteContentmanagementShareWithHttpInfo
     *
     * Deletes an existing share.
     *
     * @param string $shareId Share ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementShareWithHttpInfo($shareId)
    {
        // verify the required parameter 'shareId' is set
        if ($shareId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $shareId when calling deleteContentmanagementShare');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/shares/{shareId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($shareId !== null) {
            $resourcePath = str_replace(
                "{" . "shareId" . "}",
                $this->apiClient->getSerializer()->toPathValue($shareId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/shares/{shareId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContentmanagementStatusStatusId
     *
     * Cancel the command for this status
     *
     * @param string $statusId Status ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementStatusStatusId($statusId)
    {
        list($response) = $this->deleteContentmanagementStatusStatusIdWithHttpInfo($statusId);
        return $response;
    }

    /**
     * Operation deleteContentmanagementStatusStatusIdWithHttpInfo
     *
     * Cancel the command for this status
     *
     * @param string $statusId Status ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementStatusStatusIdWithHttpInfo($statusId)
    {
        // verify the required parameter 'statusId' is set
        if ($statusId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $statusId when calling deleteContentmanagementStatusStatusId');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/status/{statusId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($statusId !== null) {
            $resourcePath = str_replace(
                "{" . "statusId" . "}",
                $this->apiClient->getSerializer()->toPathValue($statusId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/status/{statusId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContentmanagementWorkspace
     *
     * Delete a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $moveChildrenToWorkspaceId New location for objects in deleted workspace. (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspace($workspaceId, $moveChildrenToWorkspaceId = null)
    {
        list($response) = $this->deleteContentmanagementWorkspaceWithHttpInfo($workspaceId, $moveChildrenToWorkspaceId);
        return $response;
    }

    /**
     * Operation deleteContentmanagementWorkspaceWithHttpInfo
     *
     * Delete a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $moveChildrenToWorkspaceId New location for objects in deleted workspace. (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspaceWithHttpInfo($workspaceId, $moveChildrenToWorkspaceId = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling deleteContentmanagementWorkspace');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($moveChildrenToWorkspaceId !== null) {
            $queryParams['moveChildrenToWorkspaceId'] = $this->apiClient->getSerializer()->toQueryValue($moveChildrenToWorkspaceId);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/workspaces/{workspaceId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContentmanagementWorkspaceMember
     *
     * Delete a member from a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspaceMember($workspaceId, $memberId)
    {
        list($response) = $this->deleteContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId);
        return $response;
    }

    /**
     * Operation deleteContentmanagementWorkspaceMemberWithHttpInfo
     *
     * Delete a member from a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling deleteContentmanagementWorkspaceMember');
        }
        // verify the required parameter 'memberId' is set
        if ($memberId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $memberId when calling deleteContentmanagementWorkspaceMember');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($memberId !== null) {
            $resourcePath = str_replace(
                "{" . "memberId" . "}",
                $this->apiClient->getSerializer()->toPathValue($memberId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContentmanagementWorkspaceTagvalue
     *
     * Delete workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspaceTagvalue($workspaceId, $tagId)
    {
        list($response) = $this->deleteContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId);
        return $response;
    }

    /**
     * Operation deleteContentmanagementWorkspaceTagvalueWithHttpInfo
     *
     * Delete workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling deleteContentmanagementWorkspaceTagvalue');
        }
        // verify the required parameter 'tagId' is set
        if ($tagId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $tagId when calling deleteContentmanagementWorkspaceTagvalue');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($tagId !== null) {
            $resourcePath = str_replace(
                "{" . "tagId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tagId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementDocument
     *
     * Get a document.
     *
     * @param string $documentId Document ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\Document
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocument($documentId, $expand = null)
    {
        list($response) = $this->getContentmanagementDocumentWithHttpInfo($documentId, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementDocumentWithHttpInfo
     *
     * Get a document.
     *
     * @param string $documentId Document ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\Document, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentWithHttpInfo($documentId, $expand = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling getContentmanagementDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Document',
                '/api/v2/contentmanagement/documents/{documentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Document', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Document', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementDocumentAudits
     *
     * Get a list of audits for a document.
     *
     * @param string $documentId Document ID (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $transactionFilter Transaction filter (optional)
     * @param string $level level (optional, default to USER)
     * @param string $sortBy Sort by (optional)
     * @param string $sortOrder Sort order (optional, default to ascending)
     * @return \PureCloudSDK\DocumentAuditEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentAudits($documentId, $pageSize = null, $pageNumber = null, $transactionFilter = null, $level = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getContentmanagementDocumentAuditsWithHttpInfo($documentId, $pageSize, $pageNumber, $transactionFilter, $level, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getContentmanagementDocumentAuditsWithHttpInfo
     *
     * Get a list of audits for a document.
     *
     * @param string $documentId Document ID (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $transactionFilter Transaction filter (optional)
     * @param string $level level (optional, default to USER)
     * @param string $sortBy Sort by (optional)
     * @param string $sortOrder Sort order (optional, default to ascending)
     * @return Array of \PureCloudSDK\DocumentAuditEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentAuditsWithHttpInfo($documentId, $pageSize = null, $pageNumber = null, $transactionFilter = null, $level = null, $sortBy = null, $sortOrder = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling getContentmanagementDocumentAudits');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}/audits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($transactionFilter !== null) {
            $queryParams['transactionFilter'] = $this->apiClient->getSerializer()->toQueryValue($transactionFilter);
        }
        // query params
        if ($level !== null) {
            $queryParams['level'] = $this->apiClient->getSerializer()->toQueryValue($level);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DocumentAuditEntityListing',
                '/api/v2/contentmanagement/documents/{documentId}/audits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DocumentAuditEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DocumentAuditEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementDocumentContent
     *
     * Download a document.
     *
     * @param string $documentId Document ID (required)
     * @param string $disposition Request how the content will be downloaded: a file attachment or inline. Default is attachment. (optional)
     * @param string $contentType The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav (optional)
     * @return \PureCloudSDK\DownloadResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentContent($documentId, $disposition = null, $contentType = null)
    {
        list($response) = $this->getContentmanagementDocumentContentWithHttpInfo($documentId, $disposition, $contentType);
        return $response;
    }

    /**
     * Operation getContentmanagementDocumentContentWithHttpInfo
     *
     * Download a document.
     *
     * @param string $documentId Document ID (required)
     * @param string $disposition Request how the content will be downloaded: a file attachment or inline. Default is attachment. (optional)
     * @param string $contentType The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav (optional)
     * @return Array of \PureCloudSDK\DownloadResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentContentWithHttpInfo($documentId, $disposition = null, $contentType = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling getContentmanagementDocumentContent');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}/content";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($disposition !== null) {
            $queryParams['disposition'] = $this->apiClient->getSerializer()->toQueryValue($disposition);
        }
        // query params
        if ($contentType !== null) {
            $queryParams['contentType'] = $this->apiClient->getSerializer()->toQueryValue($contentType);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DownloadResponse',
                '/api/v2/contentmanagement/documents/{documentId}/content'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DownloadResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DownloadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementDocuments
     *
     * Get a list of documents.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $name Name (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @return \PureCloudSDK\DocumentEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocuments($workspaceId, $name = null, $expand = null, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getContentmanagementDocumentsWithHttpInfo($workspaceId, $name, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getContentmanagementDocumentsWithHttpInfo
     *
     * Get a list of documents.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $name Name (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @return Array of \PureCloudSDK\DocumentEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementDocumentsWithHttpInfo($workspaceId, $name = null, $expand = null, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($workspaceId !== null) {
            $queryParams['workspaceId'] = $this->apiClient->getSerializer()->toQueryValue($workspaceId);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DocumentEntityListing',
                '/api/v2/contentmanagement/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DocumentEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DocumentEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementQuery
     *
     * Query content
     *
     * @param string $queryPhrase Phrase tokens are ANDed together over all searchable fields (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional, default to name)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\QueryResults
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementQuery($queryPhrase, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null, $expand = null)
    {
        list($response) = $this->getContentmanagementQueryWithHttpInfo($queryPhrase, $pageSize, $pageNumber, $sortBy, $sortOrder, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementQueryWithHttpInfo
     *
     * Query content
     *
     * @param string $queryPhrase Phrase tokens are ANDed together over all searchable fields (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional, default to name)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\QueryResults, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementQueryWithHttpInfo($queryPhrase, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null, $expand = null)
    {
        // verify the required parameter 'queryPhrase' is set
        if ($queryPhrase === null) {
            throw new \InvalidArgumentException('Missing the required parameter $queryPhrase when calling getContentmanagementQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($queryPhrase !== null) {
            $queryParams['queryPhrase'] = $this->apiClient->getSerializer()->toQueryValue($queryPhrase);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\QueryResults',
                '/api/v2/contentmanagement/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\QueryResults', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\QueryResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementSecurityprofile
     *
     * Get a Security Profile
     *
     * @param string $securityProfileId Security Profile Id (required)
     * @return \PureCloudSDK\SecurityProfile
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSecurityprofile($securityProfileId)
    {
        list($response) = $this->getContentmanagementSecurityprofileWithHttpInfo($securityProfileId);
        return $response;
    }

    /**
     * Operation getContentmanagementSecurityprofileWithHttpInfo
     *
     * Get a Security Profile
     *
     * @param string $securityProfileId Security Profile Id (required)
     * @return Array of \PureCloudSDK\SecurityProfile, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSecurityprofileWithHttpInfo($securityProfileId)
    {
        // verify the required parameter 'securityProfileId' is set
        if ($securityProfileId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $securityProfileId when calling getContentmanagementSecurityprofile');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/securityprofiles/{securityProfileId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($securityProfileId !== null) {
            $resourcePath = str_replace(
                "{" . "securityProfileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($securityProfileId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SecurityProfile',
                '/api/v2/contentmanagement/securityprofiles/{securityProfileId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SecurityProfile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SecurityProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementSecurityprofiles
     *
     * Get a List of Security Profiles
     *
     * @return \PureCloudSDK\SecurityProfileEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSecurityprofiles()
    {
        list($response) = $this->getContentmanagementSecurityprofilesWithHttpInfo();
        return $response;
    }

    /**
     * Operation getContentmanagementSecurityprofilesWithHttpInfo
     *
     * Get a List of Security Profiles
     *
     * @return Array of \PureCloudSDK\SecurityProfileEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSecurityprofilesWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/securityprofiles";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SecurityProfileEntityListing',
                '/api/v2/contentmanagement/securityprofiles'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SecurityProfileEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SecurityProfileEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementShare
     *
     * Retrieve details about an existing share.
     *
     * @param string $shareId Share ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\Share
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementShare($shareId, $expand = null)
    {
        list($response) = $this->getContentmanagementShareWithHttpInfo($shareId, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementShareWithHttpInfo
     *
     * Retrieve details about an existing share.
     *
     * @param string $shareId Share ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\Share, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementShareWithHttpInfo($shareId, $expand = null)
    {
        // verify the required parameter 'shareId' is set
        if ($shareId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $shareId when calling getContentmanagementShare');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/shares/{shareId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($shareId !== null) {
            $resourcePath = str_replace(
                "{" . "shareId" . "}",
                $this->apiClient->getSerializer()->toPathValue($shareId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Share',
                '/api/v2/contentmanagement/shares/{shareId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Share', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Share', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementSharedSharedId
     *
     * Get shared documents. Securely download a shared document.
     *
     * @param string $sharedId Shared ID (required)
     * @param bool $redirect Turn on or off redirect (optional, default to true)
     * @param string $disposition Request how the share content will be downloaded: attached as a file or inline. Default is attachment. (optional, default to attachment)
     * @param string $contentType The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav (optional)
     * @param string $expand Expand some document fields (optional)
     * @return \PureCloudSDK\SharedResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSharedSharedId($sharedId, $redirect = null, $disposition = null, $contentType = null, $expand = null)
    {
        list($response) = $this->getContentmanagementSharedSharedIdWithHttpInfo($sharedId, $redirect, $disposition, $contentType, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementSharedSharedIdWithHttpInfo
     *
     * Get shared documents. Securely download a shared document.
     *
     * @param string $sharedId Shared ID (required)
     * @param bool $redirect Turn on or off redirect (optional, default to true)
     * @param string $disposition Request how the share content will be downloaded: attached as a file or inline. Default is attachment. (optional, default to attachment)
     * @param string $contentType The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav (optional)
     * @param string $expand Expand some document fields (optional)
     * @return Array of \PureCloudSDK\SharedResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSharedSharedIdWithHttpInfo($sharedId, $redirect = null, $disposition = null, $contentType = null, $expand = null)
    {
        // verify the required parameter 'sharedId' is set
        if ($sharedId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sharedId when calling getContentmanagementSharedSharedId');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/shared/{sharedId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($redirect !== null) {
            $queryParams['redirect'] = $this->apiClient->getSerializer()->toQueryValue($redirect);
        }
        // query params
        if ($disposition !== null) {
            $queryParams['disposition'] = $this->apiClient->getSerializer()->toQueryValue($disposition);
        }
        // query params
        if ($contentType !== null) {
            $queryParams['contentType'] = $this->apiClient->getSerializer()->toQueryValue($contentType);
        }
        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($sharedId !== null) {
            $resourcePath = str_replace(
                "{" . "sharedId" . "}",
                $this->apiClient->getSerializer()->toPathValue($sharedId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SharedResponse',
                '/api/v2/contentmanagement/shared/{sharedId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SharedResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SharedResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementShares
     *
     * Gets a list of shares.  You must specify at least one filter (e.g. entityId).
     *
     * @param string $entityId Filters the shares returned to only the entity specified by the value of this parameter. (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return \PureCloudSDK\ShareEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementShares($entityId = null, $expand = null, $pageSize = null, $pageNumber = null)
    {
        list($response) = $this->getContentmanagementSharesWithHttpInfo($entityId, $expand, $pageSize, $pageNumber);
        return $response;
    }

    /**
     * Operation getContentmanagementSharesWithHttpInfo
     *
     * Gets a list of shares.  You must specify at least one filter (e.g. entityId).
     *
     * @param string $entityId Filters the shares returned to only the entity specified by the value of this parameter. (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return Array of \PureCloudSDK\ShareEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementSharesWithHttpInfo($entityId = null, $expand = null, $pageSize = null, $pageNumber = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/shares";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($entityId !== null) {
            $queryParams['entityId'] = $this->apiClient->getSerializer()->toQueryValue($entityId);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShareEntityListing',
                '/api/v2/contentmanagement/shares'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShareEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShareEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementStatus
     *
     * Get a list of statuses for pending operations
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return \PureCloudSDK\CommandStatusEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementStatus($pageSize = null, $pageNumber = null)
    {
        list($response) = $this->getContentmanagementStatusWithHttpInfo($pageSize, $pageNumber);
        return $response;
    }

    /**
     * Operation getContentmanagementStatusWithHttpInfo
     *
     * Get a list of statuses for pending operations
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return Array of \PureCloudSDK\CommandStatusEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementStatusWithHttpInfo($pageSize = null, $pageNumber = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/status";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CommandStatusEntityListing',
                '/api/v2/contentmanagement/status'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CommandStatusEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CommandStatusEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementStatusStatusId
     *
     * Get a status.
     *
     * @param string $statusId Status ID (required)
     * @return \PureCloudSDK\CommandStatus
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementStatusStatusId($statusId)
    {
        list($response) = $this->getContentmanagementStatusStatusIdWithHttpInfo($statusId);
        return $response;
    }

    /**
     * Operation getContentmanagementStatusStatusIdWithHttpInfo
     *
     * Get a status.
     *
     * @param string $statusId Status ID (required)
     * @return Array of \PureCloudSDK\CommandStatus, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementStatusStatusIdWithHttpInfo($statusId)
    {
        // verify the required parameter 'statusId' is set
        if ($statusId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $statusId when calling getContentmanagementStatusStatusId');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/status/{statusId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($statusId !== null) {
            $resourcePath = str_replace(
                "{" . "statusId" . "}",
                $this->apiClient->getSerializer()->toPathValue($statusId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CommandStatus',
                '/api/v2/contentmanagement/status/{statusId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CommandStatus', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CommandStatus', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementUsage
     *
     * Get usage details.
     *
     * @return \PureCloudSDK\Usage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementUsage()
    {
        list($response) = $this->getContentmanagementUsageWithHttpInfo();
        return $response;
    }

    /**
     * Operation getContentmanagementUsageWithHttpInfo
     *
     * Get usage details.
     *
     * @return Array of \PureCloudSDK\Usage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementUsageWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/usage";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Usage',
                '/api/v2/contentmanagement/usage'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Usage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Usage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspace
     *
     * Get a workspace.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\Workspace
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspace($workspaceId, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspaceWithHttpInfo($workspaceId, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceWithHttpInfo
     *
     * Get a workspace.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\Workspace, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceWithHttpInfo($workspaceId, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspace');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Workspace',
                '/api/v2/contentmanagement/workspaces/{workspaceId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Workspace', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaceDocuments
     *
     * Get a list of documents.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @return \PureCloudSDK\DocumentEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceDocuments($workspaceId, $expand = null, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getContentmanagementWorkspaceDocumentsWithHttpInfo($workspaceId, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceDocumentsWithHttpInfo
     *
     * Get a list of documents.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy name or dateCreated (optional)
     * @param string $sortOrder ascending or descending (optional, default to ascending)
     * @return Array of \PureCloudSDK\DocumentEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceDocumentsWithHttpInfo($workspaceId, $expand = null, $pageSize = null, $pageNumber = null, $sortBy = null, $sortOrder = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspaceDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DocumentEntityListing',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DocumentEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DocumentEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaceMember
     *
     * Get a workspace member
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\WorkspaceMember
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceMember($workspaceId, $memberId, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceMemberWithHttpInfo
     *
     * Get a workspace member
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\WorkspaceMember, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspaceMember');
        }
        // verify the required parameter 'memberId' is set
        if ($memberId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $memberId when calling getContentmanagementWorkspaceMember');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($memberId !== null) {
            $resourcePath = str_replace(
                "{" . "memberId" . "}",
                $this->apiClient->getSerializer()->toPathValue($memberId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkspaceMember',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkspaceMember', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkspaceMember', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaceMembers
     *
     * Get a list workspace members
     *
     * @param string $workspaceId Workspace ID (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\WorkspaceMemberEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceMembers($workspaceId, $pageSize = null, $pageNumber = null, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspaceMembersWithHttpInfo($workspaceId, $pageSize, $pageNumber, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceMembersWithHttpInfo
     *
     * Get a list workspace members
     *
     * @param string $workspaceId Workspace ID (required)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\WorkspaceMemberEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceMembersWithHttpInfo($workspaceId, $pageSize = null, $pageNumber = null, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspaceMembers');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/members";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkspaceMemberEntityListing',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/members'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkspaceMemberEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkspaceMemberEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaceTagvalue
     *
     * Get a workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\TagValue
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceTagvalue($workspaceId, $tagId, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceTagvalueWithHttpInfo
     *
     * Get a workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\TagValue, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspaceTagvalue');
        }
        // verify the required parameter 'tagId' is set
        if ($tagId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $tagId when calling getContentmanagementWorkspaceTagvalue');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($tagId !== null) {
            $resourcePath = str_replace(
                "{" . "tagId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tagId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TagValue',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TagValue', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TagValue', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaceTagvalues
     *
     * Get a list of workspace tags
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $value filter the list of tags returned (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\TagValueEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceTagvalues($workspaceId, $value = null, $pageSize = null, $pageNumber = null, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspaceTagvaluesWithHttpInfo($workspaceId, $value, $pageSize, $pageNumber, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspaceTagvaluesWithHttpInfo
     *
     * Get a list of workspace tags
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $value filter the list of tags returned (optional)
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\TagValueEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaceTagvaluesWithHttpInfo($workspaceId, $value = null, $pageSize = null, $pageNumber = null, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling getContentmanagementWorkspaceTagvalues');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($value !== null) {
            $queryParams['value'] = $this->apiClient->getSerializer()->toQueryValue($value);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TagValueEntityListing',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TagValueEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TagValueEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContentmanagementWorkspaces
     *
     * Get a list of workspaces.
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $access Requested access level. (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\WorkspaceEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspaces($pageSize = null, $pageNumber = null, $access = null, $expand = null)
    {
        list($response) = $this->getContentmanagementWorkspacesWithHttpInfo($pageSize, $pageNumber, $access, $expand);
        return $response;
    }

    /**
     * Operation getContentmanagementWorkspacesWithHttpInfo
     *
     * Get a list of workspaces.
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string[] $access Requested access level. (optional)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\WorkspaceEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getContentmanagementWorkspacesWithHttpInfo($pageSize = null, $pageNumber = null, $access = null, $expand = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if (is_array($access)) {
            $access = $this->apiClient->getSerializer()->serializeCollection($access, 'multi', true);
        }
        if ($access !== null) {
            $queryParams['access'] = $this->apiClient->getSerializer()->toQueryValue($access);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkspaceEntityListing',
                '/api/v2/contentmanagement/workspaces'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkspaceEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkspaceEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementAuditquery
     *
     * Query audits
     *
     * @param \PureCloudSDK\ContentQueryRequest $body Allows for a filtered query returning facet information (required)
     * @return \PureCloudSDK\QueryResults
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementAuditquery($body)
    {
        list($response) = $this->postContentmanagementAuditqueryWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postContentmanagementAuditqueryWithHttpInfo
     *
     * Query audits
     *
     * @param \PureCloudSDK\ContentQueryRequest $body Allows for a filtered query returning facet information (required)
     * @return Array of \PureCloudSDK\QueryResults, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementAuditqueryWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementAuditquery');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/auditquery";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\QueryResults',
                '/api/v2/contentmanagement/auditquery'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\QueryResults', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\QueryResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementDocument
     *
     * Update a document.
     *
     * @param string $documentId Document ID (required)
     * @param \PureCloudSDK\DocumentUpdate $body Document (required)
     * @param string $expand Expand some document fields (optional)
     * @param bool $override Override any lock on the document (optional)
     * @return \PureCloudSDK\Document
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocument($documentId, $body, $expand = null, $override = null)
    {
        list($response) = $this->postContentmanagementDocumentWithHttpInfo($documentId, $body, $expand, $override);
        return $response;
    }

    /**
     * Operation postContentmanagementDocumentWithHttpInfo
     *
     * Update a document.
     *
     * @param string $documentId Document ID (required)
     * @param \PureCloudSDK\DocumentUpdate $body Document (required)
     * @param string $expand Expand some document fields (optional)
     * @param bool $override Override any lock on the document (optional)
     * @return Array of \PureCloudSDK\Document, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocumentWithHttpInfo($documentId, $body, $expand = null, $override = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling postContentmanagementDocument');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($override !== null) {
            $queryParams['override'] = $this->apiClient->getSerializer()->toQueryValue($override);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Document',
                '/api/v2/contentmanagement/documents/{documentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Document', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Document', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementDocumentContent
     *
     * Replace the contents of a document.
     *
     * @param string $documentId Document ID (required)
     * @param \PureCloudSDK\ReplaceRequest $body Replace Request (required)
     * @param bool $override Override any lock on the document (optional)
     * @return \PureCloudSDK\ReplaceResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocumentContent($documentId, $body, $override = null)
    {
        list($response) = $this->postContentmanagementDocumentContentWithHttpInfo($documentId, $body, $override);
        return $response;
    }

    /**
     * Operation postContentmanagementDocumentContentWithHttpInfo
     *
     * Replace the contents of a document.
     *
     * @param string $documentId Document ID (required)
     * @param \PureCloudSDK\ReplaceRequest $body Replace Request (required)
     * @param bool $override Override any lock on the document (optional)
     * @return Array of \PureCloudSDK\ReplaceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocumentContentWithHttpInfo($documentId, $body, $override = null)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling postContentmanagementDocumentContent');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementDocumentContent');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents/{documentId}/content";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($override !== null) {
            $queryParams['override'] = $this->apiClient->getSerializer()->toQueryValue($override);
        }
        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ReplaceResponse',
                '/api/v2/contentmanagement/documents/{documentId}/content'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ReplaceResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ReplaceResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementDocuments
     *
     * Add a document.
     *
     * @param \PureCloudSDK\DocumentUpload $body Document (required)
     * @param string $copySource Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source. (optional)
     * @param string $moveSource Move a document to a new workspace. Provide a document ID as the move source. (optional)
     * @param bool $override Override any lock on the source document (optional)
     * @return \PureCloudSDK\Document
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocuments($body, $copySource = null, $moveSource = null, $override = null)
    {
        list($response) = $this->postContentmanagementDocumentsWithHttpInfo($body, $copySource, $moveSource, $override);
        return $response;
    }

    /**
     * Operation postContentmanagementDocumentsWithHttpInfo
     *
     * Add a document.
     *
     * @param \PureCloudSDK\DocumentUpload $body Document (required)
     * @param string $copySource Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source. (optional)
     * @param string $moveSource Move a document to a new workspace. Provide a document ID as the move source. (optional)
     * @param bool $override Override any lock on the source document (optional)
     * @return Array of \PureCloudSDK\Document, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementDocumentsWithHttpInfo($body, $copySource = null, $moveSource = null, $override = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($copySource !== null) {
            $queryParams['copySource'] = $this->apiClient->getSerializer()->toQueryValue($copySource);
        }
        // query params
        if ($moveSource !== null) {
            $queryParams['moveSource'] = $this->apiClient->getSerializer()->toQueryValue($moveSource);
        }
        // query params
        if ($override !== null) {
            $queryParams['override'] = $this->apiClient->getSerializer()->toQueryValue($override);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Document',
                '/api/v2/contentmanagement/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Document', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Document', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementQuery
     *
     * Query content
     *
     * @param \PureCloudSDK\QueryRequest $body Allows for a filtered query returning facet information (required)
     * @param string $expand Expand some document fields (optional)
     * @return \PureCloudSDK\QueryResults
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementQuery($body, $expand = null)
    {
        list($response) = $this->postContentmanagementQueryWithHttpInfo($body, $expand);
        return $response;
    }

    /**
     * Operation postContentmanagementQueryWithHttpInfo
     *
     * Query content
     *
     * @param \PureCloudSDK\QueryRequest $body Allows for a filtered query returning facet information (required)
     * @param string $expand Expand some document fields (optional)
     * @return Array of \PureCloudSDK\QueryResults, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementQueryWithHttpInfo($body, $expand = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\QueryResults',
                '/api/v2/contentmanagement/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\QueryResults', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\QueryResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementShares
     *
     * Creates a new share or updates an existing share if the entity has already been shared
     *
     * @param \PureCloudSDK\CreateShareRequest $body CreateShareRequest - entity id and type and a single member or list of members are required (required)
     * @return \PureCloudSDK\CreateShareResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementShares($body)
    {
        list($response) = $this->postContentmanagementSharesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postContentmanagementSharesWithHttpInfo
     *
     * Creates a new share or updates an existing share if the entity has already been shared
     *
     * @param \PureCloudSDK\CreateShareRequest $body CreateShareRequest - entity id and type and a single member or list of members are required (required)
     * @return Array of \PureCloudSDK\CreateShareResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementSharesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementShares');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/shares";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CreateShareResponse',
                '/api/v2/contentmanagement/shares'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CreateShareResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CreateShareResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementWorkspaceTagvalues
     *
     * Create a workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\TagValue $body tag (required)
     * @return \PureCloudSDK\TagValue
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspaceTagvalues($workspaceId, $body)
    {
        list($response) = $this->postContentmanagementWorkspaceTagvaluesWithHttpInfo($workspaceId, $body);
        return $response;
    }

    /**
     * Operation postContentmanagementWorkspaceTagvaluesWithHttpInfo
     *
     * Create a workspace tag
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\TagValue $body tag (required)
     * @return Array of \PureCloudSDK\TagValue, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspaceTagvaluesWithHttpInfo($workspaceId, $body)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling postContentmanagementWorkspaceTagvalues');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementWorkspaceTagvalues');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TagValue',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TagValue', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TagValue', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementWorkspaceTagvaluesQuery
     *
     * Perform a prefix query on tags in the workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\TagQueryRequest $body query (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return \PureCloudSDK\TagValueEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspaceTagvaluesQuery($workspaceId, $body, $expand = null)
    {
        list($response) = $this->postContentmanagementWorkspaceTagvaluesQueryWithHttpInfo($workspaceId, $body, $expand);
        return $response;
    }

    /**
     * Operation postContentmanagementWorkspaceTagvaluesQueryWithHttpInfo
     *
     * Perform a prefix query on tags in the workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\TagQueryRequest $body query (required)
     * @param string[] $expand Which fields, if any, to expand. (optional)
     * @return Array of \PureCloudSDK\TagValueEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspaceTagvaluesQueryWithHttpInfo($workspaceId, $body, $expand = null)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling postContentmanagementWorkspaceTagvaluesQuery');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementWorkspaceTagvaluesQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TagValueEntityListing',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TagValueEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TagValueEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContentmanagementWorkspaces
     *
     * Create a group workspace
     *
     * @param \PureCloudSDK\WorkspaceCreate $body Workspace (required)
     * @return \PureCloudSDK\Workspace
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspaces($body)
    {
        list($response) = $this->postContentmanagementWorkspacesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postContentmanagementWorkspacesWithHttpInfo
     *
     * Create a group workspace
     *
     * @param \PureCloudSDK\WorkspaceCreate $body Workspace (required)
     * @return Array of \PureCloudSDK\Workspace, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postContentmanagementWorkspacesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postContentmanagementWorkspaces');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Workspace',
                '/api/v2/contentmanagement/workspaces'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Workspace', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putContentmanagementWorkspace
     *
     * Update a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\Workspace $body Workspace (required)
     * @return \PureCloudSDK\Workspace
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspace($workspaceId, $body)
    {
        list($response) = $this->putContentmanagementWorkspaceWithHttpInfo($workspaceId, $body);
        return $response;
    }

    /**
     * Operation putContentmanagementWorkspaceWithHttpInfo
     *
     * Update a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param \PureCloudSDK\Workspace $body Workspace (required)
     * @return Array of \PureCloudSDK\Workspace, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspaceWithHttpInfo($workspaceId, $body)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling putContentmanagementWorkspace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putContentmanagementWorkspace');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Workspace',
                '/api/v2/contentmanagement/workspaces/{workspaceId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Workspace', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putContentmanagementWorkspaceMember
     *
     * Add a member to a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @param \PureCloudSDK\WorkspaceMember $body Workspace Member (required)
     * @return \PureCloudSDK\WorkspaceMember
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspaceMember($workspaceId, $memberId, $body)
    {
        list($response) = $this->putContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId, $body);
        return $response;
    }

    /**
     * Operation putContentmanagementWorkspaceMemberWithHttpInfo
     *
     * Add a member to a workspace
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $memberId Member ID (required)
     * @param \PureCloudSDK\WorkspaceMember $body Workspace Member (required)
     * @return Array of \PureCloudSDK\WorkspaceMember, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspaceMemberWithHttpInfo($workspaceId, $memberId, $body)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling putContentmanagementWorkspaceMember');
        }
        // verify the required parameter 'memberId' is set
        if ($memberId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $memberId when calling putContentmanagementWorkspaceMember');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putContentmanagementWorkspaceMember');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($memberId !== null) {
            $resourcePath = str_replace(
                "{" . "memberId" . "}",
                $this->apiClient->getSerializer()->toPathValue($memberId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkspaceMember',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkspaceMember', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkspaceMember', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putContentmanagementWorkspaceTagvalue
     *
     * Update a workspace tag. Will update all documents with the new tag value.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @param \PureCloudSDK\TagValue $body Workspace (required)
     * @return \PureCloudSDK\TagValue
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspaceTagvalue($workspaceId, $tagId, $body)
    {
        list($response) = $this->putContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId, $body);
        return $response;
    }

    /**
     * Operation putContentmanagementWorkspaceTagvalueWithHttpInfo
     *
     * Update a workspace tag. Will update all documents with the new tag value.
     *
     * @param string $workspaceId Workspace ID (required)
     * @param string $tagId Tag ID (required)
     * @param \PureCloudSDK\TagValue $body Workspace (required)
     * @return Array of \PureCloudSDK\TagValue, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putContentmanagementWorkspaceTagvalueWithHttpInfo($workspaceId, $tagId, $body)
    {
        // verify the required parameter 'workspaceId' is set
        if ($workspaceId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspaceId when calling putContentmanagementWorkspaceTagvalue');
        }
        // verify the required parameter 'tagId' is set
        if ($tagId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $tagId when calling putContentmanagementWorkspaceTagvalue');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putContentmanagementWorkspaceTagvalue');
        }
        // parse inputs
        $resourcePath = "/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($workspaceId !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspaceId),
                $resourcePath
            );
        }
        // path params
        if ($tagId !== null) {
            $resourcePath = str_replace(
                "{" . "tagId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tagId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TagValue',
                '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TagValue', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TagValue', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
