<?php

/**
 * AsyncQueryStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AsyncQueryStatus Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AsyncQueryStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AsyncQueryStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'errorMessage' => 'string',
        'expirationDate' => '\DateTime',
        'submissionDate' => '\DateTime',
        'completionDate' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'errorMessage' => 'errorMessage',
        'expirationDate' => 'expirationDate',
        'submissionDate' => 'submissionDate',
        'completionDate' => 'completionDate'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'errorMessage' => 'setErrorMessage',
        'expirationDate' => 'setExpirationDate',
        'submissionDate' => 'setSubmissionDate',
        'completionDate' => 'setCompletionDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'errorMessage' => 'getErrorMessage',
        'expirationDate' => 'getExpirationDate',
        'submissionDate' => 'getSubmissionDate',
        'completionDate' => 'getCompletionDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_QUEUED = 'QUEUED';
    public const STATE_PENDING = 'PENDING';
    public const STATE_FAILED = 'FAILED';
    public const STATE_CANCELLED = 'CANCELLED';
    public const STATE_FULFILLED = 'FULFILLED';
    public const STATE_EXPIRED = 'EXPIRED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_QUEUED,
            self::STATE_PENDING,
            self::STATE_FAILED,
            self::STATE_CANCELLED,
            self::STATE_FULFILLED,
            self::STATE_EXPIRED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['errorMessage'] = isset($data['errorMessage']) ? $data['errorMessage'] : null;
        $this->container['expirationDate'] = isset($data['expirationDate']) ? $data['expirationDate'] : null;
        $this->container['submissionDate'] = isset($data['submissionDate']) ? $data['submissionDate'] : null;
        $this->container['completionDate'] = isset($data['completionDate']) ? $data['completionDate'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("QUEUED", "PENDING", "FAILED", "CANCELLED", "FULFILLED", "EXPIRED");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("QUEUED", "PENDING", "FAILED", "CANCELLED", "FULFILLED", "EXPIRED");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The current state of the asynchronous query
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('QUEUED', 'PENDING', 'FAILED', 'CANCELLED', 'FULFILLED', 'EXPIRED');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'QUEUED', 'PENDING', 'FAILED', 'CANCELLED', 'FULFILLED', 'EXPIRED'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets errorMessage
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['errorMessage'];
    }

    /**
     * Sets errorMessage
     * @param string $errorMessage The error associated with the current query, if the state is FAILED
     * @return $this
     */
    public function setErrorMessage($errorMessage)
    {
        $this->container['errorMessage'] = $errorMessage;

        return $this;
    }

    /**
     * Gets expirationDate
     * @return \DateTime
     */
    public function getExpirationDate()
    {
        return $this->container['expirationDate'];
    }

    /**
     * Sets expirationDate
     * @param \DateTime $expirationDate The time at which results for this query will expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExpirationDate($expirationDate)
    {
        $this->container['expirationDate'] = $expirationDate;

        return $this;
    }

    /**
     * Gets submissionDate
     * @return \DateTime
     */
    public function getSubmissionDate()
    {
        return $this->container['submissionDate'];
    }

    /**
     * Sets submissionDate
     * @param \DateTime $submissionDate The time at which the query was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSubmissionDate($submissionDate)
    {
        $this->container['submissionDate'] = $submissionDate;

        return $this;
    }

    /**
     * Gets completionDate
     * @return \DateTime
     */
    public function getCompletionDate()
    {
        return $this->container['completionDate'];
    }

    /**
     * Sets completionDate
     * @param \DateTime $completionDate The time at which the query completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCompletionDate($completionDate)
    {
        $this->container['completionDate'] = $completionDate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
