<?php

/**
 * BuFullDayTimeOffMarker
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuFullDayTimeOffMarker Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuFullDayTimeOffMarker implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuFullDayTimeOffMarker';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'businessUnitDate' => '\DateTime',
        'lengthMinutes' => 'int',
        'description' => 'string',
        'activityCodeId' => 'string',
        'paid' => 'bool',
        'timeOffRequestId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'businessUnitDate' => 'businessUnitDate',
        'lengthMinutes' => 'lengthMinutes',
        'description' => 'description',
        'activityCodeId' => 'activityCodeId',
        'paid' => 'paid',
        'timeOffRequestId' => 'timeOffRequestId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'businessUnitDate' => 'setBusinessUnitDate',
        'lengthMinutes' => 'setLengthMinutes',
        'description' => 'setDescription',
        'activityCodeId' => 'setActivityCodeId',
        'paid' => 'setPaid',
        'timeOffRequestId' => 'setTimeOffRequestId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'businessUnitDate' => 'getBusinessUnitDate',
        'lengthMinutes' => 'getLengthMinutes',
        'description' => 'getDescription',
        'activityCodeId' => 'getActivityCodeId',
        'paid' => 'getPaid',
        'timeOffRequestId' => 'getTimeOffRequestId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['businessUnitDate'] = isset($data['businessUnitDate']) ? $data['businessUnitDate'] : null;
        $this->container['lengthMinutes'] = isset($data['lengthMinutes']) ? $data['lengthMinutes'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['paid'] = isset($data['paid']) ? $data['paid'] : null;
        $this->container['timeOffRequestId'] = isset($data['timeOffRequestId']) ? $data['timeOffRequestId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets businessUnitDate
     * @return \DateTime
     */
    public function getBusinessUnitDate()
    {
        return $this->container['businessUnitDate'];
    }

    /**
     * Sets businessUnitDate
     * @param \DateTime $businessUnitDate The date of the time off marker, interpreted in the business unit's time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
     * @return $this
     */
    public function setBusinessUnitDate($businessUnitDate)
    {
        $this->container['businessUnitDate'] = $businessUnitDate;

        return $this;
    }

    /**
     * Gets lengthMinutes
     * @return int
     */
    public function getLengthMinutes()
    {
        return $this->container['lengthMinutes'];
    }

    /**
     * Sets lengthMinutes
     * @param int $lengthMinutes The length of the time off marker in minutes
     * @return $this
     */
    public function setLengthMinutes($lengthMinutes)
    {
        $this->container['lengthMinutes'] = $lengthMinutes;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of the time off marker
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId The ID of the activity code associated with the time off marker
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets paid
     * @return bool
     */
    public function getPaid()
    {
        return $this->container['paid'];
    }

    /**
     * Sets paid
     * @param bool $paid Whether the time off marker is paid
     * @return $this
     */
    public function setPaid($paid)
    {
        $this->container['paid'] = $paid;

        return $this;
    }

    /**
     * Gets timeOffRequestId
     * @return string
     */
    public function getTimeOffRequestId()
    {
        return $this->container['timeOffRequestId'];
    }

    /**
     * Sets timeOffRequestId
     * @param string $timeOffRequestId The ID of the time off request
     * @return $this
     */
    public function setTimeOffRequestId($timeOffRequestId)
    {
        $this->container['timeOffRequestId'] = $timeOffRequestId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
