<?php

/**
 * IntegrationEvent
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * IntegrationEvent Class Doc Comment
 *
 * @category    Class */
 // @description Describes an event that has happened related to an integration
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class IntegrationEvent implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'IntegrationEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'selfUri' => 'string',
        'correlationId' => 'string',
        'timestamp' => '\DateTime',
        'level' => 'string',
        'eventCode' => 'string',
        'message' => '\PureCloudSDK\MessageInfo',
        'entities' => '\PureCloudSDK\EventEntity[]',
        'contextAttributes' => 'map[string,string]',
        'detailMessage' => '\PureCloudSDK\MessageInfo',
        'user' => '\PureCloudSDK\User'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'selfUri' => 'selfUri',
        'correlationId' => 'correlationId',
        'timestamp' => 'timestamp',
        'level' => 'level',
        'eventCode' => 'eventCode',
        'message' => 'message',
        'entities' => 'entities',
        'contextAttributes' => 'contextAttributes',
        'detailMessage' => 'detailMessage',
        'user' => 'user'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'selfUri' => 'setSelfUri',
        'correlationId' => 'setCorrelationId',
        'timestamp' => 'setTimestamp',
        'level' => 'setLevel',
        'eventCode' => 'setEventCode',
        'message' => 'setMessage',
        'entities' => 'setEntities',
        'contextAttributes' => 'setContextAttributes',
        'detailMessage' => 'setDetailMessage',
        'user' => 'setUser'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'selfUri' => 'getSelfUri',
        'correlationId' => 'getCorrelationId',
        'timestamp' => 'getTimestamp',
        'level' => 'getLevel',
        'eventCode' => 'getEventCode',
        'message' => 'getMessage',
        'entities' => 'getEntities',
        'contextAttributes' => 'getContextAttributes',
        'detailMessage' => 'getDetailMessage',
        'user' => 'getUser'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const LEVEL_INFO = 'INFO';
    public const LEVEL_WARN = 'WARN';
    public const LEVEL_ERROR = 'ERROR';
    public const LEVEL_CRITICAL = 'CRITICAL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLevelAllowableValues()
    {
        return [
            self::LEVEL_INFO,
            self::LEVEL_WARN,
            self::LEVEL_ERROR,
            self::LEVEL_CRITICAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['correlationId'] = isset($data['correlationId']) ? $data['correlationId'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['level'] = isset($data['level']) ? $data['level'] : null;
        $this->container['eventCode'] = isset($data['eventCode']) ? $data['eventCode'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['entities'] = isset($data['entities']) ? $data['entities'] : null;
        $this->container['contextAttributes'] = isset($data['contextAttributes']) ? $data['contextAttributes'] : null;
        $this->container['detailMessage'] = isset($data['detailMessage']) ? $data['detailMessage'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("INFO", "WARN", "ERROR", "CRITICAL");
        if (!in_array($this->container['level'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'level', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("INFO", "WARN", "ERROR", "CRITICAL");
        if (!in_array($this->container['level'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id Unique ID for this event
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets correlationId
     * @return string
     */
    public function getCorrelationId()
    {
        return $this->container['correlationId'];
    }

    /**
     * Sets correlationId
     * @param string $correlationId Correlation ID for the event
     * @return $this
     */
    public function setCorrelationId($correlationId)
    {
        $this->container['correlationId'] = $correlationId;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp Time the event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets level
     * @return string
     */
    public function getLevel()
    {
        return $this->container['level'];
    }

    /**
     * Sets level
     * @param string $level Indicates the severity of the event.
     * @return $this
     */
    public function setLevel($level)
    {
        $allowed_values = array('INFO', 'WARN', 'ERROR', 'CRITICAL');
        if (!in_array($level, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'level', must be one of 'INFO', 'WARN', 'ERROR', 'CRITICAL'");
        }
        $this->container['level'] = $level;

        return $this;
    }

    /**
     * Gets eventCode
     * @return string
     */
    public function getEventCode()
    {
        return $this->container['eventCode'];
    }

    /**
     * Sets eventCode
     * @param string $eventCode A classification for the event. Suitable for programmatic searching, sorting, or filtering
     * @return $this
     */
    public function setEventCode($eventCode)
    {
        $this->container['eventCode'] = $eventCode;

        return $this;
    }

    /**
     * Gets message
     * @return \PureCloudSDK\MessageInfo
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param \PureCloudSDK\MessageInfo $message Message indicating what happened
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets entities
     * @return \PureCloudSDK\EventEntity[]
     */
    public function getEntities()
    {
        return $this->container['entities'];
    }

    /**
     * Sets entities
     * @param \PureCloudSDK\EventEntity[] $entities Collection of entities affected by or pertaining to the event (e.g. a list of Integrations or Bridge connectors)
     * @return $this
     */
    public function setEntities($entities)
    {
        $this->container['entities'] = $entities;

        return $this;
    }

    /**
     * Gets contextAttributes
     * @return map[string,string]
     */
    public function getContextAttributes()
    {
        return $this->container['contextAttributes'];
    }

    /**
     * Sets contextAttributes
     * @param map[string,string] $contextAttributes Map of context attributes specific to this event.
     * @return $this
     */
    public function setContextAttributes($contextAttributes)
    {
        $this->container['contextAttributes'] = $contextAttributes;

        return $this;
    }

    /**
     * Gets detailMessage
     * @return \PureCloudSDK\MessageInfo
     */
    public function getDetailMessage()
    {
        return $this->container['detailMessage'];
    }

    /**
     * Sets detailMessage
     * @param \PureCloudSDK\MessageInfo $detailMessage Message with additional details about the event. (e.g. an exception cause.)
     * @return $this
     */
    public function setDetailMessage($detailMessage)
    {
        $this->container['detailMessage'] = $detailMessage;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user User that took an action that resulted in the event.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
