<?php

/**
 * TrustorAuditQueryRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TrustorAuditQueryRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TrustorAuditQueryRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TrustorAuditQueryRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'trustorOrganizationId' => 'string',
        'trusteeUserIds' => 'string[]',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'queryPhrase' => 'string',
        'facets' => '\PureCloudSDK\Facet[]',
        'filters' => '\PureCloudSDK\Filter[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'trustorOrganizationId' => 'trustorOrganizationId',
        'trusteeUserIds' => 'trusteeUserIds',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'queryPhrase' => 'queryPhrase',
        'facets' => 'facets',
        'filters' => 'filters'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'trustorOrganizationId' => 'setTrustorOrganizationId',
        'trusteeUserIds' => 'setTrusteeUserIds',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'queryPhrase' => 'setQueryPhrase',
        'facets' => 'setFacets',
        'filters' => 'setFilters'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'trustorOrganizationId' => 'getTrustorOrganizationId',
        'trusteeUserIds' => 'getTrusteeUserIds',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'queryPhrase' => 'getQueryPhrase',
        'facets' => 'getFacets',
        'filters' => 'getFilters'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['trustorOrganizationId'] = isset($data['trustorOrganizationId']) ? $data['trustorOrganizationId'] : null;
        $this->container['trusteeUserIds'] = isset($data['trusteeUserIds']) ? $data['trusteeUserIds'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['queryPhrase'] = isset($data['queryPhrase']) ? $data['queryPhrase'] : null;
        $this->container['facets'] = isset($data['facets']) ? $data['facets'] : null;
        $this->container['filters'] = isset($data['filters']) ? $data['filters'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['trustorOrganizationId'] === null) {
            $invalid_properties[] = "'trustorOrganizationId' can't be null";
        }
        if ($this->container['trusteeUserIds'] === null) {
            $invalid_properties[] = "'trusteeUserIds' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['trustorOrganizationId'] === null) {
            return false;
        }
        if ($this->container['trusteeUserIds'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets trustorOrganizationId
     * @return string
     */
    public function getTrustorOrganizationId()
    {
        return $this->container['trustorOrganizationId'];
    }

    /**
     * Sets trustorOrganizationId
     * @param string $trustorOrganizationId Limit returned audits to this trustor organizationId.
     * @return $this
     */
    public function setTrustorOrganizationId($trustorOrganizationId)
    {
        $this->container['trustorOrganizationId'] = $trustorOrganizationId;

        return $this;
    }

    /**
     * Gets trusteeUserIds
     * @return string[]
     */
    public function getTrusteeUserIds()
    {
        return $this->container['trusteeUserIds'];
    }

    /**
     * Sets trusteeUserIds
     * @param string[] $trusteeUserIds Limit returned audits to these trustee userIds.
     * @return $this
     */
    public function setTrusteeUserIds($trusteeUserIds)
    {
        $this->container['trusteeUserIds'] = $trusteeUserIds;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate Starting date/time for the audit search. ISO-8601 formatted date-time, UTC.
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate Ending date/time for the audit search. ISO-8601 formatted date-time, UTC.
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets queryPhrase
     * @return string
     */
    public function getQueryPhrase()
    {
        return $this->container['queryPhrase'];
    }

    /**
     * Sets queryPhrase
     * @param string $queryPhrase Word or phrase to look for in audit bodies.
     * @return $this
     */
    public function setQueryPhrase($queryPhrase)
    {
        $this->container['queryPhrase'] = $queryPhrase;

        return $this;
    }

    /**
     * Gets facets
     * @return \PureCloudSDK\Facet[]
     */
    public function getFacets()
    {
        return $this->container['facets'];
    }

    /**
     * Sets facets
     * @param \PureCloudSDK\Facet[] $facets Facet information to be returned with the query results.
     * @return $this
     */
    public function setFacets($facets)
    {
        $this->container['facets'] = $facets;

        return $this;
    }

    /**
     * Gets filters
     * @return \PureCloudSDK\Filter[]
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     * @param \PureCloudSDK\Filter[] $filters Additional custom filters to be applied to the query.
     * @return $this
     */
    public function setFilters($filters)
    {
        $this->container['filters'] = $filters;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
