<?php
/**
 * OrgOAuthClient
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * OrgOAuthClient Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OrgOAuthClient implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OrgOAuthClient';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'authorizedGrantType' => 'string',
        'organization' => '\PureCloudSDK\Entity'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'authorizedGrantType' => 'authorizedGrantType',
        'organization' => 'organization'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'authorizedGrantType' => 'setAuthorizedGrantType',
        'organization' => 'setOrganization'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'authorizedGrantType' => 'getAuthorizedGrantType',
        'organization' => 'getOrganization'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const AUTHORIZED_GRANT_TYPE_CODE = 'CODE';
    const AUTHORIZED_GRANT_TYPE_TOKEN = 'TOKEN';
    const AUTHORIZED_GRANT_TYPE_SAML2_BEARER = 'SAML2BEARER';
    const AUTHORIZED_GRANT_TYPE_PASSWORD = 'PASSWORD';
    const AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS = 'CLIENT_CREDENTIALS';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAuthorizedGrantTypeAllowableValues()
    {
        return [
            self::AUTHORIZED_GRANT_TYPE_CODE,
            self::AUTHORIZED_GRANT_TYPE_TOKEN,
            self::AUTHORIZED_GRANT_TYPE_SAML2_BEARER,
            self::AUTHORIZED_GRANT_TYPE_PASSWORD,
            self::AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['authorizedGrantType'] = isset($data['authorizedGrantType']) ? $data['authorizedGrantType'] : null;
        $this->container['organization'] = isset($data['organization']) ? $data['organization'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['authorizedGrantType'] === null) {
            $invalid_properties[] = "'authorizedGrantType' can't be null";
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorizedGrantType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'authorizedGrantType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['authorizedGrantType'] === null) {
            return false;
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorizedGrantType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the OAuth client.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets authorizedGrantType
     * @return string
     */
    public function getAuthorizedGrantType()
    {
        return $this->container['authorizedGrantType'];
    }

    /**
     * Sets authorizedGrantType
     * @param string $authorizedGrantType The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client.
     * @return $this
     */
    public function setAuthorizedGrantType($authorizedGrantType)
    {
        $allowed_values = array('CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS');
        if (!in_array($authorizedGrantType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'authorizedGrantType', must be one of 'CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS'");
        }
        $this->container['authorizedGrantType'] = $authorizedGrantType;

        return $this;
    }

    /**
     * Gets organization
     * @return \PureCloudSDK\Entity
     */
    public function getOrganization()
    {
        return $this->container['organization'];
    }

    /**
     * Sets organization
     * @param \PureCloudSDK\Entity $organization The  oauth client's organization.
     * @return $this
     */
    public function setOrganization($organization)
    {
        $this->container['organization'] = $organization;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


