<?php
/**
 * PhoneStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PhoneStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PhoneStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PhoneStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'operationalStatus' => 'string',
        'edgesStatus' => 'string',
        'eventCreationTime' => 'string',
        'provision' => '\PureCloudSDK\ProvisionInfo',
        'lineStatuses' => '\PureCloudSDK\LineStatus[]',
        'phoneAssignmentToEdgeType' => 'string',
        'edge' => '\PureCloudSDK\UriReference',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'operationalStatus' => 'operationalStatus',
        'edgesStatus' => 'edgesStatus',
        'eventCreationTime' => 'eventCreationTime',
        'provision' => 'provision',
        'lineStatuses' => 'lineStatuses',
        'phoneAssignmentToEdgeType' => 'phoneAssignmentToEdgeType',
        'edge' => 'edge',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'operationalStatus' => 'setOperationalStatus',
        'edgesStatus' => 'setEdgesStatus',
        'eventCreationTime' => 'setEventCreationTime',
        'provision' => 'setProvision',
        'lineStatuses' => 'setLineStatuses',
        'phoneAssignmentToEdgeType' => 'setPhoneAssignmentToEdgeType',
        'edge' => 'setEdge',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'operationalStatus' => 'getOperationalStatus',
        'edgesStatus' => 'getEdgesStatus',
        'eventCreationTime' => 'getEventCreationTime',
        'provision' => 'getProvision',
        'lineStatuses' => 'getLineStatuses',
        'phoneAssignmentToEdgeType' => 'getPhoneAssignmentToEdgeType',
        'edge' => 'getEdge',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const OPERATIONAL_STATUS_OPERATIONAL = 'OPERATIONAL';
    const OPERATIONAL_STATUS_DEGRADED = 'DEGRADED';
    const OPERATIONAL_STATUS_OFFLINE = 'OFFLINE';
    const EDGES_STATUS_IN_SERVICE = 'IN_SERVICE';
    const EDGES_STATUS_MIXED_SERVICE = 'MIXED_SERVICE';
    const EDGES_STATUS_OUT_OF_SERVICE = 'OUT_OF_SERVICE';
    const EDGES_STATUS_NO_EDGES = 'NO_EDGES';
    const PHONE_ASSIGNMENT_TO_EDGE_TYPE_PRIMARY = 'PRIMARY';
    const PHONE_ASSIGNMENT_TO_EDGE_TYPE_SECONDARY = 'SECONDARY';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperationalStatusAllowableValues()
    {
        return [
            self::OPERATIONAL_STATUS_OPERATIONAL,
            self::OPERATIONAL_STATUS_DEGRADED,
            self::OPERATIONAL_STATUS_OFFLINE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEdgesStatusAllowableValues()
    {
        return [
            self::EDGES_STATUS_IN_SERVICE,
            self::EDGES_STATUS_MIXED_SERVICE,
            self::EDGES_STATUS_OUT_OF_SERVICE,
            self::EDGES_STATUS_NO_EDGES,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPhoneAssignmentToEdgeTypeAllowableValues()
    {
        return [
            self::PHONE_ASSIGNMENT_TO_EDGE_TYPE_PRIMARY,
            self::PHONE_ASSIGNMENT_TO_EDGE_TYPE_SECONDARY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['operationalStatus'] = isset($data['operationalStatus']) ? $data['operationalStatus'] : null;
        $this->container['edgesStatus'] = isset($data['edgesStatus']) ? $data['edgesStatus'] : null;
        $this->container['eventCreationTime'] = isset($data['eventCreationTime']) ? $data['eventCreationTime'] : null;
        $this->container['provision'] = isset($data['provision']) ? $data['provision'] : null;
        $this->container['lineStatuses'] = isset($data['lineStatuses']) ? $data['lineStatuses'] : null;
        $this->container['phoneAssignmentToEdgeType'] = isset($data['phoneAssignmentToEdgeType']) ? $data['phoneAssignmentToEdgeType'] : null;
        $this->container['edge'] = isset($data['edge']) ? $data['edge'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OPERATIONAL", "DEGRADED", "OFFLINE");
        if (!in_array($this->container['operationalStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operationalStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("IN_SERVICE", "MIXED_SERVICE", "OUT_OF_SERVICE", "NO_EDGES");
        if (!in_array($this->container['edgesStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'edgesStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['phoneAssignmentToEdgeType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'phoneAssignmentToEdgeType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OPERATIONAL", "DEGRADED", "OFFLINE");
        if (!in_array($this->container['operationalStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("IN_SERVICE", "MIXED_SERVICE", "OUT_OF_SERVICE", "NO_EDGES");
        if (!in_array($this->container['edgesStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['phoneAssignmentToEdgeType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets operationalStatus
     * @return string
     */
    public function getOperationalStatus()
    {
        return $this->container['operationalStatus'];
    }

    /**
     * Sets operationalStatus
     * @param string $operationalStatus The Operational Status of this phone
     * @return $this
     */
    public function setOperationalStatus($operationalStatus)
    {
        $allowed_values = array('OPERATIONAL', 'DEGRADED', 'OFFLINE');
        if (!in_array($operationalStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operationalStatus', must be one of 'OPERATIONAL', 'DEGRADED', 'OFFLINE'");
        }
        $this->container['operationalStatus'] = $operationalStatus;

        return $this;
    }

    /**
     * Gets edgesStatus
     * @return string
     */
    public function getEdgesStatus()
    {
        return $this->container['edgesStatus'];
    }

    /**
     * Sets edgesStatus
     * @param string $edgesStatus The status of the primary or secondary Edges assigned to the phone lines.
     * @return $this
     */
    public function setEdgesStatus($edgesStatus)
    {
        $allowed_values = array('IN_SERVICE', 'MIXED_SERVICE', 'OUT_OF_SERVICE', 'NO_EDGES');
        if (!in_array($edgesStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'edgesStatus', must be one of 'IN_SERVICE', 'MIXED_SERVICE', 'OUT_OF_SERVICE', 'NO_EDGES'");
        }
        $this->container['edgesStatus'] = $edgesStatus;

        return $this;
    }

    /**
     * Gets eventCreationTime
     * @return string
     */
    public function getEventCreationTime()
    {
        return $this->container['eventCreationTime'];
    }

    /**
     * Sets eventCreationTime
     * @param string $eventCreationTime Event Creation Time represents an ISO-8601 string. For example: UTC, UTC+01:00, or Europe/London
     * @return $this
     */
    public function setEventCreationTime($eventCreationTime)
    {
        $this->container['eventCreationTime'] = $eventCreationTime;

        return $this;
    }

    /**
     * Gets provision
     * @return \PureCloudSDK\ProvisionInfo
     */
    public function getProvision()
    {
        return $this->container['provision'];
    }

    /**
     * Sets provision
     * @param \PureCloudSDK\ProvisionInfo $provision Provision information for this phone
     * @return $this
     */
    public function setProvision($provision)
    {
        $this->container['provision'] = $provision;

        return $this;
    }

    /**
     * Gets lineStatuses
     * @return \PureCloudSDK\LineStatus[]
     */
    public function getLineStatuses()
    {
        return $this->container['lineStatuses'];
    }

    /**
     * Sets lineStatuses
     * @param \PureCloudSDK\LineStatus[] $lineStatuses A list of LineStatus information for each of the lines of this phone
     * @return $this
     */
    public function setLineStatuses($lineStatuses)
    {
        $this->container['lineStatuses'] = $lineStatuses;

        return $this;
    }

    /**
     * Gets phoneAssignmentToEdgeType
     * @return string
     */
    public function getPhoneAssignmentToEdgeType()
    {
        return $this->container['phoneAssignmentToEdgeType'];
    }

    /**
     * Sets phoneAssignmentToEdgeType
     * @param string $phoneAssignmentToEdgeType The phone status's edge assignment type.
     * @return $this
     */
    public function setPhoneAssignmentToEdgeType($phoneAssignmentToEdgeType)
    {
        $allowed_values = array('PRIMARY', 'SECONDARY');
        if (!in_array($phoneAssignmentToEdgeType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'phoneAssignmentToEdgeType', must be one of 'PRIMARY', 'SECONDARY'");
        }
        $this->container['phoneAssignmentToEdgeType'] = $phoneAssignmentToEdgeType;

        return $this;
    }

    /**
     * Gets edge
     * @return \PureCloudSDK\UriReference
     */
    public function getEdge()
    {
        return $this->container['edge'];
    }

    /**
     * Sets edge
     * @param \PureCloudSDK\UriReference $edge The URI of the edge that provided this status information.
     * @return $this
     */
    public function setEdge($edge)
    {
        $this->container['edge'] = $edge;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


