# PureCloudSDK\IdentityProviderApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteIdentityprovidersAdfs**](IdentityProviderApi.md#deleteIdentityprovidersAdfs) | **DELETE** /api/v2/identityproviders/adfs | Delete ADFS Identity Provider
[**deleteIdentityprovidersCic**](IdentityProviderApi.md#deleteIdentityprovidersCic) | **DELETE** /api/v2/identityproviders/cic | Delete Customer Interaction Center (CIC) Identity Provider
[**deleteIdentityprovidersGsuite**](IdentityProviderApi.md#deleteIdentityprovidersGsuite) | **DELETE** /api/v2/identityproviders/gsuite | Delete G Suite Identity Provider
[**deleteIdentityprovidersIdentitynow**](IdentityProviderApi.md#deleteIdentityprovidersIdentitynow) | **DELETE** /api/v2/identityproviders/identitynow | Delete IdentityNow Provider
[**deleteIdentityprovidersOkta**](IdentityProviderApi.md#deleteIdentityprovidersOkta) | **DELETE** /api/v2/identityproviders/okta | Delete Okta Identity Provider
[**deleteIdentityprovidersOnelogin**](IdentityProviderApi.md#deleteIdentityprovidersOnelogin) | **DELETE** /api/v2/identityproviders/onelogin | Delete OneLogin Identity Provider
[**deleteIdentityprovidersPing**](IdentityProviderApi.md#deleteIdentityprovidersPing) | **DELETE** /api/v2/identityproviders/ping | Delete Ping Identity Provider
[**deleteIdentityprovidersPurecloud**](IdentityProviderApi.md#deleteIdentityprovidersPurecloud) | **DELETE** /api/v2/identityproviders/purecloud | Delete PureCloud Identity Provider
[**deleteIdentityprovidersSalesforce**](IdentityProviderApi.md#deleteIdentityprovidersSalesforce) | **DELETE** /api/v2/identityproviders/salesforce | Delete Salesforce Identity Provider
[**getIdentityproviders**](IdentityProviderApi.md#getIdentityproviders) | **GET** /api/v2/identityproviders | The list of identity providers
[**getIdentityprovidersAdfs**](IdentityProviderApi.md#getIdentityprovidersAdfs) | **GET** /api/v2/identityproviders/adfs | Get ADFS Identity Provider
[**getIdentityprovidersCic**](IdentityProviderApi.md#getIdentityprovidersCic) | **GET** /api/v2/identityproviders/cic | Get Customer Interaction Center (CIC) Identity Provider
[**getIdentityprovidersGsuite**](IdentityProviderApi.md#getIdentityprovidersGsuite) | **GET** /api/v2/identityproviders/gsuite | Get G Suite Identity Provider
[**getIdentityprovidersIdentitynow**](IdentityProviderApi.md#getIdentityprovidersIdentitynow) | **GET** /api/v2/identityproviders/identitynow | Get IdentityNow Provider
[**getIdentityprovidersOkta**](IdentityProviderApi.md#getIdentityprovidersOkta) | **GET** /api/v2/identityproviders/okta | Get Okta Identity Provider
[**getIdentityprovidersOnelogin**](IdentityProviderApi.md#getIdentityprovidersOnelogin) | **GET** /api/v2/identityproviders/onelogin | Get OneLogin Identity Provider
[**getIdentityprovidersPing**](IdentityProviderApi.md#getIdentityprovidersPing) | **GET** /api/v2/identityproviders/ping | Get Ping Identity Provider
[**getIdentityprovidersPurecloud**](IdentityProviderApi.md#getIdentityprovidersPurecloud) | **GET** /api/v2/identityproviders/purecloud | Get PureCloud Identity Provider
[**getIdentityprovidersSalesforce**](IdentityProviderApi.md#getIdentityprovidersSalesforce) | **GET** /api/v2/identityproviders/salesforce | Get Salesforce Identity Provider
[**putIdentityprovidersAdfs**](IdentityProviderApi.md#putIdentityprovidersAdfs) | **PUT** /api/v2/identityproviders/adfs | Update/Create ADFS Identity Provider
[**putIdentityprovidersCic**](IdentityProviderApi.md#putIdentityprovidersCic) | **PUT** /api/v2/identityproviders/cic | Update/Create Customer Interaction Center (CIC) Identity Provider
[**putIdentityprovidersGsuite**](IdentityProviderApi.md#putIdentityprovidersGsuite) | **PUT** /api/v2/identityproviders/gsuite | Update/Create G Suite Identity Provider
[**putIdentityprovidersIdentitynow**](IdentityProviderApi.md#putIdentityprovidersIdentitynow) | **PUT** /api/v2/identityproviders/identitynow | Update/Create IdentityNow Provider
[**putIdentityprovidersOkta**](IdentityProviderApi.md#putIdentityprovidersOkta) | **PUT** /api/v2/identityproviders/okta | Update/Create Okta Identity Provider
[**putIdentityprovidersOnelogin**](IdentityProviderApi.md#putIdentityprovidersOnelogin) | **PUT** /api/v2/identityproviders/onelogin | Update/Create OneLogin Identity Provider
[**putIdentityprovidersPing**](IdentityProviderApi.md#putIdentityprovidersPing) | **PUT** /api/v2/identityproviders/ping | Update/Create Ping Identity Provider
[**putIdentityprovidersPurecloud**](IdentityProviderApi.md#putIdentityprovidersPurecloud) | **PUT** /api/v2/identityproviders/purecloud | Update/Create PureCloud Identity Provider
[**putIdentityprovidersSalesforce**](IdentityProviderApi.md#putIdentityprovidersSalesforce) | **PUT** /api/v2/identityproviders/salesforce | Update/Create Salesforce Identity Provider


# **deleteIdentityprovidersAdfs**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersAdfs()

Delete ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersAdfs();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersCic**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersCic()

Delete Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersCic();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersGsuite**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersGsuite()

Delete G Suite Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersGsuite();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersGsuite: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersIdentitynow**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersIdentitynow()

Delete IdentityNow Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersIdentitynow();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersIdentitynow: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersOkta**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersOkta()

Delete Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersOkta();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersOnelogin**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersOnelogin()

Delete OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersOnelogin();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersPing**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersPing()

Delete Ping Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersPing();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersPing: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersPurecloud**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersPurecloud()

Delete PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersPurecloud();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteIdentityprovidersSalesforce**
> \PureCloudSDK\ModelEmpty deleteIdentityprovidersSalesforce()

Delete Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->deleteIdentityprovidersSalesforce();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityproviders**
> \PureCloudSDK\OAuthProviderEntityListing getIdentityproviders()

The list of identity providers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityproviders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityproviders: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthProviderEntityListing**](../Model/OAuthProviderEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersAdfs**
> \PureCloudSDK\ADFS getIdentityprovidersAdfs()

Get ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersAdfs();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ADFS**](../Model/ADFS.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersCic**
> \PureCloudSDK\CustomerInteractionCenter getIdentityprovidersCic()

Get Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersCic();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CustomerInteractionCenter**](../Model/CustomerInteractionCenter.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersGsuite**
> \PureCloudSDK\GSuite getIdentityprovidersGsuite()

Get G Suite Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersGsuite();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersGsuite: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\GSuite**](../Model/GSuite.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersIdentitynow**
> \PureCloudSDK\IdentityNow getIdentityprovidersIdentitynow()

Get IdentityNow Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersIdentitynow();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersIdentitynow: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\IdentityNow**](../Model/IdentityNow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersOkta**
> \PureCloudSDK\Okta getIdentityprovidersOkta()

Get Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersOkta();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Okta**](../Model/Okta.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersOnelogin**
> \PureCloudSDK\OneLogin getIdentityprovidersOnelogin()

Get OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersOnelogin();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OneLogin**](../Model/OneLogin.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersPing**
> \PureCloudSDK\PingIdentity getIdentityprovidersPing()

Get Ping Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersPing();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersPing: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\PingIdentity**](../Model/PingIdentity.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersPurecloud**
> \PureCloudSDK\PureCloud getIdentityprovidersPurecloud()

Get PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersPurecloud();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\PureCloud**](../Model/PureCloud.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityprovidersSalesforce**
> \PureCloudSDK\Salesforce getIdentityprovidersSalesforce()

Get Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityprovidersSalesforce();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Salesforce**](../Model/Salesforce.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersAdfs**
> \PureCloudSDK\OAuthProvider putIdentityprovidersAdfs($body)

Update/Create ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\ADFS(); // \PureCloudSDK\ADFS | Provider

try {
    $result = $api_instance->putIdentityprovidersAdfs($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ADFS**](../Model/\PureCloudSDK\ADFS.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersCic**
> \PureCloudSDK\OAuthProvider putIdentityprovidersCic($body)

Update/Create Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\CustomerInteractionCenter(); // \PureCloudSDK\CustomerInteractionCenter | Provider

try {
    $result = $api_instance->putIdentityprovidersCic($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CustomerInteractionCenter**](../Model/\PureCloudSDK\CustomerInteractionCenter.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersGsuite**
> \PureCloudSDK\OAuthProvider putIdentityprovidersGsuite($body)

Update/Create G Suite Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\GSuite(); // \PureCloudSDK\GSuite | Provider

try {
    $result = $api_instance->putIdentityprovidersGsuite($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersGsuite: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GSuite**](../Model/\PureCloudSDK\GSuite.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersIdentitynow**
> \PureCloudSDK\IdentityNow putIdentityprovidersIdentitynow($body)

Update/Create IdentityNow Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\IdentityNow(); // \PureCloudSDK\IdentityNow | Provider

try {
    $result = $api_instance->putIdentityprovidersIdentitynow($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersIdentitynow: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\IdentityNow**](../Model/\PureCloudSDK\IdentityNow.md)| Provider |

### Return type

[**\PureCloudSDK\IdentityNow**](../Model/IdentityNow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersOkta**
> \PureCloudSDK\OAuthProvider putIdentityprovidersOkta($body)

Update/Create Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Okta(); // \PureCloudSDK\Okta | Provider

try {
    $result = $api_instance->putIdentityprovidersOkta($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Okta**](../Model/\PureCloudSDK\Okta.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersOnelogin**
> \PureCloudSDK\OAuthProvider putIdentityprovidersOnelogin($body)

Update/Create OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\OneLogin(); // \PureCloudSDK\OneLogin | Provider

try {
    $result = $api_instance->putIdentityprovidersOnelogin($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OneLogin**](../Model/\PureCloudSDK\OneLogin.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersPing**
> \PureCloudSDK\OAuthProvider putIdentityprovidersPing($body)

Update/Create Ping Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\PingIdentity(); // \PureCloudSDK\PingIdentity | Provider

try {
    $result = $api_instance->putIdentityprovidersPing($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersPing: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PingIdentity**](../Model/\PureCloudSDK\PingIdentity.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersPurecloud**
> \PureCloudSDK\OAuthProvider putIdentityprovidersPurecloud($body)

Update/Create PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\PureCloud(); // \PureCloudSDK\PureCloud | Provider

try {
    $result = $api_instance->putIdentityprovidersPurecloud($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PureCloud**](../Model/\PureCloudSDK\PureCloud.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putIdentityprovidersSalesforce**
> \PureCloudSDK\OAuthProvider putIdentityprovidersSalesforce($body)

Update/Create Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Salesforce(); // \PureCloudSDK\Salesforce | Provider

try {
    $result = $api_instance->putIdentityprovidersSalesforce($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putIdentityprovidersSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Salesforce**](../Model/\PureCloudSDK\Salesforce.md)| Provider |

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

