# PureCloudSDK\LicenseApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLicenseDefinitions**](LicenseApi.md#getLicenseDefinitions) | **GET** /api/v2/license/definitions | Get all PureCloud license definitions available for the organization.
[**getLicenseDefinitionsLicenseId**](LicenseApi.md#getLicenseDefinitionsLicenseId) | **GET** /api/v2/license/definitions/{licenseId} | Get PureCloud license definition.
[**getLicenseOrganization**](LicenseApi.md#getLicenseOrganization) | **GET** /api/v2/license/organization | Get license assignments for the organization.
[**getLicenseUsersUserId**](LicenseApi.md#getLicenseUsersUserId) | **GET** /api/v2/license/users/{userId} | Get licenses for specified user.
[**postLicenseOrganization**](LicenseApi.md#postLicenseOrganization) | **POST** /api/v2/license/organization | Update the organization&#39;s license assignments in a batch.
[**postLicenseUsers**](LicenseApi.md#postLicenseUsers) | **POST** /api/v2/license/users | Fetch user licenses in a batch.


# **getLicenseDefinitions**
> \PureCloudSDK\LicenseDefinitionListing getLicenseDefinitions()

Get all PureCloud license definitions available for the organization.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();

try {
    $result = $api_instance->getLicenseDefinitions();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->getLicenseDefinitions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\LicenseDefinitionListing**](../Model/LicenseDefinitionListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLicenseDefinitionsLicenseId**
> \PureCloudSDK\LicenseDefinition getLicenseDefinitionsLicenseId($licenseId)

Get PureCloud license definition.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();
$licenseId = "licenseId_example"; // string | ID

try {
    $result = $api_instance->getLicenseDefinitionsLicenseId($licenseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->getLicenseDefinitionsLicenseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **licenseId** | **string**| ID |

### Return type

[**\PureCloudSDK\LicenseDefinition**](../Model/LicenseDefinition.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLicenseOrganization**
> \PureCloudSDK\LicenseOrganization getLicenseOrganization()

Get license assignments for the organization.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();

try {
    $result = $api_instance->getLicenseOrganization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->getLicenseOrganization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\LicenseOrganization**](../Model/LicenseOrganization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLicenseUsersUserId**
> \PureCloudSDK\LicenseUser getLicenseUsersUserId($userId)

Get licenses for specified user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();
$userId = "userId_example"; // string | ID

try {
    $result = $api_instance->getLicenseUsersUserId($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->getLicenseUsersUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| ID |

### Return type

[**\PureCloudSDK\LicenseUser**](../Model/LicenseUser.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLicenseOrganization**
> \PureCloudSDK\LicenseUpdateResponse postLicenseOrganization($body)

Update the organization's license assignments in a batch.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();
$body = new \PureCloudSDK\LicenseBatchAssignmentRequest(); // \PureCloudSDK\LicenseBatchAssignmentRequest | The license assignments to update.

try {
    $result = $api_instance->postLicenseOrganization($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->postLicenseOrganization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LicenseBatchAssignmentRequest**](../Model/\PureCloudSDK\LicenseBatchAssignmentRequest.md)| The license assignments to update. | [optional]

### Return type

[**\PureCloudSDK\LicenseUpdateResponse**](../Model/LicenseUpdateResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLicenseUsers**
> map[string,object] postLicenseUsers($body)

Fetch user licenses in a batch.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LicenseApi();
$body = array(new string[]()); // string[] | The user IDs to fetch.

try {
    $result = $api_instance->postLicenseUsers($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LicenseApi->postLicenseUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | **string[]**| The user IDs to fetch. | [optional]

### Return type

[**map[string,object]**](../Model/map.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

