# PureCloudSDK\QualityApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteQualityCalibrationsCalibrationId**](QualityApi.md#deleteQualityCalibrationsCalibrationId) | **DELETE** /api/v2/quality/calibrations/{calibrationId} | Delete a calibration by id.
[**deleteQualityConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#deleteQualityConversationsConversationIdEvaluationsEvaluationId) | **DELETE** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Delete an evaluation
[**deleteQualityFormsFormId**](QualityApi.md#deleteQualityFormsFormId) | **DELETE** /api/v2/quality/forms/{formId} | Delete an evaluation form.
[**deleteQualityKeywordsets**](QualityApi.md#deleteQualityKeywordsets) | **DELETE** /api/v2/quality/keywordsets | Delete keyword sets
[**deleteQualityKeywordsetsKeywordsetId**](QualityApi.md#deleteQualityKeywordsetsKeywordsetId) | **DELETE** /api/v2/quality/keywordsets/{keywordSetId} | Delete a keywordSet by id.
[**getQualityAgentsActivity**](QualityApi.md#getQualityAgentsActivity) | **GET** /api/v2/quality/agents/activity | Gets a list of Agent Activities
[**getQualityCalibrations**](QualityApi.md#getQualityCalibrations) | **GET** /api/v2/quality/calibrations | Get the list of calibrations
[**getQualityCalibrationsCalibrationId**](QualityApi.md#getQualityCalibrationsCalibrationId) | **GET** /api/v2/quality/calibrations/{calibrationId} | Get a calibration by id.
[**getQualityConversationsConversationIdAudits**](QualityApi.md#getQualityConversationsConversationIdAudits) | **GET** /api/v2/quality/conversations/{conversationId}/audits | Get audits for conversation or recording
[**getQualityConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#getQualityConversationsConversationIdEvaluationsEvaluationId) | **GET** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Get an evaluation
[**getQualityEvaluationsQuery**](QualityApi.md#getQualityEvaluationsQuery) | **GET** /api/v2/quality/evaluations/query | Queries Evaluations and returns a paged list
[**getQualityEvaluatorsActivity**](QualityApi.md#getQualityEvaluatorsActivity) | **GET** /api/v2/quality/evaluators/activity | Get an evaluator activity
[**getQualityForms**](QualityApi.md#getQualityForms) | **GET** /api/v2/quality/forms | Get the list of evaluation forms
[**getQualityFormsFormId**](QualityApi.md#getQualityFormsFormId) | **GET** /api/v2/quality/forms/{formId} | Get an evaluation form
[**getQualityFormsFormIdVersions**](QualityApi.md#getQualityFormsFormIdVersions) | **GET** /api/v2/quality/forms/{formId}/versions | Gets all the revisions for a specific evaluation.
[**getQualityKeywordsets**](QualityApi.md#getQualityKeywordsets) | **GET** /api/v2/quality/keywordsets | Get the list of keyword sets
[**getQualityKeywordsetsKeywordsetId**](QualityApi.md#getQualityKeywordsetsKeywordsetId) | **GET** /api/v2/quality/keywordsets/{keywordSetId} | Get a keywordSet by id.
[**getQualityPublishedforms**](QualityApi.md#getQualityPublishedforms) | **GET** /api/v2/quality/publishedforms | Get the published evaluation forms.
[**getQualityPublishedformsFormId**](QualityApi.md#getQualityPublishedformsFormId) | **GET** /api/v2/quality/publishedforms/{formId} | Get the published evaluation forms.
[**postAnalyticsEvaluationsAggregatesQuery**](QualityApi.md#postAnalyticsEvaluationsAggregatesQuery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
[**postQualityCalibrations**](QualityApi.md#postQualityCalibrations) | **POST** /api/v2/quality/calibrations | Create a calibration
[**postQualityConversationsConversationIdEvaluations**](QualityApi.md#postQualityConversationsConversationIdEvaluations) | **POST** /api/v2/quality/conversations/{conversationId}/evaluations | Create an evaluation
[**postQualityEvaluationsScoring**](QualityApi.md#postQualityEvaluationsScoring) | **POST** /api/v2/quality/evaluations/scoring | Score evaluation
[**postQualityForms**](QualityApi.md#postQualityForms) | **POST** /api/v2/quality/forms | Create an evaluation form.
[**postQualityKeywordsets**](QualityApi.md#postQualityKeywordsets) | **POST** /api/v2/quality/keywordsets | Create a Keyword Set
[**postQualityPublishedforms**](QualityApi.md#postQualityPublishedforms) | **POST** /api/v2/quality/publishedforms | Publish an evaluation form.
[**postQualitySpotability**](QualityApi.md#postQualitySpotability) | **POST** /api/v2/quality/spotability | Retrieve the spotability statistic
[**putQualityCalibrationsCalibrationId**](QualityApi.md#putQualityCalibrationsCalibrationId) | **PUT** /api/v2/quality/calibrations/{calibrationId} | Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
[**putQualityConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#putQualityConversationsConversationIdEvaluationsEvaluationId) | **PUT** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Update an evaluation
[**putQualityFormsFormId**](QualityApi.md#putQualityFormsFormId) | **PUT** /api/v2/quality/forms/{formId} | Update an evaluation form.
[**putQualityKeywordsetsKeywordsetId**](QualityApi.md#putQualityKeywordsetsKeywordsetId) | **PUT** /api/v2/quality/keywordsets/{keywordSetId} | Update a keywordSet to the specified keywordSet via PUT.


# **deleteQualityCalibrationsCalibrationId**
> \PureCloudSDK\Calibration deleteQualityCalibrationsCalibrationId($calibrationId, $calibratorId)

Delete a calibration by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$calibratorId = "calibratorId_example"; // string | calibratorId

try {
    $result = $api_instance->deleteQualityCalibrationsCalibrationId($calibrationId, $calibratorId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteQualityCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **calibratorId** | **string**| calibratorId |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQualityConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation deleteQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand)

Delete an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->deleteQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteQualityConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQualityFormsFormId**
> deleteQualityFormsFormId($formId)

Delete an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $api_instance->deleteQualityFormsFormId($formId);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteQualityFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQualityKeywordsets**
> deleteQualityKeywordsets($ids)

Delete keyword sets

Bulk delete of keyword sets; this will only delete the keyword sets that match the ids specified in the query param.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$ids = "ids_example"; // string | A comma-delimited list of valid KeywordSet ids

try {
    $api_instance->deleteQualityKeywordsets($ids);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteQualityKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | **string**| A comma-delimited list of valid KeywordSet ids |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQualityKeywordsetsKeywordsetId**
> deleteQualityKeywordsetsKeywordsetId($keywordSetId)

Delete a keywordSet by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID

try {
    $api_instance->deleteQualityKeywordsetsKeywordsetId($keywordSetId);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteQualityKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityAgentsActivity**
> \PureCloudSDK\AgentActivityEntityListing getQualityAgentsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $agentUserId, $evaluatorUserId, $name, $group)

Gets a list of Agent Activities

Including the number of evaluations and average evaluation score

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$startTime = new \DateTime(); // \DateTime | Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$agentUserId = NULL; // object[] | user id of agent requested
$evaluatorUserId = "evaluatorUserId_example"; // string | user id of the evaluator
$name = "name_example"; // string | name
$group = "group_example"; // string | group id

try {
    $result = $api_instance->getQualityAgentsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $agentUserId, $evaluatorUserId, $name, $group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityAgentsActivity: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **startTime** | **\DateTime**| Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **agentUserId** | [**object[]**](../Model/object.md)| user id of agent requested | [optional]
 **evaluatorUserId** | **string**| user id of the evaluator | [optional]
 **name** | **string**| name | [optional]
 **group** | **string**| group id | [optional]

### Return type

[**\PureCloudSDK\AgentActivityEntityListing**](../Model/AgentActivityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityCalibrations**
> \PureCloudSDK\CalibrationEntityListing getQualityCalibrations($calibratorId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $startTime, $endTime)

Get the list of calibrations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibratorId = "calibratorId_example"; // string | user id of calibrator
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$conversationId = "conversationId_example"; // string | conversation id
$startTime = new \DateTime(); // \DateTime | Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

try {
    $result = $api_instance->getQualityCalibrations($calibratorId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $startTime, $endTime);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityCalibrations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibratorId** | **string**| user id of calibrator |
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **conversationId** | **string**| conversation id | [optional]
 **startTime** | **\DateTime**| Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]

### Return type

[**\PureCloudSDK\CalibrationEntityListing**](../Model/CalibrationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityCalibrationsCalibrationId**
> \PureCloudSDK\Calibration getQualityCalibrationsCalibrationId($calibrationId, $calibratorId)

Get a calibration by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$calibratorId = "calibratorId_example"; // string | calibratorId

try {
    $result = $api_instance->getQualityCalibrationsCalibrationId($calibrationId, $calibratorId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **calibratorId** | **string**| calibratorId |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityConversationsConversationIdAudits**
> \PureCloudSDK\QualityAuditPage getQualityConversationsConversationIdAudits($conversationId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $recordingId, $entityType)

Get audits for conversation or recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$recordingId = "recordingId_example"; // string | id of the recording
$entityType = "RECORDING"; // string | entity type options: Recording, Calibration, Evaluation, Annotation, Screen_Recording

try {
    $result = $api_instance->getQualityConversationsConversationIdAudits($conversationId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $recordingId, $entityType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityConversationsConversationIdAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **recordingId** | **string**| id of the recording | [optional]
 **entityType** | **string**| entity type options: Recording, Calibration, Evaluation, Annotation, Screen_Recording | [optional] [default to RECORDING]

### Return type

[**\PureCloudSDK\QualityAuditPage**](../Model/QualityAuditPage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation getQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand)

Get an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$expand = "expand_example"; // string | agent, evaluator, evaluationForm

try {
    $result = $api_instance->getQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **expand** | **string**| agent, evaluator, evaluationForm | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityEvaluationsQuery**
> \PureCloudSDK\EvaluationEntityListing getQualityEvaluationsQuery($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $agentUserId, $evaluatorUserId, $queueId, $startTime, $endTime, $evaluationState, $isReleased, $agentHasRead, $expandAnswerTotalScores, $maximum)

Queries Evaluations and returns a paged list

Query params must include one of conversationId, evaluatorUserId, or agentUserId

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$conversationId = "conversationId_example"; // string | conversationId specified
$agentUserId = "agentUserId_example"; // string | user id of the agent
$evaluatorUserId = "evaluatorUserId_example"; // string | evaluator user id
$queueId = "queueId_example"; // string | queue id
$startTime = "startTime_example"; // string | start time of the evaluation query
$endTime = "endTime_example"; // string | end time of the evaluation query
$evaluationState = NULL; // object[] | evaluation state options: Pending, InProgress, Finished
$isReleased = true; // bool | the evaluation has been released
$agentHasRead = true; // bool | agent has the evaluation
$expandAnswerTotalScores = true; // bool | get the total scores for evaluations
$maximum = 56; // int | maximum

try {
    $result = $api_instance->getQualityEvaluationsQuery($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $agentUserId, $evaluatorUserId, $queueId, $startTime, $endTime, $evaluationState, $isReleased, $agentHasRead, $expandAnswerTotalScores, $maximum);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityEvaluationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **conversationId** | **string**| conversationId specified | [optional]
 **agentUserId** | **string**| user id of the agent | [optional]
 **evaluatorUserId** | **string**| evaluator user id | [optional]
 **queueId** | **string**| queue id | [optional]
 **startTime** | **string**| start time of the evaluation query | [optional]
 **endTime** | **string**| end time of the evaluation query | [optional]
 **evaluationState** | [**object[]**](../Model/object.md)| evaluation state options: Pending, InProgress, Finished | [optional]
 **isReleased** | **bool**| the evaluation has been released | [optional]
 **agentHasRead** | **bool**| agent has the evaluation | [optional]
 **expandAnswerTotalScores** | **bool**| get the total scores for evaluations | [optional]
 **maximum** | **int**| maximum | [optional]

### Return type

[**\PureCloudSDK\EvaluationEntityListing**](../Model/EvaluationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityEvaluatorsActivity**
> \PureCloudSDK\EvaluatorActivityEntityListing getQualityEvaluatorsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $name, $permission, $group)

Get an evaluator activity



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$startTime = new \DateTime(); // \DateTime | The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$name = "name_example"; // string | Evaluator name
$permission = NULL; // object[] | permission strings
$group = "group_example"; // string | group id

try {
    $result = $api_instance->getQualityEvaluatorsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $name, $permission, $group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityEvaluatorsActivity: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **startTime** | **\DateTime**| The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **name** | **string**| Evaluator name | [optional]
 **permission** | [**object[]**](../Model/object.md)| permission strings | [optional]
 **group** | **string**| group id | [optional]

### Return type

[**\PureCloudSDK\EvaluatorActivityEntityListing**](../Model/EvaluatorActivityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityForms**
> \PureCloudSDK\EvaluationFormEntityListing getQualityForms($pageSize, $pageNumber, $sortBy, $nextPage, $previousPage, $expand, $name)

Get the list of evaluation forms



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$expand = "expand_example"; // string | Expand
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getQualityForms($pageSize, $pageNumber, $sortBy, $nextPage, $previousPage, $expand, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityForms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **expand** | **string**| Expand | [optional]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityFormsFormId**
> \PureCloudSDK\EvaluationForm getQualityFormsFormId($formId)

Get an evaluation form



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $result = $api_instance->getQualityFormsFormId($formId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityFormsFormIdVersions**
> \PureCloudSDK\EvaluationFormEntityListing getQualityFormsFormIdVersions($formId, $pageSize, $pageNumber)

Gets all the revisions for a specific evaluation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getQualityFormsFormIdVersions($formId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityFormsFormIdVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityKeywordsets**
> \PureCloudSDK\KeywordSetEntityListing getQualityKeywordsets($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $queueId, $agentId, $operator)

Get the list of keyword sets



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$name = "name_example"; // string | the keyword set name - used for filtering results in searches.
$queueId = "queueId_example"; // string | the queue id - used for filtering results in searches.
$agentId = "agentId_example"; // string | the agent id - used for filtering results in searches.
$operator = "operator_example"; // string | If agentID and queueId are both present, this determines whether the query is an AND or OR between those parameters.

try {
    $result = $api_instance->getQualityKeywordsets($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $queueId, $agentId, $operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **name** | **string**| the keyword set name - used for filtering results in searches. | [optional]
 **queueId** | **string**| the queue id - used for filtering results in searches. | [optional]
 **agentId** | **string**| the agent id - used for filtering results in searches. | [optional]
 **operator** | **string**| If agentID and queueId are both present, this determines whether the query is an AND or OR between those parameters. | [optional]

### Return type

[**\PureCloudSDK\KeywordSetEntityListing**](../Model/KeywordSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityKeywordsetsKeywordsetId**
> \PureCloudSDK\KeywordSet getQualityKeywordsetsKeywordsetId($keywordSetId)

Get a keywordSet by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID

try {
    $result = $api_instance->getQualityKeywordsetsKeywordsetId($keywordSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityPublishedforms**
> \PureCloudSDK\EvaluationFormEntityListing getQualityPublishedforms($pageSize, $pageNumber, $name)

Get the published evaluation forms.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getQualityPublishedforms($pageSize, $pageNumber, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityPublishedforms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQualityPublishedformsFormId**
> \PureCloudSDK\EvaluationForm getQualityPublishedformsFormId($formId)

Get the published evaluation forms.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $result = $api_instance->getQualityPublishedformsFormId($formId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getQualityPublishedformsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsEvaluationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postAnalyticsEvaluationsAggregatesQuery($body)

Query for evaluation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsEvaluationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postAnalyticsEvaluationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityCalibrations**
> \PureCloudSDK\Calibration postQualityCalibrations($body, $expand)

Create a calibration



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\CalibrationCreate(); // \PureCloudSDK\CalibrationCreate | calibration
$expand = "expand_example"; // string | calibratorId

try {
    $result = $api_instance->postQualityCalibrations($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityCalibrations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CalibrationCreate**](../Model/\PureCloudSDK\CalibrationCreate.md)| calibration |
 **expand** | **string**| calibratorId | [optional]

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityConversationsConversationIdEvaluations**
> \PureCloudSDK\Evaluation postQualityConversationsConversationIdEvaluations($conversationId, $body, $expand)

Create an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Evaluation(); // \PureCloudSDK\Evaluation | evaluation
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->postQualityConversationsConversationIdEvaluations($conversationId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityConversationsConversationIdEvaluations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Evaluation**](../Model/\PureCloudSDK\Evaluation.md)| evaluation |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityEvaluationsScoring**
> \PureCloudSDK\EvaluationScoringSet postQualityEvaluationsScoring($body)

Score evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationFormAndScoringSet(); // \PureCloudSDK\EvaluationFormAndScoringSet | evaluationAndScoringSet

try {
    $result = $api_instance->postQualityEvaluationsScoring($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityEvaluationsScoring: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationFormAndScoringSet**](../Model/\PureCloudSDK\EvaluationFormAndScoringSet.md)| evaluationAndScoringSet |

### Return type

[**\PureCloudSDK\EvaluationScoringSet**](../Model/EvaluationScoringSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityForms**
> \PureCloudSDK\EvaluationForm postQualityForms($body)

Create an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->postQualityForms($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityForms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityKeywordsets**
> \PureCloudSDK\KeywordSet postQualityKeywordsets($body, $expand)

Create a Keyword Set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | keywordSet
$expand = "expand_example"; // string | queueId

try {
    $result = $api_instance->postQualityKeywordsets($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| keywordSet |
 **expand** | **string**| queueId | [optional]

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualityPublishedforms**
> \PureCloudSDK\EvaluationForm postQualityPublishedforms($body)

Publish an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->postQualityPublishedforms($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualityPublishedforms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQualitySpotability**
> \PureCloudSDK\KeywordSet postQualitySpotability($body)

Retrieve the spotability statistic



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | Keyword Set

try {
    $result = $api_instance->postQualitySpotability($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postQualitySpotability: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| Keyword Set | [optional]

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putQualityCalibrationsCalibrationId**
> \PureCloudSDK\Calibration putQualityCalibrationsCalibrationId($calibrationId, $body)

Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$body = new \PureCloudSDK\Calibration(); // \PureCloudSDK\Calibration | Calibration

try {
    $result = $api_instance->putQualityCalibrationsCalibrationId($calibrationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putQualityCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **body** | [**\PureCloudSDK\Calibration**](../Model/\PureCloudSDK\Calibration.md)| Calibration |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putQualityConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation putQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $body, $expand)

Update an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$body = new \PureCloudSDK\Evaluation(); // \PureCloudSDK\Evaluation | evaluation
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->putQualityConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putQualityConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **body** | [**\PureCloudSDK\Evaluation**](../Model/\PureCloudSDK\Evaluation.md)| evaluation |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putQualityFormsFormId**
> \PureCloudSDK\EvaluationForm putQualityFormsFormId($formId, $body)

Update an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->putQualityFormsFormId($formId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putQualityFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putQualityKeywordsetsKeywordsetId**
> \PureCloudSDK\KeywordSet putQualityKeywordsetsKeywordsetId($keywordSetId, $body)

Update a keywordSet to the specified keywordSet via PUT.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | keywordSet

try {
    $result = $api_instance->putQualityKeywordsetsKeywordsetId($keywordSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putQualityKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| keywordSet |

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

