# PureCloudSDK\TelephonyProvidersEdgeApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId) | **DELETE** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Delete a certificate authority.
[**deleteTelephonyProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesDidpoolsDidpoolId) | **DELETE** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Delete a DID Pool by ID.
[**deleteTelephonyProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesEdgeId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId} | Delete a edge.
[**deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Delete an edge logical interface
[**deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Cancels any in-progress update for this edge.
[**deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId) | **DELETE** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Delete an edge group.
[**deleteTelephonyProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesEndpointsEndpointId) | **DELETE** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Delete endpoint
[**deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId) | **DELETE** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Delete an extension pool by ID
[**deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId) | **DELETE** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Delete Outbound Route
[**deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId) | **DELETE** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Delete a Phone Base Settings by ID
[**deleteTelephonyProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesPhonesPhoneId) | **DELETE** /api/v2/telephony/providers/edges/phones/{phoneId} | Delete a Phone by ID
[**deleteTelephonyProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesSitesSiteId) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId} | Delete a Site by ID
[**deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Delete Outbound Route
[**deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **DELETE** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Delete a Trunk Base Settings object by ID
[**getConfigurationSchemasEdgesVnext**](TelephonyProvidersEdgeApi.md#getConfigurationSchemasEdgesVnext) | **GET** /api/v2/configuration/schemas/edges/vnext | Lists available schema categories (Deprecated)
[**getConfigurationSchemasEdgesVnextSchemacategory**](TelephonyProvidersEdgeApi.md#getConfigurationSchemasEdgesVnextSchemacategory) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory} | List schemas of a specific category (Deprecated)
[**getConfigurationSchemasEdgesVnextSchemacategorySchematype**](TelephonyProvidersEdgeApi.md#getConfigurationSchemasEdgesVnextSchemacategorySchematype) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType} | List schemas of a specific category (Deprecated)
[**getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId**](TelephonyProvidersEdgeApi.md#getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId} | Get a json schema (Deprecated)
[**getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**](TelephonyProvidersEdgeApi.md#getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId} | Get metadata for a schema (Deprecated)
[**getTelephonyProvidersEdges**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdges) | **GET** /api/v2/telephony/providers/edges | Get the list of edges.
[**getTelephonyProvidersEdgesAvailablelanguages**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesAvailablelanguages) | **GET** /api/v2/telephony/providers/edges/availablelanguages | Get the list of available languages.
[**getTelephonyProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesCertificateauthorities) | **GET** /api/v2/telephony/providers/edges/certificateauthorities | Get the list of certificate authorities.
[**getTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesCertificateauthoritiesCertificateId) | **GET** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Get a certificate authority.
[**getTelephonyProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesDidpools) | **GET** /api/v2/telephony/providers/edges/didpools | Get a listing of DID Pools
[**getTelephonyProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesDidpoolsDidpoolId) | **GET** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Get a DID Pool by ID.
[**getTelephonyProvidersEdgesDids**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesDids) | **GET** /api/v2/telephony/providers/edges/dids | Get a listing of DIDs
[**getTelephonyProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesDidsDidId) | **GET** /api/v2/telephony/providers/edges/dids/{didId} | Get a DID by ID.
[**getTelephonyProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeId) | **GET** /api/v2/telephony/providers/edges/{edgeId} | Get edge.
[**getTelephonyProvidersEdgesEdgeIdLines**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdLines) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines | Get the list of lines.
[**getTelephonyProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdLinesLineId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Get line
[**getTelephonyProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdLogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Get edge logical interfaces.
[**getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Get an edge logical interface
[**getTelephonyProvidersEdgesEdgeIdLogsJobsJobId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdLogsJobsJobId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId} | Get an Edge logs job.
[**getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces | Retrieve a list of all configured physical interfaces from a specific edge.
[**getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId} | Get edge physical interface.
[**getTelephonyProvidersEdgesEdgeIdSetuppackage**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdSetuppackage) | **GET** /api/v2/telephony/providers/edges/{edgeId}/setuppackage | Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
[**getTelephonyProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdSoftwareupdate) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Gets software update status information about any edge.
[**getTelephonyProvidersEdgesEdgeIdSoftwareversions**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeIdSoftwareversions) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareversions | Gets all the available software versions for this edge.
[**getTelephonyProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgegroups) | **GET** /api/v2/telephony/providers/edges/edgegroups | Get the list of edge groups.
[**getTelephonyProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgegroupsEdgegroupId) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Get edge group.
[**getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgegroupId}/edgetrunkbases/{edgetrunkbaseId} | Gets the edge trunk base associated with the edge group
[**getTelephonyProvidersEdgesEdgeversionreport**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEdgeversionreport) | **GET** /api/v2/telephony/providers/edges/edgeversionreport | Get the edge version report.
[**getTelephonyProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEndpoints) | **GET** /api/v2/telephony/providers/edges/endpoints | Get endpoints
[**getTelephonyProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesEndpointsEndpointId) | **GET** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Get endpoint
[**getTelephonyProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesExtensionpools) | **GET** /api/v2/telephony/providers/edges/extensionpools | Get a listing of extension pools
[**getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId) | **GET** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Get an extension pool by ID
[**getTelephonyProvidersEdgesExtensions**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesExtensions) | **GET** /api/v2/telephony/providers/edges/extensions | Get a listing of extensions
[**getTelephonyProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesExtensionsExtensionId) | **GET** /api/v2/telephony/providers/edges/extensions/{extensionId} | Get an extension by ID.
[**getTelephonyProvidersEdgesLinebasesettings**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLinebasesettings) | **GET** /api/v2/telephony/providers/edges/linebasesettings | Get a listing of line base settings objects
[**getTelephonyProvidersEdgesLinebasesettingsLinebaseId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLinebasesettingsLinebaseId) | **GET** /api/v2/telephony/providers/edges/linebasesettings/{lineBaseId} | Get a line base settings object by ID
[**getTelephonyProvidersEdgesLines**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLines) | **GET** /api/v2/telephony/providers/edges/lines | Get a list of Lines
[**getTelephonyProvidersEdgesLinesLineId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLinesLineId) | **GET** /api/v2/telephony/providers/edges/lines/{lineId} | Get a Line by ID
[**getTelephonyProvidersEdgesLinesTemplate**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLinesTemplate) | **GET** /api/v2/telephony/providers/edges/lines/template | Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
[**getTelephonyProvidersEdgesLogicalinterfaces**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesLogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/logicalinterfaces | Get edge logical interfaces.
[**getTelephonyProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesOutboundroutes) | **GET** /api/v2/telephony/providers/edges/outboundroutes | Get outbound routes
[**getTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesOutboundroutesOutboundrouteId) | **GET** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Get outbound route
[**getTelephonyProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonebasesettings) | **GET** /api/v2/telephony/providers/edges/phonebasesettings | Get a list of Phone Base Settings objects
[**getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/availablemetabases | Get a list of available makes and models to create a new Phone Base Settings
[**getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Get a Phone Base Settings object by ID
[**getTelephonyProvidersEdgesPhonebasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonebasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/template | Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
[**getTelephonyProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhones) | **GET** /api/v2/telephony/providers/edges/phones | Get a list of Phone Instances
[**getTelephonyProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonesPhoneId) | **GET** /api/v2/telephony/providers/edges/phones/{phoneId} | Get a Phone by ID
[**getTelephonyProvidersEdgesPhonesTemplate**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhonesTemplate) | **GET** /api/v2/telephony/providers/edges/phones/template | Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
[**getTelephonyProvidersEdgesPhysicalinterfaces**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesPhysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/physicalinterfaces | Get physical interfaces for edges.
[**getTelephonyProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSites) | **GET** /api/v2/telephony/providers/edges/sites | Get the list of Sites.
[**getTelephonyProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId} | Get a Site by ID.
[**getTelephonyProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteIdNumberplans) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Get the list of Number Plans for this Site.
[**getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications | Get a list of Classifications for this Site
[**getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId} | Get a Number Plan by ID.
[**getTelephonyProvidersEdgesSitesSiteIdOutboundroutes**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteIdOutboundroutes) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes | Get outbound routes
[**getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Get an outbound route
[**getTelephonyProvidersEdgesTimezones**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTimezones) | **GET** /api/v2/telephony/providers/edges/timezones | Get a list of Edge-compatible time zones
[**getTelephonyProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunkbasesettings) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings | Get Trunk Base Settings listing
[**getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases | Get a list of available makes and models to create a new Trunk Base Settings
[**getTelephonyProvidersEdgesTrunkbasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunkbasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/template | Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
[**getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Get a Trunk Base Settings object by ID
[**getTelephonyProvidersEdgesTrunks**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunks) | **GET** /api/v2/telephony/providers/edges/trunks | Get the list of available trunks.
[**getTelephonyProvidersEdgesTrunksTrunkId**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunksTrunkId) | **GET** /api/v2/telephony/providers/edges/trunks/{trunkId} | Get a Trunk by ID
[**getTelephonyProvidersEdgesTrunkswithrecording**](TelephonyProvidersEdgeApi.md#getTelephonyProvidersEdgesTrunkswithrecording) | **GET** /api/v2/telephony/providers/edges/trunkswithrecording | Get Counts of trunks that have recording disabled or enabled
[**postTelephonyProvidersEdges**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdges) | **POST** /api/v2/telephony/providers/edges | Create an edge.
[**postTelephonyProvidersEdgesAddressvalidation**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesAddressvalidation) | **POST** /api/v2/telephony/providers/edges/addressvalidation | Validates a street address
[**postTelephonyProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesCertificateauthorities) | **POST** /api/v2/telephony/providers/edges/certificateauthorities | Create a certificate authority.
[**postTelephonyProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesDidpools) | **POST** /api/v2/telephony/providers/edges/didpools | Create a new DID pool
[**postTelephonyProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdLogicalinterfaces) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Create an edge logical interface.
[**postTelephonyProvidersEdgesEdgeIdLogsJobs**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdLogsJobs) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs | Create a job to upload a list of Edge logs.
[**postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload | Request that the specified fileIds be uploaded from the Edge.
[**postTelephonyProvidersEdgesEdgeIdReboot**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdReboot) | **POST** /api/v2/telephony/providers/edges/{edgeId}/reboot | Reboot an Edge
[**postTelephonyProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdSoftwareupdate) | **POST** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Starts a software update for this edge.
[**postTelephonyProvidersEdgesEdgeIdStatuscode**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdStatuscode) | **POST** /api/v2/telephony/providers/edges/{edgeId}/statuscode | Take an Edge in or out of service
[**postTelephonyProvidersEdgesEdgeIdUnpair**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgeIdUnpair) | **POST** /api/v2/telephony/providers/edges/{edgeId}/unpair | Unpair an Edge
[**postTelephonyProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEdgegroups) | **POST** /api/v2/telephony/providers/edges/edgegroups | Create an edge group.
[**postTelephonyProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesEndpoints) | **POST** /api/v2/telephony/providers/edges/endpoints | Create endpoint
[**postTelephonyProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesExtensionpools) | **POST** /api/v2/telephony/providers/edges/extensionpools | Create a new extension pool
[**postTelephonyProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesOutboundroutes) | **POST** /api/v2/telephony/providers/edges/outboundroutes | Create outbound rule
[**postTelephonyProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesPhonebasesettings) | **POST** /api/v2/telephony/providers/edges/phonebasesettings | Create a new Phone Base Settings object
[**postTelephonyProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesPhones) | **POST** /api/v2/telephony/providers/edges/phones | Create a new Phone
[**postTelephonyProvidersEdgesPhonesPhoneIdReboot**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesPhonesPhoneIdReboot) | **POST** /api/v2/telephony/providers/edges/phones/{phoneId}/reboot | Reboot a Phone
[**postTelephonyProvidersEdgesPhonesReboot**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesPhonesReboot) | **POST** /api/v2/telephony/providers/edges/phones/reboot | Reboot Multiple Phones
[**postTelephonyProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesSites) | **POST** /api/v2/telephony/providers/edges/sites | Create a Site.
[**postTelephonyProvidersEdgesSitesSiteIdOutboundroutes**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesSitesSiteIdOutboundroutes) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes | Create outbound route
[**postTelephonyProvidersEdgesSitesSiteIdRebalance**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesSitesSiteIdRebalance) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/rebalance | Triggers the rebalance operation.
[**postTelephonyProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#postTelephonyProvidersEdgesTrunkbasesettings) | **POST** /api/v2/telephony/providers/edges/trunkbasesettings | Create a Trunk Base Settings object
[**putTelephonyProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesCertificateauthoritiesCertificateId) | **PUT** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Update a certificate authority.
[**putTelephonyProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesDidpoolsDidpoolId) | **PUT** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Update a DID Pool by ID.
[**putTelephonyProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesDidsDidId) | **PUT** /api/v2/telephony/providers/edges/dids/{didId} | Update a DID by ID.
[**putTelephonyProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEdgeId) | **PUT** /api/v2/telephony/providers/edges/{edgeId} | Update a edge.
[**putTelephonyProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEdgeIdLinesLineId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Update a line.
[**putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Update an edge logical interface.
[**putTelephonyProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEdgegroupsEdgegroupId) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Update an edge group.
[**putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgegroupId}/edgetrunkbases/{edgetrunkbaseId} | Update the edge trunk base associated with the edge group
[**putTelephonyProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesEndpointsEndpointId) | **PUT** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Update endpoint
[**putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId) | **PUT** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Update an extension pool by ID
[**putTelephonyProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesExtensionsExtensionId) | **PUT** /api/v2/telephony/providers/edges/extensions/{extensionId} | Update an extension by ID.
[**putTelephonyProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesOutboundroutesOutboundrouteId) | **PUT** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Update outbound route
[**putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId) | **PUT** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Update a Phone Base Settings by ID
[**putTelephonyProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesPhonesPhoneId) | **PUT** /api/v2/telephony/providers/edges/phones/{phoneId} | Update a Phone by ID
[**putTelephonyProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesSitesSiteId) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId} | Update a Site by ID.
[**putTelephonyProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesSitesSiteIdNumberplans) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Update the list of Number Plans.
[**putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId} | Update outbound route
[**putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **PUT** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Update a Trunk Base Settings object by ID


# **deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId**
> deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId)

Delete a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID

try {
    $api_instance->deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesDidpoolsDidpoolId**
> deleteTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId)

Delete a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID

try {
    $api_instance->deleteTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesEdgeId**
> deleteTelephonyProvidersEdgesEdgeId($edgeId)

Delete a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $api_instance->deleteTelephonyProvidersEdgesEdgeId($edgeId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId)

Delete an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID

try {
    $api_instance->deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate**
> deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId)

Cancels any in-progress update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $api_instance->deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId**
> deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId)

Delete an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID

try {
    $api_instance->deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesEndpointsEndpointId**
> deleteTelephonyProvidersEdgesEndpointsEndpointId($endpointId)

Delete endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID

try {
    $api_instance->deleteTelephonyProvidersEdgesEndpointsEndpointId($endpointId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**
> deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId)

Delete an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID

try {
    $api_instance->deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId**
> deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId)

Delete Outbound Route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $api_instance->deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**
> deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId)

Delete a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID

try {
    $api_instance->deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesPhonesPhoneId**
> deleteTelephonyProvidersEdgesPhonesPhoneId($phoneId)

Delete a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID

try {
    $api_instance->deleteTelephonyProvidersEdgesPhonesPhoneId($phoneId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesSitesSiteId**
> deleteTelephonyProvidersEdgesSitesSiteId($siteId)

Delete a Site by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $api_instance->deleteTelephonyProvidersEdgesSitesSiteId($siteId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**
> deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId)

Delete Outbound Route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $api_instance->deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId)

Delete a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID

try {
    $api_instance->deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigurationSchemasEdgesVnext**
> \PureCloudSDK\SchemaCategoryEntityListing getConfigurationSchemasEdgesVnext($pageSize, $pageNumber)

Lists available schema categories (Deprecated)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getConfigurationSchemasEdgesVnext($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getConfigurationSchemasEdgesVnext: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaCategoryEntityListing**](../Model/SchemaCategoryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigurationSchemasEdgesVnextSchemacategory**
> \PureCloudSDK\SchemaReferenceEntityListing getConfigurationSchemasEdgesVnextSchemacategory($schemaCategory, $pageSize, $pageNumber)

List schemas of a specific category (Deprecated)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getConfigurationSchemasEdgesVnextSchemacategory($schemaCategory, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getConfigurationSchemasEdgesVnextSchemacategory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigurationSchemasEdgesVnextSchemacategorySchematype**
> \PureCloudSDK\SchemaReferenceEntityListing getConfigurationSchemasEdgesVnextSchemacategorySchematype($schemaCategory, $schemaType, $pageSize, $pageNumber)

List schemas of a specific category (Deprecated)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getConfigurationSchemasEdgesVnextSchemacategorySchematype($schemaCategory, $schemaType, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getConfigurationSchemasEdgesVnextSchemacategorySchematype: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId**
> \PureCloudSDK\Organization getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId($schemaCategory, $schemaType, $schemaId)

Get a json schema (Deprecated)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$schemaId = "schemaId_example"; // string | Schema ID

try {
    $result = $api_instance->getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId($schemaCategory, $schemaType, $schemaId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **schemaId** | **string**| Schema ID |

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**
> \PureCloudSDK\Organization getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schemaCategory, $schemaType, $schemaId, $extensionType, $metadataId, $type)

Get metadata for a schema (Deprecated)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$schemaId = "schemaId_example"; // string | Schema ID
$extensionType = "extensionType_example"; // string | extension
$metadataId = "metadataId_example"; // string | Metadata ID
$type = "type_example"; // string | Type

try {
    $result = $api_instance->getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schemaCategory, $schemaType, $schemaId, $extensionType, $metadataId, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getConfigurationSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **schemaId** | **string**| Schema ID |
 **extensionType** | **string**| extension |
 **metadataId** | **string**| Metadata ID |
 **type** | **string**| Type | [optional]

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdges**
> \PureCloudSDK\EdgeEntityListing getTelephonyProvidersEdges($pageSize, $pageNumber, $name, $siteId, $edgeGroupId, $sortBy, $managed)

Get the list of edges.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$siteId = "siteId_example"; // string | Filter by site.id
$edgeGroupId = "edgeGroupId_example"; // string | Filter by edgeGroup.id
$sortBy = "name"; // string | Sort by
$managed = true; // bool | Filter by managed

try {
    $result = $api_instance->getTelephonyProvidersEdges($pageSize, $pageNumber, $name, $siteId, $edgeGroupId, $sortBy, $managed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **siteId** | **string**| Filter by site.id | [optional]
 **edgeGroupId** | **string**| Filter by edgeGroup.id | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **managed** | **bool**| Filter by managed | [optional]

### Return type

[**\PureCloudSDK\EdgeEntityListing**](../Model/EdgeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesAvailablelanguages**
> \PureCloudSDK\AvailableLanguageList getTelephonyProvidersEdgesAvailablelanguages()

Get the list of available languages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getTelephonyProvidersEdgesAvailablelanguages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesAvailablelanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\AvailableLanguageList**](../Model/AvailableLanguageList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesCertificateauthorities**
> \PureCloudSDK\CertificateAuthorityEntityListing getTelephonyProvidersEdgesCertificateauthorities()

Get the list of certificate authorities.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getTelephonyProvidersEdgesCertificateauthorities();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CertificateAuthorityEntityListing**](../Model/CertificateAuthorityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority getTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId)

Get a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesDidpools**
> \PureCloudSDK\DIDPoolEntityListing getTelephonyProvidersEdgesDidpools($pageSize, $pageNumber, $sortBy)

Get a listing of DID Pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by

try {
    $result = $api_instance->getTelephonyProvidersEdgesDidpools($pageSize, $pageNumber, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]

### Return type

[**\PureCloudSDK\DIDPoolEntityListing**](../Model/DIDPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool getTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId)

Get a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesDids**
> \PureCloudSDK\DIDEntityListing getTelephonyProvidersEdgesDids($pageSize, $pageNumber, $sortBy, $sortOrder, $phoneNumber)

Get a listing of DIDs



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by
$sortOrder = "ASC"; // string | Sort order
$phoneNumber = "phoneNumber_example"; // string | Filter by phoneNumber

try {
    $result = $api_instance->getTelephonyProvidersEdgesDids($pageSize, $pageNumber, $sortBy, $sortOrder, $phoneNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesDids: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **phoneNumber** | **string**| Filter by phoneNumber | [optional]

### Return type

[**\PureCloudSDK\DIDEntityListing**](../Model/DIDEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesDidsDidId**
> \PureCloudSDK\DID getTelephonyProvidersEdgesDidsDidId($didId)

Get a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didId = "didId_example"; // string | DID ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesDidsDidId($didId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didId** | **string**| DID ID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeId**
> \PureCloudSDK\Edge getTelephonyProvidersEdgesEdgeId($edgeId, $expand)

Get edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeId($edgeId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdLines**
> \PureCloudSDK\EdgeLineEntityListing getTelephonyProvidersEdgesEdgeIdLines($edgeId, $pageSize, $pageNumber)

Get the list of lines.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdLines($edgeId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EdgeLineEntityListing**](../Model/EdgeLineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine getTelephonyProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId)

Get line



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$lineId = "lineId_example"; // string | Line ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **lineId** | **string**| Line ID |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\LogicalInterfaceEntityListing getTelephonyProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $expand)

Get edge logical interfaces.

Retrieve a list of all configured logical interfaces from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\LogicalInterfaceEntityListing**](../Model/LogicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $expand)

Get an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdLogsJobsJobId**
> \PureCloudSDK\EdgeLogsJob getTelephonyProvidersEdgesEdgeIdLogsJobsJobId($edgeId, $jobId)

Get an Edge logs job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$jobId = "jobId_example"; // string | Job ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdLogsJobsJobId($edgeId, $jobId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdLogsJobsJobId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **jobId** | **string**| Job ID |

### Return type

[**\PureCloudSDK\EdgeLogsJob**](../Model/EdgeLogsJob.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces**
> \PureCloudSDK\PhysicalInterfaceEntityListing getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces($edgeId)

Retrieve a list of all configured physical interfaces from a specific edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdPhysicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\PhysicalInterfaceEntityListing**](../Model/PhysicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**
> \PureCloudSDK\DomainPhysicalInterface getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edgeId, $interfaceId)

Get edge physical interface.

Retrieve a physical interface from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edgeId, $interfaceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |

### Return type

[**\PureCloudSDK\DomainPhysicalInterface**](../Model/DomainPhysicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdSetuppackage**
> \PureCloudSDK\VmPairingInfo getTelephonyProvidersEdgesEdgeIdSetuppackage($edgeId)

Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdSetuppackage($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdSetuppackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\VmPairingInfo**](../Model/VmPairingInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto getTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId)

Gets software update status information about any edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeIdSoftwareversions**
> \PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing getTelephonyProvidersEdgesEdgeIdSoftwareversions($edgeId)

Gets all the available software versions for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeIdSoftwareversions($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeIdSoftwareversions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing**](../Model/DomainEdgeSoftwareVersionDtoEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroupEntityListing getTelephonyProvidersEdgesEdgegroups($pageSize, $pageNumber, $name, $sortBy, $managed)

Get the list of edge groups.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Sort by
$managed = true; // bool | Filter by managed

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgegroups($pageSize, $pageNumber, $name, $sortBy, $managed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **managed** | **bool**| Filter by managed | [optional]

### Return type

[**\PureCloudSDK\EdgeGroupEntityListing**](../Model/EdgeGroupEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup getTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $expand)

Get edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$expand = array("expand_example"); // string[] | Fields to expand in the response

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response | [optional]

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId**
> \PureCloudSDK\EdgeTrunkBase getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId($edgegroupId, $edgetrunkbaseId)

Gets the edge trunk base associated with the edge group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgegroupId = "edgegroupId_example"; // string | Edge Group ID
$edgetrunkbaseId = "edgetrunkbaseId_example"; // string | Edge Trunk Base ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId($edgegroupId, $edgetrunkbaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgegroupId** | **string**| Edge Group ID |
 **edgetrunkbaseId** | **string**| Edge Trunk Base ID |

### Return type

[**\PureCloudSDK\EdgeTrunkBase**](../Model/EdgeTrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEdgeversionreport**
> \PureCloudSDK\EdgeVersionReport getTelephonyProvidersEdgesEdgeversionreport()

Get the edge version report.

The report will not have consistent data about the edge version(s) until all edges have been reset.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getTelephonyProvidersEdgesEdgeversionreport();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEdgeversionreport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EdgeVersionReport**](../Model/EdgeVersionReport.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEndpoints**
> \PureCloudSDK\EndpointEntityListing getTelephonyProvidersEdgesEndpoints($pageSize, $pageNumber, $name, $sortBy)

Get endpoints



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getTelephonyProvidersEdgesEndpoints($pageSize, $pageNumber, $name, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EndpointEntityListing**](../Model/EndpointEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint getTelephonyProvidersEdgesEndpointsEndpointId($endpointId)

Get endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesEndpointsEndpointId($endpointId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPoolEntityListing getTelephonyProvidersEdgesExtensionpools($pageSize, $pageNumber, $sortBy, $number)

Get a listing of extension pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "startNumber"; // string | Sort by
$number = "number_example"; // string | Number

try {
    $result = $api_instance->getTelephonyProvidersEdgesExtensionpools($pageSize, $pageNumber, $sortBy, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to startNumber]
 **number** | **string**| Number | [optional]

### Return type

[**\PureCloudSDK\ExtensionPoolEntityListing**](../Model/ExtensionPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId)

Get an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesExtensions**
> \PureCloudSDK\ExtensionEntityListing getTelephonyProvidersEdgesExtensions($pageSize, $pageNumber, $sortBy, $sortOrder, $number)

Get a listing of extensions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by
$sortOrder = "ASC"; // string | Sort order
$number = "number_example"; // string | Filter by number

try {
    $result = $api_instance->getTelephonyProvidersEdgesExtensions($pageSize, $pageNumber, $sortBy, $sortOrder, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesExtensions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **number** | **string**| Filter by number | [optional]

### Return type

[**\PureCloudSDK\ExtensionEntityListing**](../Model/ExtensionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension getTelephonyProvidersEdgesExtensionsExtensionId($extensionId)

Get an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionId = "extensionId_example"; // string | Extension ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesExtensionsExtensionId($extensionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionId** | **string**| Extension ID |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLinebasesettings**
> \PureCloudSDK\LineBaseEntityListing getTelephonyProvidersEdgesLinebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder)

Get a listing of line base settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "ASC"; // string | Sort order

try {
    $result = $api_instance->getTelephonyProvidersEdgesLinebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLinebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\LineBaseEntityListing**](../Model/LineBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLinebasesettingsLinebaseId**
> \PureCloudSDK\LineBase getTelephonyProvidersEdgesLinebasesettingsLinebaseId($lineBaseId)

Get a line base settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineBaseId = "lineBaseId_example"; // string | Line base ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesLinebasesettingsLinebaseId($lineBaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLinebasesettingsLinebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineBaseId** | **string**| Line base ID |

### Return type

[**\PureCloudSDK\LineBase**](../Model/LineBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLines**
> \PureCloudSDK\LineEntityListing getTelephonyProvidersEdgesLines($pageSize, $pageNumber, $name, $sortBy, $expand)

Get a list of Lines



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Value by which to sort
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated

try {
    $result = $api_instance->getTelephonyProvidersEdgesLines($pageSize, $pageNumber, $name, $sortBy, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]

### Return type

[**\PureCloudSDK\LineEntityListing**](../Model/LineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLinesLineId**
> \PureCloudSDK\Line getTelephonyProvidersEdgesLinesLineId($lineId)

Get a Line by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineId = "lineId_example"; // string | Line ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesLinesLineId($lineId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineId** | **string**| Line ID |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLinesTemplate**
> \PureCloudSDK\Line getTelephonyProvidersEdgesLinesTemplate($lineBaseSettingsId)

Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineBaseSettingsId = "lineBaseSettingsId_example"; // string | The id of a Line Base Settings object upon which to base this Line

try {
    $result = $api_instance->getTelephonyProvidersEdgesLinesTemplate($lineBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLinesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineBaseSettingsId** | **string**| The id of a Line Base Settings object upon which to base this Line |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesLogicalinterfaces**
> \PureCloudSDK\LogicalInterfaceEntityListing getTelephonyProvidersEdgesLogicalinterfaces($edgeIds, $expand)

Get edge logical interfaces.

Retrieve the configured logical interfaces for a list edges. Only 100 edges can be requested at a time.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeIds = "edgeIds_example"; // string | Comma separated list of Edge Id's
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getTelephonyProvidersEdgesLogicalinterfaces($edgeIds, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeIds** | **string**| Comma separated list of Edge Id&#39;s |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\LogicalInterfaceEntityListing**](../Model/LogicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRouteEntityListing getTelephonyProvidersEdgesOutboundroutes($pageSize, $pageNumber, $name, $siteId, $sortBy)

Get outbound routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$siteId = "siteId_example"; // string | Filter by site.id
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getTelephonyProvidersEdgesOutboundroutes($pageSize, $pageNumber, $name, $siteId, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **siteId** | **string**| Filter by site.id | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\OutboundRouteEntityListing**](../Model/OutboundRouteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute getTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId)

Get outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBaseEntityListing getTelephonyProvidersEdgesPhonebasesettings($pageSize, $pageNumber, $sortBy, $sortOrder, $expand, $name)

Get a list of Phone Base Settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "ASC"; // string | Sort order
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonebasesettings($pageSize, $pageNumber, $sortBy, $sortOrder, $expand, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\PhoneBaseEntityListing**](../Model/PhoneBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases**
> \PureCloudSDK\PhoneMetaBaseEntityListing getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases($pageSize, $pageNumber)

Get a list of available makes and models to create a new Phone Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonebasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\PhoneMetaBaseEntityListing**](../Model/PhoneMetaBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId)

Get a Phone Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonebasesettingsTemplate**
> \PureCloudSDK\PhoneBase getTelephonyProvidersEdgesPhonebasesettingsTemplate($phoneMetabaseId)

Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneMetabaseId = "phoneMetabaseId_example"; // string | The id of a metabase object upon which to base this Phone Base Settings

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonebasesettingsTemplate($phoneMetabaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonebasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneMetabaseId** | **string**| The id of a metabase object upon which to base this Phone Base Settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhones**
> \PureCloudSDK\PhoneEntityListing getTelephonyProvidersEdgesPhones($pageNumber, $pageSize, $sortBy, $sortOrder, $siteId, $webRtcUserId, $phoneBaseSettingsId, $linesLoggedInUserId, $linesDefaultForUserId, $phoneHardwareId, $linesId, $linesName, $expand, $fields)

Get a list of Phone Instances



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "ASC"; // string | Sort order
$siteId = "siteId_example"; // string | Filter by site.id
$webRtcUserId = "webRtcUserId_example"; // string | Filter by webRtcUser.id
$phoneBaseSettingsId = "phoneBaseSettingsId_example"; // string | Filter by phoneBaseSettings.id
$linesLoggedInUserId = "linesLoggedInUserId_example"; // string | Filter by lines.loggedInUser.id
$linesDefaultForUserId = "linesDefaultForUserId_example"; // string | Filter by lines.defaultForUser.id
$phoneHardwareId = "phoneHardwareId_example"; // string | Filter by phone_hardwareId
$linesId = "linesId_example"; // string | Filter by lines.id
$linesName = "linesName_example"; // string | Filter by lines.name
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated
$fields = array("fields_example"); // string[] | Fields and properties to get, comma-separated

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhones($pageNumber, $pageSize, $sortBy, $sortOrder, $siteId, $webRtcUserId, $phoneBaseSettingsId, $linesLoggedInUserId, $linesDefaultForUserId, $phoneHardwareId, $linesId, $linesName, $expand, $fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **siteId** | **string**| Filter by site.id | [optional]
 **webRtcUserId** | **string**| Filter by webRtcUser.id | [optional]
 **phoneBaseSettingsId** | **string**| Filter by phoneBaseSettings.id | [optional]
 **linesLoggedInUserId** | **string**| Filter by lines.loggedInUser.id | [optional]
 **linesDefaultForUserId** | **string**| Filter by lines.defaultForUser.id | [optional]
 **phoneHardwareId** | **string**| Filter by phone_hardwareId | [optional]
 **linesId** | **string**| Filter by lines.id | [optional]
 **linesName** | **string**| Filter by lines.name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]
 **fields** | [**string[]**](../Model/string.md)| Fields and properties to get, comma-separated | [optional]

### Return type

[**\PureCloudSDK\PhoneEntityListing**](../Model/PhoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone getTelephonyProvidersEdgesPhonesPhoneId($phoneId)

Get a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonesPhoneId($phoneId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhonesTemplate**
> \PureCloudSDK\Phone getTelephonyProvidersEdgesPhonesTemplate($phoneBaseSettingsId)

Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseSettingsId = "phoneBaseSettingsId_example"; // string | The id of a Phone Base Settings object upon which to base this Phone

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhonesTemplate($phoneBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhonesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseSettingsId** | **string**| The id of a Phone Base Settings object upon which to base this Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesPhysicalinterfaces**
> \PureCloudSDK\PhysicalInterfaceEntityListing getTelephonyProvidersEdgesPhysicalinterfaces($edgeIds)

Get physical interfaces for edges.

Retrieves a list of all configured physical interfaces for a list of edges. Only 100 edges can be requested at a time.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeIds = "edgeIds_example"; // string | Comma separated list of Edge Id's

try {
    $result = $api_instance->getTelephonyProvidersEdgesPhysicalinterfaces($edgeIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesPhysicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeIds** | **string**| Comma separated list of Edge Id&#39;s |

### Return type

[**\PureCloudSDK\PhysicalInterfaceEntityListing**](../Model/PhysicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSites**
> \PureCloudSDK\SiteEntityListing getTelephonyProvidersEdgesSites($pageSize, $pageNumber, $sortBy, $sortOrder, $name, $locationId, $managed)

Get the list of Sites.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by
$sortOrder = "ASC"; // string | Sort order
$name = "name_example"; // string | Name
$locationId = "locationId_example"; // string | Location Id
$managed = true; // bool | Filter by managed

try {
    $result = $api_instance->getTelephonyProvidersEdgesSites($pageSize, $pageNumber, $sortBy, $sortOrder, $name, $locationId, $managed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **name** | **string**| Name | [optional]
 **locationId** | **string**| Location Id | [optional]
 **managed** | **bool**| Filter by managed | [optional]

### Return type

[**\PureCloudSDK\SiteEntityListing**](../Model/SiteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site getTelephonyProvidersEdgesSitesSiteId($siteId)

Get a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteId($siteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] getTelephonyProvidersEdgesSitesSiteIdNumberplans($siteId)

Get the list of Number Plans for this Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteIdNumberplans($siteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications**
> string[] getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications($siteId, $classification)

Get a list of Classifications for this Site



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$classification = "classification_example"; // string | Classification

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications($siteId, $classification);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteIdNumberplansClassifications: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **classification** | **string**| Classification | [optional]

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId**
> \PureCloudSDK\NumberPlan getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId($siteId, $numberPlanId)

Get a Number Plan by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$numberPlanId = "numberPlanId_example"; // string | Number Plan ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId($siteId, $numberPlanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteIdNumberplansNumberplanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **numberPlanId** | **string**| Number Plan ID |

### Return type

[**\PureCloudSDK\NumberPlan**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteIdOutboundroutes**
> \PureCloudSDK\OutboundRouteBaseEntityListing getTelephonyProvidersEdgesSitesSiteIdOutboundroutes($siteId, $pageSize, $pageNumber, $name, $sortBy)

Get outbound routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteIdOutboundroutes($siteId, $pageSize, $pageNumber, $name, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteIdOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\OutboundRouteBaseEntityListing**](../Model/OutboundRouteBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRouteBase getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId)

Get an outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

[**\PureCloudSDK\OutboundRouteBase**](../Model/OutboundRouteBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTimezones**
> \PureCloudSDK\TimeZoneEntityListing getTelephonyProvidersEdgesTimezones($pageSize, $pageNumber)

Get a list of Edge-compatible time zones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 1000; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getTelephonyProvidersEdgesTimezones($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTimezones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 1000]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TimeZoneEntityListing**](../Model/TimeZoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBaseEntityListing getTelephonyProvidersEdgesTrunkbasesettings($pageNumber, $pageSize, $sortBy, $sortOrder, $recordingEnabled, $ignoreHidden, $managed, $expand, $name)

Get Trunk Base Settings listing

Managed properties will not be returned unless the user is assigned the managed:all:all permission.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "ASC"; // string | Sort order
$recordingEnabled = true; // bool | Filter trunks by recording enabled
$ignoreHidden = true; // bool | Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only.
$managed = true; // bool | Filter by managed
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated
$name = "name_example"; // string | Name of the TrunkBase to filter by

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunkbasesettings($pageNumber, $pageSize, $sortBy, $sortOrder, $recordingEnabled, $ignoreHidden, $managed, $expand, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **recordingEnabled** | **bool**| Filter trunks by recording enabled | [optional]
 **ignoreHidden** | **bool**| Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only. | [optional]
 **managed** | **bool**| Filter by managed | [optional]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]
 **name** | **string**| Name of the TrunkBase to filter by | [optional]

### Return type

[**\PureCloudSDK\TrunkBaseEntityListing**](../Model/TrunkBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases**
> \PureCloudSDK\TrunkMetabaseEntityListing getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $pageSize, $pageNumber)

Get a list of available makes and models to create a new Trunk Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$type = "type_example"; // string | 
$pageSize = 25; // int | 
$pageNumber = 1; // int | 

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunkbasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**|  | [optional]
 **pageSize** | **int**|  | [optional] [default to 25]
 **pageNumber** | **int**|  | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TrunkMetabaseEntityListing**](../Model/TrunkMetabaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunkbasesettingsTemplate**
> \PureCloudSDK\TrunkBase getTelephonyProvidersEdgesTrunkbasesettingsTemplate($trunkMetabaseId)

Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkMetabaseId = "trunkMetabaseId_example"; // string | The id of a metabase object upon which to base this Trunk Base Settings

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunkbasesettingsTemplate($trunkMetabaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunkbasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkMetabaseId** | **string**| The id of a metabase object upon which to base this Trunk Base Settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $ignoreHidden)

Get a Trunk Base Settings object by ID

Managed properties will not be returned unless the user is assigned the managed:all:all permission.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID
$ignoreHidden = true; // bool | Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only.

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $ignoreHidden);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |
 **ignoreHidden** | **bool**| Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only. | [optional]

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunks**
> \PureCloudSDK\TrunkEntityListing getTelephonyProvidersEdgesTrunks($pageNumber, $pageSize, $sortBy, $sortOrder, $edgeId, $trunkBaseId, $trunkType)

Get the list of available trunks.

Trunks are created by assigning trunk base settings to an Edge or Edge Group.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "ASC"; // string | Sort order
$edgeId = "edgeId_example"; // string | Filter by Edge Ids
$trunkBaseId = "trunkBaseId_example"; // string | Filter by Trunk Base Ids
$trunkType = "trunkType_example"; // string | Filter by a Trunk type

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunks($pageNumber, $pageSize, $sortBy, $sortOrder, $edgeId, $trunkBaseId, $trunkType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **edgeId** | **string**| Filter by Edge Ids | [optional]
 **trunkBaseId** | **string**| Filter by Trunk Base Ids | [optional]
 **trunkType** | **string**| Filter by a Trunk type | [optional]

### Return type

[**\PureCloudSDK\TrunkEntityListing**](../Model/TrunkEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunksTrunkId**
> \PureCloudSDK\Trunk getTelephonyProvidersEdgesTrunksTrunkId($trunkId)

Get a Trunk by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkId = "trunkId_example"; // string | Trunk ID

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunksTrunkId($trunkId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunksTrunkId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkId** | **string**| Trunk ID |

### Return type

[**\PureCloudSDK\Trunk**](../Model/Trunk.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTelephonyProvidersEdgesTrunkswithrecording**
> \PureCloudSDK\TrunkRecordingEnabledCount getTelephonyProvidersEdgesTrunkswithrecording($trunkType)

Get Counts of trunks that have recording disabled or enabled



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkType = "trunkType_example"; // string | The type of this trunk base.

try {
    $result = $api_instance->getTelephonyProvidersEdgesTrunkswithrecording($trunkType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getTelephonyProvidersEdgesTrunkswithrecording: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkType** | **string**| The type of this trunk base. | [optional]

### Return type

[**\PureCloudSDK\TrunkRecordingEnabledCount**](../Model/TrunkRecordingEnabledCount.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdges**
> \PureCloudSDK\Edge postTelephonyProvidersEdges($body)

Create an edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->postTelephonyProvidersEdges($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesAddressvalidation**
> \PureCloudSDK\ValidateAddressResponse postTelephonyProvidersEdgesAddressvalidation($body)

Validates a street address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ValidateAddressRequest(); // \PureCloudSDK\ValidateAddressRequest | Address

try {
    $result = $api_instance->postTelephonyProvidersEdgesAddressvalidation($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesAddressvalidation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ValidateAddressRequest**](../Model/\PureCloudSDK\ValidateAddressRequest.md)| Address |

### Return type

[**\PureCloudSDK\ValidateAddressResponse**](../Model/ValidateAddressResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesCertificateauthorities**
> \PureCloudSDK\DomainCertificateAuthority postTelephonyProvidersEdgesCertificateauthorities($body)

Create a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | CertificateAuthority

try {
    $result = $api_instance->postTelephonyProvidersEdgesCertificateauthorities($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| CertificateAuthority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesDidpools**
> \PureCloudSDK\DIDPool postTelephonyProvidersEdgesDidpools($body)

Create a new DID pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->postTelephonyProvidersEdgesDidpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\DomainLogicalInterface postTelephonyProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $body)

Create an edge logical interface.

Create

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdLogsJobs**
> \PureCloudSDK\EdgeLogsJobResponse postTelephonyProvidersEdgesEdgeIdLogsJobs($edgeId, $body)

Create a job to upload a list of Edge logs.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\EdgeLogsJobRequest(); // \PureCloudSDK\EdgeLogsJobRequest | EdgeLogsJobRequest

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdLogsJobs($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdLogsJobs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobRequest**](../Model/\PureCloudSDK\EdgeLogsJobRequest.md)| EdgeLogsJobRequest |

### Return type

[**\PureCloudSDK\EdgeLogsJobResponse**](../Model/EdgeLogsJobResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload**
> postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload($edgeId, $jobId, $body)

Request that the specified fileIds be uploaded from the Edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$jobId = "jobId_example"; // string | Job ID
$body = new \PureCloudSDK\EdgeLogsJobUploadRequest(); // \PureCloudSDK\EdgeLogsJobUploadRequest | Log upload request

try {
    $api_instance->postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload($edgeId, $jobId, $body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdLogsJobsJobIdUpload: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **jobId** | **string**| Job ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobUploadRequest**](../Model/\PureCloudSDK\EdgeLogsJobUploadRequest.md)| Log upload request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdReboot**
> string postTelephonyProvidersEdgesEdgeIdReboot($edgeId, $body)

Reboot an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\EdgeRebootParameters(); // \PureCloudSDK\EdgeRebootParameters | Parameters for the edge reboot

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdReboot($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\EdgeRebootParameters**](../Model/\PureCloudSDK\EdgeRebootParameters.md)| Parameters for the edge reboot | [optional]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto postTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId, $body)

Starts a software update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainEdgeSoftwareUpdateDto(); // \PureCloudSDK\DomainEdgeSoftwareUpdateDto | Software update request

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdSoftwareupdate($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/\PureCloudSDK\DomainEdgeSoftwareUpdateDto.md)| Software update request |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdStatuscode**
> string postTelephonyProvidersEdgesEdgeIdStatuscode($edgeId, $body)

Take an Edge in or out of service



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\EdgeServiceStateRequest(); // \PureCloudSDK\EdgeServiceStateRequest | Edge Service State

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdStatuscode($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdStatuscode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\EdgeServiceStateRequest**](../Model/\PureCloudSDK\EdgeServiceStateRequest.md)| Edge Service State | [optional]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgeIdUnpair**
> string postTelephonyProvidersEdgesEdgeIdUnpair($edgeId)

Unpair an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge Id

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgeIdUnpair($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgeIdUnpair: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge Id |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroup postTelephonyProvidersEdgesEdgegroups($body)

Create an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->postTelephonyProvidersEdgesEdgegroups($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesEndpoints**
> \PureCloudSDK\Endpoint postTelephonyProvidersEdgesEndpoints($body)

Create endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->postTelephonyProvidersEdgesEndpoints($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPool postTelephonyProvidersEdgesExtensionpools($body)

Create a new extension pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->postTelephonyProvidersEdgesExtensionpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRoute postTelephonyProvidersEdgesOutboundroutes($body)

Create outbound rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->postTelephonyProvidersEdgesOutboundroutes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBase postTelephonyProvidersEdgesPhonebasesettings($body)

Create a new Phone Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->postTelephonyProvidersEdgesPhonebasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesPhones**
> \PureCloudSDK\Phone postTelephonyProvidersEdgesPhones($body)

Create a new Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->postTelephonyProvidersEdgesPhones($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesPhonesPhoneIdReboot**
> postTelephonyProvidersEdgesPhonesPhoneIdReboot($phoneId)

Reboot a Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone Id

try {
    $api_instance->postTelephonyProvidersEdgesPhonesPhoneIdReboot($phoneId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesPhonesPhoneIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesPhonesReboot**
> postTelephonyProvidersEdgesPhonesReboot($body)

Reboot Multiple Phones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhonesReboot(); // \PureCloudSDK\PhonesReboot | Phones

try {
    $api_instance->postTelephonyProvidersEdgesPhonesReboot($body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesPhonesReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhonesReboot**](../Model/\PureCloudSDK\PhonesReboot.md)| Phones |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesSites**
> \PureCloudSDK\Site postTelephonyProvidersEdgesSites($body)

Create a Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->postTelephonyProvidersEdgesSites($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesSitesSiteIdOutboundroutes**
> \PureCloudSDK\OutboundRouteBase postTelephonyProvidersEdgesSitesSiteIdOutboundroutes($siteId, $body)

Create outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$body = new \PureCloudSDK\OutboundRouteBase(); // \PureCloudSDK\OutboundRouteBase | OutboundRoute

try {
    $result = $api_instance->postTelephonyProvidersEdgesSitesSiteIdOutboundroutes($siteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesSitesSiteIdOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **body** | [**\PureCloudSDK\OutboundRouteBase**](../Model/\PureCloudSDK\OutboundRouteBase.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRouteBase**](../Model/OutboundRouteBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesSitesSiteIdRebalance**
> postTelephonyProvidersEdgesSitesSiteIdRebalance($siteId)

Triggers the rebalance operation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $api_instance->postTelephonyProvidersEdgesSitesSiteIdRebalance($siteId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesSitesSiteIdRebalance: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postTelephonyProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBase postTelephonyProvidersEdgesTrunkbasesettings($body)

Create a Trunk Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->postTelephonyProvidersEdgesTrunkbasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postTelephonyProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority putTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId, $body)

Update a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | Certificate authority

try {
    $result = $api_instance->putTelephonyProvidersEdgesCertificateauthoritiesCertificateId($certificateId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| Certificate authority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool putTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId, $body)

Update a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->putTelephonyProvidersEdgesDidpoolsDidpoolId($didPoolId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesDidsDidId**
> \PureCloudSDK\DID putTelephonyProvidersEdgesDidsDidId($didId, $body)

Update a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didId = "didId_example"; // string | DID ID
$body = new \PureCloudSDK\DID(); // \PureCloudSDK\DID | DID

try {
    $result = $api_instance->putTelephonyProvidersEdgesDidsDidId($didId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didId** | **string**| DID ID |
 **body** | [**\PureCloudSDK\DID**](../Model/\PureCloudSDK\DID.md)| DID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEdgeId**
> \PureCloudSDK\Edge putTelephonyProvidersEdgesEdgeId($edgeId, $body)

Update a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->putTelephonyProvidersEdgesEdgeId($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine putTelephonyProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId, $body)

Update a line.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$lineId = "lineId_example"; // string | Line ID
$body = new \PureCloudSDK\EdgeLine(); // \PureCloudSDK\EdgeLine | Line

try {
    $result = $api_instance->putTelephonyProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **lineId** | **string**| Line ID |
 **body** | [**\PureCloudSDK\EdgeLine**](../Model/\PureCloudSDK\EdgeLine.md)| Line |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $body)

Update an edge logical interface.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup putTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $body)

Update an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->putTelephonyProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId**
> \PureCloudSDK\EdgeTrunkBase putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId($edgegroupId, $edgetrunkbaseId, $body)

Update the edge trunk base associated with the edge group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgegroupId = "edgegroupId_example"; // string | Edge Group ID
$edgetrunkbaseId = "edgetrunkbaseId_example"; // string | Edge Trunk Base ID
$body = new \PureCloudSDK\EdgeTrunkBase(); // \PureCloudSDK\EdgeTrunkBase | EdgeTrunkBase

try {
    $result = $api_instance->putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId($edgegroupId, $edgetrunkbaseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEdgegroupsEdgegroupIdEdgetrunkbasesEdgetrunkbaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgegroupId** | **string**| Edge Group ID |
 **edgetrunkbaseId** | **string**| Edge Trunk Base ID |
 **body** | [**\PureCloudSDK\EdgeTrunkBase**](../Model/\PureCloudSDK\EdgeTrunkBase.md)| EdgeTrunkBase |

### Return type

[**\PureCloudSDK\EdgeTrunkBase**](../Model/EdgeTrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint putTelephonyProvidersEdgesEndpointsEndpointId($endpointId, $body)

Update endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->putTelephonyProvidersEdgesEndpointsEndpointId($endpointId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId, $body)

Update an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension putTelephonyProvidersEdgesExtensionsExtensionId($extensionId, $body)

Update an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionId = "extensionId_example"; // string | Extension ID
$body = new \PureCloudSDK\Extension(); // \PureCloudSDK\Extension | Extension

try {
    $result = $api_instance->putTelephonyProvidersEdgesExtensionsExtensionId($extensionId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionId** | **string**| Extension ID |
 **body** | [**\PureCloudSDK\Extension**](../Model/\PureCloudSDK\Extension.md)| Extension |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute putTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId, $body)

Update outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->putTelephonyProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId, $body)

Update a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone putTelephonyProvidersEdgesPhonesPhoneId($phoneId, $body)

Update a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->putTelephonyProvidersEdgesPhonesPhoneId($phoneId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site putTelephonyProvidersEdgesSitesSiteId($siteId, $body)

Update a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->putTelephonyProvidersEdgesSitesSiteId($siteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] putTelephonyProvidersEdgesSitesSiteIdNumberplans($siteId, $body)

Update the list of Number Plans.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$body = array(new NumberPlan()); // \PureCloudSDK\NumberPlan[] | List of number plans

try {
    $result = $api_instance->putTelephonyProvidersEdgesSitesSiteIdNumberplans($siteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **body** | [**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)| List of number plans |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRouteBase putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId, $body)

Update outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID
$body = new \PureCloudSDK\OutboundRouteBase(); // \PureCloudSDK\OutboundRouteBase | OutboundRoute

try {
    $result = $api_instance->putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId($siteId, $outboundRouteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesSitesSiteIdOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **outboundRouteId** | **string**| Outbound route ID |
 **body** | [**\PureCloudSDK\OutboundRouteBase**](../Model/\PureCloudSDK\OutboundRouteBase.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRouteBase**](../Model/OutboundRouteBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $body)

Update a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putTelephonyProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

