# PureCloudSDK\TokensApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteTokensMe**](TokensApi.md#deleteTokensMe) | **DELETE** /api/v2/tokens/me | Delete  auth token used to make the request.
[**getTokensMe**](TokensApi.md#getTokensMe) | **GET** /api/v2/tokens/me | Fetch information about the current token


# **deleteTokensMe**
> deleteTokensMe()

Delete  auth token used to make the request.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TokensApi();

try {
    $api_instance->deleteTokensMe();
} catch (Exception $e) {
    echo 'Exception when calling TokensApi->deleteTokensMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTokensMe**
> \PureCloudSDK\TokenInfo getTokensMe()

Fetch information about the current token



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TokensApi();

try {
    $result = $api_instance->getTokensMe();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TokensApi->getTokensMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\TokenInfo**](../Model/TokenInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

