# PureCloudSDK\VoicemailApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteVoicemailMessages**](VoicemailApi.md#deleteVoicemailMessages) | **DELETE** /api/v2/voicemail/messages | Delete all voicemail messages
[**deleteVoicemailMessagesMessageId**](VoicemailApi.md#deleteVoicemailMessagesMessageId) | **DELETE** /api/v2/voicemail/messages/{messageId} | Delete a message.
[**getVoicemailGroupsGroupIdMailbox**](VoicemailApi.md#getVoicemailGroupsGroupIdMailbox) | **GET** /api/v2/voicemail/groups/{groupId}/mailbox | Get the group&#39;s mailbox information
[**getVoicemailGroupsGroupIdMessages**](VoicemailApi.md#getVoicemailGroupsGroupIdMessages) | **GET** /api/v2/voicemail/groups/{groupId}/messages | List voicemail messages
[**getVoicemailGroupsGroupIdPolicy**](VoicemailApi.md#getVoicemailGroupsGroupIdPolicy) | **GET** /api/v2/voicemail/groups/{groupId}/policy | Get a group&#39;s voicemail policy
[**getVoicemailMailbox**](VoicemailApi.md#getVoicemailMailbox) | **GET** /api/v2/voicemail/mailbox | Get the current user&#39;s mailbox information
[**getVoicemailMeMailbox**](VoicemailApi.md#getVoicemailMeMailbox) | **GET** /api/v2/voicemail/me/mailbox | Get the current user&#39;s mailbox information
[**getVoicemailMeMessages**](VoicemailApi.md#getVoicemailMeMessages) | **GET** /api/v2/voicemail/me/messages | List voicemail messages
[**getVoicemailMePolicy**](VoicemailApi.md#getVoicemailMePolicy) | **GET** /api/v2/voicemail/me/policy | Get the current user&#39;s voicemail policy
[**getVoicemailMessages**](VoicemailApi.md#getVoicemailMessages) | **GET** /api/v2/voicemail/messages | List voicemail messages
[**getVoicemailMessagesMessageId**](VoicemailApi.md#getVoicemailMessagesMessageId) | **GET** /api/v2/voicemail/messages/{messageId} | Get message.
[**getVoicemailMessagesMessageIdMedia**](VoicemailApi.md#getVoicemailMessagesMessageIdMedia) | **GET** /api/v2/voicemail/messages/{messageId}/media | Get media playback URI for this message
[**getVoicemailPolicy**](VoicemailApi.md#getVoicemailPolicy) | **GET** /api/v2/voicemail/policy | Get a policy
[**getVoicemailSearch**](VoicemailApi.md#getVoicemailSearch) | **GET** /api/v2/voicemail/search | Search voicemails using the q64 value returned from a previous search
[**getVoicemailUserpoliciesUserId**](VoicemailApi.md#getVoicemailUserpoliciesUserId) | **GET** /api/v2/voicemail/userpolicies/{userId} | Get a user&#39;s voicemail policy
[**patchVoicemailGroupsGroupIdPolicy**](VoicemailApi.md#patchVoicemailGroupsGroupIdPolicy) | **PATCH** /api/v2/voicemail/groups/{groupId}/policy | Update a group&#39;s voicemail policy
[**patchVoicemailMePolicy**](VoicemailApi.md#patchVoicemailMePolicy) | **PATCH** /api/v2/voicemail/me/policy | Update the current user&#39;s voicemail policy
[**patchVoicemailUserpoliciesUserId**](VoicemailApi.md#patchVoicemailUserpoliciesUserId) | **PATCH** /api/v2/voicemail/userpolicies/{userId} | Update a user&#39;s voicemail policy
[**postVoicemailMessages**](VoicemailApi.md#postVoicemailMessages) | **POST** /api/v2/voicemail/messages | Copy a voicemail message to a user or group
[**postVoicemailSearch**](VoicemailApi.md#postVoicemailSearch) | **POST** /api/v2/voicemail/search | Search voicemails
[**putVoicemailMessagesMessageId**](VoicemailApi.md#putVoicemailMessagesMessageId) | **PUT** /api/v2/voicemail/messages/{messageId} | Update a message.
[**putVoicemailPolicy**](VoicemailApi.md#putVoicemailPolicy) | **PUT** /api/v2/voicemail/policy | Update a policy


# **deleteVoicemailMessages**
> deleteVoicemailMessages()

Delete all voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $api_instance->deleteVoicemailMessages();
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteVoicemailMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteVoicemailMessagesMessageId**
> deleteVoicemailMessagesMessageId($messageId)

Delete a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID

try {
    $api_instance->deleteVoicemailMessagesMessageId($messageId);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailGroupsGroupIdMailbox**
> \PureCloudSDK\VoicemailMailboxInfo getVoicemailGroupsGroupIdMailbox($groupId)

Get the group's mailbox information



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$groupId = "groupId_example"; // string | groupId

try {
    $result = $api_instance->getVoicemailGroupsGroupIdMailbox($groupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailGroupsGroupIdMailbox: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| groupId |

### Return type

[**\PureCloudSDK\VoicemailMailboxInfo**](../Model/VoicemailMailboxInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailGroupsGroupIdMessages**
> \PureCloudSDK\VoicemailMessageEntityListing getVoicemailGroupsGroupIdMessages($groupId, $pageSize, $pageNumber)

List voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$groupId = "groupId_example"; // string | Group ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getVoicemailGroupsGroupIdMessages($groupId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailGroupsGroupIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\VoicemailMessageEntityListing**](../Model/VoicemailMessageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailGroupsGroupIdPolicy**
> \PureCloudSDK\VoicemailGroupPolicy getVoicemailGroupsGroupIdPolicy($groupId)

Get a group's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$groupId = "groupId_example"; // string | Group ID

try {
    $result = $api_instance->getVoicemailGroupsGroupIdPolicy($groupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailGroupsGroupIdPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |

### Return type

[**\PureCloudSDK\VoicemailGroupPolicy**](../Model/VoicemailGroupPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMailbox**
> \PureCloudSDK\VoicemailMailboxInfo getVoicemailMailbox()

Get the current user's mailbox information



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailMailbox();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMailbox: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMailboxInfo**](../Model/VoicemailMailboxInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMeMailbox**
> \PureCloudSDK\VoicemailMailboxInfo getVoicemailMeMailbox()

Get the current user's mailbox information



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailMeMailbox();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMeMailbox: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMailboxInfo**](../Model/VoicemailMailboxInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMeMessages**
> \PureCloudSDK\VoicemailMessageEntityListing getVoicemailMeMessages($pageSize, $pageNumber)

List voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getVoicemailMeMessages($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMeMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\VoicemailMessageEntityListing**](../Model/VoicemailMessageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMePolicy**
> \PureCloudSDK\VoicemailUserPolicy getVoicemailMePolicy()

Get the current user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailMePolicy();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMePolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessages**
> \PureCloudSDK\VoicemailMessageEntityListing getVoicemailMessages($ids, $expand)

List voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$ids = "ids_example"; // string | An optional comma separated list of VoicemailMessage ids
$expand = array("expand_example"); // string[] | If the caller is a known user, which fields, if any, to expand

try {
    $result = $api_instance->getVoicemailMessages($ids, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | **string**| An optional comma separated list of VoicemailMessage ids | [optional]
 **expand** | [**string[]**](../Model/string.md)| If the caller is a known user, which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\VoicemailMessageEntityListing**](../Model/VoicemailMessageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessagesMessageId**
> \PureCloudSDK\VoicemailMessage getVoicemailMessagesMessageId($messageId, $expand)

Get message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID
$expand = array("expand_example"); // string[] | If the caller is a known user, which fields, if any, to expand

try {
    $result = $api_instance->getVoicemailMessagesMessageId($messageId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |
 **expand** | [**string[]**](../Model/string.md)| If the caller is a known user, which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailMessagesMessageIdMedia**
> \PureCloudSDK\VoicemailMediaInfo getVoicemailMessagesMessageIdMedia($messageId, $formatId)

Get media playback URI for this message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID
$formatId = "WEBM"; // string | The desired media format.

try {
    $result = $api_instance->getVoicemailMessagesMessageIdMedia($messageId, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailMessagesMessageIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\VoicemailMediaInfo**](../Model/VoicemailMediaInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy getVoicemailPolicy()

Get a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getVoicemailPolicy();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailSearch**
> \PureCloudSDK\VoicemailsSearchResponse getVoicemailSearch($q64, $expand)

Search voicemails using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getVoicemailSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\VoicemailsSearchResponse**](../Model/VoicemailsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy getVoicemailUserpoliciesUserId($userId)

Get a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getVoicemailUserpoliciesUserId($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getVoicemailUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchVoicemailGroupsGroupIdPolicy**
> \PureCloudSDK\VoicemailGroupPolicy patchVoicemailGroupsGroupIdPolicy($groupId, $body)

Update a group's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$groupId = "groupId_example"; // string | Group ID
$body = new \PureCloudSDK\VoicemailGroupPolicy(); // \PureCloudSDK\VoicemailGroupPolicy | The group's voicemail policy

try {
    $result = $api_instance->patchVoicemailGroupsGroupIdPolicy($groupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->patchVoicemailGroupsGroupIdPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **body** | [**\PureCloudSDK\VoicemailGroupPolicy**](../Model/\PureCloudSDK\VoicemailGroupPolicy.md)| The group&#39;s voicemail policy |

### Return type

[**\PureCloudSDK\VoicemailGroupPolicy**](../Model/VoicemailGroupPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchVoicemailMePolicy**
> \PureCloudSDK\VoicemailUserPolicy patchVoicemailMePolicy($body)

Update the current user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\VoicemailUserPolicy(); // \PureCloudSDK\VoicemailUserPolicy | The user's voicemail policy

try {
    $result = $api_instance->patchVoicemailMePolicy($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->patchVoicemailMePolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailUserPolicy**](../Model/\PureCloudSDK\VoicemailUserPolicy.md)| The user&#39;s voicemail policy |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchVoicemailUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy patchVoicemailUserpoliciesUserId($userId, $body)

Update a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\VoicemailUserPolicy(); // \PureCloudSDK\VoicemailUserPolicy | The user's voicemail policy

try {
    $result = $api_instance->patchVoicemailUserpoliciesUserId($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->patchVoicemailUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\VoicemailUserPolicy**](../Model/\PureCloudSDK\VoicemailUserPolicy.md)| The user&#39;s voicemail policy |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postVoicemailMessages**
> \PureCloudSDK\VoicemailMessage postVoicemailMessages($body)

Copy a voicemail message to a user or group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\CopyVoicemailMessage(); // \PureCloudSDK\CopyVoicemailMessage | 

try {
    $result = $api_instance->postVoicemailMessages($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->postVoicemailMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CopyVoicemailMessage**](../Model/\PureCloudSDK\CopyVoicemailMessage.md)|  | [optional]

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postVoicemailSearch**
> \PureCloudSDK\VoicemailsSearchResponse postVoicemailSearch($body)

Search voicemails



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\VoicemailSearchRequest(); // \PureCloudSDK\VoicemailSearchRequest | Search request options

try {
    $result = $api_instance->postVoicemailSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->postVoicemailSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailSearchRequest**](../Model/\PureCloudSDK\VoicemailSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\VoicemailsSearchResponse**](../Model/VoicemailsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putVoicemailMessagesMessageId**
> \PureCloudSDK\VoicemailMessage putVoicemailMessagesMessageId($messageId, $body)

Update a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$messageId = "messageId_example"; // string | Message ID
$body = new \PureCloudSDK\VoicemailMessage(); // \PureCloudSDK\VoicemailMessage | VoicemailMessage

try {
    $result = $api_instance->putVoicemailMessagesMessageId($messageId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putVoicemailMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **messageId** | **string**| Message ID |
 **body** | [**\PureCloudSDK\VoicemailMessage**](../Model/\PureCloudSDK\VoicemailMessage.md)| VoicemailMessage |

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putVoicemailPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy putVoicemailPolicy($body)

Update a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\VoicemailOrganizationPolicy(); // \PureCloudSDK\VoicemailOrganizationPolicy | Policy

try {
    $result = $api_instance->putVoicemailPolicy($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putVoicemailPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/\PureCloudSDK\VoicemailOrganizationPolicy.md)| Policy |

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

