<?php
/**
 * AcwSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AcwSettings Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AcwSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AcwSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'wrapup_prompt' => 'string',
        'timeout_ms' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'wrapup_prompt' => 'wrapupPrompt',
        'timeout_ms' => 'timeoutMs'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'wrapup_prompt' => 'setWrapupPrompt',
        'timeout_ms' => 'setTimeoutMs'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'wrapup_prompt' => 'getWrapupPrompt',
        'timeout_ms' => 'getTimeoutMs'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const WRAPUP_PROMPT_MANDATORY = 'MANDATORY';
    const WRAPUP_PROMPT_OPTIONAL = 'OPTIONAL';
    const WRAPUP_PROMPT_MANDATORY_TIMEOUT = 'MANDATORY_TIMEOUT';
    const WRAPUP_PROMPT_MANDATORY_FORCED_TIMEOUT = 'MANDATORY_FORCED_TIMEOUT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWrapupPromptAllowableValues()
    {
        return [
            self::WRAPUP_PROMPT_MANDATORY,
            self::WRAPUP_PROMPT_OPTIONAL,
            self::WRAPUP_PROMPT_MANDATORY_TIMEOUT,
            self::WRAPUP_PROMPT_MANDATORY_FORCED_TIMEOUT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['wrapup_prompt'] = isset($data['wrapup_prompt']) ? $data['wrapup_prompt'] : null;
        $this->container['timeout_ms'] = isset($data['timeout_ms']) ? $data['timeout_ms'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("MANDATORY", "OPTIONAL", "MANDATORY_TIMEOUT", "MANDATORY_FORCED_TIMEOUT");
        if (!in_array($this->container['wrapup_prompt'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'wrapup_prompt', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("MANDATORY", "OPTIONAL", "MANDATORY_TIMEOUT", "MANDATORY_FORCED_TIMEOUT");
        if (!in_array($this->container['wrapup_prompt'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets wrapup_prompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapup_prompt'];
    }

    /**
     * Sets wrapup_prompt
     * @param string $wrapup_prompt This field controls how the UI prompts the agent for a wrapup.
     * @return $this
     */
    public function setWrapupPrompt($wrapup_prompt)
    {
        $allowed_values = array('MANDATORY', 'OPTIONAL', 'MANDATORY_TIMEOUT', 'MANDATORY_FORCED_TIMEOUT');
        if (!in_array($wrapup_prompt, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'wrapup_prompt', must be one of 'MANDATORY', 'OPTIONAL', 'MANDATORY_TIMEOUT', 'MANDATORY_FORCED_TIMEOUT'");
        }
        $this->container['wrapup_prompt'] = $wrapup_prompt;

        return $this;
    }

    /**
     * Gets timeout_ms
     * @return int
     */
    public function getTimeoutMs()
    {
        return $this->container['timeout_ms'];
    }

    /**
     * Sets timeout_ms
     * @param int $timeout_ms The amount of time the agent can stay in ACW (Min: 1 sec, Max: 1 day).  Can only be used when ACW is MANDATORY_TIMEOUT or MANDATORY_FORCED_TIMEOUT.
     * @return $this
     */
    public function setTimeoutMs($timeout_ms)
    {
        $this->container['timeout_ms'] = $timeout_ms;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


