<?php
/**
 * AnalyticsConversationSegment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsConversationSegment Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsConversationSegment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsConversationSegment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'segment_start' => '\DateTime',
        'segment_end' => '\DateTime',
        'queue_id' => 'string',
        'wrap_up_code' => 'string',
        'wrap_up_note' => 'string',
        'wrap_up_tags' => 'string[]',
        'error_code' => 'string',
        'disconnect_type' => 'string',
        'segment_type' => 'string',
        'requested_routing_user_ids' => 'string[]',
        'requested_routing_skill_ids' => 'string[]',
        'requested_language_id' => 'string',
        'properties' => '\PureCloudSDK\AnalyticsProperty[]',
        'source_conversation_id' => 'string',
        'destination_conversation_id' => 'string',
        'source_session_id' => 'string',
        'destination_session_id' => 'string',
        'sip_response_codes' => 'int[]',
        'q850_response_codes' => 'int[]',
        'conference' => 'bool',
        'group_id' => 'string',
        'subject' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'segment_start' => 'segmentStart',
        'segment_end' => 'segmentEnd',
        'queue_id' => 'queueId',
        'wrap_up_code' => 'wrapUpCode',
        'wrap_up_note' => 'wrapUpNote',
        'wrap_up_tags' => 'wrapUpTags',
        'error_code' => 'errorCode',
        'disconnect_type' => 'disconnectType',
        'segment_type' => 'segmentType',
        'requested_routing_user_ids' => 'requestedRoutingUserIds',
        'requested_routing_skill_ids' => 'requestedRoutingSkillIds',
        'requested_language_id' => 'requestedLanguageId',
        'properties' => 'properties',
        'source_conversation_id' => 'sourceConversationId',
        'destination_conversation_id' => 'destinationConversationId',
        'source_session_id' => 'sourceSessionId',
        'destination_session_id' => 'destinationSessionId',
        'sip_response_codes' => 'sipResponseCodes',
        'q850_response_codes' => 'q850ResponseCodes',
        'conference' => 'conference',
        'group_id' => 'groupId',
        'subject' => 'subject'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'segment_start' => 'setSegmentStart',
        'segment_end' => 'setSegmentEnd',
        'queue_id' => 'setQueueId',
        'wrap_up_code' => 'setWrapUpCode',
        'wrap_up_note' => 'setWrapUpNote',
        'wrap_up_tags' => 'setWrapUpTags',
        'error_code' => 'setErrorCode',
        'disconnect_type' => 'setDisconnectType',
        'segment_type' => 'setSegmentType',
        'requested_routing_user_ids' => 'setRequestedRoutingUserIds',
        'requested_routing_skill_ids' => 'setRequestedRoutingSkillIds',
        'requested_language_id' => 'setRequestedLanguageId',
        'properties' => 'setProperties',
        'source_conversation_id' => 'setSourceConversationId',
        'destination_conversation_id' => 'setDestinationConversationId',
        'source_session_id' => 'setSourceSessionId',
        'destination_session_id' => 'setDestinationSessionId',
        'sip_response_codes' => 'setSipResponseCodes',
        'q850_response_codes' => 'setQ850ResponseCodes',
        'conference' => 'setConference',
        'group_id' => 'setGroupId',
        'subject' => 'setSubject'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'segment_start' => 'getSegmentStart',
        'segment_end' => 'getSegmentEnd',
        'queue_id' => 'getQueueId',
        'wrap_up_code' => 'getWrapUpCode',
        'wrap_up_note' => 'getWrapUpNote',
        'wrap_up_tags' => 'getWrapUpTags',
        'error_code' => 'getErrorCode',
        'disconnect_type' => 'getDisconnectType',
        'segment_type' => 'getSegmentType',
        'requested_routing_user_ids' => 'getRequestedRoutingUserIds',
        'requested_routing_skill_ids' => 'getRequestedRoutingSkillIds',
        'requested_language_id' => 'getRequestedLanguageId',
        'properties' => 'getProperties',
        'source_conversation_id' => 'getSourceConversationId',
        'destination_conversation_id' => 'getDestinationConversationId',
        'source_session_id' => 'getSourceSessionId',
        'destination_session_id' => 'getDestinationSessionId',
        'sip_response_codes' => 'getSipResponseCodes',
        'q850_response_codes' => 'getQ850ResponseCodes',
        'conference' => 'getConference',
        'group_id' => 'getGroupId',
        'subject' => 'getSubject'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'transportFailure';
    const DISCONNECT_TYPE_CONFERENCE_TRANSFER = 'conferenceTransfer';
    const DISCONNECT_TYPE_CONSULT_TRANSFER = 'consultTransfer';
    const DISCONNECT_TYPE_FORWARD_TRANSFER = 'forwardTransfer';
    const SEGMENT_TYPE_UNKNOWN = 'unknown';
    const SEGMENT_TYPE_ALERT = 'alert';
    const SEGMENT_TYPE_SYSTEM = 'system';
    const SEGMENT_TYPE_DELAY = 'delay';
    const SEGMENT_TYPE_HOLD = 'hold';
    const SEGMENT_TYPE_INTERACT = 'interact';
    const SEGMENT_TYPE_IVR = 'ivr';
    const SEGMENT_TYPE_DIALING = 'dialing';
    const SEGMENT_TYPE_WRAPUP = 'wrapup';
    const SEGMENT_TYPE_VOICEMAIL = 'voicemail';
    const SEGMENT_TYPE_SCHEDULED = 'scheduled';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_CONFERENCE_TRANSFER,
            self::DISCONNECT_TYPE_CONSULT_TRANSFER,
            self::DISCONNECT_TYPE_FORWARD_TRANSFER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSegmentTypeAllowableValues()
    {
        return [
            self::SEGMENT_TYPE_UNKNOWN,
            self::SEGMENT_TYPE_ALERT,
            self::SEGMENT_TYPE_SYSTEM,
            self::SEGMENT_TYPE_DELAY,
            self::SEGMENT_TYPE_HOLD,
            self::SEGMENT_TYPE_INTERACT,
            self::SEGMENT_TYPE_IVR,
            self::SEGMENT_TYPE_DIALING,
            self::SEGMENT_TYPE_WRAPUP,
            self::SEGMENT_TYPE_VOICEMAIL,
            self::SEGMENT_TYPE_SCHEDULED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['segment_start'] = isset($data['segment_start']) ? $data['segment_start'] : null;
        $this->container['segment_end'] = isset($data['segment_end']) ? $data['segment_end'] : null;
        $this->container['queue_id'] = isset($data['queue_id']) ? $data['queue_id'] : null;
        $this->container['wrap_up_code'] = isset($data['wrap_up_code']) ? $data['wrap_up_code'] : null;
        $this->container['wrap_up_note'] = isset($data['wrap_up_note']) ? $data['wrap_up_note'] : null;
        $this->container['wrap_up_tags'] = isset($data['wrap_up_tags']) ? $data['wrap_up_tags'] : null;
        $this->container['error_code'] = isset($data['error_code']) ? $data['error_code'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['segment_type'] = isset($data['segment_type']) ? $data['segment_type'] : null;
        $this->container['requested_routing_user_ids'] = isset($data['requested_routing_user_ids']) ? $data['requested_routing_user_ids'] : null;
        $this->container['requested_routing_skill_ids'] = isset($data['requested_routing_skill_ids']) ? $data['requested_routing_skill_ids'] : null;
        $this->container['requested_language_id'] = isset($data['requested_language_id']) ? $data['requested_language_id'] : null;
        $this->container['properties'] = isset($data['properties']) ? $data['properties'] : null;
        $this->container['source_conversation_id'] = isset($data['source_conversation_id']) ? $data['source_conversation_id'] : null;
        $this->container['destination_conversation_id'] = isset($data['destination_conversation_id']) ? $data['destination_conversation_id'] : null;
        $this->container['source_session_id'] = isset($data['source_session_id']) ? $data['source_session_id'] : null;
        $this->container['destination_session_id'] = isset($data['destination_session_id']) ? $data['destination_session_id'] : null;
        $this->container['sip_response_codes'] = isset($data['sip_response_codes']) ? $data['sip_response_codes'] : null;
        $this->container['q850_response_codes'] = isset($data['q850_response_codes']) ? $data['q850_response_codes'] : null;
        $this->container['conference'] = isset($data['conference']) ? $data['conference'] : false;
        $this->container['group_id'] = isset($data['group_id']) ? $data['group_id'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("endpoint", "client", "system", "transfer", "error", "peer", "other", "spam", "transportFailure", "conferenceTransfer", "consultTransfer", "forwardTransfer");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("unknown", "alert", "system", "delay", "hold", "interact", "ivr", "dialing", "wrapup", "voicemail", "scheduled");
        if (!in_array($this->container['segment_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'segment_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("endpoint", "client", "system", "transfer", "error", "peer", "other", "spam", "transportFailure", "conferenceTransfer", "consultTransfer", "forwardTransfer");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("unknown", "alert", "system", "delay", "hold", "interact", "ivr", "dialing", "wrapup", "voicemail", "scheduled");
        if (!in_array($this->container['segment_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets segment_start
     * @return \DateTime
     */
    public function getSegmentStart()
    {
        return $this->container['segment_start'];
    }

    /**
     * Sets segment_start
     * @param \DateTime $segment_start Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSegmentStart($segment_start)
    {
        $this->container['segment_start'] = $segment_start;

        return $this;
    }

    /**
     * Gets segment_end
     * @return \DateTime
     */
    public function getSegmentEnd()
    {
        return $this->container['segment_end'];
    }

    /**
     * Sets segment_end
     * @param \DateTime $segment_end Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSegmentEnd($segment_end)
    {
        $this->container['segment_end'] = $segment_end;

        return $this;
    }

    /**
     * Gets queue_id
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queue_id'];
    }

    /**
     * Sets queue_id
     * @param string $queue_id
     * @return $this
     */
    public function setQueueId($queue_id)
    {
        $this->container['queue_id'] = $queue_id;

        return $this;
    }

    /**
     * Gets wrap_up_code
     * @return string
     */
    public function getWrapUpCode()
    {
        return $this->container['wrap_up_code'];
    }

    /**
     * Sets wrap_up_code
     * @param string $wrap_up_code
     * @return $this
     */
    public function setWrapUpCode($wrap_up_code)
    {
        $this->container['wrap_up_code'] = $wrap_up_code;

        return $this;
    }

    /**
     * Gets wrap_up_note
     * @return string
     */
    public function getWrapUpNote()
    {
        return $this->container['wrap_up_note'];
    }

    /**
     * Sets wrap_up_note
     * @param string $wrap_up_note
     * @return $this
     */
    public function setWrapUpNote($wrap_up_note)
    {
        $this->container['wrap_up_note'] = $wrap_up_note;

        return $this;
    }

    /**
     * Gets wrap_up_tags
     * @return string[]
     */
    public function getWrapUpTags()
    {
        return $this->container['wrap_up_tags'];
    }

    /**
     * Sets wrap_up_tags
     * @param string[] $wrap_up_tags
     * @return $this
     */
    public function setWrapUpTags($wrap_up_tags)
    {
        $this->container['wrap_up_tags'] = $wrap_up_tags;

        return $this;
    }

    /**
     * Gets error_code
     * @return string
     */
    public function getErrorCode()
    {
        return $this->container['error_code'];
    }

    /**
     * Sets error_code
     * @param string $error_code
     * @return $this
     */
    public function setErrorCode($error_code)
    {
        $this->container['error_code'] = $error_code;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'error', 'peer', 'other', 'spam', 'transportFailure', 'conferenceTransfer', 'consultTransfer', 'forwardTransfer');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'endpoint', 'client', 'system', 'transfer', 'error', 'peer', 'other', 'spam', 'transportFailure', 'conferenceTransfer', 'consultTransfer', 'forwardTransfer'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets segment_type
     * @return string
     */
    public function getSegmentType()
    {
        return $this->container['segment_type'];
    }

    /**
     * Sets segment_type
     * @param string $segment_type
     * @return $this
     */
    public function setSegmentType($segment_type)
    {
        $allowed_values = array('unknown', 'alert', 'system', 'delay', 'hold', 'interact', 'ivr', 'dialing', 'wrapup', 'voicemail', 'scheduled');
        if (!in_array($segment_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'segment_type', must be one of 'unknown', 'alert', 'system', 'delay', 'hold', 'interact', 'ivr', 'dialing', 'wrapup', 'voicemail', 'scheduled'");
        }
        $this->container['segment_type'] = $segment_type;

        return $this;
    }

    /**
     * Gets requested_routing_user_ids
     * @return string[]
     */
    public function getRequestedRoutingUserIds()
    {
        return $this->container['requested_routing_user_ids'];
    }

    /**
     * Sets requested_routing_user_ids
     * @param string[] $requested_routing_user_ids
     * @return $this
     */
    public function setRequestedRoutingUserIds($requested_routing_user_ids)
    {
        $this->container['requested_routing_user_ids'] = $requested_routing_user_ids;

        return $this;
    }

    /**
     * Gets requested_routing_skill_ids
     * @return string[]
     */
    public function getRequestedRoutingSkillIds()
    {
        return $this->container['requested_routing_skill_ids'];
    }

    /**
     * Sets requested_routing_skill_ids
     * @param string[] $requested_routing_skill_ids
     * @return $this
     */
    public function setRequestedRoutingSkillIds($requested_routing_skill_ids)
    {
        $this->container['requested_routing_skill_ids'] = $requested_routing_skill_ids;

        return $this;
    }

    /**
     * Gets requested_language_id
     * @return string
     */
    public function getRequestedLanguageId()
    {
        return $this->container['requested_language_id'];
    }

    /**
     * Sets requested_language_id
     * @param string $requested_language_id
     * @return $this
     */
    public function setRequestedLanguageId($requested_language_id)
    {
        $this->container['requested_language_id'] = $requested_language_id;

        return $this;
    }

    /**
     * Gets properties
     * @return \PureCloudSDK\AnalyticsProperty[]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     * @param \PureCloudSDK\AnalyticsProperty[] $properties
     * @return $this
     */
    public function setProperties($properties)
    {
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets source_conversation_id
     * @return string
     */
    public function getSourceConversationId()
    {
        return $this->container['source_conversation_id'];
    }

    /**
     * Sets source_conversation_id
     * @param string $source_conversation_id
     * @return $this
     */
    public function setSourceConversationId($source_conversation_id)
    {
        $this->container['source_conversation_id'] = $source_conversation_id;

        return $this;
    }

    /**
     * Gets destination_conversation_id
     * @return string
     */
    public function getDestinationConversationId()
    {
        return $this->container['destination_conversation_id'];
    }

    /**
     * Sets destination_conversation_id
     * @param string $destination_conversation_id
     * @return $this
     */
    public function setDestinationConversationId($destination_conversation_id)
    {
        $this->container['destination_conversation_id'] = $destination_conversation_id;

        return $this;
    }

    /**
     * Gets source_session_id
     * @return string
     */
    public function getSourceSessionId()
    {
        return $this->container['source_session_id'];
    }

    /**
     * Sets source_session_id
     * @param string $source_session_id
     * @return $this
     */
    public function setSourceSessionId($source_session_id)
    {
        $this->container['source_session_id'] = $source_session_id;

        return $this;
    }

    /**
     * Gets destination_session_id
     * @return string
     */
    public function getDestinationSessionId()
    {
        return $this->container['destination_session_id'];
    }

    /**
     * Sets destination_session_id
     * @param string $destination_session_id
     * @return $this
     */
    public function setDestinationSessionId($destination_session_id)
    {
        $this->container['destination_session_id'] = $destination_session_id;

        return $this;
    }

    /**
     * Gets sip_response_codes
     * @return int[]
     */
    public function getSipResponseCodes()
    {
        return $this->container['sip_response_codes'];
    }

    /**
     * Sets sip_response_codes
     * @param int[] $sip_response_codes
     * @return $this
     */
    public function setSipResponseCodes($sip_response_codes)
    {
        $this->container['sip_response_codes'] = $sip_response_codes;

        return $this;
    }

    /**
     * Gets q850_response_codes
     * @return int[]
     */
    public function getQ850ResponseCodes()
    {
        return $this->container['q850_response_codes'];
    }

    /**
     * Sets q850_response_codes
     * @param int[] $q850_response_codes
     * @return $this
     */
    public function setQ850ResponseCodes($q850_response_codes)
    {
        $this->container['q850_response_codes'] = $q850_response_codes;

        return $this;
    }

    /**
     * Gets conference
     * @return bool
     */
    public function getConference()
    {
        return $this->container['conference'];
    }

    /**
     * Sets conference
     * @param bool $conference
     * @return $this
     */
    public function setConference($conference)
    {
        $this->container['conference'] = $conference;

        return $this;
    }

    /**
     * Gets group_id
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['group_id'];
    }

    /**
     * Sets group_id
     * @param string $group_id
     * @return $this
     */
    public function setGroupId($group_id)
    {
        $this->container['group_id'] = $group_id;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


