<?php
/**
 * AnalyticsEvaluation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsEvaluation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsEvaluation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsEvaluation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'evaluation_id' => 'string',
        'evaluator_id' => 'string',
        'user_id' => 'string',
        'event_time' => 'string',
        'queue_id' => 'string',
        'form_id' => 'string',
        'context_id' => 'string',
        'form_name' => 'string',
        'geto_total_score' => 'int',
        'geto_total_critical_score' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'evaluation_id' => 'evaluationId',
        'evaluator_id' => 'evaluatorId',
        'user_id' => 'userId',
        'event_time' => 'eventTime',
        'queue_id' => 'queueId',
        'form_id' => 'formId',
        'context_id' => 'contextId',
        'form_name' => 'formName',
        'geto_total_score' => 'getoTotalScore',
        'geto_total_critical_score' => 'getoTotalCriticalScore'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'evaluation_id' => 'setEvaluationId',
        'evaluator_id' => 'setEvaluatorId',
        'user_id' => 'setUserId',
        'event_time' => 'setEventTime',
        'queue_id' => 'setQueueId',
        'form_id' => 'setFormId',
        'context_id' => 'setContextId',
        'form_name' => 'setFormName',
        'geto_total_score' => 'setGetoTotalScore',
        'geto_total_critical_score' => 'setGetoTotalCriticalScore'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'evaluation_id' => 'getEvaluationId',
        'evaluator_id' => 'getEvaluatorId',
        'user_id' => 'getUserId',
        'event_time' => 'getEventTime',
        'queue_id' => 'getQueueId',
        'form_id' => 'getFormId',
        'context_id' => 'getContextId',
        'form_name' => 'getFormName',
        'geto_total_score' => 'getGetoTotalScore',
        'geto_total_critical_score' => 'getGetoTotalCriticalScore'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['evaluation_id'] = isset($data['evaluation_id']) ? $data['evaluation_id'] : null;
        $this->container['evaluator_id'] = isset($data['evaluator_id']) ? $data['evaluator_id'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
        $this->container['event_time'] = isset($data['event_time']) ? $data['event_time'] : null;
        $this->container['queue_id'] = isset($data['queue_id']) ? $data['queue_id'] : null;
        $this->container['form_id'] = isset($data['form_id']) ? $data['form_id'] : null;
        $this->container['context_id'] = isset($data['context_id']) ? $data['context_id'] : null;
        $this->container['form_name'] = isset($data['form_name']) ? $data['form_name'] : null;
        $this->container['geto_total_score'] = isset($data['geto_total_score']) ? $data['geto_total_score'] : null;
        $this->container['geto_total_critical_score'] = isset($data['geto_total_critical_score']) ? $data['geto_total_critical_score'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets evaluation_id
     * @return string
     */
    public function getEvaluationId()
    {
        return $this->container['evaluation_id'];
    }

    /**
     * Sets evaluation_id
     * @param string $evaluation_id
     * @return $this
     */
    public function setEvaluationId($evaluation_id)
    {
        $this->container['evaluation_id'] = $evaluation_id;

        return $this;
    }

    /**
     * Gets evaluator_id
     * @return string
     */
    public function getEvaluatorId()
    {
        return $this->container['evaluator_id'];
    }

    /**
     * Sets evaluator_id
     * @param string $evaluator_id
     * @return $this
     */
    public function setEvaluatorId($evaluator_id)
    {
        $this->container['evaluator_id'] = $evaluator_id;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets event_time
     * @return string
     */
    public function getEventTime()
    {
        return $this->container['event_time'];
    }

    /**
     * Sets event_time
     * @param string $event_time
     * @return $this
     */
    public function setEventTime($event_time)
    {
        $this->container['event_time'] = $event_time;

        return $this;
    }

    /**
     * Gets queue_id
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queue_id'];
    }

    /**
     * Sets queue_id
     * @param string $queue_id
     * @return $this
     */
    public function setQueueId($queue_id)
    {
        $this->container['queue_id'] = $queue_id;

        return $this;
    }

    /**
     * Gets form_id
     * @return string
     */
    public function getFormId()
    {
        return $this->container['form_id'];
    }

    /**
     * Sets form_id
     * @param string $form_id
     * @return $this
     */
    public function setFormId($form_id)
    {
        $this->container['form_id'] = $form_id;

        return $this;
    }

    /**
     * Gets context_id
     * @return string
     */
    public function getContextId()
    {
        return $this->container['context_id'];
    }

    /**
     * Sets context_id
     * @param string $context_id
     * @return $this
     */
    public function setContextId($context_id)
    {
        $this->container['context_id'] = $context_id;

        return $this;
    }

    /**
     * Gets form_name
     * @return string
     */
    public function getFormName()
    {
        return $this->container['form_name'];
    }

    /**
     * Sets form_name
     * @param string $form_name
     * @return $this
     */
    public function setFormName($form_name)
    {
        $this->container['form_name'] = $form_name;

        return $this;
    }

    /**
     * Gets geto_total_score
     * @return int
     */
    public function getGetoTotalScore()
    {
        return $this->container['geto_total_score'];
    }

    /**
     * Sets geto_total_score
     * @param int $geto_total_score
     * @return $this
     */
    public function setGetoTotalScore($geto_total_score)
    {
        $this->container['geto_total_score'] = $geto_total_score;

        return $this;
    }

    /**
     * Gets geto_total_critical_score
     * @return int
     */
    public function getGetoTotalCriticalScore()
    {
        return $this->container['geto_total_critical_score'];
    }

    /**
     * Sets geto_total_critical_score
     * @param int $geto_total_critical_score
     * @return $this
     */
    public function setGetoTotalCriticalScore($geto_total_critical_score)
    {
        $this->container['geto_total_critical_score'] = $geto_total_critical_score;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


