<?php
/**
 * AnalyticsParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'participant_id' => 'string',
        'participant_name' => 'string',
        'user_id' => 'string',
        'purpose' => 'string',
        'external_contact_id' => 'string',
        'external_organization_id' => 'string',
        'sessions' => '\PureCloudSDK\AnalyticsSession[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'participant_id' => 'participantId',
        'participant_name' => 'participantName',
        'user_id' => 'userId',
        'purpose' => 'purpose',
        'external_contact_id' => 'externalContactId',
        'external_organization_id' => 'externalOrganizationId',
        'sessions' => 'sessions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'participant_id' => 'setParticipantId',
        'participant_name' => 'setParticipantName',
        'user_id' => 'setUserId',
        'purpose' => 'setPurpose',
        'external_contact_id' => 'setExternalContactId',
        'external_organization_id' => 'setExternalOrganizationId',
        'sessions' => 'setSessions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'participant_id' => 'getParticipantId',
        'participant_name' => 'getParticipantName',
        'user_id' => 'getUserId',
        'purpose' => 'getPurpose',
        'external_contact_id' => 'getExternalContactId',
        'external_organization_id' => 'getExternalOrganizationId',
        'sessions' => 'getSessions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PURPOSE_MANUAL = 'manual';
    const PURPOSE_DIALER = 'dialer';
    const PURPOSE_INBOUND = 'inbound';
    const PURPOSE_ACD = 'acd';
    const PURPOSE_IVR = 'ivr';
    const PURPOSE_VOICEMAIL = 'voicemail';
    const PURPOSE_OUTBOUND = 'outbound';
    const PURPOSE_AGENT = 'agent';
    const PURPOSE_USER = 'user';
    const PURPOSE_STATION = 'station';
    const PURPOSE_GROUP = 'group';
    const PURPOSE_CUSTOMER = 'customer';
    const PURPOSE_EXTERNAL = 'external';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPurposeAllowableValues()
    {
        return [
            self::PURPOSE_MANUAL,
            self::PURPOSE_DIALER,
            self::PURPOSE_INBOUND,
            self::PURPOSE_ACD,
            self::PURPOSE_IVR,
            self::PURPOSE_VOICEMAIL,
            self::PURPOSE_OUTBOUND,
            self::PURPOSE_AGENT,
            self::PURPOSE_USER,
            self::PURPOSE_STATION,
            self::PURPOSE_GROUP,
            self::PURPOSE_CUSTOMER,
            self::PURPOSE_EXTERNAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['participant_id'] = isset($data['participant_id']) ? $data['participant_id'] : null;
        $this->container['participant_name'] = isset($data['participant_name']) ? $data['participant_name'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['external_contact_id'] = isset($data['external_contact_id']) ? $data['external_contact_id'] : null;
        $this->container['external_organization_id'] = isset($data['external_organization_id']) ? $data['external_organization_id'] : null;
        $this->container['sessions'] = isset($data['sessions']) ? $data['sessions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("manual", "dialer", "inbound", "acd", "ivr", "voicemail", "outbound", "agent", "user", "station", "group", "customer", "external");
        if (!in_array($this->container['purpose'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'purpose', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("manual", "dialer", "inbound", "acd", "ivr", "voicemail", "outbound", "agent", "user", "station", "group", "customer", "external");
        if (!in_array($this->container['purpose'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets participant_id
     * @return string
     */
    public function getParticipantId()
    {
        return $this->container['participant_id'];
    }

    /**
     * Sets participant_id
     * @param string $participant_id
     * @return $this
     */
    public function setParticipantId($participant_id)
    {
        $this->container['participant_id'] = $participant_id;

        return $this;
    }

    /**
     * Gets participant_name
     * @return string
     */
    public function getParticipantName()
    {
        return $this->container['participant_name'];
    }

    /**
     * Sets participant_name
     * @param string $participant_name
     * @return $this
     */
    public function setParticipantName($participant_name)
    {
        $this->container['participant_name'] = $participant_name;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $allowed_values = array('manual', 'dialer', 'inbound', 'acd', 'ivr', 'voicemail', 'outbound', 'agent', 'user', 'station', 'group', 'customer', 'external');
        if (!in_array($purpose, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'purpose', must be one of 'manual', 'dialer', 'inbound', 'acd', 'ivr', 'voicemail', 'outbound', 'agent', 'user', 'station', 'group', 'customer', 'external'");
        }
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets external_contact_id
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['external_contact_id'];
    }

    /**
     * Sets external_contact_id
     * @param string $external_contact_id
     * @return $this
     */
    public function setExternalContactId($external_contact_id)
    {
        $this->container['external_contact_id'] = $external_contact_id;

        return $this;
    }

    /**
     * Gets external_organization_id
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['external_organization_id'];
    }

    /**
     * Sets external_organization_id
     * @param string $external_organization_id
     * @return $this
     */
    public function setExternalOrganizationId($external_organization_id)
    {
        $this->container['external_organization_id'] = $external_organization_id;

        return $this;
    }

    /**
     * Gets sessions
     * @return \PureCloudSDK\AnalyticsSession[]
     */
    public function getSessions()
    {
        return $this->container['sessions'];
    }

    /**
     * Sets sessions
     * @param \PureCloudSDK\AnalyticsSession[] $sessions
     * @return $this
     */
    public function setSessions($sessions)
    {
        $this->container['sessions'] = $sessions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


